unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, cRichView, StdCtrls, cDateTime, ComCtrls, ExtCtrls, cLayoutObjects,
  cLayoutTable, cLayoutBase;

type
  TForm1 = class(TForm)
    RichView: TelRichView;
    Button1: TButton;
    Button2: TButton;
    OpenDialog: TOpenDialog;
    cShowCaret: TCheckBox;
    cLineWrap: TCheckBox;
    cNoMargins: TCheckBox;
    iFlag: TImage;
    iEternalLines: TImage;
    iSmiley: TImage;
    colBack: TColorBox;
    Bevel1: TBevel;
    Label1: TLabel;
    iBulb: TImage;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure cShowCaretClick(Sender: TObject);
    procedure cLineWrapClick(Sender: TObject);
    procedure cNoMarginsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure colBackChange(Sender: TObject);
    procedure RichViewLinkClick(Sender: ARichView; Button: TMouseButton;
      Shift: TShiftState; LinkObj: TLayoutLink; Link: String);
  private
  public
  end;

var
  Form1: TForm1;

implementation

uses
  { Fundamentals }
  cReaders, cLayoutCollection;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  colBack.Selected := RichView.Color;
  cShowCaret.Checked := rvoShowCaret in RichView.Options;
  cLineWrap.Checked := rvoLineWrap in RichView.Options;
  cNoMargins.Checked := rvoNoMargins in RichView.Options;
end;

procedure TForm1.cShowCaretClick(Sender: TObject);
begin
  if cShowCaret.Checked then
    begin
      RichView.Options := RichView.Options + [rvoShowCaret];
      RichView.SetFocus;
    end else
    RichView.Options := RichView.Options - [rvoShowCaret];
end;

procedure TForm1.cLineWrapClick(Sender: TObject);
begin
  if cLineWrap.Checked then
    RichView.Options := RichView.Options + [rvoLineWrap] else
    RichView.Options := RichView.Options - [rvoLineWrap];
end;

procedure TForm1.cNoMarginsClick(Sender: TObject);
begin
  if cNoMargins.Checked then
    RichView.Options := RichView.Options + [rvoNoMargins] else
    RichView.Options := RichView.Options - [rvoNoMargins];
end;

procedure TForm1.Button1Click(Sender: TObject);
var I: Integer;
begin
  With RichView.Objects do
    begin
      BeginUpdate;
      try
        Clear;
        Style.FontName := 'Verdana';

        AddRichTextLine('elRichView Demo Document', [fsUnderline], clNone, 20);
        AddBreak;
        AddBreak;
        Style.FontSize := 12;


        AddBreak;
        Style.Indent := 0;
        AddGraphic(iFlag.Picture.Bitmap, False);
        Style.Indent := 28;
        AddBoldText('elRichView');
        AddTextLine(' is native Delphi code. No ActiveX controls or DLLs required.');
        AddBreak;


        AddBreak;
        Style.Indent := 0;
        AddGraphic(iFlag.Picture.Bitmap, False);
        Style.Indent := 28;
        AddBoldText('elRichView');
        AddText(' allows control of text styles:');
        AddBreak;
        AddBreak;
        AddColorText('C', clRed);
        AddColorText('O', clGreen);
        AddColorText('L', clBlue);
        AddColorText('O', clPurple);
        AddColorText('R', clOlive);
        AddColorText('S', clDkGray);
        AddBreak;
        AddBoldText('Bold');
        AddText('  ');
        AddItalicText('Italic');
        AddText('  ');
        AddUnderlineText('Underline');
        AddBreak;
        AddRichText('Big ', [], clNone, 28);
        AddRichText('Small', [], clNone, 8);
        AddBreak;
        AddBreak;


        AddBreak;
        Style.Indent := 0;
        AddGraphic(iFlag.Picture.Bitmap, False);
        Style.Indent := 28;
        AddBoldText('elRichView');
        AddText(' handles images:');
        AddBreak;
        AddBreak;
        AddTextLine('Transparent: ');
        For I := 1 to 8 do
          AddGraphic(iSmiley.Picture.Bitmap, False);
        AddBreak;
        AddGraphic(iEternalLines.Picture.Bitmap, False);
        AddBreak;
        AddBreak;
        AddTextLine('Stretched: ');
        AddGraphic(iSmiley.Picture.Bitmap, False, 80, 80);
        AddGraphic(iSmiley.Picture.Bitmap, False, 40, 80);
        AddGraphic(iSmiley.Picture.Bitmap, False, 80, 40);
        AddGraphic(iSmiley.Picture.Bitmap, False, 40, 80);
        AddGraphic(iSmiley.Picture.Bitmap, False, 80, 80);
        AddBreak;
        AddBreak;


        AddBreak;
        Style.Indent := 0;
        AddGraphic(iFlag.Picture.Bitmap, False);
        Style.Indent := 28;
        AddBoldText('elRichView');
        AddText(' supports hot-spots:');
        AddBreak;
        AddBreak;
        AddTextLink('http://www.eternallines.com/richview/',
                             'http://www.eternallines.com/richview/');
        AddBreak;
        AddBreak;
        Style.IsHotSpot := True;
        Style.HotSpotLink := 'link:bulb';
        AddGraphic(iBulb.Picture.Bitmap, False);
        AddText('Image hot-spot');
        Style.IsHotSpot := False;
        AddBreak;
        AddBreak;


        AddBreak;
        Style.Indent := 0;
        AddGraphic(iFlag.Picture.Bitmap, False);
        Style.Indent := 28;
        AddBoldText('elRichView');
        AddText(' can do tables:');
        AddBreak;
        AddBreak;
        BeginTable(clRed, 8, 8, 8, haLeft, vaMiddle);
        Style.Indent := 0;
        BeginRow;
        BeginCell(clSkyBlue, 2).HorAlign := haCenter;
        AddText('Cell 1');
        BeginRow;
        BeginCell(clTeal);
        AddText('Cell 21');
        BeginCell(clLtGray);
        AddText('Cell 22');
        BeginRow;
        BeginCell(clMoneyGreen, 2).HorAlign := haCenter;
        AddGraphic(iSmiley.Picture.Bitmap, False);
        EndTable;
        Style.Indent := 28;
        AddBreak;
        AddBreak;

      finally
        EndUpdate;
      end;
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if OpenDialog.Execute then
    begin
      RichView.Font.Name := 'Courier New';
      RichView.Text := ReadFileToStr(OpenDialog.FileName);
    end;
end;

procedure TForm1.colBackChange(Sender: TObject);
begin
  RichView.Color := colBack.Selected;
end;

procedure TForm1.RichViewLinkClick(Sender: ARichView; Button: TMouseButton;
  Shift: TShiftState; LinkObj: TLayoutLink; Link: String);
begin
  MessageDlg('Link'#13#10#13#10 + Link, mtInformation, [mbOk], -1);
end;

end.

