unit SimPview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, PDGPview;

type
  TSimplePreviewForm = class(TForm)
    TopPanel: TPanel;
    PageEdit: TEdit;
    ZoomComboBox: TComboBox;
    ZoomLabel: TLabel;
    PageLabel: TLabel;
    PrintButton: TButton;
    CloseButton: TButton;
    PDGPreview: TPDGPreview;
    ZoomModeLabel: TLabel;
    ZoomModeComboBox: TComboBox;
    OrientationButton: TButton;
    BestWidthsButton: TButton;
    PageUpDown: TUpDown;
    procedure CloseButtonClick(Sender: TObject);
    procedure ZoomComboBoxChange(Sender: TObject);
    procedure PDGPreviewChangeZoom(Sender: TObject; AZoomPercent: Integer);
    procedure PDGPreviewChangeCurPage(Sender: TObject; APageX,
      APageY: Integer);
    procedure ZoomModeComboBoxChange(Sender: TObject);
    procedure PDGPreviewChangeZoomMode(Sender: TObject;
      AZoomMode: TZoomMode);
    procedure PageUpDownClick(Sender: TObject; Button: TUDBtnType);
    procedure PrintButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OrientationButtonClick(Sender: TObject);
    procedure BestWidthsButtonClick(Sender: TObject);
  private
    procedure AdjustControlsAfterPreparation;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses
  Printers;

procedure TSimplePreviewForm.AdjustControlsAfterPreparation;
begin
  with PDGPreview do begin
    Caption := Title;
    PageUpDown.Min := 1;
    PageUpDown.Max := TotalPagesCount;
    PageUpDown.Position := PageIndex + 1;
  end;
end;

procedure TSimplePreviewForm.CloseButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TSimplePreviewForm.ZoomModeComboBoxChange(Sender: TObject);
begin
  PDGPreview.ZoomMode := TZoomMode((Sender as TComboBox).ItemIndex);
end;

procedure TSimplePreviewForm.PDGPreviewChangeZoomMode(Sender: TObject;
  AZoomMode: TZoomMode);
begin
  ZoomModeComboBox.ItemIndex := Integer(AZoomMode);
end;

procedure TSimplePreviewForm.ZoomComboBoxChange(Sender: TObject);
begin
  PDGPreview.CustomZoom := StrToInt((Sender as TComboBox).Text);
end;

procedure TSimplePreviewForm.PDGPreviewChangeZoom(Sender: TObject;
  AZoomPercent: Integer);
begin
  ZoomComboBox.Text := IntToStr(AZoomPercent);
end;

procedure TSimplePreviewForm.PageUpDownClick(Sender: TObject;
  Button: TUDBtnType);
begin
  with PDGPreview do begin
    PageIndex := PageUpDown.Position - 1;
  end;
end;

procedure TSimplePreviewForm.PDGPreviewChangeCurPage(Sender: TObject;
  APageX, APageY: Integer);
const
  PageInfoMask = 'Horz:%d, Vert:%d';
begin
  PageEdit.Text := Format(PageInfoMask, [APageX + 1, APageY + 1]);
end;

procedure TSimplePreviewForm.PrintButtonClick(Sender: TObject);
begin
  PDGPreview.PrintWithDialog;
end;

procedure TSimplePreviewForm.FormShow(Sender: TObject);
begin
  AdjustControlsAfterPreparation;
  PDGPreview.ActivatePreview;//important line
end;

procedure TSimplePreviewForm.OrientationButtonClick(Sender: TObject);
begin
  with Printer do begin
    if Orientation = poPortrait then begin
      Orientation := poLandscape;
    end else begin
      Orientation := poPortrait;
    end;
  end;
  with PDGPreview do begin
    ReprepareReport;
    ActivatePreview; 
  end;
  // don't forget to adjust controls on form after report preparation
  AdjustControlsAfterPreparation;
end;

procedure TSimplePreviewForm.BestWidthsButtonClick(Sender: TObject);
begin
  with PDGPreview do begin
    PrintDecisionGrid.AdjustBestColumnWidhts;
    ReprepareReport;
    ActivatePreview;
  end;
  // don't forget to adjust controls on form after report preparation
  AdjustControlsAfterPreparation;
end;

end.
