{$A+,B-,C+,D+,E-,F-,G+,H+,I+,J+,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE GUI}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, mxgrid, mxpivsrc, ExtCtrls, mxstore, mxDB, Db, DBTables,
  mxtables, StdCtrls, PrnDGrid, PDGPview, CheckLst;

type
  TMainDemoForm = class(TForm)
    DecisionSource1: TDecisionSource;
    DecisionQuery1: TDecisionQuery;
    DecisionCube1: TDecisionCube;
    GroundPanel: TPanel;
    DecisionPivot: TDecisionPivot;
    ButtonsPanel: TPanel;
    AdjustWidthButton: TButton;
    PrintPreviewButton: TButton;
    PrintButton: TButton;
    CloseButton: TButton;
    PrintDecisionGrid: TPrintDecisionGrid;
    UseCustomCheckBox: TCheckBox;
    CopyToClipBoardButton: TButton;
    LogoImage: TImage;
    ReportOptionsCheckListBox: TCheckListBox;
    ReportOptionsLabel: TLabel;
    Label2: TLabel;
    ScalePercentLabel: TLabel;
    ScalePercentEdit: TEdit;
    HeaderLeftEdit: TEdit;
    HeaderCenterEdit: TEdit;
    HeaderRightEdit: TEdit;
    FooterLeftEdit: TEdit;
    FooterCenterEdit: TEdit;
    FooterRightEdit: TEdit;
    HeaderRightLabel: TLabel;
    FooterRightLabel: TLabel;
    HeaderCenterLabel: TLabel;
    FooterCenterLabel: TLabel;
    HeaderLeftLabel: TLabel;
    FooterLeftLabel: TLabel;
    HeaderLabel: TLabel;
    FooterLabel: TLabel;
    TotalsCheckBox: TCheckBox;
    AdjustWidthsQuickButton: TButton;
    ReportDuplicatesLabel: TLabel;
    ReportDuplicatesCheckListBox: TCheckListBox;
    HtmlReportGroupBox: TGroupBox;
    HtmlReportLabel: TLabel;
    HtmlReportPatternEdit: TEdit;
    HtmlReportReportButton: TButton;
    ExcelExportGroupBox: TGroupBox;
    ExcelButton: TButton;
    ExcelPathLabel: TLabel;
    ExcelPathEdit: TEdit;
    ExcelPTButton: TButton;
    ExcelClipboardButton: TButton;
    procedure AdjustWidthButtonClick(Sender: TObject);
    procedure PrintPreviewButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure PrintDecisionGridPreviewReport(Sender: TObject;
      var AShowDefaultPreview: Boolean);
    procedure PrintDecisionGridDecisionDrawCell(Sender: TObject; Col,
      Row: Integer; var Value: String; var aFont: TFont;
      var aColor: TColor; AState: TGridDrawState;
      aDrawState: TDecisionDrawState);
    procedure CopyToClipBoardButtonClick(Sender: TObject);
    procedure PrintDecisionGridReportPrintFooter(APageIndex: Integer;
      APlace: TTextPlace; var AText: String; AFont: TFont);
    procedure FormCreate(Sender: TObject);
    procedure PrintDecisionGridReportPrintPage(AParentCanvas: TCanvas;
      APageIndex: Integer);
    procedure HtmlReportReportButtonClick(Sender: TObject);
    procedure TotalsCheckBoxClick(Sender: TObject);
    procedure PrintDecisionGridReportHTML(APageIndex: Integer;
      var AContent: String);
    procedure AdjustWidthsQuickButtonClick(Sender: TObject);
    procedure ReportOptionsCheckListBoxClickCheck(Sender: TObject);
    procedure ExcelButtonClick(Sender: TObject);
    procedure ExcelPTButtonClick(Sender: TObject);
    procedure ExcelClipboardButtonClick(Sender: TObject);
  private
		procedure AdjustDuplicatesEnabled(ACheckliistBox: TCheckListBox);
    procedure SetValuesToControls;
    procedure GetValuesFromControls;
  public
    { Public declarations }
  end;

var
  MainDemoForm: TMainDemoForm;

implementation

uses ShellApi, SimPview;

{$R *.DFM}

procedure TMainDemoForm.AdjustDuplicatesEnabled(ACheckliistBox: TCheckListBox);
var
	aDuplicateFixedRows, aDuplicateFixedColumns: boolean;
begin
  with ACheckliistBox do begin
  	aDuplicateFixedRows := Checked[Integer(roDuplicateFixedRows)];
    if not aDuplicateFixedRows then begin
      ReportDuplicatesCheckListBox.State[Integer(rdTopRows)] := cbGrayed;
      ReportDuplicatesCheckListBox.State[Integer(rdBottomRows)] := cbGrayed;
  	end else begin
      ReportDuplicatesCheckListBox.State[Integer(rdTopRows)] := cbChecked;
      ReportDuplicatesCheckListBox.State[Integer(rdBottomRows)] := cbChecked;
    end;
    aDuplicateFixedColumns := Checked[Integer(roDuplicateFixedColumns)];
    if not aDuplicateFixedColumns then begin
      ReportDuplicatesCheckListBox.State[Integer(rdLeftColumns)] := cbGrayed;
      ReportDuplicatesCheckListBox.State[Integer(rdRightColumns)] := cbGrayed;
  	end else begin
      ReportDuplicatesCheckListBox.State[Integer(rdLeftColumns)] := cbChecked;
      ReportDuplicatesCheckListBox.State[Integer(rdRightColumns)] := cbChecked;
    end;
  end;
end;

procedure TMainDemoForm.SetValuesToControls;
var
  i: Integer;
begin
  with PrintDecisionGrid do begin
    for i := 0 to ReportOptionsCheckListBox.Items.Count - 1 do begin
      ReportOptionsCheckListBox.Checked[i] :=
        TReportOption(i) in ReportOptions;
    end;
    ScalePercentEdit.Text := IntToStr(ReportScalePercent);

    HeaderLeftEdit.Text := ReportHeader.TextPartLeft;
    HeaderCenterEdit.Text := ReportHeader.TextPartCenter;
    HeaderRightEdit.Text := ReportHeader.TextPartRight;

    FooterLeftEdit.Text := ReportFooter.TextPartLeft;
    FooterCenterEdit.Text := ReportFooter.TextPartCenter;
    FooterRightEdit.Text := ReportFooter.TextPartRight;
		TotalsCheckBox.Checked := Totals;

    for i := 0 to ReportDuplicatesCheckListBox.Items.Count - 1 do begin
      ReportDuplicatesCheckListBox.Checked[i] :=
        TReportDuplicate(i) in ReportDuplicates;
    end;
    AdjustDuplicatesEnabled(ReportOptionsCheckListBox);
  end;
end;

procedure TMainDemoForm.GetValuesFromControls;
var
  i: Integer;
begin
  with PrintDecisionGrid do begin
    ReportOptions := [];
    for i := 0 to ReportOptionsCheckListBox.Items.Count - 1 do begin
      if ReportOptionsCheckListBox.Checked[i] then begin
        ReportOptions := ReportOptions + [TReportOption(i)];
      end;
    end;
    ReportScalePercent := StrToInt(ScalePercentEdit.Text);

    ReportHeader.TextPartLeft := HeaderLeftEdit.Text;
    ReportHeader.TextPartCenter := HeaderCenterEdit.Text;
    ReportHeader.TextPartRight := HeaderRightEdit.Text;

    ReportFooter.TextPartLeft := FooterLeftEdit.Text;
    ReportFooter.TextPartCenter := FooterCenterEdit.Text;
    ReportFooter.TextPartRight := FooterRightEdit.Text;

    ReportDuplicates := [];
    for i := 0 to ReportDuplicatesCheckListBox.Items.Count - 1 do begin
      if ReportDuplicatesCheckListBox.Checked[i] then begin
        ReportDuplicates := ReportDuplicates + [TReportDuplicate(i)];
      end;
    end;
  end;
end;


procedure TMainDemoForm.PrintPreviewButtonClick(Sender: TObject);
begin
  GetValuesFromControls;
  PrintDecisionGrid.PreviewReport;
end;

procedure TMainDemoForm.PrintButtonClick(Sender: TObject);
begin
  GetValuesFromControls;
  PrintDecisionGrid.PrintReportWithDialog;
end;

procedure TMainDemoForm.CloseButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TMainDemoForm.PrintDecisionGridPreviewReport(Sender: TObject;
  var AShowDefaultPreview: Boolean);
begin
  if UseCustomCheckBox.Checked then begin
    with TSimplePreviewForm.Create(nil) do begin
      try
        PDGPreview.PrintDecisionGrid := Self.PrintDecisionGrid; // very important line
        ShowModal;
        AShowDefaultPreview := False;
      finally
        Free;
      end;
    end;
  end;
end;

procedure TMainDemoForm.PrintDecisionGridDecisionDrawCell(Sender: TObject;
  Col, Row: Integer; var Value: String; var aFont: TFont;
  var aColor: TColor; AState: TGridDrawState;
  aDrawState: TDecisionDrawState);
begin
  // TPrintDecisionGrid works correctly now with OnDecisionDrawCell event
  if (Col = 2) and (Row = 5) then begin
    Value := 'This is test string';
    aFont := PrintDecisionGrid.CaptionFont;
    aColor := PrintDecisionGrid.CaptionColor;
  end;
end;

procedure TMainDemoForm.CopyToClipBoardButtonClick(Sender: TObject);
begin
  PrintDecisionGrid.CopyToClipBoard(#9); // use tab delimiter
  ShowMessage('Tab delimited string values of cells are copied  to Clipboard');
end;

procedure TMainDemoForm.PrintDecisionGridReportPrintFooter(
  APageIndex: Integer; APlace: TTextPlace; var AText: String;
  AFont: TFont);
begin
  case APlace of
    tpLeft: ;
    tpCenter: begin
      AText := AText + '(Added in runtime)';
      if APageIndex = 0 then begin
        AFont.Color := clRed;
        AFont.Style := AFont.Style + [fsBold, fsUnderline];
      end;
    end;
    tpRight: ;
  end;
end;

procedure TMainDemoForm.FormCreate(Sender: TObject);
begin
  SetValuesToControls;
end;

procedure TMainDemoForm.PrintDecisionGridReportPrintPage(
  AParentCanvas: TCanvas; APageIndex: Integer);
var
  aScreenRect, aPrinterRect: TRect;
begin
  if APageIndex = 0 then begin
    aScreenRect := Rect(
      5, 5,
      5 + LogoImage.Width,
      5 + LogoImage.Height
    );
    // we call special method to define size of picture on current output canvas
    aPrinterRect := PrintDecisionGrid.GetPrintAreaRect(aScreenRect);
    AParentCanvas.StretchDraw(aPrinterRect, LogoImage.Picture.Graphic);
  end;
end;

procedure TMainDemoForm.HtmlReportReportButtonClick(Sender: TObject);

	procedure ShellExecuteCommand(ACommandStr: String);
  var
    TempString: array[0..99] of Char;
  begin
    StrPCopy(TempString, ACommandStr);
    ShellExecute(0, Nil, TempString, Nil, Nil, SW_NORMAL);
  end;

begin
  GetValuesFromControls;
	PrintDecisionGrid.PublishHTMLReport(HtmlReportPatternEdit.Text, True);
  ShellExecuteCommand(HtmlReportPatternEdit.Text + '0.htm');
end;

procedure TMainDemoForm.TotalsCheckBoxClick(Sender: TObject);
begin
	PrintDecisionGrid.Totals := TotalsCheckBox.Checked;
end;

(*This event handler demonstrates how to change output HTML report*)
procedure TMainDemoForm.PrintDecisionGridReportHTML(APageIndex: Integer;
  var AContent: String);
const
	TitleAdditionStr = 'HTML Reporting. ';
var
	aPos: Integer;
begin
	aPos := Pos('<TITLE>', AContent);
  if aPos <> 0 then begin
  	Insert(TitleAdditionStr, AContent, aPos + Length('<TITLE>'));
  end;
end;

procedure TMainDemoForm.AdjustWidthButtonClick(Sender: TObject);
begin
	PrintDecisionGrid.AdjustBestColumnWidhts;
end;

procedure TMainDemoForm.AdjustWidthsQuickButtonClick(Sender: TObject);
begin
	PrintDecisionGrid.DoAdjustBestColumnWidhts(PrintDecisionGrid.FixedCols - 1, PrintDecisionGrid.FixedRows - 1);
end;

procedure TMainDemoForm.ReportOptionsCheckListBoxClickCheck(
  Sender: TObject);
begin
	AdjustDuplicatesEnabled(Sender as TCheckListBox);
end;

procedure TMainDemoForm.ExcelButtonClick(Sender: TObject);
begin
  GetValuesFromControls;
  PrintDecisionGrid.ExportToExcel(ExcelPathEdit.Text, True);
end;

procedure TMainDemoForm.ExcelPTButtonClick(Sender: TObject);
begin
  GetValuesFromControls;
  PrintDecisionGrid.ExportToExcelAsPivotTable(ExcelPathEdit.Text, True);
end;

procedure TMainDemoForm.ExcelClipboardButtonClick(Sender: TObject);
begin
  GetValuesFromControls;
  PrintDecisionGrid.ExportToExcelWithClipboard(ExcelPathEdit.Text, True);
end;

end.
