unit PDJ_RegMsc;

{
*****************************
*         PDJTools          *
*****************************
}

// Register and Design Unit for PDJCtrl

//                            \\|//
//                            (@ @)
// ----------------------oOO---(_)---OOo-------------------------
// Copyright  2000-2003 by PDJTools
// Author Peric Djordje
// for D5,D6,D7
// --------------------------------------------------------------
//                           |__|__|
//                            || ||
//                           ooO Ooo
// http://www.ptt.yu/korisnici/p/e/pericddn/
// E-mail: pericddn@ptt.yu, pericddn@neobee.net
// If You find any errors or rubbish in PDJ_RegPlus.pas please send me Your suggest or Reclamation.

{$I DFS.INC}

interface

{$R PDJ_MscDsg.res}

uses Graphics,Windows,Classes,
  {$IFDEF DFS_NO_DSGNINTF}
  DesignIntf,VCLEditors,
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}

//******************************************************************************
{TDateTimeFormatProperty}

  type
  TDateTimeFormatProperty = class(TStringProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc); override;
  end;

//******************************************************************************
{TPDJStatusBarEditor}
type
  TPDJStatusBarEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;

//******************************************************************************
{TPDJMiscBarEditor}
type
  TPDJMiscBarEditor = class(TDefaultEditor)
    function GetVerbCount : Integer; override;
    function GetVerb(Index : Integer) : string; override;
    procedure ExecuteVerb(Index : Integer); override;
  end;


procedure Register;

implementation

uses  Forms, Dialogs, Controls, SysUtils, TypInfo,PDJ_AbFo,PDJ_HiEd,
      PDJ_StBr,PDJ_PrBr,PDJ_Basic,PDJ_LbEd,PDJ_MsX,PDJ_AnIm,PDJ_Hint,PDJ_HePa,


      PDJ_SpinLab,PDJ_OO,PDJ_GLab,PDJ_GrBtn,PDJ_GrPB,

      PDJ_ScrBox,PDJ_ImBtn,PDJ_UD;


procedure Register;
begin

  RegisterComponents('PDJ Misc',
  [
  TPDJStatusBar,TPDJStatusText,TPDJStatusKeyState,TPDJStatusDateTime,TPDJDBStatusText,
  TPDJListBoxEdit,
  
  TPDJMiscBar// pocetak izmisljenih komponenti

  ,TPDJAnimateImage,TPDJHint,TPDJImageShape,TPDJShape,

  TPDJHeaderPanel,TPDJShrinkPanel,

  TPDJSpinPanel,TPDJDatePeriod,TPDJPeriodEdit,

  TPDJOnlyOne,
  
  TPDJGradientText,TPDJDBGradientText,TPDJGradButton,TGradProgressBar,

  TPDJScrollBox,TPDJImageButton,TPDJUpDown
  ]);



  RegisterComponentEditor(TPDJStatusBar, TPDJStatusBarEditor);

  RegisterComponentEditor(TPDJMiscBar, TPDJMiscBarEditor);

  RegisterComponentEditor(TPDJStatusText, TPDJ_About);
  RegisterComponentEditor(TPDJStatusKeyState, TPDJ_About);
  RegisterComponentEditor(TPDJStatusDateTime, TPDJ_About);
  RegisterComponentEditor(TPDJDBStatusText, TPDJ_About);
  RegisterComponentEditor(TPDJItem, TPDJ_About);
  RegisterComponentEditor(TPDJAnimateImage, TPDJ_About);
  RegisterComponentEditor(TPDJImageShape, TPDJ_About);
  RegisterComponentEditor(TPDJShape, TPDJ_About);
  RegisterComponentEditor(TPDJHeaderPanel, TPDJ_About);
  RegisterComponentEditor(TPDJShrinkPanel, TPDJ_About);
  RegisterComponentEditor(TPDJScrollBox, TPDJ_About);
  RegisterComponentEditor(TPDJDatePeriod, TPDJ_About);

  RegisterComponentEditor(TPDJSpinPanel, TPDJ_About);
  RegisterComponentEditor(TPDJOnlyOne, TPDJ_About);
  RegisterComponentEditor(TPDJGradientText, TPDJ_About);
  RegisterComponentEditor(TPDJGradButton, TPDJ_About);
  RegisterComponentEditor(TGradProgressBar, TPDJ_About);
  RegisterComponentEditor(TPDJPeriodEdit, TPDJ_About);
  RegisterComponentEditor(TPDJImageButton, TPDJ_About);
  RegisterComponentEditor(TPDJUpDown, TPDJ_About);

  RegisterPropertyEditor(TypeInfo(String), TPDJStatusDateTime, 'DateTimeFormat', TDateTimeFormatProperty);

  RegisterClass(TPDJItem);
  RegisterNoIcon([TPDJItem]);
end;

//******************************************************************************
{TDateTimeFormatProperty}

function TDateTimeFormatProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [paValueList, paMultiSelect, paAutoUpdate];
end;

procedure TDateTimeFormatProperty.GetValues(Proc : TGetStrProc);
begin
Proc('c');
Proc('t');
Proc('tt');
Proc('ddddd');
Proc('dddddd');
Proc('ddddd t');
Proc('ddddd tt');
Proc('dddddd tt');
Proc('m/d/yy');
Proc('mm/dd/yy');
Proc('d/m/yy');
Proc('dd/mm/yy');
Proc('dd/mm/yyyy');
Proc('h:n:s');
Proc('h:n:s a/p');
Proc('h:nn:ss');
Proc('h:nn:ss am/pm');
Proc('hh:nn:ss');
Proc('hh:nn:ss am/pm');
end;

//******************************************************************************
{TPDJStatusBarProperty}

function TPDJStatusBarEditor.GetVerbCount : Integer;
begin
  Result := 7;
end;

function TPDJStatusBarEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'New PDJStatusText';
    1 : Result := 'New PDJStatusKeyState';
    2 : Result := 'New PDJStatusDateTime';
    3 : Result := 'New PDJProgressBar';
    4 : Result := 'New PDJDBStatusText';
    5  : Result := '-';
    6  : Result := PCVersion;
  end;
end;

procedure TPDJStatusBarEditor.ExecuteVerb(Index : Integer);
var
    StatusText,NewStatusText: TPDJStatusText;
    StatusKeyState,NewStatusKeyState:TPDJStatusKeyState;
    StatusDateTime,NewStatusDateTime:TPDJStatusDateTime;
    StatusProgressBar,NewStatusProgressBar:TPDJProgressBar;
    StatusDBStatusText,NewDBStatusText:TPDJDBStatusText;
    Main:TPDJStatusBar;
begin
    Main:=TPDJStatusBar(Component);
    case Index of
    0:
      begin
      StatusText:=TPDJStatusText(Component);
      if Main=nil then exit;
      NewStatusText:=TPDJStatusText.Create(StatusText.Owner);
      NewStatusText.Name:=Designer.UniqueName(TPDJStatusText.ClassName);
      NewStatusText.Parent:=Main;
      NewStatusText.Align:=alRight;
      NewStatusText.Align:=alLeft;
      Designer.SelectComponent(NewStatusText);
      end;
    1:
      begin
      StatusKeyState:=TPDJStatusKeyState(Component);
      if Main=nil then exit;
      NewStatusKeyState:=TPDJStatusKeyState.Create(StatusKeyState.Owner);
      NewStatusKeyState.Name:=Designer.UniqueName(TPDJStatusKeyState.ClassName);
      NewStatusKeyState.Parent:=Main;
      NewStatusKeyState.Align:=alRight;
      NewStatusKeyState.Align:=alLeft;
      Designer.SelectComponent(NewStatusKeyState);
      end;
    2:
      begin
      StatusDateTime:=TPDJStatusDateTime(Component);
      if Main=nil then exit;
      NewStatusDateTime:=TPDJStatusDateTime.Create(StatusDateTime.Owner);
      NewStatusDateTime.Name:=Designer.UniqueName(TPDJStatusDateTime.ClassName);
      NewStatusDateTime.Parent:=Main;
      NewStatusDateTime.Align:=alRight;
      NewStatusDateTime.Align:=alLeft;
      Designer.SelectComponent(NewStatusDateTime);
      end;
    3:
      begin
      StatusProgressBar:=TPDJProgressBar(Component);
      if Main=nil then exit;
      NewStatusProgressBar:=TPDJProgressBar.Create(StatusProgressBar.Owner);
      NewStatusProgressBar.Name:=Designer.UniqueName(TPDJProgressBar.ClassName);
      NewStatusProgressBar.Parent:=Main;
      NewStatusProgressBar.Align:=alRight;
      NewStatusProgressBar.Align:=alLeft;
      Designer.SelectComponent(NewStatusProgressBar);
      end;
     4:
      begin
      StatusDBStatusText:=TPDJDBStatusText(Component);
      if Main=nil then exit;
      NewDBStatusText:=TPDJDBStatusText.Create(StatusDBStatusText.Owner);
      NewDBStatusText.Name:=Designer.UniqueName(TPDJDBStatusText.ClassName);
      NewDBStatusText.Parent:=Main;
      NewDBStatusText.Align:=alRight;
      NewDBStatusText.Align:=alLeft;
      Designer.SelectComponent(NewDBStatusText);
      end;
    6:
      begin
      ShowAboutDialog;
      Exit;
      end;
    end;
      Designer.Modified;
end;


//******************************************************************************
{TPDJMiscBarEditor}

function TPDJMiscBarEditor.GetVerbCount : Integer;
begin
  Result := 3;
end;

function TPDJMiscBarEditor.GetVerb(Index : Integer) : string;
begin
  case Index of
    0 : Result := 'New PDJItem';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

procedure TPDJMiscBarEditor.ExecuteVerb(Index : Integer);
var
    Item,NewItem: TPDJItem;
    Main:TPDJMiscBar;
begin
    Main:=TPDJMiscBar(Component);
    case Index of
    0:
      begin
      Item:=TPDJItem(Component);
      if Main=nil then exit;
      NewItem:=TPDJItem.Create(Item.Owner);
      NewItem.Name:=Designer.UniqueName(TPDJItem.ClassName);
      NewItem.Parent:=Main;
      NewItem.Align:=alRight;
      NewItem.Align:=alLeft;
      NewItem.Transparent:=True;
      Designer.SelectComponent(NewItem);
      end;
    2:
      begin
      ShowAboutDialog;
      Exit;
      end;
    end;
      Designer.Modified;
end;

end.
