unit PDJ_DsgProEdit;

{
*****************************
*         PDJTools          *
*****************************
}

// Register and Design Unit for PDJCtrl

//                            \\|//
//                            (@ @)
// ----------------------oOO---(_)---OOo-------------------------
// Copyright  2000-2004 by PDJTools
// Author Peric Djordje
// for D5,D6,D7
// --------------------------------------------------------------
//                           |__|__|
//                            || ||
//                           ooO Ooo
// http://www.ptt.yu/korisnici/p/e/pericddn/
// E-mail: pericddn@ptt.yu, pericddn@neobee.net
// If You find any errors or rubbish in PDJ_DsgProEdit.pas please send me Your suggest or Reclamation.

{$I DFS.INC}

{$R PDJ_DsgproEdit.res}

interface

uses Windows,Graphics, Classes,
  {$IFDEF DFS_NO_DSGNINTF}
  DesignIntf,VCLEditors,
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}
  

//******************************************************************************
{TPDJ_BitBtnKindProperty}

type
  TPDJ_BitBtnKindProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_FormBorderStyleProperty}

type
  TPDJ_FormBorderStyleProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_AlignProperty}

type
  TPDJ_AlignProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_BooleanProperty}

type
  TPDJ_BooleanProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_CharCaseProperty}

type
  TPDJ_CharCaseProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

  //******************************************************************************
{TPDJ_CheckBoxStateProperty}

type
  TPDJ_CheckBoxStateProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    procedure DrawChekMark(ACanvas:TCanvas;R:TRect);
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_ScrollStyleProperty}

type
  TPDJ_ScrollStyleProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public

    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_ColorProperty}

type
  TPDJ_ColorProperty = class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;

    { ICustomPropertyListDrawing }
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_BorderStyleProperty}

type
  TPDJ_BorderStyleProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

procedure Register;

implementation

uses  TypInfo, Forms, Controls, SysUtils,Math,Buttons,Registry,StdCtrls,Dialogs,
PDJ_Basic;

var
  BaseRegistryKey: string = '';

const

  hcDColorEditor      = 25010;

procedure Register;
begin
RegisterPropertyEditor(TypeInfo(TBitBtnKind), TPersistent, '',TPDJ_BitBtnKindProperty);
RegisterPropertyEditor(TypeInfo(TFormBorderStyle), TPersistent, '',TPDJ_FormBorderStyleProperty);
RegisterPropertyEditor(TypeInfo(TAlign), TPersistent, '',TPDJ_AlignProperty);
RegisterPropertyEditor(TypeInfo(Boolean), TPersistent, '',TPDJ_BooleanProperty);
RegisterPropertyEditor(TypeInfo(TEditCharCase), TPersistent, '',TPDJ_CharCaseProperty);
RegisterPropertyEditor(TypeInfo(TCheckBoxState), TPersistent, '',TPDJ_CheckBoxStateProperty);
RegisterPropertyEditor(TypeInfo(TScrollStyle), TPersistent, '',TPDJ_ScrollStyleProperty);
RegisterPropertyEditor(TypeInfo(TColor), TPersistent, '',TPDJ_ColorProperty);
RegisterPropertyEditor(TypeInfo(TBorderStyle), TPersistent, '',TPDJ_BorderStyleProperty);
end;

//******************************************************************************
{TPDJ_BitBtnKindProperty}

procedure TPDJ_BitBtnKindProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_BitBtnKindProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_BitBtnKindProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  R: TRect;
  TextStart: Integer;
  Style: TBitBtnKind;
  Bmp, BorderStyleBmp: TBitmap;
  TransparentColor: TColor;
  DestRct, SrcRct: TRect;
  BmpOffset: Integer;
begin
  R := ARect;
  R.Right := R.Left + ( R.Bottom - R.Top )+4;
  TextStart := R.Right;
  with ACanvas do
  begin
    Bmp := TBitmap.Create;
    BorderStyleBmp := TBitmap.Create;
    try
      FillRect( R );

      DestRct := Classes.Rect( 0, 0,18, 18 );
      SrcRct := DestRct;
      BmpOffset := ( ( R.Bottom - R.Top ) - 18 ) div 2;

      { Don't Forget to Set the Width and Height of Destination Bitmap }
      Bmp.Width := 18;
      Bmp.Height := 18;

      Bmp.Canvas.Brush.Color := ACanvas.Brush.Color;

      TransparentColor := clOlive;

      Style := TBitBtnKind( GetEnumValue( GetPropInfo^.PropType^, Value ) );
      with R do
      begin
        case Style of
bkCustom:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBCUSTOM' );
bkOK:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBOK' );
bkCancel:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBCANCEL' );
bkHelp:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBHELP' );
bkYes:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBYES' );
bkNo:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBNO' );
bkClose:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBCLOSE' );
bkAbort:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBABORT' );
bkRetry:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBRETRY' );
bkIgnore:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBIGNORE' );
bkAll:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BBALL' );

        end;
        Bmp.Canvas.BrushCopy( DestRct, BorderStyleBmp, SrcRct, TransparentColor );
        Draw( Left + 4, Top + BmpOffset, Bmp );
      end;
    finally
      Bmp.Free;
      BorderStyleBmp.Free;

    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(TextStart, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(TextStart, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
    end;
  end;
end;

procedure TPDJ_BitBtnKindProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_BitBtnKindProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := 20;
end;



//******************************************************************************
{TPDJ_FormBorderStyleProperty}

procedure TPDJ_FormBorderStyleProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_FormBorderStyleProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_FormBorderStyleProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  R: TRect;
  TextStart: Integer;
  Style: TFormBorderStyle;
  Bmp, BorderStyleBmp: TBitmap;
  TransparentColor: TColor;
  DestRct, SrcRct: TRect;
  BmpOffset: Integer;
begin
  R := ARect;
  R.Right := R.Left + ( R.Bottom - R.Top )+4;
  TextStart := R.Right;
  with ACanvas do
  begin
    Bmp := TBitmap.Create;
    BorderStyleBmp := TBitmap.Create;
    try
      FillRect( R );

      DestRct := Classes.Rect( 0, 0, 20, 20 );
      SrcRct := DestRct;
      BmpOffset := ( ( R.Bottom - R.Top ) - 20 ) div 2;

      Bmp.Width := 20;
      Bmp.Height := 20;

      Bmp.Canvas.Brush.Color := ACanvas.Brush.Color;

      TransparentColor := clOlive;

      Style := TFormBorderStyle( GetEnumValue( GetPropInfo^.PropType^, Value ) );
      with R do
      begin
        case Style of
bsNone:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSNONE' );
bsSingle:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSSINGLE' );
bsSizeable:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSSIZEABLE' );
bsDialog:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSDIALOG' );
bsToolWindow:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSTOOLWINDOW' );
bsSizeToolWin:BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_FBSSIZETOOLWIN' );
end;
Bmp.Canvas.BrushCopy( DestRct, BorderStyleBmp, SrcRct, TransparentColor );
Draw( Left + 2, Top + BmpOffset, Bmp );
      end;
    finally
      Bmp.Free;
      BorderStyleBmp.Free;

      {$IFDEF DFS_NO_DSGNINTF}
      DefaultPropertyListDrawValue( Value, ACanvas,
                                    Rect( TextStart, ARect.Top, ARect.Right, ARect.Bottom ),
                                    ASelected );
      {$ELSE}
      inherited ListDrawValue( Value, ACanvas,
                               Rect( TextStart, ARect.Top, ARect.Right, ARect.Bottom ),
                               ASelected );
      {$ENDIF}
    end;
  end;
end;

procedure TPDJ_FormBorderStyleProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_FormBorderStyleProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := 24;
end;

//******************************************************************************
{TPDJ_AlignProperty}

procedure TPDJ_AlignProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_AlignProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_AlignProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempAlign:TAlign;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);
    TempAlign := TAlign(GetEnumValue(GetPropInfo^.PropType^, Value));

    Pen.Color := $000080FF;
    Brush.Color:=clWhite;
    Rectangle(R);

    Brush.Color := ColorToRGB(XPColorHl(ACanvas,$000080FF,58));

Case TempAlign of
alNone:
begin
InflateRect (R, -3, -3);
Rectangle(R);
end;
alTop:Rectangle(R.Left,R.Top,R.Right,R.Top+2+(R.Bottom-R.Top) div 3);
alBottom:Rectangle(R.Left,R.Bottom-2-(R.Bottom-R.Top) div 3,R.Right,R.Bottom);
alLeft:Rectangle(R.Left,R.Top,R.Left+2+(R.Right-R.Left) div 3 ,R.Bottom);
alRight:Rectangle(R.Right-2-(R.Right-R.Left) div 3,R.Top,R.Right,R.Bottom);
alClient:Rectangle(R);
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_AlignProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_AlignProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight + 9;
end;

//******************************************************************************
{TPDJ_BooleanProperty}

procedure TPDJ_BooleanProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_BooleanProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_BooleanProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);

    Brush.Color:=clWhite;
    Pen.Color := $00C85810;//$000657FF;
    Rectangle(R);
InflateRect (R, -1, -1);
Pen.Color := $004A9500;//$004080FF;
if Value='True' then
begin
penpos := Point(R.left+2, R.top+4);
lineto(R.left+6, R.top+8);
penpos := Point(R.left+2, R.top+5);
lineto(R.left+5, R.top+8);
penpos := Point(R.left+2, R.top+6);
lineto(R.left+5, R.top+9);
penpos := Point(R.left+8, R.top+2);
lineto(R.left+4, R.top+6);
penpos := Point(R.left+8, R.top+3);
lineto(R.left+4, R.top+7);
penpos := Point(R.left+8, R.top+4);
lineto(R.left+5, R.top+7);
end
else
begin
Pen.Color := clMaroon;
penpos := Point(R.left+2, R.top+2);
lineto(R.left+9, R.top+9);
penpos := Point(R.left+3, R.top+2);
lineto(R.left+9, R.top+8);
penpos := Point(R.left+2, R.top+3);
lineto(R.left+8, R.top+9);
 
penpos := Point(R.left+2, R.top+7);
lineto(R.left+8, R.top+1);
penpos := Point(R.left+2, R.top+8);
lineto(R.left+9, R.top+1);
penpos := Point(R.left+3, R.top+8);
lineto(R.left+9, R.top+2);
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_BooleanProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_BooleanProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight;
end;

//******************************************************************************
{TPDJ_CharCaseProperty}

procedure TPDJ_CharCaseProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_CharCaseProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_CharCaseProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempCharCase:TEditCharCase;
  Tx:string;
  vOldFont:TColor;
  vOldFontStyle:TFontStyles;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left+6;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;
   vOldFont:=Font.Color;
   vOldFontStyle:=Font.Style;

    // frame things

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);
    Brush.Color:=ColorToRGB(XPColorHl(ACanvas,clBtnFace,58));
    Pen.Color:=ColorToRGB(XPColorHl(ACanvas,clBtnFace,58));
    Rectangle(R);

    TempCharCase := TEditCharCase(GetEnumValue(GetPropInfo^.PropType^, Value));

Case TempCharCase of
ecNormal:Tx:='Ab';
ecUpperCase:Tx:='AB';
ecLowerCase:Tx:='ab';
end;
Font.Style:=[fsBold];
Font.Color:=$00C85810;
R.left:=R.Left+2;
DrawText(ACanvas.Handle, PChar(Tx), Length(Tx), R, DT_LEFT or DT_SINGLELINE or DT_VCENTER);

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
    Font.Color:=vOldFont;
    Font.Style:=vOldFontStyle;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_CharCaseProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_CharCaseProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight;
end;


//******************************************************************************
{TPDJ_CheckBoxStateProperty}

procedure TPDJ_CheckBoxStateProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_CheckBoxStateProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_CheckBoxStateProperty.DrawChekMark(ACanvas:TCanvas;R:TRect);
begin
with ACanvas do begin
inflateRect(R,-1,-1);
penpos := Point(R.left+2, R.top+4);
lineto(R.left+6, R.top+8);
penpos := Point(R.left+2, R.top+5);
lineto(R.left+5, R.top+8);
penpos := Point(R.left+2, R.top+6);
lineto(R.left+5, R.top+9);
penpos := Point(R.left+8, R.top+2);
lineto(R.left+4, R.top+6);
penpos := Point(R.left+8, R.top+3);
lineto(R.left+4, R.top+7);
penpos := Point(R.left+8, R.top+4);
lineto(R.left+5, R.top+7);
end;
end;

procedure TPDJ_CheckBoxStateProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempCheckBoxState:TCheckBoxState;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;

    // frame things

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);
    Brush.Color:=clWhite;
    Pen.Color:=$00C85810;
    Rectangle(R);

    TempCheckBoxState := TCheckBoxState(GetEnumValue(GetPropInfo^.PropType^, Value));
Case TempCheckBoxState of
cbChecked:
DrawChekMark(ACanvas,R);
cbGrayed:
begin
    Brush.Color:=ColorToRGB(XPColorHl(ACanvas,clBtnFace,58));
    Rectangle(R);
    Pen.Color:=clBtnShadow;
    DrawChekMark(ACanvas,R);
end;
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_CheckBoxStateProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_CheckBoxStateProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight;
end;

//******************************************************************************
{TPDJ_ScrollStyleProperty}

procedure TPDJ_ScrollStyleProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_ScrollStyleProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_ScrollStyleProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempScrollStyle:TScrollStyle;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);
    TempScrollStyle := TScrollStyle(GetEnumValue(GetPropInfo^.PropType^, Value));

    Pen.Color := $005EBB00;
    Brush.Color:=clWhite;
    Rectangle(R);

    Brush.Color := ColorToRGB(XPColorHl(ACanvas,$005EBB00,58));

Case TempScrollStyle of
ssHorizontal:
begin
Rectangle(R.Left,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Right,R.Bottom);
Brush.Color:=$005EBB00;
Rectangle(R.Left,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Left+4,R.Bottom);
Rectangle(R.Right-4,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Right,R.Bottom);
end;
ssVertical:
begin
Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Top,R.Right,R.Bottom);
Brush.Color:=$005EBB00;
Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Top,R.Right,R.Top+4);
Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Bottom-4,R.Right,R.Bottom);
end;
ssBoth:
begin
Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Top,R.Right,R.Bottom-2-(R.Right-R.Left) div 4);
Rectangle(R.Left,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Right-2-(R.Right-R.Left) div 4,R.Bottom);
Brush.Color:=$005EBB00;
Rectangle(R.Left,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Left+4,R.Bottom);
Rectangle(R.Right-6-(R.Right-R.Left) div 4,R.Bottom-2-(R.Bottom-R.Top) div 4,R.Right-2-(R.Right-R.Left) div 4,R.Bottom);

Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Top,R.Right,R.Top+4);
Rectangle(R.Right-2-(R.Right-R.Left) div 4,R.Bottom-6-(R.Right-R.Left) div 4,R.Right,R.Bottom-2-(R.Right-R.Left) div 4);

end;
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_ScrollStyleProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_ScrollStyleProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight + 12;
end;

//******************************************************************************
{TPDJ_ColorProperty}

procedure TPDJ_ColorProperty.Edit;
var
  ColorDialog: TColorDialog;
  IniFile: TRegIniFile;
  procedure GetCustomColors;
  begin
    if BaseRegistryKey = '' then Exit;
    IniFile := TRegIniFile.Create(BaseRegistryKey);
    try
      IniFile.ReadSectionValues('Custom Colors', ColorDialog.CustomColors);
    except
      { Ignore errors reading values }
    end;
  end;

  procedure SaveCustomColors;
  var
    I, P: Integer;
    S: string;
  begin
    if IniFile <> nil then
      with ColorDialog do
        for I := 0 to CustomColors.Count - 1 do
        begin
          S := CustomColors.Strings[I];
          P := Pos('=', S);
          if P <> 0 then
          begin
            S := Copy(S, 1, P - 1);
            IniFile.WriteString('Custom Colors', S,
              CustomColors.Values[S]);
          end;
        end;
  end;

begin
  IniFile := nil;
  ColorDialog := TColorDialog.Create(Application);
  try
    GetCustomColors;
    ColorDialog.Color := GetOrdValue;
    ColorDialog.HelpContext := hcDColorEditor;
    ColorDialog.Options := [cdShowHelp];
    if ColorDialog.Execute then SetOrdValue(ColorDialog.Color);
    SaveCustomColors;
  finally
    IniFile.Free;
    ColorDialog.Free;
  end;
end;

function TPDJ_ColorProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList, paRevertable];
end;

function TPDJ_ColorProperty.GetValue: string;
begin
  Result := ColorToString(TColor(GetOrdValue));
end;

procedure TPDJ_ColorProperty.GetValues(Proc: TGetStrProc);
begin
  GetColorValues(Proc);
end;

procedure TPDJ_ColorProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, True{ASelected})
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_ColorProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_ColorProperty.ListDrawValue(const Value: string; ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
  function ColorToBorderColor(AColor: TColor): TColor;
  type
    TColorQuad = record
      Red,
      Green,
      Blue,
      Alpha: Byte;
    end;
  begin
    if (TColorQuad(AColor).Red > 192) or
       (TColorQuad(AColor).Green > 192) or
       (TColorQuad(AColor).Blue > 192) then
      Result := clBlack
    else if ASelected then
      Result := clWhite
    else
      Result := AColor;
  end;
var
  vRight: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  R:TRect;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;

    // frame things
    Pen.Color := Brush.Color;
    Rectangle(ARect.Left, ARect.Top, vRight, ARect.Bottom);

    // set things up and do the work
    Brush.Color := StringToColor(Value);
    Pen.Color := ColorToBorderColor(ColorToRGB(Brush.Color));
    Rectangle(ARect.Left + 1, ARect.Top + 1, vRight - 1, ARect.Bottom - 1);

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);

    Pen.Color := clBtnShadow;
    if value='clNone' then begin
      MoveTo(R.Left, R.Bottom - 1);
      LineTo(R.Right - 1, R.Top);
      MoveTo(R.Left, R.Top);
      LineTo(R.Right, R.Bottom);
    end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Pen.Color := vOldPenColor;

  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_ColorProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('M') {* 2};
end;

procedure TPDJ_ColorProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight + 6;
end;

procedure TPDJ_ColorProperty.SetValue(const Value: string);
var
  NewValue: Longint;
begin
  if IdentToColor(Value, NewValue) then
    SetOrdValue(NewValue)
  else
    inherited SetValue(Value);
end;

//******************************************************************************
{TPDJ_BorderStyleProperty}

procedure TPDJ_BorderStyleProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_BorderStyleProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_BorderStyleProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  TempRect:TRect;
  TempBorder:TBorderStyle;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left+6;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;


    // frame things
    Brush.Color := clBtnFace;
    Pen.Color := clBtnFace;
    FillRect(Rect(ARect.Left, ARect.Top, vRight, ARect.Bottom));

    TempRect:=Rect(ARect.Left+2, ARect.Top+2, vRight-2, ARect.Bottom-2);

    TempBorder := TBorderStyle(GetEnumValue(GetPropInfo^.PropType^, Value));

    Case TempBorder of
    bsNone:
     begin
     Pen.Color:=clWhite;
     Brush.Color:=clWhite;
     Rectangle(TempRect);
     end;
    bsSingle:
      begin
     DrawEdge(ACanvas.handle, TempRect, EDGE_BUMP, BF_RECT or BF_Flat);
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENINNER, BF_TOPLEFT or BF_ADJUST);
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT or BF_ADJUST);
      end;
    end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;

  finally

    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_BorderStyleProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_BorderStyleProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight+4;
end;


end.
