unit PDJ_RegBasic;

{
*****************************
*         PDJTools          *
*****************************
}

// Register and Design Unit for PDJCtrl

//..............................................................................
// Copyright  2000-2003 by PDJTools
// Author Peric Djordje
// for D5,D6,D7
//..............................................................................
// http://www.ptt.yu/korisnici/p/e/pericddn/
// E-mail: pericddn@ptt.yu, pericddn@neobee.net
// If You find any errors or rubbish in PDJ_RegBasic.pas please send me Your suggest or Reclamation.

{$I DFS.INC}

interface

{$R PDJ_CtrlBasDsg.res}

uses Graphics,Windows, Classes,
  {$IFDEF DFS_NO_DSGNINTF}
  DesignIntf,VCLEditors,
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}

//******************************************************************************
{TPDJ_TreeEditor}

  type
  TPDJ_TreeEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;
//******************************************************************************
{TPDJ_ListEditor}

type
  TPDJ_ListEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;

//******************************************************************************
{TPDJ_BorderProperty}

type
  TPDJ_BorderProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure DrawArrow(ACanvas:TCanvas;R:TRect);
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

procedure Register;

implementation

uses  Forms, Dialogs, Controls, SysUtils, TypInfo,StdCtrls,
      PDJ_Basic,PDJ_HiEd, PDJ_AbFo;

procedure Register;
begin

  RegisterComponents('PDJ Controls',
  [
  TPDJEdit,
  TPDJComboBox,
  TPDJListBox,
  TPDJMemo ,TPDJRichEdit,
  TPDJTreeView, TPDJListView
  ]);

//******************************************************************************
  {PDJ Controls}

  RegisterComponentEditor(TPDJEdit, TPDJ_About);
  RegisterComponentEditor(TPDJComboBox, TPDJ_About);
  RegisterComponentEditor(TPDJListBox, TPDJ_About);
  RegisterComponentEditor(TPDJMemo, TPDJ_About);
  RegisterComponentEditor(TPDJRichEdit, TPDJ_About);
  RegisterComponentEditor(TPDJTreeView, TPDJ_TreeEditor);
  RegisterComponentEditor(TPDJListView, TPDJ_ListEditor);

  RegisterPropertyEditor(TypeInfo(String), TPDJEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMemo, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJRichEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJTreeView, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJListView, 'Hint', TPDJ_HiEd);


  
  //pdj  universal property editor
  RegisterPropertyEditor(TypeInfo(TBorder), TPersistent, '',TPDJ_BorderProperty);
end;

//******************************************************************************
{TPDJ_TreeEditor}

procedure TPDJ_TreeEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_TreeEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'Items' then
    Prop.Edit;
end;

procedure TPDJ_TreeEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_TreeEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'Items Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_TreeEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

//******************************************************************************
{TPDJ_ListEditor}

procedure TPDJ_ListEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_ListEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'Items' then
    Prop.Edit;
end;

procedure TPDJ_ListEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_ListEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'Items Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_ListEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

//******************************************************************************
{TPDJ_BorderProperty}

procedure TPDJ_BorderProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_BorderProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_BorderProperty.DrawArrow(ACanvas:TCanvas;R:TRect);
begin
with ACanvas do
begin
pen.color:=clBlack;
Moveto(R.Left, R.Top);
LineTo(R.Left, R.Top+12);
Moveto(R.Left+1, R.Top);
LineTo(R.Right, R.Top+8);
Moveto(R.Left+5, R.Top+7);
LineTo(R.Right-1, R.Top+7);
Moveto(R.Left+5, R.Top+7);
LineTo(R.Left+5, R.Bottom);
Moveto(R.Left+6, R.Top+9);
LineTo(R.Left+6, R.Bottom);
Moveto(R.Left+7, R.Top+11);
LineTo(R.Left+7, R.Bottom-1);
Moveto(R.Left+4, R.Top+11);
LineTo(R.Left+4, R.Bottom-1);
Moveto(R.Left+3, R.Top+9);
LineTo(R.Left+3, R.Bottom-3);
Pixels[R.Left+1,R.Top+10]:=clBlack;
Pixels[R.Left+2,R.Top+9]:=clBlack;
Pen.Color:=clWhite;
Moveto(R.Left+1, R.Top+1);
LineTo(R.Left+1, R.Top+10);
Moveto(R.Left+2, R.Top+2);
LineTo(R.Left+2, R.Top+9);
Moveto(R.Left+3, R.Top+3);
LineTo(R.Left+3, R.Top+9);
Moveto(R.Left+4, R.Top+4);
LineTo(R.Left+4, R.Top+11);
Moveto(R.Left+5, R.Top+5);
LineTo(R.Left+5, R.Top+7);
Pixels[R.Left+6,R.Top+6]:=clWhite;
Moveto(R.Left+5, R.Top+9);
LineTo(R.Left+5, R.Top+13);
Moveto(R.Left+6, R.Top+11);
LineTo(R.Left+6, R.Top+13);
end;
end;

procedure TPDJ_BorderProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  TempRect:TRect;
  TempBorder:TBorder;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left+10;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things
    Brush.Color := ColorToRGB(XPColorHl(ACanvas,clBtnFace,58));
    Pen.Color := ColorToRGB(XPColorHl(ACanvas,clBtnFace,58));
    FillRect(Rect(ARect.Left, ARect.Top, vRight, ARect.Bottom));

    TempRect:=Rect(ARect.Left+2, ARect.Top+2, vRight-2, ARect.Bottom-2);

    TempBorder := TBorder(GetEnumValue(GetPropInfo^.PropType^, Value));

    Case TempBorder of
    bsFlat,bsSuperFlat:
    begin
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
     TempRect.Left:=TempRect.Left+4+(TempRect.Right-TempRect.Left) div 2 ;
     TempRect.Bottom:=TempRect.Top+14;
     TempRect.Right:=TempRect.Left+9;
     TempRect.Top:=TempRect.Top-1;
     DrawArrow(ACanvas,TempRect);
    end;
    bsSoftEdge:
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
    bsColorEdge,bsColorEdgeFlat:
     begin
     Pen.Color:=$00C85810;
     Rectangle(TempRect);
     end;
    bsRaiseEdge:
       DrawEdge(ACanvas.handle, TempRect, EDGE_BUMP,BF_RECT );
    bsRaise:
       DrawEdge(ACanvas.handle, TempRect, EDGE_RAISED,BF_RECT );
    bsBracket:
     DrawEdge(ACanvas.handle, TempRect, EDGE_BUMP, BF_RECT or BF_Flat);
    bsBottomLine:
     begin
     Pen.Color:=$00C85810;
     Moveto(TempRect.Left+1,TempRect.Bottom - 2);
     LineTo(TempRect.Right-1 ,TempRect.Bottom - 2);
     end;
    bsBoldColorEdge:
     begin
     Pen.Color:=$00C85810;
     Pen.Width:=2;
     Rectangle(TempRect);
     end;
    bsRoundColorEdge:
     begin
     Pen.Color:=$00C85810;
     RoundRect(ARect.Left+2, ARect.Top+2, vRight-2, ARect.Bottom-2,6,6);
     end;
    bsRoundBoldColorEdge:
     begin
     Pen.Color:=$00C85810;
     Pen.Width:=2;
     RoundRect(ARect.Left+2, ARect.Top+2, vRight-2, ARect.Bottom-2,6,6);
     end;
    bsColorLowered:
     begin
      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,68));
      Moveto(TempRect.Left,TempRect.Bottom - 2);
      LineTo(TempRect.Right-1,TempRect.Bottom - 2);
      Moveto(TempRect.right-2, TempRect.top);
      LineTo(TempRect.right-2, TempRect.bottom-1);

      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,58));
      Moveto(TempRect.left, TempRect.top);
      LineTo(TempRect.Right-1, TempRect.top);
      Moveto(TempRect.Left, TempRect.Top);
      LineTo(TempRect.Left, TempRect.Bottom-1);

      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,8));
      Moveto(TempRect.left+1, TempRect.top+1);
      LineTo(TempRect.Right-2, TempRect.top+1);
      Moveto(TempRect.Left+1, TempRect.Top+1);
      LineTo(TempRect.Left+1, TempRect.Bottom-2);
     end;
    bsColorRaised:
      begin
      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,8));
      Moveto(TempRect.Left,TempRect.Bottom - 2);
      LineTo(TempRect.Right-1,TempRect.Bottom - 2);
      Moveto(TempRect.right-2, TempRect.top);
      LineTo(TempRect.right-2, TempRect.bottom-1);

      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,58));
      Moveto(TempRect.left, TempRect.top);
      LineTo(TempRect.Right-1, TempRect.top);
      Moveto(TempRect.Left, TempRect.Top);
      LineTo(TempRect.Left, TempRect.Bottom-1);

      Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,68));
      Moveto(TempRect.left+1, TempRect.top+1);
      LineTo(TempRect.Right-2, TempRect.top+1);
      Moveto(TempRect.Left+1, TempRect.Top+1);
      LineTo(TempRect.Left+1, TempRect.Bottom-2);
     end;
    bsDotColorEdge:
    begin
     Pen.Color:=$00C85810;
     Pen.Style:=psDot;
     Rectangle(TempRect);
    end;
    bsStandard:
     begin
     DrawEdge(ACanvas.handle, TempRect, EDGE_BUMP, BF_RECT or BF_Flat);
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENINNER, BF_TOPLEFT or BF_ADJUST);
     DrawEdge(ACanvas.handle, TempRect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT or BF_ADJUST);
     end;
    bsXPEdge:
     begin
     Pen.Color := ColorToRGB(XPColorHl(ACanvas,$00C85810,38));
     Rectangle(TempRect);
     TempRect.Left:=TempRect.Left+4+(TempRect.Right-TempRect.Left) div 2 ;
     TempRect.Bottom:=TempRect.Top+14;
     TempRect.Right:=TempRect.Left+9;
     TempRect.Top:=TempRect.Top-1;
     DrawArrow(ACanvas,TempRect);
     end;
    end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
   
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_BorderProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_BorderProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight + 9;
end;

end.
