unit PDJ_RegPlus;

{
*****************************
*         PDJTools          *
*****************************
}

// Register and Design Unit for PDJCtrl

//..............................................................................
// Copyright  2000-2003 by PDJTools
// Author Peric Djordje
// for D5,D6,D7
//..............................................................................
// http://www.ptt.yu/korisnici/p/e/pericddn/
// E-mail: pericddn@ptt.yu, pericddn@neobee.net
// If You find any errors or rubbish in PDJ_RegPlus.pas please send me Your suggest or Reclamation.

{$I DFS.INC}

interface

{$R PDJ_CtrlDsgPlus.res}

uses Graphics,Windows,Classes,
  {$IFDEF DFS_NO_DSGNINTF}
  DesignIntf,VCLEditors,
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}

//******************************************************************************
{TPDJ_LGEditor}

type
TPDJ_LGEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;

//******************************************************************************
type
  TPDJ_ButtonTypeProperty=class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;


procedure Register;

implementation

uses  Forms, Dialogs, Controls, SysUtils, TypInfo,
      PDJ_AbFo,PDJ_EmFo, PDJ_MeT,PDJ_HiEd,PDJ_FO,PDJ_ColPan,PDJ_EDColor,
      PDJ_ImEdi,PDJ_BtnColor,PDJ_AuEd,PDJ_FoCap,PDJ_LinePan,PDJ_EdLine,
      PDJ_CbwBt,PDJ_EdLb,PDJ_MsEdLb,PDJ_TbEdLb,PDJ_TeLb,PDJ_Ico,PDJ_Lab,PDJ_Basic
      ,PDJ_SB;

//******************************************************************************
{TPDJ_LGEditor}

procedure TPDJ_LGEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_LGEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'LGLabels' then
    Prop.Edit;
end;

procedure TPDJ_LGEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_LGEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'LGLabels Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_LGEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;



procedure Register;
begin

  RegisterComponents('PDJ Controls',
  [
  TPDJFilesOp
  ]);

  RegisterComponents('PDJ Plus',
  [
  TPDJColorPanel,TPDJEditColor,TPDJImageEdit,TPDJImageMaskEdit,
  TPDJPickColorBtn,TPDJAutoCompeteEdit,TPDJAutoCompeteEditMultiB,
  TPDJCaptionPanel,TPDJLinePanel,TPDJEditLine,

  TPDJEditListBox,TPDJMaskEditListBox,TPDJEditListBoxB,TPDJTBEditListBox,
  TPDJExComboBox,

  TPDJWallpaper,

  TPDJImageLabel,TPDJLabelGroup,TPDJHeader,

  TPDJTypeButton,TPDJGradientPanel
  ]);

//******************************************************************************
  {PDJ Controls}

  RegisterComponentEditor(TPDJFilesOp, TPDJ_About);
  RegisterComponentEditor(TPDJColorPanel, TPDJ_About);
  RegisterComponentEditor(TPDJEditColor, TPDJ_About);
  RegisterComponentEditor(TPDJPickColorBtn, TPDJ_About);
  RegisterComponentEditor(TPDJImageMaskEdit, TPDJ_About);
  RegisterComponentEditor(TPDJCaptionPanel, TPDJ_About);
  RegisterComponentEditor(TPDJLinePanel, TPDJ_About);
  RegisterComponentEditor(TPDJEditLine, TPDJ_About);
  RegisterComponentEditor(TPDJEditListBox, TPDJ_About);
  RegisterComponentEditor(TPDJMaskEditListBox, TPDJ_About);
  RegisterComponentEditor(TPDJTBEditListBox, TPDJ_About);
  RegisterComponentEditor(TPDJExComboBox, TPDJ_About);
  RegisterComponentEditor(TPDJWallpaper, TPDJ_About);
  RegisterComponentEditor(TPDJImageLabel, TPDJ_About);
  RegisterComponentEditor(TPDJHeader, TPDJ_About);
  RegisterComponentEditor(TPDJTypeButton, TPDJ_About);
  RegisterComponentEditor(TPDJGradientPanel, TPDJ_About);

  RegisterPropertyEditor(TypeInfo(String), TPDJColorPanel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditColor, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJPickColorBtn, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageMaskEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCaptionPanel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJLinePanel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditLine, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJTBEditListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJExComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJWallpaper, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageLabel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJLabelGroup, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TLGLabel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJHeader, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJTypeButton, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJGradientPanel, 'Hint', TPDJ_HiEd);

  RegisterComponentEditor(TPDJLabelGroup, TPDJ_LGEditor);

  RegisterPropertyEditor(TypeInfo(String), TPDJImageMaskEdit, 'EditMask', TPDJ_EM);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageMaskEdit, 'Text', TPDJ_MeT );
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditListBox, 'EditMask', TPDJ_EM);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditListBox, 'Text', TPDJ_MeT );

  RegisterPropertyEditor(TypeInfo(TButtonType), TPDJTypeButton, '',TPDJ_ButtonTypeProperty);

end;


//******************************************************************************
{TPDJ_ButtonTypeProperty}

procedure TPDJ_ButtonTypeProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_ButtonTypeProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_ButtonTypeProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempButtonType:TButtonType;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things
    Brush.Color := clBtnFace;
    Pen.Color := clBtnFace;
    FillRect(Rect(ARect.Left, ARect.Top, vRight, ARect.Bottom));

    R:=Rect(ARect.Left+1, ARect.Top+1, vRight-1, ARect.Bottom-1);


    TempButtonType := TButtonType(GetEnumValue(GetPropInfo^.PropType^, Value));

Case TempButtonType of
btRestore:DrawFrameControl(ACanvas.Handle, R, DFC_CAPTION, DFCS_CAPTIONRESTORE);
btMax:DrawFrameControl(ACanvas.Handle, R, DFC_CAPTION, DFCS_CAPTIONMAX);
btMin:DrawFrameControl(ACanvas.Handle, R, DFC_CAPTION, DFCS_CAPTIONMIN);
btClose:DrawFrameControl(ACanvas.Handle, R, DFC_CAPTION, DFCS_CAPTIONCLOSE);
btHelp:DrawFrameControl(ACanvas.Handle, R, DFC_CAPTION, DFCS_CAPTIONHELP);
btScrollDown,btSpinDown:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLDOWN);
btScrollUp,btSpinUp:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLUP);
btScrollLeft,btSpinLeft:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLLEFT);
btScrollRight,btSpinRight:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLRIGHT);
btGrip:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLSIZEGRIP);
btComboButton:DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLCOMBOBOX);
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_ButtonTypeProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_ButtonTypeProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight + 2;
end;

end.
