unit PDJ_Reg;

{
*****************************
*         PDJTools          *
*****************************
}

// Register and Design Unit for PDJCtrl

//..............................................................................
// TPDJ_TreeEditor version 1.00
// TPDJ_ListEditor version 1.00
// TPDJ_CCEditor version 1.00
// TPDJ_CLEditor version 1.00
// TPDJ_LCEditor version 1.00
// TPDJ_GrabFileEditor version 1.00
// Copyright  2000-2003 by PDJTools
// Author Peric Djordje
// for D5,D6,D7
//..............................................................................
// http://www.ptt.yu/korisnici/p/e/pericddn/
// E-mail: pericddn@ptt.yu, pericddn@neobee.net
// If You find any errors or rubbish in PDJ_Reg.pas please send me Your suggest or Reclamation.

{$I DFS.INC}

interface

{$R PDJ_CtrlDsg.res}

uses Windows,Graphics,
  {$IFDEF DFS_NO_DSGNINTF}
  DesignIntf,VCLEditors,
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}

//******************************************************************************
{TPDJ_CCEditor}

    type
  TPDJ_CCEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;
//******************************************************************************
{TPDJ_LCEditor}

    type
  TPDJ_LCEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;
//******************************************************************************
{TPDJ_CLEditor}

    type
  TPDJ_CLEditor = class(TDefaultEditor)
  protected
    {$IFDEF DFS_IPROPERTY}
    procedure RunPropertyEditor(const Prop: IProperty);
    {$ELSE}
    procedure RunPropertyEditor(Prop: TPropertyEditor);
    {$ENDIF}
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;
//******************************************************************************
{TPDJ_GrabFileEditor}

type

TPDJ_GrabFileEditor = class(TPropertyEditor)

  public
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

//******************************************************************************
{TPDJ_ButtonLookProperty}

type
  TPDJ_ButtonLookProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

//******************************************************************************
{TPDJ_ButtonStylesProperty}

type
  TPDJ_ButtonStylesProperty =class(TEnumProperty{$IFDEF DFS_NO_DSGNINTF}, ICustomPropertyDrawing,
    ICustomPropertyListDrawing{$ENDIF})
  public
    { ICustomPropertyListDrawing }
    procedure ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListMeasureWidth(const Value: string; ACanvas: TCanvas;
      var AWidth: Integer);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
    procedure ListDrawValue(const Value: string; ACanvas: TCanvas;
      const ARect: TRect; ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}

    { ICustomPropertyDrawing }
    {$IFDEF DFS_NO_DSGNINTF}
    procedure PropDrawName(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);
    {$ENDIF}
    procedure PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
      ASelected: Boolean);{$IFDEF DFS_NO_DSGNINTF}{$ELSE}override;{$ENDIF}
  end;

procedure Register;

implementation

uses  Forms, Dialogs, Controls, Classes, SysUtils, TypInfo,
      {for PDJ Controls and PDJ Dialogs}
      PDJ_Basic, PDJ_MaEd, PDJ_HiEd, PDJ_AbFo, PDJ_EmFo, PDJ_MeT,
      PDJ_EdBs, PDJ_PrBr, PDJ_SpEd, PDJ_CoCLb, PDJ_IBBx, PDJ_CoPa,
      PDJ_CoCLi, PDJ_IBLx, PDJ_DsgIBBL, PDJ_IChL, PDJ_EdDate, PDJ_TeLb,
      PDJ_ClPn,PDJ_Lab,PDJ_PosF,PDJ_BrwFol,PDJ_DsgBrFl,PDJ_ChBx,PDJ_ChBtn,
      PDJ_RaBtn,PDJ_GrBx,PDJ_RdGr,PDJ_DFclB,PDJ_ChLb,PDJ_PrCb,PDJ_FoSiClb,
      PDJ_MulClb,PDJ_EdChLb,PDJ_RcBn,PDJ_Ico,
      PDJ_DuDlg,PDJ_RtfDlg,PDJ_SeB,PDJ_EdMb,PDJ_MEdMb,PDJ_DsgEdMMb
      ,PDJ_RegBasic;


procedure Register;
begin

  RegisterComponents('PDJ Controls',
  [
  //Labels
  TPDJLabel,TPDJPathLabel,
  //ButtonControls
  TPDJCheckBox,TPDJCheckBoxEx,TPDJCheckButton,TPDJCheckButtonEx,TPDJRadioButton,
  //GroupBoxs
  TPDJGroupBox,TPDJRadioGroup,
  //Edits
  TPDJEditB, TPDJEditMultiB,
  TPDJSpinEdit,TPDJSpinFloatEdit,
  TPDJMaskEdit,TPDJMaskEditB,TPDJMaskEditMultiB,
  TPDJFolderEdit,
  //ComboBoxs
  TPDJColorComboBox,TPDJImageBox,TPDJBandBox,TPDJEditDate,
  TPDJPrinterComboBox,TPDJDriveComboBox,TPDJFontComboBox,TPDJFontSizeBox,
  TPDJEditCheckList,TPDJEditCalc,
  //ListBoxs
  TPDJColorListBox,TPDJBandList,TPDJImageList,TPDJImageCheckList,
  TPDJTextListBox,TPDJCheckListBox,TPDJDriveListBox,TPDJDirListBox,
  TPDJPrinterListBox,TPDJFontListBox,TPDJMultiLineListBox,TPDJFileListBox,
  //ComCtrl
  TPDJProgressBar,
  //Other
  TPDJCalendar,TPDJIcon,
  TPDJPosForm,TPDJEmptyRecycleBin,TPDJKeyboardState,TPDJDiskInfo,
  TPDJSpeedButton
  ]);

  RegisterComponents('PDJ Dialogs',
  [
  TPDJBrowseFolder,TPDJOpenRtfDialog,
  TPDJSaveRtfDialog,
  TPDJDualListDialog,
  TPDJExDlgProperty
  ]);


//******************************************************************************
  {PDJ Controls}

  RegisterComponentEditor(TPDJLabel, TPDJ_About);
  RegisterComponentEditor(TPDJEditB, TPDJ_About);
  RegisterComponentEditor(TPDJEditMultiB, TPDJ_EMEditor);
  RegisterComponentEditor(TPDJSpinEdit, TPDJ_About);
  RegisterComponentEditor(TPDJSpinFloatEdit, TPDJ_About);
  RegisterComponentEditor(TPDJMaskEdit, TPDJ_About);
  RegisterComponentEditor(TPDJMaskEditB, TPDJ_About);
  RegisterComponentEditor(TPDJMaskEditMultiB, TPDJ_EMEditor);
  RegisterComponentEditor(TPDJColorComboBox, TPDJ_CCEditor);
  RegisterComponentEditor(TPDJColorListBox, TPDJ_LCEditor);
  RegisterComponentEditor(TPDJListBox, TPDJ_About);
  RegisterComponentEditor(TPDJProgressBar, TPDJ_About);
  RegisterComponentEditor(TPDJImageBox, TPDJ_IBEditor);
  RegisterComponentEditor(TPDJBandBox, TPDJ_BBEditor);
  RegisterComponentEditor(TPDJImageList, TPDJ_ILEditor);
  RegisterComponentEditor(TPDJBandList, TPDJ_BLEditor);
  RegisterComponentEditor(TPDJImageCheckList, TPDJ_CLEditor);
  RegisterComponentEditor(TPDJTextListBox, TPDJ_About);
  RegisterComponentEditor(TPDJCalendar, TPDJ_About);
  RegisterComponentEditor(TPDJEditDate, TPDJ_About);
  RegisterComponentEditor(TPDJPosForm, TPDJ_About);
  RegisterComponentEditor(TPDJFolderEdit, TPDJ_About);
  RegisterComponentEditor(TPDJCheckBox, TPDJ_About);
  RegisterComponentEditor(TPDJCheckButton, TPDJ_About);
  RegisterComponentEditor(TPDJCheckBoxEx, TPDJ_About);
  RegisterComponentEditor(TPDJCheckButtonEx, TPDJ_About);
  RegisterComponentEditor(TPDJRadioButton, TPDJ_About);
  RegisterComponentEditor(TPDJGroupBox, TPDJ_About);
  RegisterComponentEditor(TPDJRadioGroup, TPDJ_About);
  RegisterComponentEditor(TPDJDirListBox, TPDJ_About);
  RegisterComponentEditor(TPDJDriveComboBox, TPDJ_About);
  RegisterComponentEditor(TPDJPathLabel, TPDJ_About);
  RegisterComponentEditor(TPDJCheckListBox, TPDJ_About);
  RegisterComponentEditor(TPDJPrinterComboBox, TPDJ_About);
  RegisterComponentEditor(TPDJDriveListBox, TPDJ_About);
  RegisterComponentEditor(TPDJPrinterListBox, TPDJ_About);
  RegisterComponentEditor(TPDJFontComboBox, TPDJ_About);
  RegisterComponentEditor(TPDJFontSizeBox, TPDJ_About);
  RegisterComponentEditor(TPDJFontListBox, TPDJ_About);
  RegisterComponentEditor(TPDJMultiLineListBox, TPDJ_About);
  RegisterComponentEditor(TPDJEditCheckList, TPDJ_About);
  RegisterComponentEditor(TPDJEmptyRecycleBin, TPDJ_About);
  RegisterComponentEditor(TPDJIcon, TPDJ_About);
  RegisterComponentEditor(TPDJSpeedButton, TPDJ_About);
  RegisterComponentEditor(TPDJEditCalc, TPDJ_About);
  RegisterComponentEditor(TPDJFileListBox, TPDJ_About);
  RegisterComponentEditor(TPDJKeyboardState, TPDJ_About);
  RegisterComponentEditor(TPDJDiskInfo, TPDJ_About);
  RegisterComponentEditor(TPDJExDlgProperty, TPDJ_About);

  RegisterPropertyEditor(TypeInfo(String), TPDJLabel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(TCaption), TPDJLabel, 'Caption', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditB, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditMultiB, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TEMButton, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditB, 'BtnHint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditB, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditB, 'BtnHint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditMultiB, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJSpinEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJSpinFloatEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJColorComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJColorListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJListView, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJProgressBar, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJBandBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageList, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJBandList, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJImageCheckList, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJTextListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCalendar, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditDate, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCheckBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCheckButton, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCheckBoxEx, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCheckButtonEx, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJRadioButton, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJGroupBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJRadioGroup, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJDirListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJDriveComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJPathLabel, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJCheckListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJPrinterComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJDriveListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJPrinterListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFontComboBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFontSizeBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFontListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJMultiLineListBox, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditCheckList, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJIcon, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJSpeedButton, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJEditCalc, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFileListBox, 'Hint', TPDJ_HiEd);

  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEdit, 'EditMask', TPDJ_EM);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEdit, 'Text', TPDJ_MeT );
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditB, 'EditMask', TPDJ_EM);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditB, 'Text', TPDJ_MeT );
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditMultiB, 'EditMask', TPDJ_EM);
  RegisterPropertyEditor(TypeInfo(String), TPDJMaskEditMultiB, 'Text', TPDJ_MeT );

  RegisterPropertyEditor(TypeInfo(String), TPDJColorComboBox, 'ColorPalette', TPDJ_CoPa);
  RegisterPropertyEditor(TypeInfo(String), TPDJColorListBox, 'ColorPalette', TPDJ_CoPa);

  RegisterPropertyEditor(TypeInfo(String), TPDJBrowseFolder , 'Folder', TPDJ_FlEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFolderEdit , 'Text', TPDJ_FlEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFolderEdit, 'Hint', TPDJ_HiEd);
  RegisterPropertyEditor(TypeInfo(String), TPDJFolderEdit, 'BtnHint', TPDJ_HiEd);

  RegisterPropertyEditor(TypeInfo(String), TPDJIcon, 'GrabIconFromFile', TPDJ_GrabFileEditor);
 

//******************************************************************************
  {PDJ Dialogs}
  RegisterComponentEditor(TPDJOpenRtfDialog, TPDJ_About);
  RegisterComponentEditor(TPDJSaveRtfDialog, TPDJ_About);
  RegisterComponentEditor(TPDJBrowseFolder, TPDJ_About);
  RegisterComponentEditor(TPDJDualListDialog, TPDJ_About);

// PDJ universal property editor
  RegisterPropertyEditor(TypeInfo(TPDJButtonLook), TPersistent, '',TPDJ_ButtonLookProperty);
  RegisterPropertyEditor(TypeInfo(TButtonStyles), TPersistent, '',TPDJ_ButtonStylesProperty);

end;

//******************************************************************************
{TPDJ_CCEditor}

procedure TPDJ_CCEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_CCEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'CCItems' then
    Prop.Edit;
end;

procedure TPDJ_CCEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_CCEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'CCItems Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_CCEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

//******************************************************************************
{TPDJ_LCEditor}

procedure TPDJ_LCEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_LCEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'LCItems' then
    Prop.Edit;
end;

procedure TPDJ_LCEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_LCEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'LCItems Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_LCEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

//******************************************************************************
{TPDJ_CLEditor}

procedure TPDJ_CLEditor.Edit;
var
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components: IDesignerSelections;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components: TDesignerSelectionList;
  {$ELSE}
  Components: TComponentList;
  {$ENDIF}
  {$ENDIF}
begin
  {$IFDEF DFS_DESIGNERSELECTIONS}
  Components := CreateSelectionList;
  {$ELSE}
  {$IFDEF DFS_COMPILER_5_UP}
  Components := TDesignerSelectionList.Create;
  {$ELSE}
  Components := TComponentList.Create;
  {$ENDIF}
  {$ENDIF}
  try
  	Components.Add(Component);
  	GetComponentProperties(Components, [tkClass], Designer, RunPropertyEditor);
  finally
    {$IFNDEF DFS_DESIGNERSELECTIONS}
  	Components.Free;
    {$ENDIF}
  end;
end;

procedure TPDJ_CLEditor.RunPropertyEditor(
{$IFDEF DFS_IPROPERTY}
  const Prop: IProperty
{$ELSE}
  Prop: TPropertyEditor
{$ENDIF}
);
begin
 if Prop.GetName= 'CLItems' then
    Prop.Edit;
end;

procedure TPDJ_CLEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 2 then
  begin
    ShowAboutDialog;
    Exit;
  end
  else if Index = 0 then
  Edit;
end;

function TPDJ_CLEditor.GetVerb(Index: Integer): string;
begin
    case Index of
    0  : Result := 'CLItems Editor...';
    1  : Result := '-';
    2  : Result := PCVersion;
  end;
end;

function TPDJ_CLEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

//******************************************************************************
{TPDJ_GrabFileEditor}

function TPDJ_GrabFileEditor.GetValue: string;
begin
  Result:=(GetComponent(0) as TPDJIcon).GrabIconFromFile;
end;

procedure TPDJ_GrabFileEditor.SetValue(const Value: string);
begin
  (GetComponent(0) as TPDJIcon).GrabIconFromFile:=Value;
  Modified;
end;

function TPDJ_GrabFileEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect];
end;

procedure TPDJ_GrabFileEditor.Edit;
var
  Dialog: TOpenDialog;
begin
  Dialog:=TOpenDialog.Create(nil);
  try
    with Dialog do
    begin
      Filter:='All files (*.exe;*.dll;*.ico;*.ocx)|*.exe;*.dll;*.ico;*.ocx'+
              '|exe files (*.exe)|*.exe'+
              '|dll files (*.dll)|*.dll'+
              '|ocx files (*.ocx)|*.ocx'+
              '|ico files (*.ico)|*.ico';
      FileName:=ExtractFileName((GetComponent(0) as TPDJIcon).GrabIconFromFile);
      if Execute then
          (GetComponent(0) as TPDJIcon).GrabIconFromFile:=FileName;
          Modified;
    end;
  finally
    Dialog.Free;
  end;
end;


//******************************************************************************
{TPDJ_ButtonLookProperty}

procedure TPDJ_ButtonLookProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  if GetVisualValue <> '' then
    ListDrawValue(GetVisualValue, ACanvas, ARect, ASelected)
  else
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_ButtonLookProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_ButtonLookProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  vRight,vOldPenWidth: Integer;
  vOldPenColor, vOldBrushColor: TColor;
  vOldBrushStyle: TBrushStyle;
  R:TRect;
  TempButtonLook:TPDJButtonLook;
begin
  vRight := (ARect.Bottom - ARect.Top) {* 2} + ARect.Left;
  with ACanvas do
  try
    // save off things
    vOldPenColor := Pen.Color;
    vOldBrushColor := Brush.Color;
   vOldBrushStyle := Brush.Style;
   vOldPenWidth:=Pen.Width;

    // frame things

    R:=Rect(ARect.Left+2, ARect.Top+2, vRight-2, ARect.Bottom-2);
    Brush.Color:=vOldBrushColor;
    FillRect(ARect);


TempButtonLook := TPDJButtonLook(GetEnumValue(GetPropInfo^.PropType^, Value));

    Brush.Color:=clBtnFace;
    FillRect(R);

Case TempButtonLook of
blFlat:
begin
Pen.Color:=clBtnHighlight;
Moveto(R.Left, R.Top);
LineTo(R.Left, R.Bottom);
Moveto(R.left, R.top);
LineTo(R.Right, R.top);
Pen.Color:=clBtnShadow;
Moveto(R.Left, R.Bottom-1);
LineTo(R.Right, R.Bottom-1);
Moveto(R.right-1, R.top);
LineTo(R.right-1, R.bottom);
end;
blNoFlat:DrawEdge(ACanvas.handle, R, EDGE_RAISED,BF_RECT);
blXPstyle:
begin
Pen.Color:=$00FF8080;
Brush.Color:=ColorToRGB(XPColorHl(ACanvas,$00FF8080,58));
Rectangle(R);
end;
blFlatFrame:
begin
Pen.Color:=clBtnShadow;
Rectangle(R);
InflateRect(R,-1,-1);
Pen.Color:=clBtnHighlight;
Moveto(R.Left, R.Top);
LineTo(R.Left, R.Bottom);
Moveto(R.left, R.top);
LineTo(R.Right, R.top);
Pen.Color:=clBtnShadow;
Moveto(R.Left, R.Bottom-1);
LineTo(R.Right, R.Bottom-1);
Moveto(R.right-1, R.top);
LineTo(R.right-1, R.bottom);
end;
blNoFlatFrame:
begin
DrawEdge(ACanvas.handle, R, EDGE_RAISED,BF_RECT or BF_FLAT);
InflateRect(R,-1,-1);
DrawEdge(ACanvas.handle, R, EDGE_RAISED,BF_RECT);
end;
end;

    // restore the things we twiddled with
    Brush.Color := vOldBrushColor;
    Brush.Style := vOldBrushStyle;
    Pen.Color := vOldPenColor;
    Pen.Width:=vOldPenWidth;
  finally
    {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ELSE}
    inherited ListDrawValue(Value, ACanvas,
                            Rect(vRight, ARect.Top, ARect.Right, ARect.Bottom),
                            ASelected);
    {$ENDIF}
  end;
end;

procedure TPDJ_ButtonLookProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_ButtonLookProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := AHeight+9;
end;

//******************************************************************************
{TPDJ_ButtonStylesProperty}

procedure TPDJ_ButtonStylesProperty.PropDrawValue(ACanvas: TCanvas; const ARect: TRect;
  ASelected: Boolean);
begin
  {$IFDEF DFS_NO_DSGNINTF}
    DefaultPropertyDrawValue(Self, ACanvas, ARect);
  {$ELSE}
    inherited PropDrawValue(ACanvas, ARect, ASelected);
  {$ENDIF}
end;

{$IFDEF DFS_NO_DSGNINTF}
procedure TPDJ_ButtonStylesProperty.PropDrawName(ACanvas: TCanvas;
  const ARect: TRect; ASelected: Boolean);
begin
  DefaultPropertyDrawName(Self, ACanvas, ARect);
end;
{$ENDIF}

procedure TPDJ_ButtonStylesProperty.ListDrawValue(const Value: string;
  ACanvas: TCanvas; const ARect: TRect; ASelected: Boolean);
var
  R: TRect;
  TextStart: Integer;
  Style: TButtonStyles;
  Bmp, BorderStyleBmp: TBitmap;
  TransparentColor: TColor;
  DestRct, SrcRct: TRect;
  BmpOffset: Integer;

begin

  R := ARect;
  R.Right := R.Left + ( R.Bottom - R.Top )+2;
  TextStart := R.Right;
  with ACanvas do
  begin
    Bmp := TBitmap.Create;
    BorderStyleBmp := TBitmap.Create;
    try
      FillRect( R );
      DestRct := Classes.Rect( 0, 0, 25, 25 );
      SrcRct := DestRct;
      BmpOffset := ( ( R.Bottom - R.Top ) - 25 ) div 2;

      Bmp.Width := 16;
      Bmp.Height := 16;

      Bmp.Canvas.Brush.Color := ACanvas.Brush.Color;

      TransparentColor := clWhite;

      Style := TButtonStyles( GetEnumValue( GetPropInfo^.PropType^, Value ) );
      with R do
      begin
inflaterect(R,-2,-2);
DrawEdge(ACanvas.handle, R, EDGE_RAISED,BF_RECT or BF_MIDDLE);
        case Style of
bsArrow: DrawFrameControl(ACanvas.Handle, R, DFC_SCROLL, DFCS_SCROLLCOMBOBOX);
bsEllipsis:
begin
Pixels[R.Left+7,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+7,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+8,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+8,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+10,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+10,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+11,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+11,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+13,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+13,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+14,R.Top+( R.Bottom - R.Top ) div 2]:=clBlack;
Pixels[R.Left+14,R.Top-1+( R.Bottom - R.Top ) div 2]:=clBlack;
end;
bsGlyph:
begin
BorderStyleBmp.Handle := LoadBitmap( HInstance, 'PDJ_BSGLYPH' );
Bmp.Canvas.BrushCopy( DestRct, BorderStyleBmp, SrcRct, TransparentColor );
Draw( Left + 3, Top + BmpOffset+2, Bmp );
end;

end;

      end;


    finally
      Bmp.Free;
      BorderStyleBmp.Free;

      {$IFDEF DFS_NO_DSGNINTF}
      DefaultPropertyListDrawValue( Value, ACanvas,
                                    Rect( TextStart, ARect.Top, ARect.Right, ARect.Bottom ),
                                    ASelected );
      {$ELSE}
      inherited ListDrawValue( Value, ACanvas,
                               Rect( TextStart, ARect.Top, ARect.Right, ARect.Bottom ),
                               ASelected );
      {$ENDIF}
    end;
  end;
end;


procedure TPDJ_ButtonStylesProperty.ListMeasureWidth(const Value: string;
  ACanvas: TCanvas; var AWidth: Integer);
begin
  AWidth := AWidth + ACanvas.TextHeight('A') {* 2};
end;

procedure TPDJ_ButtonStylesProperty.ListMeasureHeight(const Value: string; ACanvas: TCanvas;
      var AHeight: Integer);
begin
  AHeight := 25;
end;


end.
