{*******************************************************} 
{                                                       }
{  MTReport Components Suite 1.0                        }
{                                                       }
{  Designer component: main form                        }
{                                                       }
{  Copyright (c) 2001 MT Tools.                         }
{                                                       }
{*******************************************************}

unit mtrDesignForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ActnList, Menus,
  mtrGlobal, mtrDesigner, ImgList;

type
  TfmDesigner = class(TForm)
    Tree: TTreeView;
    btOk: TButton;
    btCancel: TButton;
    ActionList: TActionList;
    actBandAdd: TAction;
    actBandEdit: TAction;
    actBandDel: TAction;
    pmTree: TPopupMenu;
    miAddBand: TMenuItem;
    miEditBand: TMenuItem;
    miDeleteBand: TMenuItem;
    actQueryAdd: TAction;
    actQueryEdit: TAction;
    actQueryDel: TAction;
    N1: TMenuItem;
    miAddQuery: TMenuItem;
    miEditQuery: TMenuItem;
    miDeleteQuery: TMenuItem;
    actParamAdd: TAction;
    actParamEdit: TAction;
    actParamDel: TAction;
    N2: TMenuItem;
    miAddParam: TMenuItem;
    miEditParam: TMenuItem;
    miDeleteParam: TMenuItem;
    actFieldAdd: TAction;
    actFieldEdit: TAction;
    actFieldDel: TAction;
    N3: TMenuItem;
    miAddField: TMenuItem;
    miEditField: TMenuItem;
    miDeleteField: TMenuItem;
    ImageList: TImageList;
    actSchemeEdit: TAction;
    miEditScheme: TMenuItem;
    N4: TMenuItem;
    procedure actBandAddExecute(Sender: TObject);
    procedure actBandEditExecute(Sender: TObject);
    procedure actBandDelExecute(Sender: TObject);
    procedure actQueryAddExecute(Sender: TObject);
    procedure actQueryEditExecute(Sender: TObject);
    procedure actQueryDelExecute(Sender: TObject);
    procedure actParamAddExecute(Sender: TObject);
    procedure actParamEditExecute(Sender: TObject);
    procedure actParamDelExecute(Sender: TObject);
    procedure actFieldAddExecute(Sender: TObject);
    procedure actFieldEditExecute(Sender: TObject);
    procedure actFieldDelExecute(Sender: TObject);
    procedure TreeChange(Sender: TObject; Node: TTreeNode);
    procedure TreeDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure actSchemeEditExecute(Sender: TObject);
  private
    { Private declarations }
    FDesigner: TmtrDesigner;
  public
    { Public declarations }
    property Designer: TmtrDesigner read FDesigner write FDesigner;
  end;

implementation

{$R *.DFM}

procedure TfmDesigner.actBandAddExecute(Sender: TObject);
begin
  FDesigner.DesignBand(Tree.Selected, daAdd);
end;

procedure TfmDesigner.actBandEditExecute(Sender: TObject);
begin
  FDesigner.DesignBand(Tree.Selected, daEdit);
end;

procedure TfmDesigner.actBandDelExecute(Sender: TObject);
begin
  FDesigner.DesignBand(Tree.Selected, daDelete);
end;

procedure TfmDesigner.actQueryAddExecute(Sender: TObject);
begin
  FDesigner.DesignQuery(Tree.Selected, daAdd);
end;

procedure TfmDesigner.actQueryEditExecute(Sender: TObject);
begin
  FDesigner.DesignQuery(Tree.Selected, daEdit);
end;

procedure TfmDesigner.actQueryDelExecute(Sender: TObject);
begin
  FDesigner.DesignQuery(Tree.Selected, daDelete);
end;

procedure TfmDesigner.actParamAddExecute(Sender: TObject);
begin
  FDesigner.DesignParam(Tree.Selected, daAdd);
end;

procedure TfmDesigner.actParamEditExecute(Sender: TObject);
begin
  FDesigner.DesignParam(Tree.Selected, daEdit);
end;

procedure TfmDesigner.actParamDelExecute(Sender: TObject);
begin
  FDesigner.DesignParam(Tree.Selected, daDelete);
end;

procedure TfmDesigner.actFieldAddExecute(Sender: TObject);
begin
  FDesigner.DesignField(Tree.Selected, daAdd);
end;

procedure TfmDesigner.actFieldEditExecute(Sender: TObject);
begin
  FDesigner.DesignField(Tree.Selected, daEdit);
end;

procedure TfmDesigner.actFieldDelExecute(Sender: TObject);
begin
  FDesigner.DesignField(Tree.Selected, daDelete);
end;

procedure TfmDesigner.TreeChange(Sender: TObject; Node: TTreeNode);
begin
  FDesigner.SelectActions(Node, ActionList);
end;

procedure TfmDesigner.TreeDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := FDesigner.AllowDragDrop(Sender, Source);
end;

procedure TfmDesigner.TreeDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  FDesigner.DoDragDrop(Sender, Source);
end;

procedure TfmDesigner.actSchemeEditExecute(Sender: TObject);
begin
  FDesigner.DesignScheme(Tree.Selected);
end;

end.
