{*******************************************************} 
{                                                       }
{  MTReport Components Suite 1.0                        }
{                                                       }
{  Server-side components                               }
{                                                       }
{  Copyright (c) 2001 MT Tools.                         }
{                                                       }
{*******************************************************}

unit mtrCustomServers;

{$I MTR.INC}

interface

uses {$IFDEF BDE}DbTables, {$ENDIF}
     {$IFDEF IBX}IBDatabase, {$ENDIF}
     Classes, mtrServer, mtrDBAccess;

type
{$IFDEF BDE}
  TmtrBDEServer = class(TmtrServer)
  private
    function GetDatabase: TDatabase;
    procedure SetDatabase(const Value: TDatabase);
    { Private declarations }
  protected
    { Protected declarations }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Database: TDatabase read GetDatabase write SetDatabase;
  end;
{$ENDIF}

{$IFDEF IBX}
  TmtrIBServer = class(TmtrServer)
  private
    { Private declarations }
    FBase: TIBBase;
    function GetDatabase: TIBDatabase;
    procedure SetDatabase(const Value: TIBDatabase);
    function GetTransaction: TIBTransaction;
    procedure SetTransaction(const Value: TIBTransaction);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Database: TIBDatabase read GetDatabase write SetDatabase;
    property Transaction: TIBTransaction read GetTransaction write SetTransaction;
  end;
{$ENDIF}

procedure Register;

implementation

procedure Register;
begin
{$IFDEF BDE}
  RegisterComponents('MTReport', [TmtrBDEServer]);
{$ENDIF}
{$IFDEF IBX}
  RegisterComponents('MTReport', [TmtrIBServer]);
{$ENDIF}
end;

{ TmtrBDEServer }

{$IFDEF BDE}

constructor TmtrBDEServer.Create(AOwner: TComponent);
begin
  inherited;
  FDBMSType := dbmsBDE;
end;

function TmtrBDEServer.GetDatabase: TDatabase;
begin
  result := TDatabase(FDatabase);
end;

procedure TmtrBDEServer.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if (AComponent = FDatabase) and (Operation = opRemove) then
    Database := nil;
end;

procedure TmtrBDEServer.SetDatabase(const Value: TDatabase);
begin
  FDatabase := Value;
end;

{$ENDIF}

{ TmtrIBServer }

{$IFDEF IBX}

constructor TmtrIBServer.Create(AOwner: TComponent);
begin
  inherited;
  FDBMSType := dbmsInterbase;
  FBase := TIBBase.Create(Self);
end;

destructor TmtrIBServer.Destroy;
begin
  FBase.Free;
  inherited;
end;

function TmtrIBServer.GetDatabase: TIBDatabase;
begin
  result := FBase.Database;
  if result = nil then FDatabase := nil;
end;

function TmtrIBServer.GetTransaction: TIBTransaction;
begin
  result := FBase.Transaction;
  if result = nil then FTransaction := nil;
end;

procedure TmtrIBServer.SetDatabase(const Value: TIBDatabase);
begin
  FBase.Database := Value;
  FDatabase := Value;
end;

procedure TmtrIBServer.SetTransaction(const Value: TIBTransaction);
begin
  FBase.Transaction := Value;
  FTransaction := Value;
end;

{$ENDIF}

end.
