unit ReportServer;

interface

uses
  ComObj, ActiveX, ServerIB_TLB, StdVcl, Classes, IBDatabase, mtrServer,
  mtrCustomServers, mtrGlobal;

type
  TReportServer = class(TAutoObject, IReportServer)
  private
    FDatabase: TIBDatabase;
    FTransaction: TIBTransaction;
    FServer: TmtrIBServer;
  protected
    { IReportServer }
    procedure Prepare(var AData: OleVariant); safecall;
    procedure Execute(var AData: OleVariant); safecall;
    procedure Connect(const ADatabase, AUser, APassword: WideString); safecall;
  public
    procedure AfterConstruction; override;
    procedure BeforeDestruction; override;
  end;

implementation

uses ComServ;

{ TReportServer }

procedure TReportServer.AfterConstruction;
begin
  inherited;
  FDatabase := TIBDatabase.Create(nil);
  FDatabase.LoginPrompt := false;
  FTransaction := TIBTransaction.Create(nil);
  FDatabase.DefaultTransaction := FTransaction;
  FTransaction.DefaultDatabase := FDatabase;
  FServer := TmtrIBServer.Create(nil);
  FServer.Database := FDatabase;
  FServer.Transaction := FTransaction;
end;

procedure TReportServer.BeforeDestruction;
begin
  FServer.Free; FServer := nil;
  if FTransaction.InTransaction then FTransaction.Commit;
  FDatabase.Close;
  FTransaction.Free; FTransaction := nil;
  FDatabase.Free; FDatabase := nil;
  inherited;
end;

procedure TReportServer.Connect(const ADatabase, AUser,
  APassword: WideString);
begin
  FDatabase.DatabaseName := ADatabase;
  FDatabase.Params.Add('isc_dpb_user_name='+AUser);
  FDatabase.Params.Add('isc_dpb_password='+APassword);
  FDatabase.Open;
  FTransaction.StartTransaction;
end;

procedure TReportServer.Prepare(var AData: OleVariant);
var
  stream: TMemoryStream;
begin
  stream := TMemoryStream.Create;
  try
    mtrGlobal.OleVariant2MemoryStream(AData, stream);
    FServer.Prepare(stream);
    AData := mtrGlobal.MemoryStream2OleVariant(stream);
  finally
    stream.Free;
  end;
end;

procedure TReportServer.Execute(var AData: OleVariant);
var
  stream: TMemoryStream;
begin
  stream := TMemoryStream.Create;
  try
    mtrGlobal.OleVariant2MemoryStream(AData, stream);
    FServer.Execute(stream);
    AData := mtrGlobal.MemoryStream2OleVariant(stream);
  finally
    stream.Free;
  end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TReportServer, Class_ReportServer,
    ciMultiInstance, tmApartment);
end.
