unit ReportServer;

interface

uses
  ComObj, ActiveX, ServerBDE_TLB, StdVcl, Classes, Db, DBTables, mtrServer,
  mtrCustomServers, mtrGlobal;

type
  TReportServer = class(TAutoObject, IReportServer)
  private
    FDatabase: TDatabase;
    FServer: TmtrBDEServer;
  protected
    { IReportServer }
    procedure Prepare(var AData: OleVariant); safecall;
    procedure Execute(var AData: OleVariant); safecall;
  public
    procedure AfterConstruction; override;
    procedure BeforeDestruction; override;
  end;

implementation

uses ComServ;

{ TReportServer }

procedure TReportServer.AfterConstruction;
begin
  inherited;
  FDatabase := TDatabase.Create(nil);
  FDatabase.AliasName := 'DBDEMOS';
  FDatabase.DatabaseName := 'dbname';
  FDatabase.LoginPrompt := false;
  FServer := TmtrBDEServer.Create(nil);
  FServer.Database := FDatabase;
  FDatabase.Open;
end;

procedure TReportServer.BeforeDestruction;
begin
  FDatabase.Close;
  FServer.Free; FServer := nil;
  FDatabase.Free; FDatabase := nil;
  inherited;
end;

procedure TReportServer.Prepare(var AData: OleVariant);
var
  stream: TMemoryStream;
begin
  stream := TMemoryStream.Create;
  try
    mtrGlobal.OleVariant2MemoryStream(AData, stream);
    FServer.Prepare(stream);
    AData := mtrGlobal.MemoryStream2OleVariant(stream);
  finally
    stream.Free;
  end;
end;

procedure TReportServer.Execute(var AData: OleVariant);
var
  stream: TMemoryStream;
begin
  stream := TMemoryStream.Create;
  try
    mtrGlobal.OleVariant2MemoryStream(AData, stream);
    FServer.Execute(stream);
    AData := mtrGlobal.MemoryStream2OleVariant(stream);
  finally
    stream.Free;
  end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TReportServer, Class_ReportServer,
    ciMultiInstance, tmApartment);
end.
