unit ClientForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls, ShellApi,
  mtrClient, mtrExcelView, mtrHtmlView, mtrDesigner, mtrView, mtrRtfView,
  mtrGlobal, ServerBDE_TLB;

type
  TfmClient = class(TForm)
    btConnect: TButton;
    btDisconnect: TButton;
    btStart: TButton;
    btSchema: TButton;
    rgRpt: TRadioGroup;
    btTemplate: TButton;
    gbView: TGroupBox;
    rbExcel: TRadioButton;
    rbHTML: TRadioButton;
    rbRTF: TRadioButton;
    mtrClient: TmtrClient;
    mtrExcelView: TmtrExcelView;
    mtrHtmlView: TmtrHtmlView;
    mtrRtfView: TmtrRtfView;
    mtrDesigner: TmtrDesigner;
    edServerMachine: TEdit;
    Label1: TLabel;
    procedure btConnectClick(Sender: TObject);
    procedure btDisconnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure btSchemaClick(Sender: TObject);
    procedure rgRptClick(Sender: TObject);
    procedure btTemplateClick(Sender: TObject);
    procedure rbExcelClick(Sender: TObject);
    procedure rbHTMLClick(Sender: TObject);
    procedure rbRTFClick(Sender: TObject);
    procedure mtrClientGetData(ADataStream: TMemoryStream);
    procedure mtrClientGetSchemaData(ADataStream: TMemoryStream);
  private
    { Private declarations }
    FPath: string;
    FServerIntf: IReportServer;
  public
    { Public declarations }
  end;

var
  fmClient: TfmClient;

implementation

const
  SchemaArr: array [0..5] of string = (
    'list1',
    'masterdetail1',
    'masterdetail2',
    'crosstab1',
    'chart1',
    'chart2'
    );

{$R *.DFM}

procedure TfmClient.btConnectClick(Sender: TObject);
begin
  FServerIntf := CoReportServer.CreateRemote(edServerMachine.Text);

  edServerMachine.Enabled := false;
  btConnect.Enabled := false;
  btDisconnect.Enabled := true;
  btStart.Enabled := true;
  btSchema.Enabled := true;
  btTemplate.Enabled := true;
end;

procedure TfmClient.btDisconnectClick(Sender: TObject);
begin
  FServerIntf := nil;

  edServerMachine.Enabled := true;
  btConnect.Enabled := true;
  btDisconnect.Enabled := false;
  btStart.Enabled := false;
  btSchema.Enabled := false;
  btTemplate.Enabled := false;
end;

procedure TfmClient.FormCreate(Sender: TObject);
var
  p: integer;
begin
  //locate demo shared directory
  FPath := AnsiUpperCase(Application.ExeName);
  p := Pos('\DEMOS\3TIER', FPath);
  FPath := Copy(FPath, 1, p) + 'DEMOS\SHARED\';
  mtrExcelView.TemplateDir := FPath;
  mtrHtmlView.TemplateDir := FPath;
  mtrRtfView.TemplateDir := FPath;
end;

procedure TfmClient.btStartClick(Sender: TObject);
begin
  mtrClient.LoadFromFile(FPath + SchemaArr[rgRpt.ItemIndex] + '.config');

  mtrClient.Params.Clear;
  //for "Master/detail with parameters" add one parameter
  if rgRpt.ItemIndex = 2 then
    mtrClient.Params.Add('company', 'K%');

  mtrClient.Execute;
end;

procedure TfmClient.btSchemaClick(Sender: TObject);
begin
  mtrDesigner.FileName := FPath + SchemaArr[rgRpt.ItemIndex] + '.config';
  mtrDesigner.ShowDesigner;
end;

procedure TfmClient.rgRptClick(Sender: TObject);
begin
  if rgRpt.ItemIndex in [3,4,5] then begin
    rbExcel.Checked := true;
    rbHTML.Enabled := false;
    rbRTF.Enabled := false;
  end
  else begin
    rbHTML.Enabled := true;
    rbRTF.Enabled := true;
  end;
end;

procedure TfmClient.btTemplateClick(Sender: TObject);
var
  s: string;
begin
  s := FPath + SchemaArr[rgRpt.ItemIndex];
  if rbExcel.Checked then begin
    ShellExecute(HWND(nil), 'Open', PChar(s + '.xlt'), nil, nil, SW_SHOWNORMAL);
  end
  else if rbHTML.Checked then begin
    ShellExecute(HWND(nil), 'Edit', PChar(s + '.htm'), nil, nil, SW_SHOWNORMAL);
  end
  else if rbRTF.Checked then begin
    ShellExecute(HWND(nil), 'Open', PChar(s + '.rtf'), nil, nil, SW_SHOWNORMAL);
  end;
end;

procedure TfmClient.rbExcelClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrExcelView;
end;

procedure TfmClient.rbHTMLClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrHtmlView;
end;

procedure TfmClient.rbRTFClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrRtfView;
end;

procedure TfmClient.mtrClientGetSchemaData(ADataStream: TMemoryStream);
var
  value: OleVariant;
begin
  value := mtrGlobal.MemoryStream2OleVariant(ADataStream);
  FServerIntf.Prepare(value);
  mtrGlobal.OleVariant2MemoryStream(value, ADataStream);
end;

procedure TfmClient.mtrClientGetData(ADataStream: TMemoryStream);
var
  value: OleVariant;
begin
  value := mtrGlobal.MemoryStream2OleVariant(ADataStream);
  FServerIntf.Execute(value);
  mtrGlobal.OleVariant2MemoryStream(value, ADataStream);
end;

end.
