unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ShellApi, IBDatabase,
  mtrServer, mtrCustomServers, mtrClient, mtrExcelView, mtrHtmlView, mtrDesigner,
  mtrView, mtrRtfView, Db;

type
  TfmMain = class(TForm)
    btConnect: TButton;
    btDisconnect: TButton;
    btStart: TButton;
    btSchema: TButton;
    rgRpt: TRadioGroup;
    btTemplate: TButton;
    gbView: TGroupBox;
    rbExcel: TRadioButton;
    rbHTML: TRadioButton;
    rbRTF: TRadioButton;
    mtrClient: TmtrClient;
    mtrDesigner: TmtrDesigner;
    mtrExcelView: TmtrExcelView;
    mtrHtmlView: TmtrHtmlView;
    mtrRtfView: TmtrRtfView;
    mtrIBServer: TmtrIBServer;
    IBTransaction: TIBTransaction;
    IBDatabase: TIBDatabase;
    Label1: TLabel;
    lbDBLink: TLabel;
    Label3: TLabel;
    procedure btConnectClick(Sender: TObject);
    procedure btDisconnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure btSchemaClick(Sender: TObject);
    procedure rgRptClick(Sender: TObject);
    procedure btTemplateClick(Sender: TObject);
    procedure rbExcelClick(Sender: TObject);
    procedure rbHTMLClick(Sender: TObject);
    procedure rbRTFClick(Sender: TObject);
    procedure lbDBLinkClick(Sender: TObject);
  private
    { Private declarations }
    FPath: string;
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

const
  SchemaArr: array [0..5] of string = (
    'list1',
    'masterdetail1',
    'masterdetail2',
    'crosstab1',
    'chart1',
    'chart2'
    );

{$R *.DFM}

procedure TfmMain.btConnectClick(Sender: TObject);
begin
  IBDatabase.Open;
  IBTransaction.StartTransaction;
  btConnect.Enabled := false;
  btDisconnect.Enabled := true;
  btStart.Enabled := true;
  btSchema.Enabled := true;
  btTemplate.Enabled := true;
end;

procedure TfmMain.btDisconnectClick(Sender: TObject);
begin
  IBTransaction.Commit;
  IBDatabase.Close;
  btConnect.Enabled := true;
  btDisconnect.Enabled := false;
  btStart.Enabled := false;
  btSchema.Enabled := false;
  btTemplate.Enabled := false;
end;

procedure TfmMain.FormCreate(Sender: TObject);
var
  p: integer;
begin
  //locate demo shared directory
  FPath := AnsiUpperCase(Application.ExeName);
  p := Pos('\DEMOS\2TIER', FPath);
  FPath := Copy(FPath, 1, p) + 'DEMOS\SHARED\';

  IBDatabase.DatabaseName := FPath + 'DBDEMOS.GDB';
  mtrExcelView.TemplateDir := FPath;
  mtrHtmlView.TemplateDir := FPath;
  mtrRtfView.TemplateDir := FPath;
end;

procedure TfmMain.btStartClick(Sender: TObject);
begin
  mtrClient.LoadFromFile(FPath + SchemaArr[rgRpt.ItemIndex] + '.config');

  mtrClient.Params.Clear;
  //for "Master/detail with parameters" add one parameter
  if rgRpt.ItemIndex = 2 then
    mtrClient.Params.Add('company', 'K%');

  mtrClient.Execute;
end;

procedure TfmMain.btSchemaClick(Sender: TObject);
begin
  mtrDesigner.FileName := FPath + SchemaArr[rgRpt.ItemIndex] + '.config';
  mtrDesigner.ShowDesigner;
end;

procedure TfmMain.rgRptClick(Sender: TObject);
begin
  if rgRpt.ItemIndex in [3,4,5] then begin
    rbExcel.Checked := true;
    rbHTML.Enabled := false;
    rbRTF.Enabled := false;
  end
  else begin
    rbHTML.Enabled := true;
    rbRTF.Enabled := true;
  end;
end;

procedure TfmMain.btTemplateClick(Sender: TObject);
var
  s: string;
begin
  s := FPath + SchemaArr[rgRpt.ItemIndex];
  if rbExcel.Checked then begin
    ShellExecute(HWND(nil), 'Open', PChar(s + '.xlt'), nil, nil, SW_SHOWNORMAL);
  end
  else if rbHTML.Checked then begin
    ShellExecute(HWND(nil), 'Edit', PChar(s + '.htm'), nil, nil, SW_SHOWNORMAL);
  end
  else if rbRTF.Checked then begin
    ShellExecute(HWND(nil), 'Open', PChar(s + '.rtf'), nil, nil, SW_SHOWNORMAL);
  end;
end;

procedure TfmMain.rbExcelClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrExcelView;
end;

procedure TfmMain.rbHTMLClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrHtmlView;
end;

procedure TfmMain.rbRTFClick(Sender: TObject);
begin
  mtrClient.Viewer := mtrRtfView;
end;

procedure TfmMain.lbDBLinkClick(Sender: TObject);
begin
  ShellExecute(HWND(nil), 'Open', PChar('http://mttools.hypermart.net/files/dbdemos_ib.zip'), nil, nil, SW_SHOWNORMAL);
end;

end.
