{******************************************************************************}
{                                                                              }
{ ModLink                                                                      }
{ Copyright (C) 2002 Ing. Ivo Bauer. All Rights Reserved.                      }
{ web: http://www.ozm.cz/ivobauer/modlink/                                     }
{ e-mail: ivo.bauer@tiscali.cz                                                 }
{                                                                              }
{******************************************************************************}

unit ConnectionOptionsF;

{$I CompilerDefs.inc}

{$B-,H+,J-,T-,X+,Z1}

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  { Windows  } Windows, Messages,
  { Delphi   } SysUtils, {$IFDEF COMPILER6_UP} Variants, {$ENDIF} Classes,
               Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  { CPortLib } CPortCtl,
  { ModLink  } ModLink;

//------------------------------------------------------------------------------

type
  TConnectionOptionsForm = class(TForm)
    OKButton: TButton;
    CancelButton: TButton;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    PortComboBox: TComComboBox;
    BaudRateComboBox: TComComboBox;
    CustomBaudRateEdit: TEdit;
    ParityBitsComboBox: TComComboBox;
    StopBitsComboBox: TComComboBox;
    DataBitsComboBox: TComComboBox;
    GroupBox2: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    IntCharJitterEdit: TEdit;
    IntTransDelayEdit: TEdit;
    QryTransTimeoutEdit: TEdit;
    RplRecvTimeoutEdit: TEdit;
    TransThrdPriorityComboBox: TComboBox;
    MaxTransRetriesEdit: TEdit;
    procedure BaudRateComboBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    constructor Create(AOwner: TComponent); override;
  end;

//------------------------------------------------------------------------------

var
  ConnectionOptionsForm: TConnectionOptionsForm;

//------------------------------------------------------------------------------

function EditConnectionOptions(AConnection: TModbusConnection): Boolean;

//------------------------------------------------------------------------------

implementation

{$R *.dfm}

//------------------------------------------------------------------------------

function EditConnectionOptions(AConnection: TModbusConnection): Boolean;
begin
  with TConnectionOptionsForm.Create(nil) do
    try
      // Feed the controls with appropriate initial property values
      // fetched from supplied AConnection.
      PortComboBox.ComPort := AConnection;
      BaudRateComboBox.ComPort := AConnection;
      CustomBaudRateEdit.Text := IntToStr(AConnection.CustomBaudRate);
      DataBitsComboBox.ComPort := AConnection;
      StopBitsComboBox.ComPort := AConnection;
      ParityBitsComboBox.ComPort := AConnection;
      IntCharJitterEdit.Text := IntToStr(AConnection.InterCharacterJitter);
      IntTransDelayEdit.Text := IntToStr(AConnection.InterTransactionDelay);
      QryTransTimeoutEdit.Text := IntToStr(AConnection.QueryTransmitTimeout);
      RplRecvTimeoutEdit.Text := IntToStr(AConnection.ReplyReceiveTimeout);
      MaxTransRetriesEdit.Text := IntToStr(AConnection.MaxTransactionRetries);
      TransThrdPriorityComboBox.ItemIndex := Ord(AConnection.TransactionThreadPriority);
      // Display the dialog and save the result.
      Result := ShowModal = mrOk;
      // Update AConnection with new property values in case of positive
      // modal result.
      if Result then
      begin
        // Most of Modbus transaction related properties cannot be changed
        // while the connection is active so it should be temporarily
        // deactivated in order to modify those properties...
        AConnection.Connected := False;
        // Apply the new property values.
        PortComboBox.ApplySettings;
        BaudRateComboBox.ApplySettings;
        if CustomBaudRateEdit.Visible then
        begin
          AConnection.CustomBaudRate := StrToInt(CustomBaudRateEdit.Text);
        end;
        DataBitsComboBox.ApplySettings;
        StopBitsComboBox.ApplySettings;
        ParityBitsComboBox.ApplySettings;
        AConnection.InterCharacterJitter := StrToInt(IntCharJitterEdit.Text);
        AConnection.InterTransactionDelay := StrToInt(IntTransDelayEdit.Text);
        AConnection.QueryTransmitTimeout := StrToInt(QryTransTimeoutEdit.Text);
        AConnection.ReplyReceiveTimeout := StrToInt(RplRecvTimeoutEdit.Text);
        AConnection.MaxTransactionRetries := StrToInt(MaxTransRetriesEdit.Text);
        AConnection.TransactionThreadPriority := TThreadPriority(TransThrdPriorityComboBox.ItemIndex);
        // Finally, re-connect the connection.
        AConnection.Connected := True;
      end;
    finally
      Free;
    end;
end;

//------------------------------------------------------------------------------

function ThreadPriorityToStr(ThreadPriority: TThreadPriority): string;
const
  ThreadPriorities: array [TThreadPriority] of string = (
    'Idle',
    'Lowest',
    'Lower',
    'Normal',
    'Higher',
    'Highest',
    'Time Critical'
  );
begin
  Result := ThreadPriorities[ThreadPriority];
end;

//------------------------------------------------------------------------------
// TConnectionSetupForm class
//------------------------------------------------------------------------------

constructor TConnectionOptionsForm.Create(AOwner: TComponent);
var
  I: TThreadPriority;
begin
  inherited;
  with TransThrdPriorityComboBox.Items do
  begin
    Clear;
    for I := Low(I) to High(I) do
      Add(ThreadPriorityToStr(I));
  end;
end;

//------------------------------------------------------------------------------

procedure TConnectionOptionsForm.BaudRateComboBoxClick(Sender: TObject);
var
  IsCustomBaudRate: Boolean;
begin
  IsCustomBaudRate := BaudRateComboBox.ItemIndex = 0;
  Label4.Visible := not IsCustomBaudRate;
  CustomBaudRateEdit.Visible := IsCustomBaudRate;
  Label5.Visible := IsCustomBaudRate;
end;

//------------------------------------------------------------------------------

procedure TConnectionOptionsForm.FormShow(Sender: TObject);
begin
  BaudRateComboBoxClick(nil);
end;

//------------------------------------------------------------------------------

procedure TConnectionOptionsForm.OKButtonClick(Sender: TObject);

  procedure ValidateInteger(AEdit: TEdit; MinValue, MaxValue: Integer);
  var
    I: Integer;
    IsInvalid: Boolean;
  begin
    I := 0;
    IsInvalid := False;
    try
      I := StrToInt(AEdit.Text);
    except
      on E: Exception do
        if E is EConvertError then
          IsInvalid := True
        else
          raise;
    end;
    if not IsInvalid and (MinValue <> MaxValue) and
      ((I < MinValue) or (I > MaxValue)) then
    begin
      IsInvalid := True;
    end;
    if IsInvalid then
    begin
      MessageDlg('You''ve entered an invalid value.', mtError, [mbOK], 0);
      if AEdit.CanFocus then AEdit.SetFocus;
      Abort;
    end;
  end;

begin
  try
    // Perform a very simple input data validation.
    if CustomBaudRateEdit.Visible then
    begin
      ValidateInteger(CustomBaudRateEdit, 1, MaxInt);
    end;
    ValidateInteger(IntCharJitterEdit, 1, MaxInt);
    ValidateInteger(IntTransDelayEdit, 0, MaxInt);
    ValidateInteger(QryTransTimeoutEdit, 0, 0);
    ValidateInteger(RplRecvTimeoutEdit, 0, 0);
    ValidateInteger(MaxTransRetriesEdit, 1, MaxInt);
  except
    ModalResult := mrNone;
    raise;
  end;
end;

//------------------------------------------------------------------------------

end.
