// DELPHIX and DELPHIX_UP directives are defined only if Delphi is the compiler:
//
// DELPHI       Defined if Delphi (any version) is the compiler.
// DELPHI1      Defined if Delphi 1 is the compiler.
// DELPHI2      Defined if Delphi 2 is the compiler.
// DELPHI3      Defined if Delphi 3 is the compiler.
// DELPHI4      Defined if Delphi 4 is the compiler.
// DELPHI5      Defined if Delphi 5 is the compiler.
// DELPHI6      Defined if Delphi 6 is the compiler.
// DELPHI1_UP   Defined if Delphi 1 or higher is the compiler.
// DELPHI2_UP   Defined if Delphi 2 or higher is the compiler.
// DELPHI3_UP   Defined if Delphi 3 or higher is the compiler.
// DELPHI4_UP   Defined if Delphi 4 or higher is the compiler.
// DELPHI5_UP   Defined if Delphi 5 or higher is the compiler.
// DELPHI6_UP   Defined if Delphi 6 or higher is the compiler.
//
//------------------------------------------------------------------------------
//
// BCBX and BCBX_UP directives are defined only if C++ Builder is the compiler:
//
// BCB1         Defined if C++ Builder 1 is the compiler.
// BCB3         Defined if C++ Builder 3 is the compiler.
// BCB4         Defined if C++ Builder 4 is the compiler.
// BCB5         Defined if C++ Builder 5 is the compiler.
// BCB6         Defined if C++ Builder 6 is the compiler.
// BCB1_UP      Defined if C++ Builder 1 or higher is the compiler.
// BCB3_UP      Defined if C++ Builder 3 or higher is the compiler.
// BCB4_UP      Defined if C++ Builder 4 or higher is the compiler.
// BCB5_UP      Defined if C++ Builder 5 or higher is the compiler.
// BCB6_UP      Defined if C++ Builder 6 or higher is the compiler.
//
//------------------------------------------------------------------------------
//
// COMPILERX and COMPILERX_UP directives are defined always provided that either
// Delphi or C++ Builder is the compiler:
//
// COMPILER1    Defined if Delphi 1 is the compiler.
// COMPILER2    Defined if Delphi 2 or C++ Builder 1 is the compiler.
// COMPILER3    Defined if Delphi 3 is the compiler.
// COMPILER35   Defined if C++ Builder 3 is the compiler.
// COMPILER4    Defined if Delphi 4 or C++ Builder 4 is the compiler.
// COMPILER5    Defined if Delphi 5 or C++ Builder 5 is the compiler.
// COMPILER6    Defined if Delphi 6 or C++ Builder 6 is the compiler.
// COMPILER1_UP Defined if Delphi 1 or higher is the compiler.
// COMPILER2_UP Defined if Delphi 2 or C++ Builder 1 or higher is the compiler.
// COMPILER3_UP Defined if Delphi 3 or higher is the compiler.
// COMPILER35UP Defined if C++ Builder 3 or higher is the compiler.
// COMPILER4_UP Defined if Delphi 4 or C++ Builder 4 or higher is the compiler.
// COMPILER5_UP Defined if Delphi 5 or C++ Builder 5 or higher is the compiler.
// COMPILER6_UP Defined if Delphi 6 or C++ Builder 6 or higher is the compiler.

//------------------------------------------------------------------------------
// COMPILERX, DELPHIX, and BCBX directive definitions.
//------------------------------------------------------------------------------

{$IFDEF VER140}
  {$DEFINE COMPILER6}
  {$IFDEF BCB}
    {$DEFINE BCB6}
    {$DEFINE BCB}
  {$ELSE}
    {$DEFINE DELPHI6}
    {$DEFINE DELPHI}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER130}
  {$DEFINE COMPILER5}
  {$IFDEF BCB}
    {$DEFINE BCB5}
    {$DEFINE BCB}
  {$ELSE}
    {$DEFINE DELPHI5}
    {$DEFINE DELPHI}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER125}
  {$DEFINE COMPILER4}
  {$DEFINE BCB4}
  {$DEFINE BCB}
{$ENDIF}

{$IFDEF VER120}
  {$DEFINE COMPILER4}
  {$DEFINE DELPHI4}
  {$DEFINE DELPHI}
{$ENDIF}

{$IFDEF VER110}
  {$DEFINE COMPILER35}
  {$DEFINE BCB3}
{$ENDIF}

{$IFDEF VER100}
  {$DEFINE COMPILER3}
  {$DEFINE DELPHI3}
  {$DEFINE DELPHI}
{$ENDIF}

{$IFDEF VER93}
  {$DEFINE COMPILER2}
  {$DEFINE BCB1}
  {$DEFINE BCB}
{$ENDIF}

{$IFDEF VER90}
  {$DEFINE COMPILER2}
  {$DEFINE DELPHI2}
  {$DEFINE DELPHI}
{$ENDIF}

{$IFDEF VER80}
  {$DEFINE COMPILER1}
  {$DEFINE DELPHI1}
  {$DEFINE DELPHI}
{$ENDIF}

//------------------------------------------------------------------------------
// DELPHIX_UP directive definitions.
//------------------------------------------------------------------------------

{$IFDEF DELPHI6}
  {$DEFINE DELPHI6_UP}
  {$DEFINE DELPHI5_UP}
  {$DEFINE DELPHI4_UP}
  {$DEFINE DELPHI3_UP}
  {$DEFINE DELPHI2_UP}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

{$IFDEF DELPHI5}
  {$DEFINE DELPHI5_UP}
  {$DEFINE DELPHI4_UP}
  {$DEFINE DELPHI3_UP}
  {$DEFINE DELPHI2_UP}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

{$IFDEF DELPHI4}
  {$DEFINE DELPHI4_UP}
  {$DEFINE DELPHI3_UP}
  {$DEFINE DELPHI2_UP}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

{$IFDEF DELPHI3}
  {$DEFINE DELPHI3_UP}
  {$DEFINE DELPHI2_UP}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

{$IFDEF DELPHI2}
  {$DEFINE DELPHI2_UP}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

{$IFDEF DELPHI1}
  {$DEFINE DELPHI1_UP}
{$ENDIF}

//------------------------------------------------------------------------------
// BCBX_UP directive definitions.
//------------------------------------------------------------------------------

{$IFDEF BCB6}
  {$DEFINE BCB6_UP}
  {$DEFINE BCB5_UP}
  {$DEFINE BCB4_UP}
  {$DEFINE BCB3_UP}
  {$DEFINE BCB1_UP}
{$ENDIF}

{$IFDEF BCB5}
  {$DEFINE BCB5_UP}
  {$DEFINE BCB4_UP}
  {$DEFINE BCB3_UP}
  {$DEFINE BCB1_UP}
{$ENDIF}

{$IFDEF BCB4}
  {$DEFINE BCB4_UP}
  {$DEFINE BCB3_UP}
  {$DEFINE BCB1_UP}
{$ENDIF}

{$IFDEF BCB3}
  {$DEFINE BCB3_UP}
  {$DEFINE BCB1_UP}
{$ENDIF}

{$IFDEF BCB1}
  {$DEFINE BCB1_UP}
{$ENDIF}

//------------------------------------------------------------------------------
// COMPILERX_UP directive definitions.
//------------------------------------------------------------------------------

{$IFDEF COMPILER6}
  {$DEFINE COMPILER6_UP}
  {$DEFINE COMPILER5_UP}
  {$DEFINE COMPILER4_UP}
  {$DEFINE COMPILER35_UP}
  {$DEFINE COMPILER3_UP}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER5}
  {$DEFINE COMPILER5_UP}
  {$DEFINE COMPILER4_UP}
  {$DEFINE COMPILER35_UP}
  {$DEFINE COMPILER3_UP}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER4}
  {$DEFINE COMPILER4_UP}
  {$DEFINE COMPILER35_UP}
  {$DEFINE COMPILER3_UP}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER35}
  {$DEFINE COMPILER35_UP}
  {$DEFINE COMPILER3_UP}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER3}
  {$DEFINE COMPILER3_UP}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER2}
  {$DEFINE COMPILER2_UP}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

{$IFDEF COMPILER1}
  {$DEFINE COMPILER1_UP}
{$ENDIF}

