// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MRViewer.pas' rev: 5.00

#ifndef MRViewerHPP
#define MRViewerHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Graphics.hpp>	// Pascal unit
#include <ADOintmr.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <RAWPrinter.hpp>	// Pascal unit
#include <ParseExpr.hpp>	// Pascal unit
#include <UBaseClass.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Mrviewer
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TMRPrintType { ptNone, ptPrint, ptPrintToFile, ptPreview };
#pragma option pop

#pragma option push -b-
enum TMRInitReportBool { irb_default, irb_Yes, irb_No };
#pragma option pop

typedef void __fastcall (__closure *TOnGetPicture)(AnsiString PictureName, Graphics::TPicture* APicture
	, bool &Accept);

typedef void __fastcall (__closure *TOnProgressEvent)(int Position);

typedef void __fastcall (__closure *TOnLoadReportEvent)(AnsiString ReportFile, AnsiString &ReportName
	, Classes::TStringList* ReportDefinition, bool &Accept);

class DELPHICLASS TMRPrintReport;
typedef void __fastcall (__closure *TAfterLoadReportEvent)(TMRPrintReport* Report);

typedef void __fastcall (__closure *TOnActivateConnectionEvent)(Adointmr::_di__Connection &Connection
	, bool &Accept);

typedef void __fastcall (__closure *TOnActivateQueryEvent)(AnsiString Name, bool IsMain, AnsiString 
	DetailInternalName, AnsiString &Query, bool &Accept);

typedef void __fastcall (__closure *TOnLoadMainSQL)(AnsiString Name, AnsiString &SQL, bool &Accept);
	

typedef void __fastcall (__closure *TGetDataRecordSet)(AnsiString Name, bool IsMain, AnsiString DetailInternalName
	, AnsiString SQL, Adointmr::_di__Recordset &FDataSet);

typedef void __fastcall (__closure *TGetDataSetEvent)(AnsiString Name, bool IsMain, AnsiString DetailInternalName
	, Db::TDataSet* &FDataSet);

class DELPHICLASS TPageData;
class PASCALIMPLEMENTATION TPageData : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Classes::TStringList* Lines;
	Classes::TStringList* Control;
	Classes::TStringList* Frame;
	__fastcall TPageData(void);
	__fastcall virtual ~TPageData(void);
};


typedef DynamicArray<TPageData* >  MRViewer__3;

class DELPHICLASS TPreviewData;
class PASCALIMPLEMENTATION TPreviewData : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int PagesCount;
	DynamicArray<TPageData* >  Pages;
	__fastcall virtual ~TPreviewData(void);
	TPageData* __fastcall GetNewPage(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPreviewData(void) : System::TObject() { }
	#pragma option pop
	
};


class DELPHICLASS TGraphicField;
class PASCALIMPLEMENTATION TGraphicField : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Ubaseclass::TSectionFieldBase* Field;
	AnsiString Value;
	int YStart;
	__fastcall TGraphicField(Ubaseclass::TSectionFieldBase* AField, AnsiString AValue, int AYStart);
public:
		
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TGraphicField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TGraphicPageData;
class PASCALIMPLEMENTATION TGraphicPageData : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Classes::TList* PrintDataFields;
	__fastcall TGraphicPageData(void);
	__fastcall virtual ~TGraphicPageData(void);
	void __fastcall AddField(Ubaseclass::TSectionFieldBase* AField, AnsiString AValue, int AYStart);
};


typedef DynamicArray<TGraphicPageData* >  MRViewer__7;

class DELPHICLASS TPreviewGraphicData;
class PASCALIMPLEMENTATION TPreviewGraphicData : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int PagesCount;
	DynamicArray<TGraphicPageData* >  Pages;
	__fastcall virtual ~TPreviewGraphicData(void);
	TGraphicPageData* __fastcall GetNewPage(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPreviewGraphicData(void) : System::TObject() { }
	#pragma option pop
	
};


#pragma option push -b-
enum TExpressionValueType { evtDouble, evtString };
#pragma option pop

class DELPHICLASS TExpressionVariable;
class DELPHICLASS TReportField;
class DELPHICLASS TMRViewer;
class PASCALIMPLEMENTATION TMRViewer : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FpAbort;
	AnsiString FReportFile;
	AnsiString FReportDir;
	AnsiString FDefinitionDir;
	bool FLoaded;
	int FPageNum;
	int FLineNum;
	int FLinesCount;
	TextFile FFile;
	TMRPrintType FPrintType;
	Ubaseclass::TReportBase* Report;
	TMRPrintReport* MReport;
	Ubaseclass::TPrinterDefinition* PrinterDef;
	Classes::TStringList* EscSeq;
	int ConvTableMP[256];
	int ConvTableDM[256];
	TPreviewData* PData;
	TPreviewGraphicData* GDataPrint;
	TPreviewGraphicData* GDataPreview;
	TPageData* ActualPreviewPage;
	TGraphicPageData* ActualGraphicPage;
	Rawprinter::TRAWPrinter* RAWPrinter;
	int FromPage;
	int ToPage;
	bool FAcceptAppData;
	TMRInitReportBool FSetFontSize;
	int FPageLength;
	AnsiString FConvTableNameMP;
	AnsiString FConvTableNameDM;
	TMRInitReportBool FFFAfterReport;
	TMRInitReportBool FResetPrinter;
	AnsiString FPrinterESCCodes;
	Classes::TStrings* FParameters;
	Classes::TStringList* FParamNames;
	TOnProgressEvent FOnProgress;
	TOnLoadReportEvent FOnLoadReport;
	TAfterLoadReportEvent FAfterLoadReport;
	TOnActivateConnectionEvent FOnActivateConnection;
	TOnActivateQueryEvent FOnActivateQuery;
	TGetDataSetEvent FGetDataSet;
	TOnLoadMainSQL FOnLoadMainSQL;
	TGetDataRecordSet FGetDataRecordSet;
	TOnGetPicture FOnGetPicture;
	void __fastcall SetReportDir(const AnsiString Value);
	void __fastcall SetDefinitionDir(const AnsiString Value);
	bool __fastcall ReadReport(AnsiString FileName);
	AnsiString __fastcall DecodeESCString(AnsiString EscString);
	void __fastcall DecodeEscSequences(void);
	void __fastcall DecodePrinterCodes(void);
	AnsiString __fastcall DecodeEsc(AnsiString ESCCode);
	AnsiString __fastcall ConvertMP(AnsiString Source);
	AnsiString __fastcall ConvertDM(AnsiString Source);
	void __fastcall CreateMReport(TMRPrintReport* &AMReport, Ubaseclass::TReportBase* AReport);
	void __fastcall InitializePrintReport(void);
	void __fastcall SetFieldsToNoEvaluated(TMRPrintReport* FReport);
	void __fastcall SetGroupValues(TMRPrintReport* FReport);
	bool __fastcall PrintGroupHeaders(TMRPrintReport* FReport, int StartGroup, bool NoFirst);
	void __fastcall PrintGroupFooters(TMRPrintReport* FReport, int StartGroup, bool LastRow);
	bool __fastcall CompareGroupValues(TMRPrintReport* FReport, int &ChangedIndex);
	void __fastcall InitializeDetailQuery(TMRPrintReport* MasterReport, TMRPrintReport* DetailReport, AnsiString 
		MasterLinkDataField, AnsiString DetailLinkDataField);
	void __fastcall InitializeParameters(TMRPrintReport* Rpt);
	bool __fastcall PrintLine(AnsiString Line, Ubaseclass::TSectionBase* Section, AnsiString AControl, 
		AnsiString AFrame);
	void __fastcall PrintReport(bool Main, TMRPrintReport* PReport);
	void __fastcall PrintReportBeforePart(void);
	void __fastcall PrintReportAfterPart(void);
	bool __fastcall NewPage(void);
	bool __fastcall PrintTopOfPage(void);
	bool __fastcall PrintBottomOfPage(void);
	void __fastcall SetAcceptAppData(const bool Value);
	void __fastcall SetParameters(Classes::TStrings* Value);
	void __fastcall Set_ParamNames(Classes::TStringList* Value);
	AnsiString __fastcall GetDefinitionPath(void);
	void __fastcall PrintExec(int FPrinterIndex, AnsiString FPrinterName, int FFromPage, int FToPage, int 
		FCopies);
	
protected:
	bool __fastcall DoGetPicture(AnsiString PictureName, Graphics::TPicture* APicture);
	void __fastcall DoProgress(int Position);
	bool __fastcall DoLoadReport(AnsiString ReportFile, AnsiString &ReportName, Classes::TStringList* ReportDefinition
		);
	void __fastcall DoAfterLoadReport(TMRPrintReport* Report);
	bool __fastcall DoActivateConnection(Adointmr::_di__Connection &Connection);
	bool __fastcall DoActivateQuery(AnsiString Name, bool IsMain, AnsiString DetailInternalName, AnsiString 
		&Query);
	bool __fastcall DoLoadMainSQL(AnsiString Name, AnsiString &SQL);
	Adointmr::_di__Recordset __fastcall DoGetDataRecordSet(AnsiString Name, bool IsMain, AnsiString DetailInternalName
		, AnsiString SQL);
	void __fastcall DoGetDataSet(AnsiString Name, bool IsMain, AnsiString DetailInternalName, Db::TDataSet* 
		&FDataSet);
	void __fastcall PrepareExprVar(TMRPrintReport* AMReport, AnsiString ExprString, Classes::TStringList* 
		ExprVarLocal);
	void __fastcall AssignExprVariables(Parseexpr::TExpressionParser* MathParser, Classes::TStringList* 
		ExprVarLocal);
	
public:
	Graphics::TMetafile* FMetafile;
	__fastcall virtual TMRViewer(Classes::TComponent* AOwner);
	__fastcall virtual ~TMRViewer(void);
	void __fastcall Print(AnsiString FPrinterName, int FFromPage, int FToPage, int FCopies)/* overload */
		;
	void __fastcall Print(int FPrinterIndex, int FFromPage, int FToPage, int FCopies)/* overload */;
	void __fastcall PrintToFile(AnsiString FFileName);
	void __fastcall Preview(void);
	bool __fastcall LoadReport(AnsiString FileName);
	void __fastcall UnLoadReport(void);
	void __fastcall GetConvTables(Classes::TStringList* ConvList);
	void __fastcall GetPrinterESCCodes(Classes::TStringList* PrinterCodesList);
	void __fastcall CreateGraphicPage(int FPage, bool IsPreview);
	__property TMRPrintType PrintType = {read=FPrintType, write=FPrintType, nodefault};
	__property bool pAbort = {read=FpAbort, write=FpAbort, nodefault};
	__property Classes::TStringList* ParamNames = {read=FParamNames, write=Set_ParamNames};
	
__published:
	__property AnsiString ReportDir = {read=FReportDir, write=SetReportDir};
	__property AnsiString DefinitionDir = {read=FDefinitionDir, write=SetDefinitionDir};
	__property bool AcceptAppData = {read=FAcceptAppData, write=SetAcceptAppData, nodefault};
	__property Classes::TStrings* Parameters = {read=FParameters, write=SetParameters};
	__property TMRInitReportBool SetFontSize = {read=FSetFontSize, write=FSetFontSize, default=0};
	__property int PageLength = {read=FPageLength, write=FPageLength, default=0};
	__property AnsiString ConvTableNameDM = {read=FConvTableNameDM, write=FConvTableNameDM};
	__property AnsiString ConvTableNameMP = {read=FConvTableNameMP, write=FConvTableNameMP};
	__property TMRInitReportBool FFAfterReport = {read=FFFAfterReport, write=FFFAfterReport, default=0}
		;
	__property TMRInitReportBool ResetPrinter = {read=FResetPrinter, write=FResetPrinter, default=0};
	__property AnsiString PrinterESCCodes = {read=FPrinterESCCodes, write=FPrinterESCCodes};
	__property TOnProgressEvent OnProgress = {read=FOnProgress, write=FOnProgress};
	__property TOnLoadReportEvent OnLoadReport = {read=FOnLoadReport, write=FOnLoadReport};
	__property TAfterLoadReportEvent AfterLoadReport = {read=FAfterLoadReport, write=FAfterLoadReport};
		
	__property TOnActivateConnectionEvent OnActivateConnection = {read=FOnActivateConnection, write=FOnActivateConnection
		};
	__property TOnActivateQueryEvent OnActivateQuery = {read=FOnActivateQuery, write=FOnActivateQuery};
		
	__property TGetDataSetEvent OnGetDataSet = {read=FGetDataSet, write=FGetDataSet};
	__property TOnLoadMainSQL OnLoadMainSQL = {read=FOnLoadMainSQL, write=FOnLoadMainSQL};
	__property TGetDataRecordSet GetDataRecordSet = {read=FGetDataRecordSet, write=FGetDataRecordSet};
	__property TOnGetPicture OnGetPicture = {read=FOnGetPicture, write=FOnGetPicture};
};


class PASCALIMPLEMENTATION TReportField : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TMRViewer* Viewer;
	Ubaseclass::TFieldBase* FieldBase;
	TMRPrintReport* MReport;
	Variant FValue;
	bool Evaluated;
	Ubaseclass::TReportBase* DetailReport;
	TMRPrintReport* DetailMReport;
	Classes::TStringList* ExprVar;
	bool ExprVarPrepared;
	__fastcall TReportField(Ubaseclass::TFieldBase* AFieldBase, TMRPrintReport* AMReport, TMRViewer* AViewer
		);
	__fastcall virtual ~TReportField(void);
	Variant __fastcall Get_Value(void);
	char __fastcall GetFrameCode(Ubaseclass::TFrameType FrameCode);
	Variant __fastcall ComputeFuncionField(void);
	__property Variant Value = {read=Get_Value, write=FValue};
};


class PASCALIMPLEMENTATION TExpressionVariable : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TExpressionValueType ValueType;
	TReportField* Field;
	double DoubleValue;
	AnsiString StringValue;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TExpressionVariable(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TExpressionVariable(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPrintField;
class PASCALIMPLEMENTATION TPrintField : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Ubaseclass::TSectionFieldBase* SectionField;
	TMRViewer* Viewer;
	TMRPrintReport* MReport;
	TReportField* ReportField;
	AnsiString FESCBefore;
	AnsiString FESCAfter;
	bool PrintEnabled;
	bool Evaluated;
	AnsiString FValue;
	Classes::TStringList* ExprVarLeftIf;
	Classes::TStringList* ExprVarRightIf;
	bool ExprVarLeftIfPrepared;
	bool ExprVarRightIfPrepared;
	__fastcall TPrintField(TMRViewer* AViewer, Ubaseclass::TSectionFieldBase* FSectionField, TMRPrintReport* 
		AMReport, TReportField* AReportField);
	__fastcall virtual ~TPrintField(void);
	bool __fastcall IfPrintCondition(void);
	AnsiString __fastcall Get_Value(void);
	__property AnsiString Value = {read=Get_Value};
};


typedef DynamicArray<TPrintField* >  MRViewer__21;

class DELPHICLASS TPrintLine;
class PASCALIMPLEMENTATION TPrintLine : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	DynamicArray<TPrintField* >  PrintFields;
	int PrintFieldsCount;
	Ubaseclass::TReportBase* FReport;
	TMRViewer* Viewer;
	AnsiString FControlLine;
	AnsiString FFrameLine;
	__fastcall TPrintLine(TMRViewer* AViewer, Ubaseclass::TReportBase* AReport, Ubaseclass::TSectionBase* 
		FSection, int FLine, TMRPrintReport* AMReport);
	__fastcall virtual ~TPrintLine(void);
	AnsiString __fastcall ReplaceString(AnsiString s, AnsiString Substr, int Pos, int addchar, int add)
		;
	AnsiString __fastcall GetPreviewLine(void);
	AnsiString __fastcall GetPrintLine(void);
};


typedef DynamicArray<TPrintLine* >  MRViewer__41;

typedef DynamicArray<AnsiString >  MRViewer__51;

typedef DynamicArray<Variant >  MRViewer__61;

class DELPHICLASS TPrintSection;
class PASCALIMPLEMENTATION TPrintSection : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	DynamicArray<TPrintLine* >  PrintLine;
	TMRViewer* Viewer;
	TMRPrintReport* FMReport;
	int GroupFieldsCount;
	DynamicArray<AnsiString >  GroupFields;
	DynamicArray<Variant >  GroupActualValues;
	__fastcall TPrintSection(TMRViewer* AViewer, TMRPrintReport* AMReport, Ubaseclass::TReportBase* FReport
		, Ubaseclass::TSectionBase* FSection);
	__fastcall virtual ~TPrintSection(void);
	bool __fastcall Print(void);
	void __fastcall PrintGraphic(void);
	void __fastcall SetFieldsToNoEvaluated(void);
	Ubaseclass::TSectionBase* Section;
};


typedef DynamicArray<TReportField* >  MRViewer__81;

typedef DynamicArray<TPrintSection* >  MRViewer__91;

typedef DynamicArray<TPrintSection* >  MRViewer__02;

class PASCALIMPLEMENTATION TMRPrintReport : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TMRViewer* Viewer;
	bool InitializeData;
	Adointmr::_di__Connection DataConnection;
	Adointmr::_di__Recordset DataRecordSet;
	Db::TDataSet* FDataSet;
	int ReportFieldsCount;
	DynamicArray<TReportField* >  ReportFields;
	AnsiString DetailName;
	AnsiString DetailInternalName;
	bool CondensFromNormal;
	__fastcall TMRPrintReport(Ubaseclass::TReportBase* ABaseReport, TMRViewer* AViewer);
	TReportField* __fastcall GetReportField(Ubaseclass::TFieldBase* AFieldBase);
	void __fastcall AddReportField(Ubaseclass::TFieldBase* AFieldBase);
	void __fastcall SetFieldsToNoEvaluated(void);
	void __fastcall SetComputeFieldsToZero(Ubaseclass::TSetZeroType SetType, int GroupIndex);
	void __fastcall ComputeSumFields(void);
	
public:
	Ubaseclass::TReportBase* BaseReport;
	TPrintSection* PrintReportHeader;
	TPrintSection* PrintPageHeader;
	TPrintSection* PrintBodyHeader;
	TPrintSection* PrintReportBody;
	TPrintSection* PrintPageFooter;
	TPrintSection* PrintFillToEndPage;
	TPrintSection* PrintReportFooter;
	DynamicArray<TPrintSection* >  PrintGroupHeader;
	DynamicArray<TPrintSection* >  PrintGroupFooter;
	int GroupsCount;
	AnsiString DetailQuery;
	__fastcall virtual ~TMRPrintReport(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TMRPrintReport(void) : System::TObject() { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Mrviewer */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mrviewer;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// MRViewer
