unit uInsertText;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons;

type
  TfrmInsertText = class(TForm)
    GroupBox1: TGroupBox;
    edtText: TEdit;
    edtFontName: TComboBox;
    edtFontSize: TEdit;
    udFontSize: TUpDown;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    btnBold: TSpeedButton;
    btnItalic: TSpeedButton;
    btnUnderline: TSpeedButton;
    procedure edtFontNameChange(Sender: TObject);
    procedure GetFontNames;
    procedure btnBoldClick(Sender: TObject);
    procedure btnItalicClick(Sender: TObject);
    procedure btnUnderlineClick(Sender: TObject);
    procedure edtFontSizeChange(Sender: TObject);
  private
    function CreateTextHandle: HRGN;
  public
    { Public declarations }
  end;

  function ShowInsertText: HRGN;

var
  frmInsertText: TfrmInsertText;

implementation

{$R *.DFM}

function ShowInsertText: HRGN;
begin
  with TfrmInsertText.Create(nil) do
  try
    GetFontNames;
    edtFontName.Text := 'Tahoma';
    udFontSize.Position := 36;
    if ShowModal = mrOK then
      Result := CreateTextHandle
    else Result := 0;
  finally
    Release;
  end;
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

procedure TfrmInsertText.GetFontNames;
var
  DC: HDC;
begin
  DC := GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(edtFontName.Items));
  ReleaseDC(0, DC);
  edtFontName.Sorted := True;
end;

procedure TfrmInsertText.edtFontNameChange(Sender: TObject);
begin
  edtText.Font.Name := edtFontName.Items[edtFontName.ItemIndex];
end;

procedure TfrmInsertText.btnBoldClick(Sender: TObject);
var
  FontStyles : TFontStyles;
begin
  FontStyles := edtText.Font.Style;
  if btnBold.Down then
    Include(FontStyles, fsBold)
  else Exclude(FontStyles, fsBold);
  edtText.Font.Style := FontStyles;
end;

procedure TfrmInsertText.btnItalicClick(Sender: TObject);
var
  FontStyles : TFontStyles;
begin
  FontStyles := edtText.Font.Style;
  if btnItalic.Down then
    Include(FontStyles, fsItalic)
  else Exclude(FontStyles, fsItalic);
  edtText.Font.Style := FontStyles;
end;

procedure TfrmInsertText.btnUnderlineClick(Sender: TObject);
var
  FontStyles : TFontStyles;
begin
  FontStyles := edtText.Font.Style;
  if btnUnderline.Down then
    Include(FontStyles, fsUnderline)
  else Exclude(FontStyles, fsUnderline);
  edtText.Font.Style := FontStyles;
end;

procedure TfrmInsertText.edtFontSizeChange(Sender: TObject);
begin
  try
    edtText.Font.Size := StrToInt(edtFontSize.Text);
  except
    edtFontSize.Text := '36';
  end;  
end;

function TfrmInsertText.CreateTextHandle: HRGN;
var
  Bitmap : TBitmap;
  Handle : HDC;
begin
  Bitmap := TBitmap.Create;
  Bitmap.Canvas.Font.Name := edtText.Font.Name;
  Bitmap.Canvas.Font.Style := edtText.Font.Style;
  Bitmap.Canvas.Font.Size := edtText.Font.Size;
  Handle := Bitmap.Canvas.Handle;
  try
    BeginPath(Handle);
    SetBkMode(Handle, TRANSPARENT);
    SetPolyFillMode(Handle, WINDING);
    TextOut(Handle, 10, 30, PChar(edtText.Text), Length(edtText.Text));
    EndPath(Handle);
    FlattenPath(Handle);
    Result := PathToRegion(Handle);
  finally
    Bitmap.Free;
  end;
end;
end.
