unit uExtractData;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls, uMATypeLibrary, uMARoutines;

(******************************************************************************)
(*  Wraps enabling objects to be added to TString                             *)
(******************************************************************************)
type
  TPointWrap = class
  private
    FPoint: TPoint;
    FLink: integer;
  public
    property Point : TPoint read FPoint write FPoint;
    property Link : integer read FLink write FLink;
  end;

  TRectWrap = class
  private
    FRect: TRect;
  public
    property Rect : TRect read FRect write FRect;
  end;


type
  TfrmExtractData = class(TForm)
    btnOK: TBitBtn;
    PageControl1: TPageControl;
    tsRegions: TTabSheet;
    Bevel1: TBevel;
    lblRectCount: TLabel;
    Label1: TLabel;
    ListBoxRegion: TListBox;
    tsPaths: TTabSheet;
    Label2: TLabel;
    lblPointCount: TLabel;
    ListBoxPath: TListBox;
    Bevel3: TBevel;
    procedure FormDestroy(Sender: TObject);
    procedure ListBoxRegionClick(Sender: TObject);
    procedure ListBoxPathClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    DrawingCanvas : TCanvas;
    Shape : TShape;
  public
    { Public declarations }
  end;

  procedure PreviewExtractRegion(AOwner, WinControl: TComponent; Canvas : TCanvas; Path : TPath; Region : TRegion);
  procedure LoadPathDetails(Path : TPath; ListBox : TListBox);
  procedure LoadRegionDetails(Region: TRegion; Listbox : TListbox);

var
  frmExtractData: TfrmExtractData;

implementation

{$R *.DFM}

procedure PreviewExtractRegion(AOwner, WinControl: TComponent;  Canvas : TCanvas; Path : TPath; Region : TRegion);
begin
  with TfrmExtractData.Create(AOwner) do
  try
    Shape.Parent := (WinControl as TWinControl);
    DrawingCanvas := Canvas;
    DrawingCanvas.Brush.Color := clRed;
    LoadPathDetails(Path, ListBoxPath);
    LoadRegionDetails(Region, ListboxRegion);
    lblPointCount.Caption := inttostr(ListboxPath.Items.Count);
    lblRectCount.Caption := inttostr(ListboxRegion.Items.Count);
    Left := (AOwner as TControl).BoundsRect.Right;
    Top := (AOwner as TControl).Top;
    Height := (AOwner as TControl).Height;
    ShowModal;
  finally
    Release;
  end;
end;

procedure LoadPathDetails(Path : TPath; ListBox : TListBox);
var
  i : integer;
  Temp : string;
  nPoint : TPointWrap;
begin
  for i := 0 to high(Path.points) do
  begin
    case Path.Types[i] and not PT_CLOSEFIGURE of
    PT_MOVETO :   Temp := 'MoveTo ';
    PT_LINETO :   Temp := 'lineTo ';
    PT_BEZIERTO : Temp := 'BezierTo '; // Never used as all Paths are flatterned
    end;
    if (Path.Types[i] and PT_CLOSEFIGURE)=PT_CLOSEFIGURE then
      Temp := Temp + '& Close ';
    Temp := Temp + 'x: '+ inttostr(Path.Points[i].x)+' y: '+inttostr(Path.Points[i].y);
    nPoint := TPointWrap.Create;
    nPoint.Point := point(Path.Points[i].x,Path.Points[i].y);
    ListBox.Items.AddObject(Temp, TObject(nPoint));
  end;
end;

procedure LoadRegionDetails(Region: TRegion; Listbox : TListbox);
var
  Rect : TRectWrap;
  i : integer;
begin
  for i := 0 to high(Region.Rects) do
  begin
    Rect := TRectWrap.Create;
    Rect.Rect := Region.Rects[i];
    Listbox.Items.AddObject('L: '+IntToStr(Region.Rects[i].Left)+
          ', T: '+IntToStr(Region.Rects[i].Top)+
          ', R: '+IntToStr(Region.Rects[i].Right)+
          ', B: '+IntToStr(Region.Rects[i].Bottom)+')',
          TObject(Rect));
  end;
end;

procedure CleanUpListBoxes(ListBox : TListBox);
var
  i : integer;
begin
  for i := 0 to ListBox.Items.Count-1 do
    ListBox.Items.Objects[i].free;
  ListBox.Items.Clear;
end;

procedure TfrmExtractData.FormDestroy(Sender: TObject);
begin
  CleanUpListBoxes(ListboxRegion);
  CleanUpListBoxes(ListboxPath);
  Shape.Free;
end;

procedure TfrmExtractData.ListBoxRegionClick(Sender: TObject);
begin
  if ((Sender as TListBox).Items.Objects[(Sender as TListBox).ItemIndex]) <> nil then
  begin
     Shape.BoundsRect := (TRectWrap((Sender as TListBox).Items.Objects[(Sender as TListBox).ItemIndex]).Rect);
  end;
end;

procedure TfrmExtractData.ListBoxPathClick(Sender: TObject);
var
  pt : TPoint;
begin
  if ((Sender as TListBox).Items.Objects[(Sender as TListBox).ItemIndex]) <> nil then
  begin
    pt := TPointWrap((Sender as TListbox).Items.Objects[(Sender as TListbox).ItemIndex]).Point;
    Shape.BoundsRect := Rect(pt.x-2,pt.y-2, pt.x+2, pt.y+2);
  end;
end;

procedure TfrmExtractData.FormCreate(Sender: TObject);
begin
  Shape := TShape.Create(Owner);
  Shape.Brush.Color := clRed;
  Shape.Pen.Color := clRed;
  Shape.BringToFront;
  Shape.Width := 0;
  Shape.Height := 0;
  Shape.Visible := True;
end;

end.
