unit uDemoFeatured;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uMASelectionManager, uMASelectionCreator, jpeg, ExtCtrls, Menus, ComCtrls,
  StdCtrls, uMATypeLibrary, ImgList, uMAClasses, uMASelectionControl, uMARoutines,
  Spin, Buttons, uInsertText;

type
  TfrmDemoFeatured = class(TForm)
    StatusBar1: TStatusBar;
    pnlControl: TPanel;
    SelectionControl1: TSelectionControl;
    SelectionCreator1: TSelectionCreator;
    btnSelectionOnOff: TSpeedButton;
    pnlSelection: TPanel;
    Label1: TLabel;
    Label5: TLabel;
    lblCornerRounding: TLabel;
    Label6: TLabel;
    Label2: TLabel;
    cbToolShape: TComboBox;
    cbLinePattern: TComboBox;
    seRoundCorner: TSpinEdit;
    seSpeed: TSpinEdit;
    btnText: TBitBtn;
    cbDirection: TComboBox;
    SpeedButton1: TSpeedButton;
    btnRefresh: TSpeedButton;
    SelectionManager1: TSelectionManager;
    chkLockToImage: TCheckBox;
    btnExtractData: TBitBtn;
    ScrollBox1: TScrollBox;
    bgGrid: TShape;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure ScrollBoxResize(Sender: TObject);
    procedure cbLinePatternChange(Sender: TObject);
    procedure cbToolShapeChange(Sender: TObject);
    procedure btnTextClick(Sender: TObject);
    procedure seSpeedChange(Sender: TObject);
    procedure seRoundCornerChange(Sender: TObject);
    procedure cbDirectionChange(Sender: TObject);
    procedure btnSelectionOnOffClick(Sender: TObject);
    procedure SelectionManager1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SelectionManager1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SelectionManager1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnRefreshClick(Sender: TObject);
    procedure SelectionManager1SelectionChange(Sender: TObject; Region: HRGN);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure chkLockToImageClick(Sender: TObject);
    procedure btnExtractDataClick(Sender: TObject);
  private
    Bitmap,MaskBitmap,OrigBitmap : TBitmap;
    ShiftPos : TPoint;
    FloatRect : TRect;
    MaskBoundRGN, MaskRGN : HRGN;
    FRemainFloat: Boolean;
    FIsShifting: Boolean;
    procedure SetRemainFloat(const Value: Boolean);
    procedure SetIsShifting(const Value: Boolean);
  public
    { Public declarations }
    property IsShifting : Boolean read FIsShifting write SetIsShifting;
    property RemainFloat : Boolean read FRemainFloat write SetRemainFloat;
  end;

var
  frmDemoFeatured: TfrmDemoFeatured;

implementation

uses uExtractData;

{$R *.DFM}

procedure TfrmDemoFeatured.FormCreate(Sender: TObject);
begin
  SelectionControl1.WinControl := Scrollbox1;
  SelectionControl1.DrawingBounds.SetDimensions(Image1.Width, Image1.Height);
  cbToolShape.ItemIndex := 0;
  cbLinePattern.ItemIndex := 3;
  cbDirection.ItemIndex := 0;
  IsShifting := False;
  RemainFloat := False;
  MaskRGN := 0;
  MaskBoundRGN := 0;
end;

procedure TfrmDemoFeatured.ScrollBoxResize(Sender: TObject);
begin
  Image1.Left := (Scrollbox1.ClientWidth - Image1.Width) div 2;
  Image1.Top := (Scrollbox1.ClientHeight - Image1.Height) div 2;

  SelectionControl1.DrawingBounds.SetStartPoint(Image1.BoundsRect.TopLeft);
end;

procedure TfrmDemoFeatured.cbToolShapeChange(Sender: TObject);
begin
  SelectionCreator1.SelectionShapetype := TSelectionShapetype(cbToolShape.ItemIndex);
  // Enable/Disable non essential Controls
  lblCornerRounding.Enabled := cbToolShape.ItemIndex > 3;
  seRoundCorner.Enabled := cbToolShape.ItemIndex > 3;
end;

procedure TfrmDemoFeatured.cbLinePatternChange(Sender: TObject);
begin
  SelectionManager1.LinesPattern := TLinesPattern(cbLinePattern.ItemIndex);
end;

procedure TfrmDemoFeatured.btnTextClick(Sender: TObject);
var
  Region : HRGN;
  Shift: TShiftState;
begin
  try
    Region := ShowInsertText;
    if (Region <> 0) then
    begin
      if GetKeyState( VK_SHIFT ) < 0 then
        Include(Shift,ssShift);
      if GetKeyState( VK_CONTROL ) < 0 then
        Include(Shift,ssCtrl);
      SelectionManager1.LoadRegion(Region,Shift);
    end;
  finally
    DeleteObject(Region);
  end;
end;

procedure TfrmDemoFeatured.seSpeedChange(Sender: TObject);
begin
 SelectionManager1.Speed := seSpeed.Value;
end;

procedure TfrmDemoFeatured.seRoundCornerChange(Sender: TObject);
begin
  SelectionCreator1.RoundValue := seRoundCorner.Value;
end;

procedure TfrmDemoFeatured.cbDirectionChange(Sender: TObject);
begin
  SelectionManager1.Direction := TDirection(cbDirection.ItemIndex);
end;

procedure TfrmDemoFeatured.btnSelectionOnOffClick(Sender: TObject);
begin
  SelectionControl1.RunEngine := btnSelectionOnOff.Down;
  pnlSelection.Visible := btnSelectionOnOff.Down;
end;

(******************************************************************************)
(*  Below demostrates how to incorporate simply any image transformation with *)
(*  MarchingAnts. Moving selected regions has been implemented                *)
(******************************************************************************)

procedure TfrmDemoFeatured.SelectionManager1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  SelectionManager1.LockToCursor := True;
  if not chkLockToImage.Checked then exit;

  if RemainFloat then
  begin
    ShiftPos := Point(X,Y);
    IsShifting := True;
    exit;
  end;
  SelectionManager1.Animate := False;
  MaskBitmap := TBitmap.Create;
  Bitmap := TBitmap.Create;
  OrigBitmap := TBitmap.Create;
  // Generate Floating Image
  FloatRect := ExtractRegionBounds(SelectionManager1.GetRegion);
  with FloatRect do
  begin
    Bitmap.Width := Right-Left;
    Bitmap.Height := Bottom-Top;
    OrigBitmap.Width := Right-Left;
    OrigBitmap.Height := Bottom-Top;
    Bitmap.Canvas.CopyRect(Rect(0,0,Bitmap.Width,Bitmap.Height),Image1.Canvas,FloatRect);
    if (MaskBoundRGN <> 0) then
      DeleteObject(MaskBoundRGN);
    MaskBoundRGN := CreateRectRgn(0,0,Right-Left,Bottom-Top);
    CopyRegion(MaskRGN, SelectionManager1.GetRegion);
    OffSetRgn(MaskRGN, 0-Left,0-Top);
  end;

  MaskBitmap.Handle := GenerateMask(MaskBoundRGN, MaskRGN, True);
  BitBlt(Bitmap.Canvas.Handle, 0, 0, MaskBitmap.Width,
       MaskBitmap.Height, MaskBitmap.Canvas.Handle, 0, 0, SRCAND);
  // Generate image with cut out area
  try
    MaskBitmap.Handle := GenerateMask(SelectionControl1.DrawingBounds.Region,SelectionManager1.GetRegion, False);
    BitBlt(Image1.Canvas.Handle, 0,0, MaskBitmap.Width,
         MaskBitmap.Height, MaskBitmap.Canvas.Handle, 0, 0, SRCAND);
  finally
   // First grab the old background
   OrigBitmap.Canvas.CopyRect(Rect(0,0,OrigBitmap.Width,OrigBitmap.Height),Image1.Canvas,FloatRect);
  end;
  ShiftPos := Point(X,Y);
  IsShifting := True;
  RemainFloat := True;
end;

procedure TfrmDemoFeatured.SelectionManager1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  DiffPoint : TPoint;
begin
 if IsShifting and RemainFloat then
 begin
   // First restore the old background using the snap shot
   Image1.Canvas.Draw(FloatRect.Left, FloatRect.Top, OrigBitmap);
   // Calculate values from the movement in the mouse
   DiffPoint := SubtractPoints(Point(X,Y),ShiftPos);
   OffsetRect(FloatRect, DiffPoint.X, DiffPoint.Y);
   // Take a snap shot of what you are about to paint over
   OrigBitmap.Canvas.CopyRect(Rect(0, 0, OrigBitmap.Width, OrigBitmap.Height),Image1.Canvas,FloatRect);
   try
     if (MaskBoundRGN <> 0) then
      DeleteObject(MaskBoundRGN);
     MaskBoundRGN := CreateRectRgn(FloatRect.Left,FloatRect.Top,FloatRect.Right,FloatRect.Bottom);
     MaskBitmap.Handle := GenerateMask(MaskBoundRGN, MaskRGN, False);
     BitBlt(Image1.Canvas.Handle, FloatRect.Left, FloatRect.Top, MaskBitmap.Width,
            MaskBitmap.Height, MaskBitmap.Canvas.Handle, 0, 0, SRCAND);
   finally
     // Finally paint the new floating image over the original background
     BitBlt(Image1.Canvas.Handle, FloatRect.Left, FloatRect.Top, Bitmap.Width,
            Bitmap.Height, Bitmap.Canvas.Handle, 0, 0, SRCPAINT);
   end;
   ShiftPos := Point(X,Y);
  end;
end;

procedure TfrmDemoFeatured.SelectionManager1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  IsShifting := False;
  SelectionManager1.Animate := True;
  SelectionManager1.LockToCursor := False;
end;

procedure TfrmDemoFeatured.SetRemainFloat(const Value: Boolean);
begin
  if RemainFloat <> Value then
  begin
    FRemainFloat := Value;
    if not Value then
    begin
      IsShifting := False;
      MaskBitmap.Free;
      Bitmap.Free;
      OrigBitmap.Free;
      if MaskRGN <> 0 then
        DeleteObject(MaskRGN);
      MaskRGN := 0;
      if MaskBoundRGN <> 0 then
        DeleteObject(MaskBoundRGN);
      MaskBoundRGN := 0;
    end;
  end;
end;

procedure TfrmDemoFeatured.SetIsShifting(const Value: Boolean);
begin
  FIsShifting := Value;
end;

procedure TfrmDemoFeatured.btnRefreshClick(Sender: TObject);
begin
  RemainFloat := False;
  if FileExists('castle.bmp') then
    Image1.Picture.LoadFromFile('castle.bmp');
  SelectionControl1.DrawingBounds.Refresh;
end;

procedure TfrmDemoFeatured.SelectionManager1SelectionChange(Sender: TObject; Region: HRGN);
begin
  RemainFloat := False;
  SelectionControl1.DrawingBounds.Refresh;
end;

procedure TfrmDemoFeatured.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RemainFloat := False;
end;

procedure TfrmDemoFeatured.chkLockToImageClick(Sender: TObject);
begin
  RemainFloat := False;
  SelectionControl1.DrawingBounds.Refresh;
end;

procedure TfrmDemoFeatured.btnExtractDataClick(Sender: TObject);
begin
   PreviewExtractRegion(Self, Scrollbox1, Canvas, SelectionManager1.GetTPath(wtZoomed_Form_TL), SelectionManager1.GetTRegion(wtZoomed_Form_TL))
end;

end.
