unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, MultiLanguage, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Language1: TMenuItem;
    Exit1: TMenuItem;
    MultiLang1: TMultiLang;
    Button1: TButton;
    Button2: TButton;
    Bevel1: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LangClick(Sender: TObject);
    Procedure Translate(Lang : integer);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

Procedure TForm1.Translate(Lang : integer);
var i,from : integer;
begin
With MultiLang1 Do
 begin
 From:=Language;Language:=Lang;
 TranslateComponent(Form1,True,From);
 TranslateComponent(Form2,True,From);
 for i:=0 to ListView1.Columns.Count-1 do
  Form1.ListView1.Columns.Items[i].Caption:=
   Translate(Form1.ListView1.Columns.Items[i].Caption,From);
 end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
if Form2.ShowModal=MrOK then
 with ListView1.Items.Add do
  begin
  Caption:=Form2.Edit1.Text;
  SubItems.Add(Form2.Edit2.Text);
  SubItems.Add(Form2.Edit3.Text);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
Var i : integer;
begin
with ListView1.Items do
 for i:=0 to Count-1 do
  IF Item[i].selected then Delete(i);
end;

procedure TForm1.FormCreate(Sender: TObject);
var i : integer;
    itm : tmenuitem;
begin
MultiLang1.LoadLanguageList('Demo2.lng');
for i:=0 to Multilang1.LanguageCount-1 do
 begin
 itm:=tmenuitem.create(Language1);
 itm.caption:=MultiLang1.Languages[i];
 itm.OnClick:=LangClick;
 Language1.Add(Itm);
 end;
end;

procedure TForm1.LangClick(Sender: TObject);
begin
Translate(MultiLang1.LanguageByName(StripSymbols(TMenuItem(Sender).Caption)));
end;


procedure TForm1.Exit1Click(Sender: TObject);
begin
Form1.Close;
end;

end.
