unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ImageEnView, ImageEnIO, ComCtrls;

type
  TForm1 = class(TForm)
    ImageEnIO1: TImageEnIO;
    ImageEnView1: TImageEnView;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    GroupBox2: TGroupBox;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    ComboBox2: TComboBox;
    CheckBox2: TCheckBox;
    GroupBox3: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Button1: TButton;
    Button2: TButton;
    ProgressBar1: TProgressBar;
    CheckBox3: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ImageEnIO1Progress(Sender: TObject; per: Integer);
  private
    { Private declarations }
    procedure FillBack;	// copy twain parameters to the controls
    procedure FillIn;	// copy controls to twain parameters
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
var
	i:integer;
begin
	// fills TWain sources
	for i:=0 to ImageEnIO1.TWainParams.SourceCount-1 do
   	ComboBox1.Items.Add( ImageEnIO1.TWainParams.SourceName[i] );
   // Select first scanner
   ComboBox1.ItemIndex:=0;
   ImageEnIO1.TWainParams.SelectedSource:=ComboBox1.ItemIndex;
   FillBack;
end;

// Select scanner
procedure TForm1.ComboBox1Change(Sender: TObject);
begin
	ImageEnIO1.TWainParams.SelectedSource:=ComboBox1.ItemIndex;
   FillBack;
end;

// negotiate parameters (verify that scanner supports Frame rectangle, Dpi...)
procedure TForm1.Button2Click(Sender: TObject);
begin
	FillIn;
   ImageEnIO1.TWainParams.Update;	// verify here...
   FillBack;
end;

// copy twain parameters to the controls
procedure TForm1.FillBack;
const
	COLORS:array [0..2] of string=('Black&White','GrayScale','RGB');
var
	i:integer;
begin
   Edit1.Text:=FloatToStr( ImageEnIO1.TWainParams.YResolution.CurrentValue );
	Edit2.Text:=FloatToStr( ImageEnIO1.TWainParams.XResolution.CurrentValue );
   // Fill Colors (0=B/W 1=GrayScale 2=RGB) combobox
   ComboBox2.Clear;
	for i:=0 to ImageEnIO1.TWainParams.PixelType.Count-1 do
   	ComboBox2.Items.Add( COLORS[ ImageEnIO1.TWainParams.PixelType[i] ] );
   ComboBox2.ItemIndex:=ImageEnIO1.TWainParams.PixelType.IndexOf(ImageEnIO1.TWainParams.PixelType.CurrentValue);
	// frame
	Edit3.Text:=FloatToStr(ImageEnIO1.TWainParams.AcquireFrameLeft);
	Edit4.Text:=FloatToStr(ImageEnIO1.TWainParams.AcquireFrameTop);
   Edit5.Text:=FloatToStr(ImageEnIO1.TWainParams.AcquireFrameRight);
   Edit6.Text:=FloatToStr(ImageEnIO1.TWainParams.AcquireFrameBottom);
end;

// copy controls to twain parameters
procedure TForm1.FillIn;
begin
	ImageEnIO1.TWainParams.VisibleDialog:=CheckBox1.Checked;
   ImageEnIO1.TWainParams.ProgressIndicators:=CheckBox2.Checked;
	ImageEnIO1.TWainParams.AcquireFrameLeft:=StrToFloat( Edit3.Text );
	ImageEnIO1.TWainParams.AcquireFrameTop:=StrToFloat( Edit4.Text );
   ImageEnIO1.TWainParams.AcquireFrameRight:=StrToFloat( Edit5.Text );
   ImageEnIO1.TWainParams.AcquireFrameBottom:=StrToFloat( Edit6.Text );
   ImageEnIO1.TWainParams.PixelType.CurrentValue:=ComboBox2.ItemIndex;
   ImageEnIO1.TWainParams.YResolution.CurrentValue:=StrToInt( edit1.text);
	ImageEnIO1.TWainParams.XResolution.CurrentValue:=StrToInt( edit2.text);
end;

// Acquire
procedure TForm1.Button1Click(Sender: TObject);
begin
	FillIn;
   ImageEnIO1.Acquire;
   ProgressBar1.Position:=0;
end;

// progress
procedure TForm1.ImageEnIO1Progress(Sender: TObject; per: Integer);
begin
	ProgressBar1.Position:=per;
   if CheckBox3.Checked then begin
	   ImageEnView1.Update;
	   application.processmessages;
   end;
end;

end.
