unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  hy3d, hyman3d, ExtCtrls, Buttons, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Hy3DManView1: THy3DManView;
    GroupBox1: TGroupBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Load1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    RadioGroup1: TRadioGroup;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure EnablePolyReduction(en:boolean);
    procedure SetPolyReductionValues;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// Actions
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
	if SpeedButton1.Down then
   	Hy3DManView1.MouseInteract:=hyiTranslateSceneXY;
   if SpeedButton2.Down then
		Hy3DManView1.MouseInteract:=hyiDistanceScene;
   if SpeedButton3.Down then
		Hy3DManView1.MouseInteract:=hyiRotateSceneXY;
   if SpeedButton4.Down then
		Hy3DManView1.MouseInteract:=hyiRotateSceneZ;
   if SpeedButton5.Down then
		Hy3DManView1.MouseInteract:=hyiInsertFixedObject;
   if SpeedButton6.Down then
		Hy3DManView1.MouseInteract:=hyiTranslateObjectXY;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
	// load and adapt 3D object 'markup.3ds'
	Hy3DManView1.LoadMarkupAs3DS('markup.3ds');
   Hy3DManView1.ScaleMarkup(HYTOINSERT,0.00045);
   Hy3DManView1.MarkupColor[HYTOINSERT]:=clGreen;
   // set polygon reduction values
   SetPolyReductionValues;
end;

// Menu load
procedure TForm1.Load1Click(Sender: TObject);
begin
	if OpenDialog1.Execute then
   	Hy3DManView1.LoadFromFile(OpenDialog1.FileName);
end;

// Menu save
procedure TForm1.Save1Click(Sender: TObject);
begin
	if SaveDialog1.Execute then
		Hy3DManView1.SaveToFile(SaveDialog1.FileName);
end;

// Menu exit
procedure TForm1.Exit1Click(Sender: TObject);
begin
	close;
end;

// Enable/disable "Polygon reduction"
procedure TForm1.EnablePolyReduction(en:boolean);
begin
   Edit1.Enabled:=en;
   Edit2.Enabled:=en;
   Label1.Enabled:=en;
   Label2.Enabled:=en;
end;

// type change
procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
	case RadioGroup1.ItemIndex of
   	0:
        	// man
        	Hy3DManView1.ManType:=hymMan;
      1:
        	// woman
        	Hy3DManView1.ManType:=hymWoman;
      2:
      	begin
            // from file
            ShowMessage('Download high resolution model from www.hyrix.com/delphi.htm !');
            if OpenDialog1.Execute then begin
               Hy3DManView1.FileName:=OpenDialog1.FileName;
               Hy3DManView1.ManType:=hymFromFile
            end;
         end;
   end;
   EnablePolyReduction( RadioGroup1.ItemIndex=2 );
end;

// change Static/Moving
procedure TForm1.Edit1Change(Sender: TObject);
begin
	Button1.Enabled:=True;
end;

//
procedure TForm1.SetPolyReductionValues;
begin
   Hy3DManView1.MaxVertices:=StrToIntDef(Edit1.Text,0);
   Hy3DManView1.RunVertices:=StrToIntDef(Edit2.Text,0);
end;

// Set (polygon reduction values)
procedure TForm1.Button1Click(Sender: TObject);
begin
	SetPolyReductionValues;
   Button1.Enabled:=False;
end;

end.
