unit RptMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DBTables, Db, Grids, DBGrids, HTMLConstructorProducer;

type
  TForm1 = class(TForm)
    RadioGroup1: TRadioGroup;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    TableVendors: TTable;
    TableVendorsVendorName: TStringField;
    TableVendorsPhone: TStringField;
    TableVendorsFAX: TStringField;
    Panel1: TPanel;
    DBGridVendors: TDBGrid;
    DataSource1: TDataSource;
    HTMLReportProducer1: THTMLReportProducer;
    procedure FormActivate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation uses HTMLWEBReport;

{$R *.DFM}
const FilesArr: array [0..8] of pchar=
      ('SimpleList.htm',
       'SimpleListGroup.htm',
       'MasterDetail.htm',
       'SeveralGroup.htm',
       'Combine.htm',
       'SimpleTable.htm',
       'SimpleGrid.htm',
       'DefaultDataSource.htm',
       'PivotGrid.htm'
      );

const HintsArr: array [0..8] of pchar=
      ('This customer listing report shows the following basic features:'#13#10+
       '- Connecting a dataset'#13#10+
       '- Use DBD_DATAHEADER to print headers of table fields'#13#10+
       '- Use DBD_DATAFIELD to print table fields'#13#10+
       '- Using autoincrement fields'#13#10+
       ''#13#10+
       'You can also see how to'#13#10+
       '- Use different fonts, sizes and colors'#13#10+
       '- How to align text',

       'This report builds on the Customer listing report and adds grouping of customers by first letter in company name. You can see how to:'#13#10+
       '- Use DBD_DATASET to group records'#13#10,

       'This is a basic master/detail report showing all orders for each customer. It adds the master/detail functionallity to the simple list repor. You can see how to:'#13#10+
       '- Set up the datasets in a master/detail relationship'#13#10+
       '- Use DBD_DATASET and DBD_DATAFIELD to print detail data'#13#10+
       '- Attach a group footer band to a DBD_DATASET'#13#10+
       '- Use DBD_GROUP to calculate totals and count records',

       'This report shows how to create a master/detail report from a TQuery component and use multiple DBD_DATASET in the same report',
       'This example shows how to use the HTML to create a report that uses HREF, MEMO''s and combining several fields into one.',
       'This report shows how to create a report from a TTable/TQuery component at Form',
       'This report shows how to create a autoreport from a TTable/TQuery/TDBGrid component at Form',
       'This report shows how to create a report, that using default DataSource at a Form',
       'This report shows how to create a crosstab report from a dataset'
       );

var ProgramPATH: string;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin FormActivate(nil); end;

procedure TForm1.FormActivate(Sender: TObject);
begin
      Memo1.Text:=HintsArr[RadioGroup1.ItemIndex];
      Edit1.Text:=FilesArr[RadioGroup1.ItemIndex];
      Panel1.Visible:=(RadioGroup1.ItemIndex=6);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin Close; end;

procedure TForm1.Button1Click(Sender: TObject);
begin screen.Cursor:=crHourGlass;
      HTMLReportProducer1.FileName:=ProgramPATH+'Templates\'+Edit1.Text;
      HTMLReportProducer1.Preview;
      screen.Cursor:=crDefault;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin screen.Cursor:=crHourGlass;
      HTMLReportProducer1.FileName:=ProgramPATH+'Templates\'+Edit1.Text;
      HTMLReportProducer1.Print;
      screen.Cursor:=crDefault;
end;

initialization
    ProgramPATH:=ExtractFilePath(paramstr(0));
    if ProgramPATH[length(ProgramPATH)]<>'\' then ProgramPATH:=ProgramPATH+'\';
end.
