unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    EditFilePath: TEdit;
    Button3: TButton;
    Label2: TLabel;
    RadioGroup1: TRadioGroup;
    OpenDialog1: TOpenDialog;
    SpeedButton1: TSpeedButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Images: TTabSheet;
    TreeView1: TTreeView;
    MemoLinks: TMemo;
    MemoImages: TMemo;
    procedure Button3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation uses HTMLConstructor;

{$R *.DFM}

procedure TForm1.Button3Click(Sender: TObject);
  procedure Outer(TTN: TTreeNode; TT: THTMLTag);
  var i: integer; TTC: TTreeNode;
  begin
       for i:=0 to TT.Tags.Count-1 do begin
           with THTMLTag(TT.Tags[i]) do begin
                TTC:=TreeView1.Items.AddChild(TTN, '');;
                if InnerName=''
                   then TTC.Text:=TagString
                   else begin
                        if TagStyle=ts_ClosingTag then TTC.Text:='</'+InnerName+'>'
                           else begin TTC.Text:='<'+InnerName+'>';
                                      if THTMLTag(TT.Tags[i]) is THTMLTAG_A then begin
                                         with THTMLTAG_A(TT.Tags[i]) do
                                              MemoLinks.lines.Add(HREF+'="'+trim(InnerText)+'"');
                                         end;
                                      if THTMLTag(TT.Tags[i]) is THTMLTAG_IMG then begin
                                         with THTMLTAG_IMG(TT.Tags[i]) do
                                              MemoImages.lines.Add(SRC);
                                         end;
                                end;
                        end;
                if TagBlock<>tb_Inline then Outer(TTC, THTMLTag(TT.Tags[i]));
                end;
           end;
  end;
var A: TFileStream; s: string; TTN: TTreeNode;
    HTML: THTMLConstructor; i: integer;
begin screen.cursor:=crHourGlass;

      if RadioGroup1.ItemIndex=0
         then A:=TFileStream.Create(EditFilePath.text, fmOpenRead)
         else A:=TFileStream.Create('Html\'+RadioGroup1.Items[RadioGroup1.ItemIndex], fmOpenRead);
      SetLength(s, A.Size); A.Read(s[1], A.Size); A.Free;

      HTML:=THTMLConstructor.Create;
      HTML.Content:=s;

      TreeView1.Items.Clear;
      TreeView1.Items.BeginUpdate;
      MemoLinks.Clear; MemoImages.Clear;

      for i:=0 to HTML.Tags.Count-1 do begin
          with THTMLTag(HTML.Tags[i]) do begin
               TTN:=TreeView1.Items.Add(nil, '');
               if InnerName=''
                  then TTN.Text:=TagString
                  else begin
                       if TagStyle=ts_ClosingTag then s:='</'+InnerName+'>'
                                                 else s:='<'+InnerName+'>';
                       TTN.Text:=s;
                       end;
               if TagBlock<>tb_Inline then Outer(TTN, THTMLTag(HTML.Tags[i]));
               end;
          end;
      HTML.Free;
      TreeView1.Items.EndUpdate;
      screen.cursor:=crDefault;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
      if OpenDialog1.Execute then EditFilePath.Text:=OpenDialog1.FileName;
end;

end.
