unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Buttons, OleCtrls, HTMLConstructor,
  SHDocVw;

type
  TForm1 = class(TForm)
    EditFilePath: TEdit;
    OpenDialog1: TOpenDialog;
    SpeedButton1: TSpeedButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Images: TTabSheet;
    TreeView1: TTreeView;
    MemoLinks: TMemo;
    MemoImages: TMemo;
    PageControl2: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    MemoSource: TMemo;
    WebBrowser1: TWebBrowser;
    procedure Button3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure EditFilePathKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TreeView1Click(Sender: TObject);
  private
    { Private declarations }
    HTML: THTMLConstructor;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation uses ShellApi;

{$R *.DFM}

// Parsing of HTML file
procedure TForm1.Button3Click(Sender: TObject);
  procedure Outer(TTN: TTreeNode; TT: THTMLTag);
  var i: integer; TTC: TTreeNode;
  begin
       for i:=0 to TT.Tags.Count-1 do begin
           with THTMLTag(TT.Tags[i]) do begin
                TTC:=TreeView1.Items.AddChildObject(TTN, '', TT.Tags[i]);
                if InnerName=''
                   then TTC.Text:=TagString
                   else begin
                        if TagStyle=ts_ClosingTag then TTC.Text:='</'+InnerName+'>'
                           else begin TTC.Text:='<'+InnerName+'>';
                                      if THTMLTag(TT.Tags[i]) is THTMLTAG_A then begin
                                         with THTMLTAG_A(TT.Tags[i]) do
                                              MemoLinks.lines.Add(HREF+'="'+trim(InnerText)+'"');
                                         end;
                                      if THTMLTag(TT.Tags[i]) is THTMLTAG_IMG then begin
                                         with THTMLTAG_IMG(TT.Tags[i]) do
                                              MemoImages.lines.Add(SRC);
                                         end;
                                end;
                        end;
                if TagBlock<>tb_Inline then Outer(TTC, THTMLTag(TT.Tags[i]));
                end;
           end;
  end;
var A: TFileStream; s: string; TTN: TTreeNode;
    i: integer;
begin screen.cursor:=crHourGlass;

      A:=TFileStream.Create(EditFilePath.text, fmOpenRead);
      SetLength(s, A.Size); A.Read(s[1], A.Size); A.Free;

      HTML.Content:=s;

      TreeView1.Items.Clear;
      TreeView1.Items.BeginUpdate;
      MemoLinks.Clear; MemoImages.Clear;

      for i:=0 to HTML.Tags.Count-1 do begin
          with THTMLTag(HTML.Tags[i]) do begin
               TTN:=TreeView1.Items.AddObject(nil, '', HTML.Tags[i]);
               if InnerName=''
                  then TTN.Text:=TagString
                  else begin
                       if TagStyle=ts_ClosingTag then s:='</'+InnerName+'>'
                                                 else s:='<'+InnerName+'>';
                       TTN.Text:=s;
                       end;
               if TagBlock<>tb_Inline then Outer(TTN, THTMLTag(HTML.Tags[i]));
               end;
          end;
      TreeView1.Items.EndUpdate;
      screen.cursor:=crDefault;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var ch: char;
begin ch:=#13;
      if OpenDialog1.Execute then EditFilePath.Text:=OpenDialog1.FileName;
      EditFilePathKeyPress(nil, ch);
end;

procedure TForm1.EditFilePathKeyPress(Sender: TObject; var Key: Char);
begin
      if Key<>#13 then exit;
      if not FileExists(EditFilePath.Text) then begin
         ShowMessage('File not found'); exit;
         end;
      Button3Click(nil);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
      HTML:=THTMLConstructor.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
      HTML.Free;
end;

const TempFile='temp.htm';

// Updating of MEMO content and HTML viewer
procedure TForm1.TreeView1Click(Sender: TObject);
var s, s1: string; A: TFileStream;
begin
      if not Assigned(TreeView1.Selected) then s:=''
         else begin
              if not Assigned(TreeView1.Selected.Data) then s:=''
                 else s:=THTMLTag(TreeView1.Selected.Data).GetContent;
              end;

      Screen.Cursor:=crHourGlass;
      MemoSource.Lines.BeginUpdate;
      MemoSource.Text:=s;
      MemoSource.Lines.EndUpdate;
      Screen.Cursor:=crDefault;

      s1:=ExtractFilePath(ParamStr(0));
      if s1[length(s1)]<>'\' then s1:=s1+'\';

      s1:=s1+TempFile;
      A:=TFileStream.Create(s1, fmCreate);
      A.Write(s[1], length(s)); A.Free;

      s1:=StringReplace(s1, '\', '/', [rfReplaceAll]);
      s1:=StringReplace(s1, ':', '|', [rfReplaceAll]);
      WebBrowser1.Navigate('file://'+s1);
end;

end.
