{*************************************************************************}
{ TAdvStringGrid main demo unit                                           }
{                                                                         }
{ written by TMS Software                                                 }
{            copyright  1996-2001                                        }
{            Email : info@tmssoftware.com                                 }
{            Web : http://www.tmssoftware.com                             }
{                                                                         }
{*************************************************************************}

unit Asgunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, AdvGrid, StdCtrls, Buttons, ExtCtrls,
  Menus, ClipBrd, asabout, ComCtrls,
  AsgFindDialog, asgprev, asgprint,Spin, advsprd, AdvCGrid
  {$IFDEF VER120} ,ImgList {$ENDIF}
  {$IFDEF VER130} ,ImgList {$ENDIF}
  {$IFDEF VER140} ,ImgList {$ENDIF}
  ;

type
  TDemo = class(TForm)
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    Loaddata1: TMenuItem;
    Loadfromfile1: TMenuItem;
    Savetofile1: TMenuItem;
    SavetoHTML1: TMenuItem;
    SavetoCSV1: TMenuItem;
    SaveasXLS1: TMenuItem;
    Clipboard1: TMenuItem;
    Print1: TMenuItem;
    Copytoclipboard2: TMenuItem;
    Pastefromclipboard2: TMenuItem;
    Copyselectiontoclipboard1: TMenuItem;
    Print2: TMenuItem;
    Printpreview1: TMenuItem;
    Setselection1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Pastefromclipboard1: TMenuItem;
    LoadfromCSV1: TMenuItem;
    LoadfromXLS1: TMenuItem;
    Hide1: TMenuItem;
    Column11: TMenuItem;
    Column21: TMenuItem;
    Column31: TMenuItem;
    Column41: TMenuItem;
    Search1: TMenuItem;
    Findfirst1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    AdvStringGrid2: TAdvStringGrid;
    GroupBox3: TGroupBox;
    Label2: TLabel;
    Button3: TButton;
    Button6: TButton;
    RadioGroup1: TRadioGroup;
    fixedsort: TCheckBox;
    multiline: TCheckBox;
    colro: TCheckBox;
    AdvStringGrid1: TAdvStringGrid;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SavetoASCII1: TMenuItem;
    TabSheet3: TTabSheet;
    editgrid: TAdvStringGrid;
    Label6: TLabel;
    Column51: TMenuItem;
    Column61: TMenuItem;
    Column71: TMenuItem;
    ImageList1: TImageList;
    PrintDialog1: TPrintDialog;
    TabSheet4: TTabSheet;
    AdvStringGrid3: TAdvStringGrid;
    SavetoDOC1: TMenuItem;
    Button1: TButton;
    Button2: TButton;
    RadioGroup2: TRadioGroup;
    Exit1: TMenuItem;
    SavetoXML1: TMenuItem;
    colfix: TCheckBox;
    Printpreviewwithgraphics1: TMenuItem;
    Printwithgraphics1: TMenuItem;
    Timer1: TTimer;
    TabSheet5: TTabSheet;
    AdvStringGrid4: TAdvStringGrid;
    Label9: TLabel;
    ComboBox1: TComboBox;
    CheckBox8: TCheckBox;
    ComboBox2: TComboBox;
    Label10: TLabel;
    TabSheet6: TTabSheet;
    AdvStringGrid5: TAdvStringGrid;
    Label11: TLabel;
    Label12: TLabel;
    CheckBox9: TCheckBox;
    TabSheet7: TTabSheet;
    AdvGridPrintSettingsDialog1: TAdvGridPrintSettingsDialog;
    AdvPreviewDialog1: TAdvPreviewDialog;
    AdvGridFindDialog1: TAdvGridFindDialog;
    Printsetup1: TMenuItem;
    TabSheet8: TTabSheet;
    AdvSpreadGrid1: TAdvSpreadGrid;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    NewSheet: TSpeedButton;
    OpenSheet: TSpeedButton;
    SaveSheet: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    CheckBox2: TCheckBox;
    Button4: TButton;
    Button5: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    AdvColumnGrid1: TAdvColumnGrid;
    ColorDialog1: TColorDialog;
    ColumnFont: TSpeedButton;
    ColumnColor: TSpeedButton;
    ColAlign: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton8: TSpeedButton;
    Label7: TLabel;
    ColumnList: TComboBox;
    procedure Button3Click(Sender: TObject);
    procedure AdvStringGrid1GetAlignment(Sender: TObject; ARow,
      ACol: Longint; var AAlignment: TAlignment);
    procedure Button6Click(Sender: TObject);
    procedure AdvStringGrid1GetCellColor(Sender: TObject; ARow,
      ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
    procedure FormCreate(Sender: TObject);
    procedure AdvStringGrid1GridHint(Sender: TObject; Arow, Acol: Longint;
      var hintstr: string);
    procedure Loadfromfile1Click(Sender: TObject);
    procedure Savetofile1Click(Sender: TObject);
    procedure SavetoHTML1Click(Sender: TObject);
    procedure SavetoCSV1Click(Sender: TObject);
    procedure AdvStringGrid1AutoInsertRow(Sender: TObject; ARow: Longint);
    procedure AdvStringGrid1AutoDeleteRow(Sender: TObject; aRow: Longint);
    procedure AdvStringGrid1ClickSort(Sender: TObject; aCol: Longint);
    procedure SaveasXLS1Click(Sender: TObject);
    procedure Copytoclipboard2Click(Sender: TObject);
    procedure Pastefromclipboard2Click(Sender: TObject);
    procedure Print2Click(Sender: TObject);
    procedure Printpreview1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Setselection1Click(Sender: TObject);
    procedure fixedsortClick(Sender: TObject);
    procedure Copyselectiontoclipboard1Click(Sender: TObject);
    procedure Pastefromclipboard1Click(Sender: TObject);
    procedure LoadfromCSV1Click(Sender: TObject);
    procedure LoadfromXLS1Click(Sender: TObject);
    procedure AdvStringGrid1PrintPage(Sender: TObject; Canvas: TCanvas;
      pagenr, pagexsize, pageysize: Integer);
    procedure Column11Click(Sender: TObject);
    procedure Findfirst1Click(Sender: TObject);
    procedure multilineClick(Sender: TObject);
    procedure AdvStringGrid1CanEditCell(Sender: TObject; Arow,
      Acol: Integer; var canedit: Boolean);
    procedure AdvStringGrid2GetAlignment(Sender: TObject; ARow,
      ACol: Integer; var AAlignment: TAlignment);
    procedure SavetoASCII1Click(Sender: TObject);
    procedure editgridGetEditorType(Sender: TObject; aCol, aRow: Integer;
      var aEditor: TEditorType);
    procedure editgridEllipsClick(Sender: TObject; aCol, aRow: Integer;
      var S: String);
    procedure AdvStringGrid1GetFormat(Sender: TObject; ACol: Integer;
      var AStyle: TSortStyle; var aPrefix, aPostfix: String);
    procedure AdvStringGrid1PrintStart(Sender: TObject; NrOfPages: Integer;
      var FromPage, ToPage: Integer);
    procedure SavetoDOC1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SavetoXML1Click(Sender: TObject);
    procedure AdvStringGrid1IsFixedCell(Sender: TObject; Arow,
      Acol: Integer; var isfixed: Boolean);
    procedure colfixClick(Sender: TObject);
    procedure Printpreviewwithgraphics1Click(Sender: TObject);
    procedure Printwithgraphics1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure AdvStringGrid2ButtonClick(Sender: TObject; aCol,
      aRow: Integer);
    procedure CheckBox9Click(Sender: TObject);
    procedure AdvStringGrid5GetFormat(Sender: TObject; ACol: Integer;
      var AStyle: TSortStyle; var aPrefix, aSuffix: String);
    procedure Printsetup1Click(Sender: TObject);
    procedure NewSheetClick(Sender: TObject);
    procedure OpenSheetClick(Sender: TObject);
    procedure SaveSheetClick(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure AdvSpreadGrid1SelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure SpeedButton7Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure AdvSpreadGrid1CellFormat(Sender: TObject; ACol,
      Arow: Integer; var format: String; var datetype: Boolean);
    procedure AdvSpreadGrid1CalcCustomFunction(sender: TObject;
      var func: String; var param: Double);
    procedure AdvSpreadGrid1IsCustomFunction(sender: TObject;
      var func: String; var match: Boolean);
    procedure AdvSpreadGrid1AutoInsertRow(Sender: TObject; ARow: Integer);
    procedure AdvSpreadGrid1AutoDeleteRow(Sender: TObject; ARow: Integer);
    procedure SpeedButton4Click(Sender: TObject);
    procedure ColumnFontClick(Sender: TObject);
    procedure ColumnColorClick(Sender: TObject);
    procedure ColAlignClick(Sender: TObject);
  private
     procedure InitGraphicGrid;
     procedure UpdateStatusBar(ACol,ARow: Integer);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Demo: TDemo;

implementation

uses Uhelp;

{$R *.DFM}
{$R icons.res}     

procedure TDemo.Button3Click(Sender: TObject);
begin
  AdvStringGrid1.AutoSize := True;
end;

procedure TDemo.AdvStringGrid1GetAlignment(Sender: TObject; ARow,
  ACol: Longint; var AAlignment: TAlignment);
begin
  if ACol in [3,4] then
    AAlignment := taRightJustify;
end;

procedure TDemo.Button6Click(Sender: TObject);
begin
  if RadioGroup1.ItemIndex = 0 then
    AdvStringGrid1.SortDirection := sdAscending
  else
    AdvStringGrid1.SortDirection := sdDescending;
  AdvStringGrid1.SortColumn := 1;
  AdvStringGrid1.QSort;
end;

procedure TDemo.AdvStringGrid1GetCellColor(Sender: TObject; ARow,
  ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
begin
  if (ACol = 1) and (ARow > 0) and
     (ARow < AdvStringGrid1.RowCount - AdvStringGrid1.FixedFooters) and
     (not(gdSelected in AState) or (gdFocused in AState)) then
  begin
    ABrush.Color := clYellow;
    AFont.Color := clRed;
  end;

  if ARow = 0 then
  begin
    AFont.Style := [fsBold];
  end;
end;

procedure TDemo.InitGraphicGrid;
begin
  with AdvStringGrid2 do
  begin
    with CreateIcon(1,1,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_1');
    with CreateIcon(1,2,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_2');
    with CreateIcon(1,3,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_3');
    with CreateIcon(1,4,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_4');
    with CreateIcon(1,5,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_5');

    Addrotated(1,0,90,'Icons');

    Cells[1,1]:='cpu';
    Cells[1,2]:='trashcan';
    Cells[1,3]:='icon';
    Cells[1,4]:='floppy';
    Cells[1,5]:='audio';

    Addimageidx(2,1,0,habeforetext,vaCenter);
    Addimageidx(2,2,1,haBeforeText,vaCenter);
    Addimageidx(2,3,2,haBeforeText,vaCenter);
    Addimageidx(2,4,3,haBeforeText,vaCenter);
    Addimageidx(2,5,4,haBeforeText,vaCenter);

    Addrotated(2,0,90,'Imagelist');

    Cells[2,1]:='mail';
    Cells[2,2]:='note';
    Cells[2,3]:='cancel';
    Cells[2,4]:='home';
    Cells[2,5]:='web';

    with CreateBitmap(3,1,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_1');
    with CreateBitmap(3,2,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_2');
    with CreateBitmap(3,3,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_3');
    with CreateBitmap(3,4,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_4');
    with CreateBitmap(3,5,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_5');

    Cells[3,1]:='';
    Cells[3,2]:='';
    Cells[3,3]:='';
    Cells[3,4]:='';
    Cells[3,5]:='';

    Addrotated(3,0,90,'Bitmaps');

    Autonumbercol(0);

    Addrotated(4,0,90,'Text');

    Addrotated(4,1,45,'One');

    Addrotated(4,2,135,'Two');

    Addrotated(4,3,225,'Three');

    Addrotated(4,4,315,'Four');

    Addrotated(4,5,180,'Five');

    Addrotated(5,0,90,'Multi Image');

    Addrotated(6,0,90,'Rich text');

    Addmultiimage(5,1,0,haBeforeText,vaCenter);

    with CellImages [5,1] do
    begin
      Add(0);
      Add(1);
    end;

    Addmultiimage(5,2,0,haBeforeText,vaCenter);

    with CellImages [5,2] do
    begin
      Add(2);
      Add(3);
      Add(4);
    end;

    AddMultiimage(5,3,0,haBeforeText,vaCenter);

    with CellImages [5,3] do
    begin
      Add(0);
    end;

    Addmultiimage(5,4,0,haBeforeText,vaCenter);

    with CellImages [5,4] do
    begin
      Add(1);
      Add(3);
      Add(4);
      Add(2);
    end;

    Addmultiimage(5,5,0,haBeforeText,vaCenter);

    with CellImages [5,5] do
    begin
      Add(4);
      Add(1);
    end;

    RichEdit.text := 'Rich text';
    RichEdit.Selstart := 0;
    RichEdit.Sellength := 4;
    RichEdit.Selattributes.Color:=clRed;
    RichEdit.Selattributes.Style:=[fsBold];
    RichEdit.Selstart:=5;
    RichEdit.Sellength:=4;
    RichEdit.Selattributes.Color:=clBlue;
    RichEdit.Selattributes.Style:=[fsItalic];
    RichToCell(6,1,RichEdit);

    RichEdit.Clear;
    RichEdit.Selattributes.style:=[];
    RichEdit.Selattributes.color:=clBlack;

    RichEdit.text:='Superscript';

    RichEdit.Selstart:=0;
    RichEdit.Sellength:=5;
    RichEdit.Selsuperscript;
    RichEdit.Selattributes.color:=clBlue;

    RichToCell(6,2,RichEdit);

    RichEdit.Clear;
    RichEdit.Selattributes.style:=[];
    RichEdit.Selattributes.color:=clBlack;

    RichEdit.text:='Subscript';
    RichEdit.Selstart:=0;
    RichEdit.Sellength:=3;
    RichEdit.Selsubscript;
    RichEdit.Selattributes.color:=clBlue;

    RichToCell(6,3,RichEdit);

    RichEdit.Clear;
    RichEdit.Selattributes.style:=[];
    RichEdit.Selattributes.color:=clBlack;
    RichEdit.Selnormal;
    RichEdit.paragraph.Numbering := nsBullet;

    RichEdit.lines.add('One'#13'Two'#13'Three');
    RichEdit.paragraph.Numbering := nsNone;

    RichToCell(6,4,RichEdit);

    AddRotated(7,0,90,'HTML');

    Cells[7,1]:='Easy <B>HTML</B><BR><I>formatting</I>';
    Cells[7,2]:='Including <IMG src="idx:0"><FONT color="clred">everywhere</FONT>';
    Cells[7,3]:='Enjoy<HR><B>miniHTML</B>';
    Cells[7,4]:='<A href="http://www.tmssoftware.com/minihtml.htm">Click here</A><BR>for more';
    Cells[7,5]:='125 <SUP>9</SUP>/<SUB>16</SUB>';

    Addrotated(8,0,90,'Various');
    Ints[8,1]:=50;

    AddProgress(8,1,clRed,clSilver);

    Ints[8,2]:=75;

    AddProgressEx(8,2,clBlue,clWhite,clWhite,clRed);

    AddComment(8,3,'This is a custom'#13'comment for this cell');

    Cells[8,3]:='Cell with<BR><I>comment</I>';

    Cells[8,4]:='<A href="CELL://R2C1">Link to cell 1,2</A>';
    Cells[8,5]:='<A href="CELL://R1C2">Link to cell 2,1</A>';

    Ints[6,5]:=1;

    AddButton(6,5,45,20,'Push me',haBeforeText,vaCenter);

   end;
end;

procedure TDemo.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  AdvStringGrid1.Clear;
  AdvStringGrid1.LoadFromFile('test.txt');
  AdvStringGrid3.LoadFromFile('test.txt');
  AdvStringGrid4.LoadFromFile('test.txt');
  AdvStringGrid5.LoadFromFile('test.txt');
  AdvStringGrid5.AutoSizeColumns(false,15);

  AdvStringGrid1.SortColumn :=1;
  Editgrid.Clear;
  Editgrid.loadfromfile('test.txt');

  EditGrid.ClearComboString;
  EditGrid.AddComboString('BMW');
  EditGrid.AddComboString('Mercedes Benz');
  EditGrid.AddComboString('Audi');
  EditGrid.AddComboString('Porsche');
  EditGrid.AddComboString('Ferrari');
  EditGrid.AddComboString('Opel');
  EditGrid.AddComboString('Lamborghini');
  EditGrid.Combobox.Sorted := True;

  InitGraphicGrid;

  for i := 1 to Editgrid.RowCount - 1 do
    EditGrid.AddCheckBox(5,i,False,False);

  EditGrid.DateTimePicker.CalColors.TitlebackColor := clRed;
  EditGrid.DateTimePicker.CalColors.MonthbackColor := clYellow;

  EditGrid.SpinEdit.MinValue := 0;
  EditGrid.SpinEdit.MaxValue := 100;
  EditGrid.SpinEdit.Increment := 2;

  with AdvStringGrid3 do
  begin
    FixedCols := 0;
    FixedColWidth := 20;
    AddNode(2,4);
    AddNode(7,2);
    AddNode(13,4);
  end;

  ComboBox1.Itemindex := 0;
  ComboBox2.Itemindex := 0;

  AdvSpreadGrid1.SaveFixedCells := False;
  AdvSpreadGrid1.LoadFromCSV('spread.csv');

  AdvColumnGrid1.LoadFromFile('test.txt');

  AdvColumnGrid1.Columns.Items[0].Name := '';
  AdvColumnGrid1.Columns.Items[1].Name := 'Car';
  AdvColumnGrid1.Columns.Items[2].Name := 'Type';
  AdvColumnGrid1.Columns.Items[3].Name := 'Cylinders';
  AdvColumnGrid1.Columns.Items[4].Name := 'Intro';
  AdvColumnGrid1.Columns.Items[5].Name := 'Power';
  AdvColumnGrid1.Columns.Items[6].Name := 'Price';
  AdvColumnGrid1.Columns.Items[7].Name := 'Web';

  ColumnList.ItemIndex := 0;
end;

procedure TDemo.AdvStringGrid1GridHint(Sender: TObject; Arow,
  Acol: Longint; var hintstr: string);
begin
  case acol of
  1:hintstr := 'Name of car company';
  2:hintstr := 'Car model';
  3:hintstr := '# of cylinders';
  4:hintstr := 'Year of introduction';
  5:hintstr := 'Engine power';
  6:hintstr := 'Price';
  7:hintstr := 'Website';
  end;
end;

procedure TDemo.Loadfromfile1Click(Sender: TObject);
begin
  AdvStringGrid1.Clear;
  AdvStringGrid1.LoadFromFile('test.txt');
end;

procedure TDemo.Savetofile1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveToFile('test.txt');
end;

procedure TDemo.SavetoHTML1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveToHTML('test.htm');
end;

procedure TDemo.SavetoCSV1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveFixedCells := False;
  AdvStringGrid1.SaveToCSV('test.csv');
end;

procedure TDemo.LoadfromCSV1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveFixedCells := False;
  AdvStringGrid1.LoadFromCSV('test.csv');
end;

procedure TDemo.AdvStringGrid1AutoInsertRow(Sender: TObject;
  ARow: Longint);
begin
  AdvStringGrid1.AutoNumberCol(0);
end;

procedure TDemo.AdvStringGrid1AutoDeleteRow(Sender: TObject;
  aRow: Longint);
begin
  AdvStringGrid1.AutoNumberCol(0);
end;

procedure TDemo.AdvStringGrid1ClickSort(Sender: TObject; aCol: Longint);
begin
  if not AdvStringGrid1.SortFixedCols then
    AdvStringGrid1.AutoNumberCol(0);
end;

procedure TDemo.SaveasXLS1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveToXLS('text.xls');
end;

procedure TDemo.Copytoclipboard2Click(Sender: TObject);
begin
 AdvStringGrid1.copytoclipboard;
end;

procedure TDemo.Copyselectiontoclipboard1Click(Sender: TObject);
begin
  AdvStringGrid1.CopySelectiontoClipboard;
end;

procedure TDemo.Pastefromclipboard2Click(Sender: TObject);
begin
  AdvStringGrid1.PasteSelectionFromClipboard;
end;

procedure TDemo.Pastefromclipboard1Click(Sender: TObject);
begin
  AdvStringGrid1.PasteFromClipboard;
end;

procedure TDemo.Print2Click(Sender: TObject);
begin
  AdvStringGrid1.Print;
end;

procedure TDemo.Printpreview1Click(Sender: TObject);
begin
  AdvPreviewDialog1.Grid := AdvStringGrid1;
  AdvPreviewDialog1.Execute;
end;

procedure TDemo.About1Click(Sender: TObject);
var
  About: TAbout;
begin
  About := TAbout.Create(Self);
  try
    About.ShowModal;
  finally
    About.Free;
  end;
end;

procedure TDemo.Setselection1Click(Sender: TObject);
var
  GridRect: TGridRect;
begin
  GridRect.Left := 1;
  GridRect.Top := 5;
  GridRect.Right := AdvStringGrid1.ColCount - 1;
  GridRect.Bottom := AdvStringGrid1.RowCount - 1;
  AdvStringGrid1.PrintRect(GridRect);
end;

procedure TDemo.fixedsortClick(Sender: TObject);
begin
  AdvStringGrid1.SortFixedCols := FixedSort.Checked;
end;

procedure TDemo.LoadfromXLS1Click(Sender: TObject);
begin
  AdvStringGrid1.LoadFromXLS('test.xls');
end;

procedure TDemo.AdvStringGrid1PrintPage(Sender: TObject; Canvas: TCanvas;
  pagenr, pagexsize, pageysize: Integer);
var
  SaveFont: TFont;
  ts,tw: Integer;

const
  myowntitle: string = 'Your company name can go here using custom drawing';

begin
  if AdvStringGrid1.PrintColStart <> 0 then
    Exit;
  with canvas do
  begin
    Savefont := TFont.create;
    SaveFont.Assign(Font);

    Font.Name := 'Arial';
    Font.Style := [fsBold];
    // Maps font height into current used logical units
    Font.Height := AdvStringGrid1.MapFontHeight(10);
    Font.Color := clRed;

    ts := AdvStringGrid1.PrintColOffset[0];
    tw := AdvStringGrid1.PrintPagewidth;

    MoveTo(ts,-5);
    LineTo(ts+tw,-5);
    Lineto(ts+tw,-AdvStringGrid1.printsettings.headersize+5);
    LineTo(ts,-AdvStringGrid1.printsettings.headersize+5);
    LineTo(ts,-5);

    ts := ts+ ((tw-textwidth(myowntitle)) shr 1);

    TextOut(ts,-10,myowntitle);

    Font.Assign(SaveFont);
    SaveFont.Free;
  end;
end;

procedure TDemo.Column11Click(Sender: TObject);
var
  ACol: Integer;
begin
  PageControl1.ActivePage := Tabsheet1;

  ACol := (Sender as TMenuItem).Tag;
  with AdvStringGrid1 do
  begin
    if IsHiddenColumn(ACol) then
      UnHideColumn(ACol)
    else
      HideColumn(ACol);

    (Sender as TMenuItem).Checked := IsHiddenColumn(ACol);
  end;
end;

procedure TDemo.Findfirst1Click(Sender: TObject);
begin
  PageControl1.ActivePage := Tabsheet1;
  AdvGridFindDialog1.Execute;
end;

procedure TDemo.multilineClick(Sender: TObject);
begin
  if multiline.checked then
    AdvStringGrid1.DefaultRowHeight := 28
  else
    AdvStringGrid1.DefaultRowHeight := 16;

  AdvStringGrid1.MultiLineCells := MultiLine.Checked;
end;

procedure TDemo.AdvStringGrid1CanEditCell(Sender: TObject; Arow,
  Acol: Integer; var canedit: Boolean);
begin
  Canedit := (acol <> 3) or (colro.Checked = False);
end;

procedure TDemo.AdvStringGrid2GetAlignment(Sender: TObject; ARow,
  ACol: Integer; var AAlignment: TAlignment);
begin
  if (acol<4) and (acol<>2) then Aalignment := taCenter;
  if (arow=0) then Aalignment := taCenter;
end;


procedure TDemo.SavetoASCII1Click(Sender: TObject);
begin
  AdvStringGrid1.SaveToASCII('test.asc');
end;

procedure TDemo.editgridGetEditorType(Sender: TObject; ACol, ARow: Integer;
  var AEditor: TEditorType);
begin
  case ACol of
  1:AEditor := edComboList;
  2:AEditor := edEditBtn;
  3:AEditor := edSpinEdit;
  4:AEditor := edDateEdit;
  end;
end;

procedure TDemo.editgridEllipsClick(Sender: TObject; ACol, ARow: Integer;
  var S: String);
var
  tmp:string;
begin
  tmp := s;
  if InputQuery('Edit ('+IntToStr(aCol)+':'+IntToStr(aRow)+')','Cell value',tmp) then
    s:=tmp;
end;



procedure TDemo.AdvStringGrid1GetFormat(Sender: TObject; ACol: Integer;
  var AStyle: TSortStyle; var aPrefix, aPostfix: String);
begin
  case ACol of
  2:AStyle := ssAlphabetic;
  3:AStyle := ssNumeric;
  4:AStyle := ssDate;
  5:begin
      AStyle := ssNumeric;
      APostfix := 'pk';
    end;
  6:begin
      AStyle := ssFinancial;
      APrefix := '$ ';
    end;
  end;
end;

procedure TDemo.AdvStringGrid1PrintStart(Sender: TObject;
  NrOfPages: Integer; var FromPage, ToPage: Integer);
begin
  PrintDialog1.FromPage := Frompage;
  PrintDialog1.ToPage :=  ToPage;
  PrintDialog1.Maxpage := ToPage;
  PrintDialog1.Minpage := 1;

  if PrintDialog1.Execute then
  begin
    FromPage := PrintDialog1.FromPage;
    ToPage := PrintDialog1.ToPage;
  end
  else
  begin
    FromPage := 0;
    ToPage := 0;
  end;
end;

procedure TDemo.SavetoDOC1Click(Sender: TObject);
begin
 AdvStringGrid1.SavetoDOC('test.doc');
end;

procedure TDemo.Button1Click(Sender: TObject);
begin
 AdvStringGrid3.expandall;
end;

procedure TDemo.Button2Click(Sender: TObject);
begin
  AdvStringGrid3.contractall;
end;

procedure TDemo.RadioGroup2Click(Sender: TObject);
begin
  case Radiogroup2.Itemindex of
  0:AdvStringGrid3.Cellnode.NodeType := cnFlat;
  1:AdvStringGrid3.Cellnode.NodeType := cn3D;
  2:AdvStringGrid3.Cellnode.NodeType := cnGlyph;
  end;
end;

procedure TDemo.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TDemo.SavetoXML1Click(Sender: TObject);
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  sl.Add('Nr');
  sl.Add('Car');
  sl.Add('Type');
  sl.Add('Cylinders');
  sl.Add('Intro');
  sl.Add('Power');
  sl.Add('Price');
  sl.Add('Web');
  AdvStringGrid1.SaveToXML('test.xml','CARLIST','CAR',sl);
  sl.Free;
end;

procedure TDemo.AdvStringGrid1IsFixedCell(Sender: TObject; Arow,
  Acol: Integer; var isfixed: Boolean);
begin
  isfixed := colfix.Checked and (acol = 3);
end;

procedure TDemo.colfixClick(Sender: TObject);
begin
  AdvStringGrid1.Col := 1;
  AdvStringGrid1.Row := 1;
  ColRo.Checked := True;
  AdvStringGrid1.Repaint;
end;

procedure TDemo.Printpreviewwithgraphics1Click(Sender: TObject);
begin
  AdvPreviewDialog1.Grid := AdvStringGrid2;
  AdvPreviewDialog1.Execute;
end;

procedure TDemo.Printwithgraphics1Click(Sender: TObject);
begin
  AdvStringGrid2.Print;
end;

procedure TDemo.Timer1Timer(Sender: TObject);
begin
  AdvStringGrid2.Ints[8,1] := random(100);
  AdvStringGrid2.Ints[8,2] := random(100);
end;

procedure TDemo.CheckBox8Click(Sender: TObject);
begin
  AdvStringGrid4.Filter.Clear;
  with AdvStringGrid4.Filter.Add do
  begin
    Condition := ComboBox1.Items[ComboBox1.ItemIndex];
    Column := 1;
  end;
  with AdvStringGrid4.Filter.Add do
  begin
    Condition := ComboBox2.Items[ComboBox2.ItemIndex];
    Column := 3;
  end;

  AdvStringGrid4.FilterActive := Checkbox8.Checked;
end;

procedure TDemo.AdvStringGrid2ButtonClick(Sender: TObject; aCol,
  aRow: Integer);
begin
  with AdvStringGrid2 do
    Ints[6,5] := Ints[6,5] + 1;
end;

procedure TDemo.CheckBox9Click(Sender: TObject);
begin
  AdvStringGrid1.URLFull := CheckBox9.checked;
end;

procedure TDemo.AdvStringGrid5GetFormat(Sender: TObject; ACol: Integer;
  var AStyle: TSortStyle; var aPrefix, aSuffix: String);
begin
  {make sure some model nummers with numeric only data do not confuse the
   automatic format detection}
  if acol = 2 then
    AStyle := ssAlphabetic
  else
    AStyle := ssAutomatic;
end;

procedure TDemo.Printsetup1Click(Sender: TObject);
begin
  AdvGridPrintSettingsDialog1.Execute;
end;

procedure TDemo.NewSheetClick(Sender: TObject);
begin
  AdvSpreadGrid1.ClearNormalCells;
end;

procedure TDemo.OpenSheetClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  with AdvSpreadGrid1 do
  begin
    ClearNormalCells;
    AutoRecalc := False;
    SaveFixedCells := False;
    LoadFromCSV(OpenDialog1.FileName);
    AutoRecalc := True;
    ReCalc;
  end;
end;

procedure TDemo.SaveSheetClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    AdvSpreadGrid1.SaveToCSV(SaveDialog1.FileName);
end;

procedure TDemo.UpdateStatusBar(ACol,ARow: Integer);
begin
  with Advspreadgrid1 do
  begin
    StatusBar1.Panels[0].Text := CellToName(ACol,ARow);
    if CellName[ACol,ARow] <> '' then
      Statusbar1.Panels[0].Text := StatusBar1.Panels[0].Text+' ['+CellName[ACol,ARow]+']';
  end;
end;


procedure TDemo.SpeedButton6Click(Sender: TObject);
var
  s: string;
begin
  with AdvSpreadGrid1 do
  begin
    s := CellName[Col,Row];
    if Inputquery('Cell name','Name:',s) then
    begin
      CellName[Col,Row]:=s;
      UpdateStatusbar(Col,Row);
    end;
  end;
end;

procedure TDemo.AdvSpreadGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  CanSelect := True;
  UpdateStatusbar(ACol,ARow);
end;

procedure TDemo.SpeedButton7Click(Sender: TObject);
var
  i: Integer;
  gr: TGridRect;
begin
  with AdvSpreadGrid1 do
  for i := Selection.Left to Selection.Right do
  begin
    gr := Selection;
    gr.left := i;
    gr.right := i;
    Cells[i,Selection.Bottom + 1] := '=SUM('+RangeToName(gr)+')';
    ReCalc;
  end;
end;

procedure TDemo.CheckBox1Click(Sender: TObject);
begin
  AdvSpreadGrid1.ShowFormula := Checkbox1.Checked;
end;

procedure TDemo.SpinEdit1Change(Sender: TObject);
begin
  AdvSpreadGrid1.CellFormat := '%.'+IntToStr(SpinEdit1.Value) + 'f';
end;

procedure TDemo.CheckBox2Click(Sender: TObject);
begin
  if Checkbox2.Checked then
    AdvSpreadGrid1.CellNameMode := nmRC
  else
    AdvSpreadGrid1.CellNameMode := nmA1;
end;

procedure TDemo.Button5Click(Sender: TObject);
begin
  CheckBox2.Checked := True;
  with AdvSpreadGrid1 do
  begin
    ClearNormalCells;
    CellNameMode := nmRC;

    Cells[1,1] := 'Price';
    Cells[1,2] := 'Tax';

    Cells[2,1] := '100';
    Cells[2,2] := '15';

    Cellname[2,1] := 'PRICE';
    Cellname[2,2] := 'TAX';

    Cells[2,3] := '=PRICE+(PRICE*TAX/100)';

    Cells[3,1] := '100';
    Cells[3,2] := '15';

    Cells[3,3] := '=R1C3+(R1C3*R2C3/100)';

    ReCalc;
  end;
end;

procedure TDemo.Button4Click(Sender: TObject);
var
  i,c:integer;

begin
  c := 20;
  CheckBox2.Checked := True;

  with AdvSpreadGrid1 do
  begin
    ClearNormalCells;
    CellNameMode := nmRC;
    for i := 1 to c do
    begin
      Ints[1,i] := i;
      Cells[2,i] := '=SUM(R' + IntToStr(i) + 'C1:R' + IntToStr(c)+'C1)';
      Cells[3,i] := '=AVERAGE(R' + IntToStr(i) + 'C1:R' + IntToStr(c)+'C1)';
      Cells[4,i] := '=MIN(R' + IntToStr(i) + 'C1:R' + IntToStr(c)+'C1)';
      Cells[5,i] := '=MAX(R' + IntToStr(i) + 'C1:R' + IntToStr(c)+'C1)';
      Cells[6,i] := '=STDEV(R' + IntToStr(i) + 'C1:R' + IntToStr(c)+'C1)';
    end;
    InsertRows(1,1);
    Cells[2,1]:='SUM';
    Cells[3,1]:='AVERAGE';
    Cells[4,1]:='MIN';
    Cells[5,1]:='MAX';
    Cells[6,1]:='STDEV';
    ReCalc;
  end;
end;

procedure TDemo.AdvSpreadGrid1CellFormat(Sender: TObject; ACol,
  Arow: Integer; var format: String; var datetype: Boolean);
begin
  DateType := ACol = 7;
  if DateType then
    Format := 'ddd dd/mm/yyyy';
end;

procedure TDemo.AdvSpreadGrid1CalcCustomFunction(sender: TObject;
  var func: String; var param: Double);
begin
 if func = 'BFS' then Param := Param * 2;
 if func = 'SELECT' then Param := 125;
end;

procedure TDemo.AdvSpreadGrid1IsCustomFunction(sender: TObject;
  var func: String; var match: Boolean);
begin
  match := Pos('BFS',func) = 1;
  if match then
    func := 'BFS'
  else
  begin
    match := Pos('SELECT',func) = 1;
    if match then
      func := 'SELECT';
  end;
end;

procedure TDemo.AdvSpreadGrid1AutoInsertRow(Sender: TObject;
  ARow: Integer);
begin
  AdvSpreadGrid1.AutoSpreadHeaders;
end;

procedure TDemo.AdvSpreadGrid1AutoDeleteRow(Sender: TObject;
  ARow: Integer);
begin
  AdvSpreadGrid1.AutoSpreadHeaders;
end;

procedure TDemo.SpeedButton4Click(Sender: TObject);
begin
  Help.Show;
end;

procedure TDemo.ColumnFontClick(Sender: TObject);
var
  col: TGridColumnItem;
begin
  col := AdvColumnGrid1.ColumnByName[ColumnList.Items[ColumnList.ItemIndex]];

  if not Assigned(Col) then
    Exit;

  FontDialog1.Font.Assign(Col.Font);

  if FontDialog1.Execute then
    Col.Font.Assign(FontDialog1.Font);


end;

procedure TDemo.ColumnColorClick(Sender: TObject);
var
  col: TGridColumnItem;
begin
  col := AdvColumnGrid1.ColumnByName[ColumnList.Items[ColumnList.ItemIndex]];

  if not Assigned(Col) then
    Exit;

  ColorDialog1.Color := Col.Color;
  if ColorDialog1.Execute then
    Col.Color := ColorDialog1.Color;

end;

procedure TDemo.ColAlignClick(Sender: TObject);
var
  col: TGridColumnItem;
begin
  col := AdvColumnGrid1.ColumnByName[ColumnList.Items[ColumnList.ItemIndex]];

  if not Assigned(Col) then
    Exit;

  case (Sender as TSpeedButton).Tag of
  0:Col.Alignment := taLeftJustify;
  1:Col.Alignment := taCenter;
  2:Col.Alignment := taRightJustify;
  end;

end;

end.
