{                                                                              }
{ Conditional defines defined here:                                            }
{   DELPHI       - Delphi compiler.                                            }
{     DELPHI5    - Delphi 5.                                                   }
{     DELPHI6    - Delphi 6.                                                   }
{     DELPHI5_UP - Delphi 5 or later.                                          }
{     DELPHI6_UP - Delphi 6 or later.                                          }
{   OS_UNIX      - Unix type operating system.                                 }
{     OS_LINUX   - Linux operating system.                                     }
{   OS_MSWIN     - MS Windows type operating system.                           }
{     OS_WIN32   - Win32 operating system.                                     }
{   CPU_INTEL386 - Intel 386 compatible CPU.                                   }
{   WINTEL       - OS_WIN32 and CPU_INTEL386.                                  }
{   LINTEL       - OS_LINUX and CPU_INTEL386.                                  }
{   USE_DEBUG    - Units use cDebug.                                           }
{                                                                              }



{                                                                              }
{ Delphi 5                                                                     }
{                                                                              }
{$IFDEF VER130}
  {$DEFINE DELPHI}
  {$DEFINE DELPHI5}
  {$DEFINE DELPHI5_UP}
  {$DEFINE OS_WIN32}
{$ENDIF}



{                                                                              }
{ Delphi 6                                                                     }
{                                                                              }
{$IFDEF VER140}
  {$DEFINE DELPHI}
  {$DEFINE DELPHI6}
  {$DEFINE DELPHI6_UP}
  {$IFDEF LINUX}
    {$DEFINE OS_LINUX}
  {$ENDIF}
  {$IFDEF WIN32}
    {$DEFINE OS_WIN32}
  {$ENDIF}
{$ENDIF}



{                                                                              }
{ CPU Type                                                                     }
{                                                                              }
{$IFDEF DELPHI}
  {$IFDEF CPU386}
    {$DEFINE CPU_INTEL386}
  {$ENDIF}
{$ENDIF}



{                                                                              }
{ Operating system type                                                        }
{                                                                              }
{$IFDEF OS_WIN32}
  {$DEFINE OS_MSWIN}
{$ENDIF}
{$IFDEF OS_LINUX}
  {$DEFINE OS_UNIX}
{$ENDIF}



{                                                                              }
{ OS / CPU combination                                                         }
{                                                                              }
{$IFDEF CPU_INTEL386}
  {$IFDEF OS_MSWIN}
    {$DEFINE WINTEL}
  {$ENDIF}
  {$IFDEF OS_LINUX}
    {$DEFINE LINTEL}
  {$ENDIF}
{$ENDIF}



{                                                                              }
{ Standard compiler directives                                                 }
{                                                                              }
{$IFDEF DELPHI}
  {$DESCRIPTION 'Delphi Fundamentals'}
  {$EXTENDEDSYNTAX ON}
  {$IOCHECKS ON}
  {$LONGSTRINGS ON}
  {$BOOLEVAL OFF}
  {$OPTIMIZATION ON}
  {$IFDEF DEBUG}
    {$ASSERTIONS ON}
    {$DEBUGINFO ON}
    {$OVERFLOWCHECKS ON}
    {$RANGECHECKS ON}
    {$WARNINGS ON}
    {$HINTS ON}
  {$ELSE}
    {$ASSERTIONS OFF}
    {$DEBUGINFO OFF}
    {$OVERFLOWCHECKS OFF}
    {$RANGECHECKS OFF}
    {$WARNINGS OFF}
    {$HINTS OFF}
  {$ENDIF}
{$ENDIF}
