unit fMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, cUtils, cStrings, cDateTime, cReaders,
  cHTMLConsts, cHTMLUtils, cHTMLLexer, cHTMLDocBase, cHTMLDocElements,
  cHTMLDoc, cHTMLParser;

type
  TForm1 = class(TForm)
    bParse: TButton;
    memoOutput: TMemo;
    bLex: TButton;
    elHTMLParser: TelHTMLParser;
    memoSource: TMemo;
    bLoad: TButton;
    OpenDialog: TOpenDialog;
    elHTMLLexer: TelHTMLLexicalParser;
    procedure bParseClick(Sender: TObject);
    procedure bLexClick(Sender: TObject);
    procedure bLoadClick(Sender: TObject);
    procedure elHTMLLexerToken(Parser: TelHTMLLexicalParser;
      TokenType: ThtmlTokenType);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.bLoadClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    memoSource.Text := ReadFileToStr(OpenDialog.FileName);
end;

procedure TForm1.bLexClick(Sender: TObject);
var J : THPTimer;
    E : Extended;
    T : String;
begin
  T := memoSource.Text;
  elHTMLLexer.Text := T;

  // calculate lexing speed
  J := StartTimer;
  elHTMLLexer.Reset;
  elHTMLLexer.Options := elHTMLLexer.Options + [loDisableNotifications];
  Repeat
    elHTMLLexer.GetNextToken;
  Until elHTMLLexer.TokenType = htEOF;
  E := MillisecondsElapsed(J);
  memoOutput.Lines.Add('');
  memoOutput.Lines.Add(IntToStr(elHTMLLexer.TokenCount) + ' tokens');
  memoOutput.Lines.Add(IntToStr(Length(T)) + ' bytes');
  memoOutput.Lines.Add(FloatToStr(Round(E * 10) / 10.0) + 'ms');
  if E >= 2.0 then
    begin
      memoOutput.Lines.Add(IntToStr(Round((Length(T) / 1024.0 * 1000.0) / E)) + ' K/s');
      memoOutput.Lines.Add(IntToStr(Round((elHTMLLexer.TokenCount * 1000.0) / E)) + ' tokens/s');
    end;

  // do lexing with notifications
  elHTMLLexer.Reset;
  elHTMLLexer.Options := elHTMLLexer.Options - [loDisableNotifications];
  Repeat
    elHTMLLexer.GetNextToken;
  Until elHTMLLexer.TokenType = htEOF;
end;

procedure TForm1.elHTMLLexerToken(Parser: TelHTMLLexicalParser;
  TokenType: ThtmlTokenType);
begin
  // output lexer token
  memoOutput.Lines.Add(PadRight(
               'TOKEN:' +
               IntToStr(Ord(TokenType)) + ':' +
               Parser.TokenTypeIDStr,
               ' ', 30) +
               StrHexEscape(CopyLeftEllipsed(Parser.TokenStr, 32),
                            [#0..#31], '#$', '', True, True));
end;

procedure TForm1.bParseClick(Sender: TObject);
var J : THPTimer;
    T : String;
    E : Extended;
begin
  T := memoSource.Text;
  elHTMLParser.Text := T;

  // calculate parsing speed
  elHTMLParser.Options := elHTMLParser.Options + [poDisableNotifications,
      poDontProduceDocument];
  J := StartTimer;
  elHTMLParser.ParseDocument;
  E := MillisecondsElapsed(J);
  memoOutput.Lines.Add('');
  memoOutput.Lines.Add(IntToStr(Length(T)) + ' bytes');
  memoOutput.Lines.Add(FloatToStr(Round(E * 10) / 10.0) + 'ms');
  if E >= 2.0 then
    memoOutput.Lines.Add(IntToStr(Round((Length(T) / 1024.0 * 1000.0) / E)) + ' K/s');

  // parse document
  elHTMLParser.Options := elHTMLParser.Options - [poDisableNotifications,
      poDontProduceDocument];
  elHTMLParser.ParseDocument;

  // output structure
  memoOutput.Lines.Add('');
  memoOutput.Lines.Add('Structure:');
  memoOutput.Lines.Add(elHTMLParser.Document.GetStructureStr(0));
end;

end.

