unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EkRtf, Db, Grids, DBGrids, ekfunc, ekbasereport;

type
  TMainForm = class(TForm)
    CustInvRtf: TEkRtf;
    InvRtf: TEkRtf;
    CustBtn: TButton;
    InvBtn: TButton;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button2: TButton;
    Button3: TButton;
    Label5: TLabel;
    VenBtn: TButton;
    Button4: TButton;
    VenRtf: TEkRtf;
    Label6: TLabel;
    InvScanBtn: TButton;
    Button5: TButton;
    InvScan: TEkRTF;
    Label7: TLabel;
    Label8: TLabel;
    StRtf: TEkRTF;
    StBtn: TButton;
    Button6: TButton;
    Button1: TButton;
    InvFn: TEkUDFList;
    Label2: TLabel;
    procedure CustBtnClick(Sender: TObject);
    procedure InvBtnClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure VenBtnClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CustInvRtfScanBefore(ScanInfo: TEkScanInfo);
    procedure CustInvRtfScanEof(ScanInfo: TEkScanInfo);
    procedure CustInvRtfScanRecord(ScanInfo: TEkScanInfo);
    procedure InvScanBtnClick(Sender: TObject);
    procedure InvScanScanBefore(ScanInfo: TEkScanInfo);
    procedure InvScanScanEof(ScanInfo: TEkScanInfo);
    procedure InvScanScanRecord(ScanInfo: TEkScanInfo);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure StBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure InvFnFunctions0Calculate(Sender: TObject; Args: TEkUDFArgs;
      ArgCount: Integer; UDFResult: TObject);
    procedure Label2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses Unit2, UCustSel, UGauge, URedit, DlgInfU, ShellAPI;

{$R *.DFM}

procedure TMainForm.CustBtnClick(Sender: TObject);
begin
  with DM do
  begin
    CustInvRtf.OutFile:=CustInvRtf.CreateFileName(ExtractFilePath(Paramstr(0)),'cu');
    CustSel.DSCust.DataSet:=CustByLastInvQuery;
    CustByLastInvQuery.Open;
       if CustSel.showmodal=mrOk then
       begin
          application.processmessages;
          if CustSel.CustGrid.SelectedRows.Count>0 then
             //Execute report
             CustInvRtf.ExecuteOpen([CustByLastInvQuery],SW_SHOW)
                         else showmessage('Customers not selected.');
       end;//if
    CustByLastInvQuery.Close;
  end;
end;

procedure TMainForm.CustInvRtfScanBefore(ScanInfo: TEkScanInfo);
begin
   With ScanInfo do
   begin
      if Number=1 then  //if first scan in the report
      begin
         //Use Rows selected for the report in the grid
         UseSelectedRows:=true;
         SelectedRows:=CustSel.CustGrid.SelectedRows;
         FGauge.Bar.Max:=SelectedRows.count;
         FGauge.Bar.Position:=0;
         FGauge.Bar.Step:=1;
         FGauge.Show;
      end;
   end;//with
end;

procedure TMainForm.CustInvRtfScanRecord(ScanInfo: TEkScanInfo);
begin
   With ScanInfo do
   begin
      if Number=1 then  //if first scan in the report
      begin
         FGauge.Bar.StepIt;
         application.ProcessMessages;
      end;
   end;//with
end;

procedure TMainForm.CustInvRtfScanEof(ScanInfo: TEkScanInfo);
begin
  //if first scan in the report
   application.ProcessMessages;
   With ScanInfo do if Number=1 then FGauge.Close;
end;

procedure TMainForm.InvBtnClick(Sender: TObject);
var custno:integer;
begin
if DlgInv.ShowModal=mrOk then
     begin
     DM.items.Filter:='OrderNo='+DM.Orders.FieldByName('OrderNo').AsString;
     DM.items.filtered:=true;

     custno:=Dm.orders.fieldbyname('custno').AsInteger;
     Dm.cust.Locate('CustNo',custno,[]);
     InvRtf.OutFile:=InvRtf.CreateFileName(ExtractFilePath(Paramstr(0)),'in');

     //Add variable to varlist
     InvRtf.ClearVars;
     InvRtf.CreateVar('Freight',Dm.Orders.FieldByName('Freight').AsFloat);

     //Generate report
     InvRtf.ExecuteOpen([DM.Cust,DM.Orders,DM.Items], SW_SHOW);
     end;
end;

procedure TMainForm.InvFnFunctions0Calculate(Sender: TObject;
  Args: TEkUDFArgs; ArgCount: Integer; UDFResult: TObject);
begin
  //InvRTF - MyTotal code **************************

 With UDFResult As TEkReportVariable do begin
  AsFloat:=TEkReportVariable(Args[0]).AsFloat+
           TEkReportVariable(Args[1]).AsFloat;
 end;//with
end;


procedure TMainForm.Button2Click(Sender: TObject);
begin
 CustInvRtf.ShellOpenFile('CustList.doc',SW_SHOW);
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
 InvRtf.ShellOpenFile('InvRpt.doc',SW_SHOW);
end;

procedure TMainForm.VenBtnClick(Sender: TObject);
begin
    VenRtf.OutFile:=VenRtf.CreateFileName(ExtractFilePath(Paramstr(0)),'vn');
    VenRTF.ExecuteOpen([DM.Vendor],SW_SHOW);
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
 VenRtf.ShellOpenFile('vendor.doc',SW_SHOW);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  if not FileExists(ExtractFilePath(Paramstr(0))+'\vendor.rtf') then
         showmessage('Some of Input files not found!. Place your compiled exe file into project source directory.');
end;


procedure TMainForm.InvScanBtnClick(Sender: TObject);
begin
  with DM do
  begin
    InvScan.OutFile:=InvScan.CreateFileName(ExtractFilePath(Paramstr(0)),'in');
    CustSel.DSCust.DataSet:=CustByCompany;
    CustByCompany.Open;
       if CustSel.showmodal=mrOk then
       begin
          application.processmessages;
          if CustSel.CustGrid.SelectedRows.Count>0 then
             //Execute report
             begin
             InvScan.VarList.Clear;
               try
               InvScan.ExecuteOpen([DM.CustByCompany, DM.Orders, DM.items],SW_SHOW);
               finally
               FGauge.Close;
               end;
             end  else showmessage('Customers not selected.');
       end;//if
    CustByCompany.Close;
  end;
end;

procedure TMainForm.InvScanScanBefore(ScanInfo: TEkScanInfo);
begin
   With ScanInfo do
   begin
      case Number of
      1: // scan(a)
      begin
         //Use Rows selected for the report in the grid
         UseSelectedRows:=true;
         SelectedRows:=CustSel.CustGrid.SelectedRows;
         FGauge.Bar.Max:=SelectedRows.count;
         FGauge.Bar.Position:=0;
         FGauge.Bar.Step:=1;
         FGauge.Show;
      end;

      end; //case
   end;//with

end;

procedure TMainForm.InvScanScanRecord(ScanInfo: TEkScanInfo);
begin
   With ScanInfo do
   begin
      case Number of
      1:  // scan(a) - customers
      begin
         DM.Orders.Filter:='CustNo='+DM.CustByCompany.FieldbyName('CustNo').AsString;
         DM.Orders.Filtered:=true;
         FGauge.Bar.StepIt;
         application.ProcessMessages;
      end;
      2: // scan(orders) record
        begin
          DM.items.Filter:='OrderNo='+DM.Orders.FieldByName('OrderNo').AsString;
          DM.items.filtered:=true;
        end;
      end;//case
   end;//with

end;

procedure TMainForm.InvScanScanEof(ScanInfo: TEkScanInfo);
begin
  //if first scan in the report
   application.ProcessMessages;
   With ScanInfo do
    case Number of
    1:  //scan(a) eof
     begin
      DM.orders.filtered:=false;
      DM.orders.filter:='';
      DM.items.Filtered:=false;
      DM.items.filter:='';
     end;

    end;//case
end;


procedure TMainForm.Button5Click(Sender: TObject);
begin
 InvScan.ShellOpenFile('Inv_scan.doc',SW_SHOW);
end;

procedure TMainForm.Button6Click(Sender: TObject);
begin
 StRtf.ShellOpenFile('stream.doc',SW_SHOW);
end;

procedure TMainForm.StBtnClick(Sender: TObject);
var S:TMemoryStream;
begin
  S:=TMemoryStream.create;
  StRTF.ExecuteStream([DM.Vendor],S);
  FRedit.REdit.Lines.LoadFromStream(s);
  S.Free;
  FRedit.show;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
Close;
end;

procedure TMainForm.Label2Click(Sender: TObject);
begin
  if StRtf.ShellOpenFile('http://ekrtf.code.net.ru/help/albumframe.html',SW_SHOW)<33 then
   showmessage('Sorry, can''t open http://ekrtf.code.net.ru/help/albumframe.html in your browser.');
end;

end.
