unit DlgConnectEditor;

interface
   
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Mask, ExtCtrls, DDB, DMaster, DUtils; 

type
  TConnectEditor = class(TForm)
    btnCancel: TBitBtn;
    btnOk: TBitBtn;
    dlgOpen: TOpenDialog;
    Panel1: TPanel;
    rbSystem: TRadioButton;
    rbFile: TRadioButton;
    rbServer: TRadioButton;
    cbxSystem: TComboBox;
    cbxDriver: TComboBox;
    edFile: TEdit;
    btnFile: TBitBtn;
    edServer: TEdit;
    Label1: TLabel;
    edDatabase: TEdit;
    Panel2: TPanel;
    Label4: TLabel;
    edUser: TEdit;
    edPswd: TEdit;
    Label5: TLabel;
    cbxProvider: TComboBox;
    Label2: TLabel;
    chkSecurity: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FileClick(Sender: TObject);
    procedure SystemClick(Sender: TObject);
    procedure FileDSNClick(Sender: TObject);
    procedure ServerClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EnableOk(Sender: TObject);
    procedure SecurityClick(Sender: TObject);
  private
    { Private declarations }
    FConnect    : String;
    FOdbcFilter : TOdbcDialogFilter;
    FProvider   : TStrings;
    FTableName  : String;

    procedure SetProvider(Value: TStrings);
    function GetConnect: String;
    function FileFilter(const Driver: String): String;
    procedure AdjustEnabled;
    function IsSingleTable(const Driver: String): Boolean;

  public
    { Public declarations }

    property Connection : String            read GetConnect  write FConnect;
    property OdbcFilter : TOdbcDialogFilter read FOdbcFilter write FOdbcFilter;
    property Provider   : TStrings          read FProvider   write SetProvider;
    property TableName  : String            read FTableName;

  end;

var
  ConnectEditor: TConnectEditor;

implementation

{$R *.DFM}


procedure TConnectEditor.SetProvider(Value: TStrings);
begin
     FProvider.Assign(Value);
end;


procedure TConnectEditor.FormShow(Sender: TObject);
var
   iMode : Byte;
   sTmp  : String;
begin
     iMode := 0;
     edUser.Text := GetADOPart(FConnect, cnsADOUsername);
     edPswd.Text := GetADOPart(FConnect, cnsADOPassword);
     cbxProvider.ItemIndex := FProvider.IndexOf(GetADOPart(FConnect, cnsADOProvider));
     if cbxProvider.ItemIndex = -1 then cbxProvider.ItemIndex := 0;
     if GetADOPart(FConnect, cnsADOSystemDSN) <> '' then iMode := 1;
     if GetADOPart(FConnect, cnsADODriver) <> ''    then iMode := 2;
     if GetADOPart(FConnect, cnsADOServer) <> ''    then iMode := 3;
     chkSecurity.Checked := (GetADOPart(FConnect, cnsADOSecurity) = cnsDefSecurity) or
                            (GetADOPart(FConnect, cnsADOTrustNT)  = cnsDefTrustNT);
     case iMode of
          1 :
          begin
               cbxSystem.ItemIndex := cbxSystem.Items.IndexOf(GetADOPart(FConnect, cnsADOSystemDSN));
               rbSystem.Checked    := True;
          end;
          2 :
          begin
               sTmp := GetADOPart(FConnect, cnsADODriver);
               sTmp := StrTran(sTmp, '{');
               sTmp := StrTran(sTmp, '}');
               cbxDriver.ItemIndex := cbxDriver.Items.IndexOf(sTmp);
               edFile.Text         := GetADOPart(FConnect, cnsADOFileDSN);
               rbFile.Checked      := True;
          end;
          3 :
          begin
               edServer.Text       := GetADOPart(FConnect, cnsADOServer);
               edDatabase.Text     := GetADOPart(FConnect, cnsADODatabase);
               rbServer.Checked    := True;
          end;
     end;
end;


function TConnectEditor.GetConnect: String;
begin
     FConnect := '';
     FConnect := SetADOPart(FConnect, cnsADOProvider, FProvider.Strings[cbxProvider.ItemIndex]);
     if rbSystem.Checked then
     begin
          FConnect := SetADOPart(FConnect, cnsADOSystemDSN, cbxSystem.Text);
     end;
     if rbFile.Checked then
     begin
          FConnect := SetADOPart(FConnect, cnsADODriver, '{' + cbxDriver.Text + '}');
          FConnect := SetADOPart(FConnect, cnsADOFileDSN, edFile.Text);
     end;
     if rbServer.Checked then
     begin
          FConnect := SetADOPart(FConnect, cnsADOServer, edServer.Text);
          FConnect := SetADOPart(FConnect, cnsADODatabase, edDatabase.Text);
     end;
     // User + Password
     if not chkSecurity.Checked then
     begin
          if (edUser.Text <> '') then FConnect := SetADOPart(FConnect, cnsADOUsername, edUser.Text);
          if (edPswd.Text <> '') then FConnect := SetADOPart(FConnect, cnsADOPassword, edPswd.Text);
     end
     else FConnect := SetADOPart(FConnect, cnsADOSecurity, cnsDefSecurity);
     Result := FConnect;
end;


procedure TConnectEditor.FileClick(Sender: TObject);
begin
     dlgOpen.Filter     := FileFilter(cbxDriver.Text);
     dlgOpen.InitialDir := ExtractFileDir(edFile.Text);
     if dlgOpen.InitialDir = '' then dlgOpen.InitialDir := 'C:\';
     if dlgOpen.Execute then
     begin
          if IsSingleTable(cbxDriver.Text) then
          begin
               edFile.Text := ExtractFileDir(dlgOpen.FileName);
               FTableName  := ExtractName(dlgOpen.FileName);
          end
          else
          begin
               edFile.Text := dlgOpen.FileName;
               FTableName  := '';
          end;
     end;
end;


function TConnectEditor.FileFilter(const Driver: String): String;
begin
     Result := '';
     if (Driver <> '') and Assigned(OdbcFilter) then Result := OdbcFilter(Driver);
     if Result = '' then Result := 'All Files (*.*)  |*.*';
end;


procedure TConnectEditor.SystemClick(Sender: TObject);
begin
     if rbSystem.Checked then
     begin
          rbFile.Checked   := False;
          rbServer.Checked := False;
     end;
     AdjustEnabled;
end;


procedure TConnectEditor.FileDSNClick(Sender: TObject);
begin
     if rbFile.Checked then
     begin
          rbSystem.Checked := False;
          rbServer.Checked := False;
     end;
     AdjustEnabled;
end;


procedure TConnectEditor.ServerClick(Sender: TObject);
begin
     if rbServer.Checked then
     begin
          rbSystem.Checked := False;
          rbFile.Checked   := False;
     end;
     AdjustEnabled;
end;


procedure TConnectEditor.AdjustEnabled;
begin
     cbxSystem.Enabled := rbSystem.Checked;
     if rbSystem.Checked then cbxSystem.Color := clWindow else cbxSystem.Color := clInfoBk;

     cbxDriver.Enabled := rbFile.Checked;
     edFile.Enabled    := rbFile.Checked;
     btnFile.Enabled   := rbFile.Checked;
     if rbFile.Checked then cbxDriver.Color := clWindow else cbxDriver.Color := clInfoBk;
     if rbFile.Checked then edFile.Color := clWindow else edFile.Color := clInfoBk;

     edServer.Enabled   := rbServer.Checked;
     edDatabase.Enabled := rbServer.Checked;
     if rbServer.Checked then edServer.Color   := clWindow else edServer.Color := clInfoBk;
     if rbServer.Checked then edDatabase.Color := clWindow else edDatabase.Color := clInfoBk;
     if edUser.Enabled   then edUser.Color     := clWindow else edUser.Color := clInfoBk;
     if edPswd.Enabled   then edPswd.Color     := clWindow else edPswd.Color := clInfoBk;
end;


procedure TConnectEditor.FormCreate(Sender: TObject);
begin
     FProvider := TStringList.Create;
end;


procedure TConnectEditor.FormDestroy(Sender: TObject);
begin
     FProvider.Free;
     FProvider := nil;
end;


function TConnectEditor.IsSingleTable(const Driver: String): Boolean;
var
   sTmp : String;
begin
     Result := False;
     if Driver <> '' then
     begin
          sTmp := AnsiUpperCase(Driver);
          Result := (IsSub('DBASE'  , sTmp) or
                     IsSub('FOXPRO' , sTmp) or
                     IsSub('PARADOX', sTmp) or
                     IsSub('TEXT'   , sTmp) or
                     IsSub('VISUAL FOXPRO', sTmp));
     end;
end;


procedure TConnectEditor.EnableOk(Sender: TObject);
var
   bOk : Boolean;
begin
     bOk := (rbSystem.Checked and (cbxSystem.Text <> ''));
     if not bOk then bOk := (rbFile.Checked and
                            (cbxDriver.Text <> '') and
                            (edFile.Text <> ''));
     if not bOk then bOk := (rbServer.Checked and
                            (edServer.Text <> '') and
                            (edDatabase.Text <> ''));
     if btnOk.Enabled <> bOk then btnOk.Enabled := bOk;
end;


procedure TConnectEditor.SecurityClick(Sender: TObject);
begin
     if chkSecurity.Checked then
     begin
          cbxProvider.ItemIndex := FProvider.IndexOf(cnsDefOleDB);
          if cbxProvider.ItemIndex < 0 then cbxProvider.ItemIndex := 0;
     end;
     edUser.Enabled := not chkSecurity.Checked;
     edPswd.Enabled := not chkSecurity.Checked;
     AdjustEnabled;
     EnableOk(nil);
end;


end.
