unit Resize;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls;

type
  TResizeDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    tHeight: TEdit;
    Label3: TLabel;
    tWidth: TEdit;
    Label2: TLabel;
    minWidth: TEdit;
    minHeight: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    btnShrink: TButton;
    procedure btnShrinkClick(Sender: TObject);
    procedure tWidthKeyPress(Sender: TObject; var Key: Char);
    procedure tHeightKeyPress(Sender: TObject; var Key: Char);
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ResizeDlg: TResizeDlg;

implementation

{$R *.dfm}

procedure TResizeDlg.tWidthKeyPress(Sender: TObject; var Key: Char);
begin
  Case Key of
  '0'..'9',#13,#8:;
  else Key:=#0;
  end;
end;

procedure TResizeDlg.tHeightKeyPress(Sender: TObject; var Key: Char);
begin
  Case Key of
  '0'..'9',#13,#8:;
  else Key:=#0;
  end;
end;

procedure TResizeDlg.CancelBtnClick(Sender: TObject);
begin
  //restore original values and exit (based on button return code)
end;

procedure TResizeDlg.OKBtnClick(Sender: TObject);
begin
  //Accept new values and exit (based on button return code)
end;

procedure TResizeDlg.FormShow(Sender: TObject);
begin
  tWidth.SetFocus;
end;

procedure TResizeDlg.btnShrinkClick(Sender: TObject);
begin
  tWidth.Text := minWidth.Text;
  tHeight.Text := minHeight.Text;
end;

end.
