unit LogicWindow;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, ImgList, StdActns,
  ActnList, ToolWin, DateUtils, Spin, Printers,
  Globals, LogicBinaryOp, LogicUnaryOp, LogicConnect, gcMultiPolyline,
  LogicMultiOp
  ;

const
  Vers = '2.28';
  VerDate = '12 Jul 2005';

type
  TLogicForm = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ActionList1: TActionList;
    SheetNew: TAction;
    FileOpen1: TAction;
    FileSave1: TAction;
    FileSaveAs1: TAction;
    FileExit1: TAction;
    HelpAbout: TAction;
    StatusBar: TStatusBar;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    FileExitItem: TMenuItem;
    Help1: TMenuItem;
    HelpAboutItem: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    PageControl1: TPageControl;
    LogicAddAnd: TAction;
    LogicAddDelay: TAction;
    LogicAddInput: TAction;
    LogicAddLine: TAction;
    LogicAddNot: TAction;
    LogicAddOneShot: TAction;
    LogicAddOr: TAction;
    LogicAddPushBtn: TAction;
    LogicAddSetReset: TAction;
    ToolButton10: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton17: TToolButton;
    ToolButton19: TToolButton;
    ToolButton20: TToolButton;
    ToolButton21: TToolButton;
    ToolButton22: TToolButton;
    ToolButton25: TToolButton;
    SheetEditCaption: TAction;
    ToolButton11: TToolButton;
    SheetRename: TAction;
    Sheet1: TMenuItem;
    Rename1: TMenuItem;
    Logic1: TMenuItem;
    LogicAddInput1: TMenuItem;
    LogicAddAnd1: TMenuItem;
    LogicAddOr1: TMenuItem;
    LogicAddSetReset1: TMenuItem;
    Save1: TMenuItem;
    LogicAddDelay1: TMenuItem;
    LogicAddLine1: TMenuItem;
    N3: TMenuItem;
    LogicAddPushBtn1: TMenuItem;
    LogicAddNot1: TMenuItem;
    SheetDelete: TAction;
    Copy2: TMenuItem;
    PopupMenu1: TPopupMenu;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    LogicEditCaption1: TMenuItem;
    LogicAddConnSource: TAction;
    LogicAddConnSink: TAction;
    N4: TMenuItem;
    LogicAddConnSource1: TMenuItem;
    LogicAddConnSink1: TMenuItem;
    HelpShow: TAction;
    HelpShow1: TMenuItem;
    SheetResize: TAction;
    ToolButton5: TToolButton;
    FileLogicMode: TAction;
    FileLogicModeItem: TMenuItem;
    ToolButton6: TToolButton;
    HelpInspectObjects: TAction;
    FilePrint: TAction;
    N8: TMenuItem;
    Print1: TMenuItem;
    PrintDialog1: TPrintDialog;
    Resize1: TMenuItem;
    LogicAddAnyM: TAction;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton12: TToolButton;
    VotingMooNanyMinputs1: TMenuItem;
    FileNew: TAction;
    ToolButton18: TToolButton;
    FileNew1: TMenuItem;
    LogicAddMemo: TAction;
    ToolButton23: TToolButton;
    procedure LogicAddMemoExecute(Sender: TObject);
    procedure FileNewExecute(Sender: TObject);
    procedure SheetNewExecute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileSaveAs1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure HelpAboutExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LogicAddAndExecute(Sender: TObject);
    procedure LogicAddDelayExecute(Sender: TObject);
    procedure LogicAddInputExecute(Sender: TObject);
    procedure LogicAddLineExecute(Sender: TObject);
    procedure LogicAddNotExecute(Sender: TObject);
    procedure LogicAddOneShotExecute(Sender: TObject);
    procedure LogicAddOrExecute(Sender: TObject);
    procedure LogicAddPushBtnExecute(Sender: TObject);
    procedure LogicAddSetResetExecute(Sender: TObject);
    procedure SheetEditCaptionExecute(Sender: TObject);
    procedure SheetRenameExecute(Sender: TObject);
    procedure SheetDeleteExecute(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure LogicAddConnSinkExecute(Sender: TObject);
    procedure LogicAddConnSourceExecute(Sender: TObject);
    procedure HelpShowExecute(Sender: TObject);
    procedure FileLogicModeExecute(Sender: TObject);
    procedure HelpInspectObjectsExecute(Sender: TObject);
    procedure FilePrintExecute(Sender: TObject);
    procedure SheetResizeExecute(Sender: TObject);
    procedure LogicAddAnyMExecute(Sender: TObject);
  private
    FFileName: String;
    FLogicMode :TLogicMode;
    FLogicAutoFit : TLogicAutoFit;
    function  GetLogicParent:TWinControl;
    procedure ReadBLDfromStream(Sender: TObject);
    procedure RestoreObjects;
    procedure RestorePageControl1(Sender: TObject); //v2.28
    procedure SetLogicMode(Value: TLogicMode);
    procedure WriteBLDtoStream;
  public
    { Public declarations }
    property  LogicMode:TLogicMode read FLogicMode write SetLogicMode;
  published
  end;

var
  LogicForm: TLogicForm;
  LogicLine1 : TLogicLine;
  LogicNot : TLogicNot;
  LogicAnd : TLogicAnd;
  LogicMultiAnd : TLogicMultiAnd;
  LogicMultiAnyM : TLogicMultiMooN;
  LogicInput : TLogicInput;
  LogicOr : TLogicOr;
  LogicMultiOr : TLogicMultiOr;
  LogicSetReset : TLogicSetReset;
  LogicDelay: TLogicDelay;
  LogicOneShot: TLogicOneShot;
  LogicCount: TLogicTitle;
  ActiveTabSheet: TTabSheet;
  LogicSink: TLogicConnSink;
  LogicSource: TLogicConnSource;
  MultiPolyline: TgcMultiPolyline;
  ActiveScrollBox: TScrollBox;
  ActivePanel: TPanel;
  LogicDescription: TLogicDescription;

implementation

uses
  SysUtils, Mapi, Math, about, SHFolder, LogicHelpText, LogicOI, Resize;

{$R *.dfm}

const
  AllowMyDocsFlag = false;

resourcestring
  SUntitled  = 'Untitled.txt';
  SOverwrite = 'OK to overwrite %s';
  SSendError = 'Error sending mail';
  SDelete = 'OK to delete sheet %s';

function DefaultSaveLocation(AllowMyDocs:Boolean): string;
var
  P: PChar;
begin
  {
    returns the location of 'My Documents' if it exists, otherwise it returns
    the current directory.
  }
  if AllowMyDocs then
  begin
    P := nil;
    try
      P := AllocMem(MAX_PATH);
      if SHGetFolderPath(0, CSIDL_PERSONAL, 0, 0, P) = S_OK then
        Result := P
      else
        Result := GetCurrentDir;
    finally
      FreeMem(P);
    end;
  end
  else
    Result := GetCurrentDir;
end;

procedure TLogicForm.SheetNewExecute(Sender: TObject);
begin
  ActiveTabSheet := TTabSheet.Create(PageControl1);
  with ActiveTabSheet do
  begin
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'TabSheet'+IntToStr(LogicCount.Count);
    PageControl := PageControl1;
    Caption := 'New';
    PageControl1.ActivePageIndex := PageControl1.PageCount-1;
    ActiveScrollBox := TScrollBox.Create(PageControl1);
    With ActiveScrollBox do
    begin
      Parent := PageControl1.ActivePage;
      LogicCount.Count:=LogicCount.Count+1;
      Name := 'ScrollBox'+IntToStr(LogicCount.Count);
      Align := alClient;
      HorzScrollBar.Tracking := True;
      HorzScrollBar.Smooth := True;
      VertScrollBar.Tracking := True;
      VertScrollBar.Smooth := True;
      Color := clWhite;
    end;
    ActivePanel := TPanel.Create(PageControl1);
    with ActivePanel do
    begin
      Parent := ActiveScrollBox;
      LogicCount.Count := LogicCount.Count+1;
      Name := 'LogicPanel'+IntToStr(LogicCount.Count);
      Caption := '';
      Align := alNone;
      Color := clWhite;
      Left:= 0;
      Top := 0;
      Width := 2500;
      Height:=  1900;
      Anchors := [akLeft,akTop];
      PopupMenu := PopupMenu1;
      FullRepaint := true;
      BevelInner := bvNone;
      BevelOuter := bvNone;
      BevelWidth := 1;
      BorderStyle := bsNone;
      BorderWidth := 0;
    end;
    MultiPolyline := TgcMultiPolyline.Create(PageControl1);
    with MultiPolyline do
    begin
      Parent := ActivePanel;
      LogicCount.Count:=LogicCount.Count+1;
      Name := 'MultiPolyline'+IntToStr(LogicCount.Count);
      Align := alClient;
    end;
  end;
  PageControl1Change(Sender);
end;

procedure TLogicForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    FFileName := OpenDialog.FileName;
    OpenDialog.InitialDir := ExtractFilePath(FFileName);
    StatusBar.Panels[1].Text := ExtractFileName(FFileName);
    ReadBLDfromStream(Sender);
  end;
end;

procedure TLogicForm.FileSave1Execute(Sender: TObject);
begin
  if (FFileName = SUntitled) or (FFileName = '') then
    FileSaveAs1Execute(Sender)
  else
  begin
    WriteBLDtoStream;
  end;
end;

procedure TLogicForm.FileSaveAs1Execute(Sender: TObject);
begin
  with SaveDialog do
  begin
    FileName := FFileName;
    if Execute then
    begin
      FFileName := FileName;
      StatusBar.Panels[1].Text := ExtractFileName(FFileName);
      WriteBLDtoStream;
    end;
  end;
end;

procedure TLogicForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TLogicForm.HelpAboutExecute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TLogicForm.FormCreate(Sender: TObject);
begin
  Randomize;
  FFileName := SUntitled;
  FLogicMode := lmDesign;
  FLogicAutoFit := afFixed;
  StatusBar.Panels[1].Text := ExtractFileName(FFileName);

  OpenDialog.InitialDir := DefaultSaveLocation(AllowMyDocsFlag);
  SaveDialog.InitialDir := OpenDialog.InitialDir;
  Mouse.DragImmediate := false;
  Mouse.DragThreshold := 5;

  {Create streamable object that holds BLD title and count of logic elements}
  //Created at run time, re-parented in FormShow
  LogicCount := nil;
  LogicCount := TLogicTitle.Create(PageControl1);
  LogicCount.Parent := PageControl1;   //temporary parent til FormShow
  LogicCount.Name := 'LogicCounter';
  LogicCount.Caption := 'New Binary Logic Diagram';
  LogicCount.Count := 0;
  LogicCount.Version := Vers;

  Application.ShowHint := True;
end;

procedure TLogicForm.FormShow(Sender: TObject);
var
  i : integer;
begin
  AboutBox.Version.Caption := 'Version: '+Vers;
  AboutBox.VersDate.Caption := 'Date: ' + VerDate;
  for i := PageControl1.PageCount-1 downto 0 do //v2.28
    PageControl1.Pages[i].Free;
  SheetNew.Execute;
  PageControl1.ActivePage.Caption := 'Main';
  LogicCount.Parent := GetLogicParent;
  PageControl1Change(Sender);
end;

procedure TLogicForm.WriteBLDtoStream;
var
 MyIn, MyOut : TFileStream;
 MyFile : TFileName;
 MyPath : string;
begin
  MyPath := ExtractFilePath(FFileName);
  MyFile := MyPath+'\SavedLogic.bld';

  MyIn := nil;
  MyOut := nil;
  WriteComponentResFile(MyFile, PageControl1);

  //save in readable text form
  try
  MyIn := TFileStream.Create(MyFile,fmOpenRead);
  MyOut := TFileStream.Create(FFileName,fmCreate);
  ObjectResourceToText(MyIn, MyOut);
  finally
  MyIn.Free;
  MyOut.Free;
  end;
end;

procedure TLogicForm.ReadBLDfromStream(Sender: TObject); //v2.28
var
  MyIn, MyOut : TFileStream;
  FileType : string;
  TempFile : TFileName;
  ConversionFailed : boolean;
begin
{V2.28 Revamped this routine to handle exceptions, restoring startup condition if
 the input file is corrupt or doesn't contain binary logic.}
  FileType := ExtractFileExt(FFileName);
  TempFile := OpenDialog.InitialDir+'\SavedLogicTemp.bld';
  MyIn := nil;
  MyOut := nil;

  FreeAndNil(PageControl1);
  PageControl1 := TPageControl.Create(LogicForm);
  PageControl1.Name := 'PageControl1';
  PageControl1.Align := alClient;
  PageControl1.Anchors := [akLeft,akTop,akRight,akBottom];
  PageControl1.Parent := LogicForm;
  Application.ProcessMessages;

  ConversionFailed := false;
  if FileType = '.txt' then
  begin
    try
      MyIn := TFileStream.Create(FFileName,fmOpenRead);
      MyOut := TFileStream.Create(TempFile,fmCreate);
      try   //V2.28 restructured try...except...end;
        ObjectTextToResource(MyIn, MyOut);
      except
        on E: Exception do
          begin
          MessageDlg('Error reading logic file: ' + E.Message, mtError,
            [mbAbort], E.HelpContext);
          ConversionFailed := true;
          end;
      end;
    finally
      MyIn.Free;
      MyOut.Free;
    end;
    try
      try
        if not ConversionFailed then
        begin
          {According to the literature (e.g. Delphi Docs and 'Delphi Component
           Design' by Danny Thorpe, the code below should work.  But it doesn't
           and results in a component load error that indicates the problem is
           lack of a Parent for child components.
           I surmise that ReadComponentResFile expects you to load a Form, not
           a TWinControl that owns TControls.  I concluded this because there is
           no Parent or Owner references in the stream file.  Maybe that is
           why the routines will overwrite properties of an existing component,
           letting you stream persistent objects anywhere in your hierarchy.
          //FreeAndNil(PageControl1);
          //PageControl1 := ReadComponentResFile(TempFile, nil) as TPageControl;
          //PageControl1.Owner := LogicForm;
          //PageControl1.Parent := LogicForm;
          }
          ReadComponentResFile(TempFile, PageControl1);
        end;
      except
        on E: Exception do
          begin
          MessageDlg('Error reading binary logic file: ' + E.Message, mtError,
            [mbAbort], E.HelpContext);
          ConversionFailed := true;
          end;
      end;
    finally
      DeleteFile(TempFile);
      if ConversionFailed then RestorePageControl1(Sender);
    end;
  end
  else
  begin
    try
    ReadComponentResFile(FFileName, PageControl1);
    except
      on E: Exception do
        begin
        MessageDlg(E.Message,mtError,[mbAbort],E.HelpContext);
        RestorePageControl1(Sender);
        end;
    end;
  end;
  if not ConversionFailed then RestoreObjects;
end;

procedure TLogicForm.RestorePageControl1(Sender: TObject);  //v2.28
var
  i : integer;
begin
  FFileName := SUntitled;
  FreeAndNil(PageControl1);
  PageControl1 := TPageControl.Create(LogicForm);
  PageControl1.Name := 'PageControl1';
  PageControl1.Align := alClient;
  PageControl1.Anchors := [akLeft,akTop,akRight,akBottom];
  PageControl1.Parent := LogicForm;
  {Create TLogicTitle now to hold BLD title and count of logic elements,
   so SheetNew can use it to number components.  Re-parent it later.}
  LogicCount := TLogicTitle.Create(PageControl1);
  LogicCount.Parent := PageControl1;   //temporary parent til SheetNew.Execute
  LogicCount.Name := 'LogicCounter';
  LogicCount.Caption := 'New Binary Logic Diagram';
  LogicCount.Count := 0;
  LogicCount.Version := Vers;

  for i := PageControl1.PageCount-1 downto 0 do
    PageControl1.Pages[i].Free;
  SheetNew.Execute;
  PageControl1.ActivePage.Caption := 'Main';
  LogicCount.Parent := GetLogicParent;  //Returns ActivePanel
  PageControl1Change(Sender);

end;

//Why isn't all this handled by the stream reader?
procedure TLogicForm.RestoreObjects;
var
  i : integer;
begin
  if (PageControl1.PageCount > 0) and (PageControl1.ActivePageIndex = -1)then
    PageControl1.ActivePageIndex := 0;
  PageControl1.OnChange := PageControl1Change;
  PageControl1Change(Self);

  LogicCount := nil;
  for i:=0 to PageControl1.ComponentCount-1 do
    if PageControl1.Components[i] is TLogicTitle then
      begin
      LogicCount := TLogicTitle(PageControl1.Components[i]);
      break;
      end;
  if LogicCount = nil then ShowMessage('LogicCounter not restored.');
end;

function TLogicForm.GetLogicParent:TWinControl;
begin
  Result := ActivePanel;
end;

procedure TLogicForm.LogicAddAndExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicMultiAnd := TLogicMultiAnd.Create(PageControl1);
  with LogicMultiAnd do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicMultiAnd' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicMultiAnd;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddDelayExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicDelay := TLogicDelay.Create(PageControl1);
  with LogicDelay do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicDelay' + IntToStr(LogicCount.Count);
    DelayType := dtOn;
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicDelay;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddInputExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicInput := TLogicInput.Create(PageControl1);
  with LogicInput do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicInput' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicInput;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddLineExecute(Sender: TObject);
var
  MyLeft, MyTop : integer;
begin
    MyLeft := 50 + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    MyTop  := 50 + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
  LogicLine1 := MultiPolyline.ArrayToNewPolyline([point(MyLeft,MyTop),
    point(50+MyLeft,MyTop)]);
  LogicCount.Count:=LogicCount.Count+1;
  LogicLine1.Name := 'LogicLine' + IntToStr(LogicCount.Count);
end;

procedure TLogicForm.LogicAddNotExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicNot := TLogicNot.Create(PageControl1);
  with LogicNot do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicNot' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicNot;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddOneShotExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicOneShot := TLogicOneShot.Create(PageControl1);
  with LogicOneShot do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicOneShot' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicOneShot;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddOrExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicMultiOr := TLogicMultiOr.Create(PageControl1);
  with LogicMultiOr do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicMultiOr' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicMultiOr;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.LogicAddPushBtnExecute(Sender: TObject);
begin
  LogicAddInput.Execute;
  with LogicInput do
  begin
    Name := 'LogicPB' + IntToStr(LogicCount.Count);
    OneShot := True;
    Invalidate;
  end;
end;

procedure TLogicForm.LogicAddSetResetExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicSetReset := TLogicSetReset.Create(PageControl1);
  with LogicSetReset do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicSetReset' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicSetReset;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.SheetEditCaptionExecute(Sender: TObject);
Var
  MyPos : TPoint;
begin
    LogicCount.BringToFront;
    MyPos := LogicCount.ClientToScreen(Point(0,LogicCount.Height));
    LogicCount.PopupMenu.Popup(MyPos.X,MyPos.Y);
end;

procedure TLogicForm.SheetRenameExecute(Sender: TObject);
var
  MyTabSheet : TTabSheet;
begin
  MyTabSheet := PageControl1.ActivePage;
  MyTabSheet.Caption := EditControlDescription(MyTabSheet,MyTabSheet.Caption);
end;

procedure TLogicForm.SheetDeleteExecute(Sender: TObject);
var
  i : integer;
begin
  i := PageControl1.ActivePageIndex;
  if MessageDlg(Format(SDelete, [PageControl1.ActivePage.Caption]),
    mtConfirmation, mbYesNoCancel, 0) = idYes then
    if (i = 0) and (PageControl1.PageCount = 1) then
      begin
      PageControl1.Pages[0].Free;
      SheetNew.Execute;
      ActiveTabSheet.Caption := 'Main';
      LogicCount.Parent := GetLogicParent;
      end
    else if i > 0 then
      begin
      PageControl1.Pages[i].Free;
      i := i - 1;
      PageControl1.ActivePageIndex := i;
      PageControl1Change(Sender);
      end;
end;

procedure TLogicForm.PageControl1Change(Sender: TObject);
var
  i,n : integer;
  j,k : integer;
begin
  if PageControl1.ActivePageIndex = 0 then
    SheetEditCaption.Enabled := true
  else
    SheetEditCaption.Enabled := false;
  if (PageControl1.PageCount < 2) or (PageControl1.ActivePageIndex = 0) then
    SheetDelete.Enabled := false
  else
    SheetDelete.Enabled := true;
  ActiveScrollBox := nil;
  ActivePanel := nil;
  n := PageControl1.ActivePage.ControlCount;
  for i := 0 to n-1 do
    if PageControl1.ActivePage.Controls[i] is TScrollBox then
      begin
      ActiveScrollBox := TScrollBox(PageControl1.ActivePage.Controls[i]);
      for j := 0 to ActiveScrollBox.ControlCount-1 do 
        if ActiveScrollBox.Controls[j] is TPanel then
          begin
          ActivePanel := TPanel(ActiveScrollBox.Controls[i]);
          for k := 0 to ActivePanel.ControlCount-1 do
            if ActivePanel.Controls[j] is TgcMultiPolyline then
              MultiPolyline := TgcMultiPolyline(ActivePanel.Controls[i]);
          end;
      end;
end;

procedure TLogicForm.LogicAddConnSinkExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicSink := TLogicConnSink.Create(PageControl1);
  with LogicSink do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicSink' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicSink;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;


procedure TLogicForm.LogicAddConnSourceExecute(Sender: TObject);
begin
  LogicSource := TLogicConnSource.Create(PageControl1);
  with LogicSource do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicSource' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    Invalidate;
  end;
end;

procedure TLogicForm.HelpShowExecute(Sender: TObject);
begin
  HelpText.Show;
end;

procedure TLogicForm.SetLogicMode(Value: TLogicMode);
var
  i : integer;
  lmDesigning : boolean;
  AComp : TComponent;
begin
  if FLogicMode <> Value then
  begin
    FLogicMode := Value;
    for i := 0 to PageControl1.ComponentCount-1 do
      begin
      AComp := PageControl1.Components[i];
      if (AComp is TgcMultiPolyLine) then
        TgcMultiPolyLine(AComp).LogicMode := FLogicMode
      else if (AComp is TLogicUnaryOp) then
        TLogicUnaryOp(AComp).LogicMode := FLogicMode
      else if (AComp is TLogicBinaryOp) then
        TLogicBinaryOp(AComp).LogicMode := FLogicMode
      else if (AComp is TLogicMultiOp) then
        TLogicMultiOp(AComp).LogicMode := FLogicMode
      else if (AComp is TLogicConnect) then
        TLogicConnect(AComp).LogicMode := FLogicMode
      end;
    If FLogicMode = lmDesign then
    begin
      lmDesigning := true;
      FileLogicMode.Caption := 'Design';
      FileLogicModeItem.Caption := 'Design';
      ToolButton5.Hint := 'Press to Design logic';
    end else begin
      lmDesigning := false;
      FileLogicMode.Caption := 'Run';
      FileLogicModeItem.Caption := 'Run';
      ToolButton5.Hint := 'Press to Run logic';
    end;

    //Synchronize menus to LogicMode
    FileOpen1.Enabled := lmDesigning;
    FileSave1.Enabled := lmDesigning;
    FileSaveAs1.Enabled := lmDesigning;
    FileExit1.Enabled := lmDesigning;
    FilePrint.Enabled := lmDesigning;
    FileNew.Enabled := lmDesigning;
    LogicAddAnd.Enabled := lmDesigning;
    LogicAddDelay.Enabled := lmDesigning;
    LogicAddInput.Enabled := lmDesigning;
    LogicAddLine.Enabled := lmDesigning;
    LogicAddNot.Enabled := lmDesigning;
    LogicAddOneShot.Enabled := lmDesigning;
    LogicAddOr.Enabled := lmDesigning;
    LogicAddPushBtn.Enabled := lmDesigning;
    LogicAddSetReset.Enabled := lmDesigning;
    LogicAddConnSource.Enabled := lmDesigning;
    LogicAddConnSink.Enabled := lmDesigning;
    LogicAddAnyM.Enabled := lmDesigning;
    LogicAddMemo.Enabled := lmDesigning;
    SheetNew.Enabled := lmDesigning;
    SheetEditCaption.Enabled := lmDesigning;
    SheetRename.Enabled := lmDesigning;
    SheetDelete.Enabled := lmDesigning;
    SheetResize.Enabled := lmDesigning;

    //excluded the following ActionItems
    //FileLogicMode
    //HelpAbout1
    //HelpShow
    //HelpInspectObjects




  end;
end;

procedure TLogicForm.FileLogicModeExecute(Sender: TObject);
begin
  If LogicMode = lmDesign then
  begin
    LogicMode := lmRun;
    FileLogicMode.Caption := 'Design';
    FileLogicModeItem.Caption := 'Design';
    ToolButton5.Hint := 'Press to Design logic';
    FileLogicMode.ImageIndex := 30;
  end else begin
    LogicMode := lmDesign;
    FileLogicMode.Caption := 'Run';
    FileLogicModeItem.Caption := 'Run';
    ToolButton5.Hint := 'Press to Run logic';
    FileLogicMode.ImageIndex := 29;
  end;
end;

procedure TLogicForm.HelpInspectObjectsExecute(Sender: TObject);
begin
  if MessageDlg('Here be dragons...', mtWarning,
    [mbIgnore,mbCancel], 0) = mrIgnore then
  begin
  if not assigned(logicoiform) then
    Application.CreateForm(TLogicOIForm, LogicOIForm);
  LogicOIForm.show;
  end;
end;

procedure TLogicForm.FilePrintExecute(Sender: TObject);
var
  I, J, Start, Stop: Integer;
  PrintImg : TBitmap;
  PrintRct : TRect;
begin
  PrintImg := TBitmap.Create;
  try
  PrintImg.PixelFormat := pf8bit;
  PrintImg.Canvas.CopyMode := cmSrcCopy;
  PrintDialog1.Options := [poPageNums, poSelection];
  PrintDialog1.FromPage := 1;
  PrintDialog1.MinPage := 1;
  PrintDialog1.ToPage := PageControl1.PageCount;
  PrintDialog1.MaxPage := PageControl1.PageCount;
  if PrintDialog1.Execute then
  begin
    { determine the range the user wants to print }
    with PrintDialog1 do
    begin
      if PrintRange = prAllPages then
        begin
        Start := MinPage - 1;
        Stop := MaxPage - 1;
      end
      else if PrintRange = prSelection then
      begin
        Start := PageControl1.ActivePage.PageIndex;
        Stop := Start;
        end
      else  { PrintRange = prPageNums }
      begin
        Start := FromPage - 1;
        Stop := ToPage - 1;
      end;
    end;
    { now, print the pages }

    Printer.Orientation := poLandscape;
    with Printer do
    begin
      BeginDoc;
      J := PageControl1.ActivePageIndex;
      for I := Start to Stop do
      begin
        PageControl1.ActivePageIndex := I;
        PageControl1Change(Sender); //V2.28
        PrintImg.Width := ActivePanel.Width;
        PrintImg.Height := ActivePanel.Height;
        PrintImg.Canvas.Lock;
        try ActivePanel.PaintTo(PrintImg.Canvas.Handle,0,0); finally
        PrintImg.Canvas.Unlock; end;
        PrintRct := Rect(10,10,PageWidth-10,PageHeight-10);
        Canvas.StretchDraw(PrintRct,PrintImg);
        if I <> Stop then
          NewPage;
      end;
      PageControl1.ActivePageIndex := J;
      EndDoc;
    end;
  end;
  finally
  PrintImg.Free;
  end;
end;

procedure TLogicForm.SheetResizeExecute(Sender: TObject);
var
  wD, hD : integer; //Desired dimensions
  wR, hR : integer; //Minimum required dimensions
  i : integer;
  AControl : TControl;
  APt : TPoint;
begin
  //Get minimum required dimensions
  wR := 0;
  hR := 0;
  for i:=0 to ActivePanel.ControlCount-1 do
  begin
    AControl := ActivePanel.Controls[i];
    if (AControl is TLogicNot) or (AControl is TLogicAnd) or
      (AControl is TLogicMultiAnd) or (AControl is TLogicMultiMooN) or
      (AControl is TLogicInput) or (AControl is TLogicOr) or
      (AControl is TLogicMultiOr) or (AControl is TLogicSetReset) or
      (AControl is TLogicDelay) or (AControl is TLogicOneShot) or
      (AControl is TLogicTitle) or (AControl is TLogicConnSink) or
      (AControl is TLogicConnSource) or (AControl is TLogicDescription) then
        begin
        wR := max(wR,AControl.Left+AControl.Width);
        hR := max(hR,AControl.Top +AControl.Height);
        end;
  end;
  APt := MultiPolyline.GetExtents;
  wR := max(wR,APt.X);
  hR := max(hR,APt.Y);

  //Round up to nearest 50 then add 50.
  wR := (wR div 50) * 50 + 100;
  hR := (hR div 50) * 50 + 100;
  //Use dialog to show old and get new dimensions for ActivePanel
  ResizeDlg.minWidth.Text  := IntToStr(wR);
  ResizeDlg.minHeight.Text := IntToStr(hR);
  ResizeDlg.tWidth.Text  := IntToStr(ActivePanel.Width);
  ResizeDlg.tHeight.Text := IntToStr(ActivePanel.Height);
  if ResizeDlg.ShowModal = mrOk then
    begin
    wD := StrToInt(ResizeDlg.tWidth.Text);
    hD := StrToInt(ResizeDlg.tHeight.Text);
    //preserve aspect ratio to printed page
    Printer.Orientation := poLandscape;
    if wD <> ActivePanel.Width then
    begin
      hD := wD * Printer.PageHeight div Printer.PageWidth;
    end else begin
      wD := hD * Printer.PageWidth div Printer.PageHeight;
    end;
    ActivePanel.Width  := wD;
    ActivePanel.Height := hD;
    end;
end;

procedure TLogicForm.LogicAddAnyMExecute(Sender: TObject);
var
  PosX,PosY : integer;
begin
  LogicMultiAnyM := TLogicMultiMooN.Create(PageControl1);
  with LogicMultiAnyM do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicMultiAnyM' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    PosX := Left + Width + 50;
    PosY := Top + Height div 2;
    Invalidate;
  end;
  LogicAddLine.Execute;
  LogicLine1.LogicInputSource := LogicMultiAnyM;
  LogicLine1.PlacePolyPoint(-1,PosX,PosY);
end;

procedure TLogicForm.FileNewExecute(Sender: TObject);
var
  i : integer;
begin
  if MessageDlg('Do you want to save this logic?', mtConfirmation,
    [mbYes,mbNo], 0) = mrYes then FileSaveAs1.Execute;

  //Uses selected code from FormCreate() and FormShow()
  FFileName := SUntitled;
  StatusBar.Panels[1].Text := ExtractFileName(FFileName);

  for i := PageControl1.PageCount-1 downto 0 do    //V2.27
  begin
    PageControl1.Pages[i].Free;
  end;
  //Create streamable object that holds BLD title and count of logic elements
  //Created at run time, re-parented in FormShow
  LogicCount := TLogicTitle.Create(PageControl1);
  LogicCount.Parent := PageControl1;   //temporary parent til SheetNew.Execute
  LogicCount.Name := 'LogicCounter';
  LogicCount.Caption := 'New Binary Logic Diagram';
  LogicCount.Count := 0;
  LogicCount.Version := Vers;


  SheetNew.Execute;
  PageControl1.ActivePage.Caption := 'Main';
  LogicCount.Parent := GetLogicParent;  //permanent parent
  PageControl1Change(Sender);

end;

procedure TLogicForm.LogicAddMemoExecute(Sender: TObject);
begin
  LogicDescription := TLogicDescription.Create(PageControl1);
  with LogicDescription do
  begin
    Parent := GetLogicParent;
    LogicCount.Count:=LogicCount.Count+1;
    Name := 'LogicDescription' + IntToStr(LogicCount.Count);
    Left := Left + GetGridPosition(ActiveScrollBox.HorzScrollBar.Position);
    Top  := Top  + GetGridPosition(ActiveScrollBox.VertScrollBar.Position);
    //Visible := true;
    Invalidate;
  end;

end;

initialization

  registerclasses([TShape,TTabSheet,TPageControl,TScrollBox,TPanel]);

end.
