{*******************************************************}
{                                                       }
{         MiTeC Runtime Object Inspector Component      }
{                    GUI Unit                           }
{                                                       }
{           version 1.1 for Delphi 5,6                  }
{                                                       }
{       Copyright  1999,2002 Michal Mutl               }
{                                                       }
{*******************************************************}
//BinaryLogic uses a keyboard shortcut for activation: <ctrl>+<alt>+i

unit LogicOI;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Buttons, TypInfo, OI, checklst, Grids,
  ExtDlgs, Menus, Registry, ImgList;

type
  TLogicOIForm = class(TForm)
    sb: TStatusBar;
    TopPanel: TPanel;
    cbObjects: TComboBox;
    hb: TStatusBar;
    Panel: TPanel;
    pc: TPageControl;
    tsProperties: TTabSheet;
    tsEvents: TTabSheet;
    opd: TOpenPictureDialog;
    cd: TColorDialog;
    Panel1: TPanel;
    ButtonPanel: TPanel;
    sbRefresh: TSpeedButton;
    sbClose: TSpeedButton;
    cbForms: TComboBox;
    pmMain: TPopupMenu;
    pmRefresh: TMenuItem;
    N1: TMenuItem;
    pmAbout: TMenuItem;
    pmClose: TMenuItem;
    N2: TMenuItem;
    pmTop: TMenuItem;
    pmPreview: TMenuItem;
    pmImage: TPopupMenu;
    pmStretch: TMenuItem;
    pmSave: TMenuItem;
    sd: TSaveDialog;
    pmInsert: TMenuItem;
    pmDelete: TMenuItem;
    N3: TMenuItem;
    sbInsert: TSpeedButton;
    sbDelete: TSpeedButton;
    N4: TMenuItem;
    pmHide: TMenuItem;
    sbFront: TSpeedButton;
    sbBack: TSpeedButton;
    pmFront: TMenuItem;
    pmBack: TMenuItem;
    OI: TMObjectInspector;
    OIPanel: TPanel;
    sg: TStringGrid;
    Splitter: TSplitter;
    gp: TGroupBox;
    ImagePanel: TPanel;
    Image: TImage;
    ilProp: TImageList;
    Bevel1: TBevel;
    Bevel2: TBevel;
    m: TMemo;
    clb: TCheckListBox;
    e: TEdit;
    cb: TComboBox;
    hk: THotKey;
    pmAutoRefresh: TMenuItem;
    AutoRefreshTimer: TTimer;
    procedure ObjectChange(Sender: TObject);
    procedure pcChange(Sender: TObject);
    procedure cmClose(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TopPanelResize(Sender: TObject);
    procedure cmInspectObject(Sender: TObject);
    procedure pcChanging(Sender: TObject; var AllowChange: Boolean);
    procedure eDblClick(Sender: TObject);
    procedure cmRefresh(Sender: TObject);
    procedure eKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure cmAbout(Sender: TObject);
    procedure FormChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cmTop(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure sgKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cmPreview(Sender: TObject);
    procedure cmStretch(Sender: TObject);
    procedure cmSave(Sender: TObject);
    procedure cmDelete(Sender: TObject);
    procedure cmInsert(Sender: TObject);
    procedure ImagePanelResize(Sender: TObject);
    procedure OIException(sender: TObject; e: Exception);
    procedure Change(Sender: TObject);
    procedure sgSelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure sgDrawCell(Sender: TObject; Col, Row: Integer; Rect: TRect;
      State: TGridDrawState);
    procedure sgTopLeftChanged(Sender: TObject);
    procedure cmFront(Sender: TObject);
    procedure cmBack(Sender: TObject);
    procedure pmAutoRefreshClick(Sender: TObject);
    procedure AutoRefreshTimerTimer(Sender: TObject);
  private
    { Private declarations }
    FObject :TObject;
    FOwner :TComponent;
    FObjName, FPropertyName :string;
    FPreview, FModified, FEditing, FSubObject, FCollection, FTopMost :boolean;
    FAutoRefresh :boolean;
    FControl :TWinControl;
    FValue :TStringlist;
    FRow :integer;
    FColObj :tcollection;
    fprop :tobject;
    FReadOnly: boolean;
    FCanChange: boolean;
    Function GetObjects(AOwner :TComponent) :integer;
    procedure GetComponentChildren(AOwner:TComponent);
    Function GetProps(AObject :TObject; PropType :TTypeKinds) :integer;
    function GetPageControl :integer;
    function GetItems(AObject :TCollection) :integer;
    function GetPos :TRect;
    procedure PlaceEdit;
    procedure RemoveEdit;
    procedure SetControls;
    procedure ReadSet;
    procedure WriteSet;
    procedure SetComponent(const Value: string);
    procedure SetCanChange(const Value: boolean);
    procedure SetReadOnly(const Value: boolean);
  protected
    procedure SetOwner(value :TComponent);
  public
    { Public declarations }
    property Owner :TComponent read FOwner write SetOwner;
    property Comp :string write SetComponent;
    property ReadOnly :boolean read FReadOnly write SetReadOnly;
    property CanChange :boolean read FCanChange write SetCanChange;
  end;

var
  LogicOIForm: TLogicOIForm;

const
  Title = 'Runtime Object Inspector';
  fileversion = '1.2';
  productversion = '1.0';

  CursorCount = 21;
  CursorNames :array[0..CursorCount] of string = ('crDefault',
                                                 'crNone',
                                                 'crArrow',
                                                 'crCross',
                                                 'crIBeam',
                                                 'crSize',
                                                 'crSizeNESW',
                                                 'crSizeNS',
                                                 'crSizeNWSE',
                                                 'crSizeWE',
                                                 'crUpArrow',
                                                 'crHourGlass',
                                                 'crDrag',
                                                 'crNoDrop',
                                                 'crHSplit',
                                                 'crVSplit',
                                                 'crMultiDrag',
                                                 'crSQLWait',
                                                 'crNo',
                                                 'crAppStart',
                                                 'crHelp',
                                                 'crHandPoint');

implementation

{$R *.DFM}

uses
  ShellAPI, LogicWindow;

function ParseObjName(s :string) :string;
begin
  result:=copy(s,1,pos(':',s)-2);
end;

function ParseCompName(s :string) :string;
var
  p :integer;
begin
  p:=pos('.',s);
  if p>0 then
    result:=copy(s,1,p-1)
  else
    result:=s;
end;

procedure TLogicOIForm.WriteSet;
var
  i :integer;
begin
  with tregistry.create do begin
    rootkey:=HKEY_CURRENT_USER;
    openkey('SOFTWARE\Simada\ObjInsp\'+title+'\'+productversion,true);
    writebool('StayOnTop',ftopmost);
    writebool('AutoRefresh',FAutoRefresh);
    writebool('ImagePreview',fpreview);
    writebool('Stretch',image.stretch);
    writeinteger('Top',top);
    writeinteger('Left',left);
    writeinteger('Width',width);
    writeinteger('Height',Height);
    writeinteger('Split',gp.Height);
    for i:=0 to sg.colcount-1 do
      writeinteger('ColWidth['+inttostr(i)+']',sg.colwidths[i]);
    closekey;
    free;
  end;
end;

procedure TLogicOIForm.ReadSet;
var
  i :integer;
begin
  with tregistry.create do begin
    rootkey:=HKEY_CURRENT_USER;
    openkey('SOFTWARE\Simada\ObjInsp\'+title+'\'+productversion,true);
    if valueexists('StayOnTop') then
      ftopmost:=readbool('StayOnTop')
    else
      ftopmost:=false;
    if valueexists('AutoRefresh') then
      FAutoRefresh:=readbool('AutoRefresh')
    else
      FAutoRefresh:=false;
    if valueexists('Stretch') then
      image.stretch:=readbool('Stretch')
    else
      image.stretch:=false;
    if valueexists('ImagePreview') then
      fpreview:=readbool('ImagePreview')
    else
      fpreview:=false;
    if valueexists('Split') then
      gp.height:=readinteger('Split')
    else
      gp.height:=sg.height div 4;
    if valueexists('Top') then
      top:=readinteger('Top')
    else
      top:=0;
    if valueexists('Left') then
      left:=readinteger('Left')
    else
      left:=0;
    if valueexists('Width') then
      width:=readinteger('Width')
    else
      width:=331;
    if valueexists('Height') then
      Height:=readinteger('Height')
    else
      height:=screen.height;
    for i:=0 to sg.colcount-1 do
      if valueexists('ColWidth['+inttostr(i)+']') then
        sg.colwidths[i]:=readinteger('ColWidth['+inttostr(i)+']')
      else
        sg.colwidths[i]:=100;
    closekey;
    free;
  end;
  setcontrols;
end;

function TLogicOIForm.GetPageControl:integer;
var
//  i :integer; //v2.28
//  ALogicForm : TForm;  //v2.28
  APageControl : TPageControl;
begin
  cbforms.items.clear;
{V2.28
  for i:=0 to application.componentcount-1 do
    if (application.components[i] is TForm) and
       (application.Components[i].Name = 'LogicForm') then
      begin
      ALogicForm := TForm(application.components[i]);
      cbforms.items.add(ALogicForm.name+' :'+
        ALogicForm.classname);
}
{V2.28
      end;
  for i:=0 to ALogicForm.componentcount-1 do
    if (ALogicForm.components[i] is TPageControl) then
      begin
      APageControl := TPageControl(ALogicForm.components[i]);
}
      APageControl := LogicForm.PageControl1;
      cbforms.items.add(APageControl.name+' :'+
        APageControl.classname);
      fowner := APageControl;
{
      end;
}
{
  for i:=0 to APageControl.componentcount-1 do
    if (APageControl.Components[i] is TTabSheet) then
      cbforms.items.add(APageControl.components[i].name+' :'+
        APageControl.components[i].classname);
}
  result:=cbforms.items.count;
  //if Result > 0 then cbforms.ItemIndex := 0; //v2.28 reset later
  //cbforms.hint:=inttostr(result-1)+' available Tabs(s)'; //v2.28
end;

function TLogicOIForm.GetPos;
begin
  result:=sg.cellrect(2,sg.row);
end;

function TLogicOIForm.GetItems(AObject:TCollection):integer;
var
  i,j :integer;
begin
  for i:=1 to sg.rowcount-1 do
    for j:=0 to sg.colcount-1 do
      sg.cells[j,i]:='';
  if aobject.count>0 then begin
    sg.rowcount:=aobject.count+1;
    for i:=0 to aobject.count-1 do
      with sg,aobject do begin
        j:=i+1;
        cells[0,j]:='Item '+inttostr(i);
        cells[1,j]:=items[i].classname;
        cells[2,j]:='('+items[i].classname+')';
      end;
  end else begin
    sg.rowcount:=2;
    sg.cells[0,1]:='<none>';
  end;
  result:=aobject.count;
  hb.panels[1].text:=fobjname+' :'+aobject.classname;
  hb.panels[1].width:=self.canvas.textwidth(hb.panels[1].text)+10;
end;

procedure TLogicOIForm.PlaceEdit;
var
  r :trect;
  p :ppropinfo;
  obj :tobject;
  editable :boolean;
  i,j :integer;
  t :ptypedata;
  f :ptypeinfo;
  s :string;
begin
  fvalue.clear;
  frow:=sg.row;
  fpropertyname:=sg.cells[0,frow];
  p:=oi.getproperty(fpropertyname);
  t:=gettypedata(p^.proptype^);
  fprop:=nil;
  if p^.proptype^.kind=tkclass then begin
    obj:=tobject(getordprop(fobject,p));
    editable:=assigned(obj) and ((obj is tstrings) or (obj is tcomponent));
    editable:=t^.classtype.inheritsfrom(tcomponent) or editable;
    fprop:=obj;
  end else
    editable:=p^.proptype^.kind<>tkmethod;
  if editable then begin
    oi.getpropertyvalue(fpropertyname,fvalue);
    fcontrol:=nil;
    case p^.proptype^.kind of
      tkenumeration: begin
        fcontrol:=cb;
        cb.items.Clear;
        cb.style:=csdropdownlist;
        t:=gettypedata(p^.proptype^);
        if t^.maxvalue<256 then
          for i:=t^.minvalue to t^.maxvalue do
            cb.items.add(getenumname(p^.proptype^,i))
        else
          for i:=0 to 255 do begin
            s:=getenumname(p^.proptype^,i);
            if (s<>'') and (cb.items.indexof(s)=-1) then
              cb.items.add(s);
          end;
        cb.itemindex:=cb.items.indexof(fvalue[0]);
      end;
      tkset: begin
        fcontrol:=clb;
        clb.items.Clear;
        f:=t^.comptype^;
        t:=gettypedata(f);
        for i:=t^.minvalue to t^.maxvalue do begin
          clb.items.add(getenumname(f,i));
          clb.checked[i]:=pos(clb.items[i],fvalue[0])<>0;
        end;
      end;
      tkclass: begin
        if editable then begin
          if (obj is tstrings) then begin
            fcontrol:=m;
            m.clear;
            m.lines.assign(fvalue);
          end else begin
            fcontrol:=cb;
            cb.style:=csdropdown;
            cb.items.Clear;
            for i:=0 to fowner.componentcount-1 do
              if fowner.components[i] is t^.classtype then
                cb.items.add(fowner.components[i].name);
            for i:=0 to application.componentcount-1 do
              if (application.components[i] is tdatamodule) and (application.components[i].name<>fowner.name) then
                for j:=0 to application.components[i].componentcount-1 do
                  if application.components[i].components[j] is t^.classtype then
                    cb.items.add(application.components[i].name+'.'+application.components[i].components[j].name);
            cb.itemindex:=cb.items.indexof(fvalue[0]);
          end;
        end;
      end;
      else begin
        fcontrol:=e;
        e.text:=fvalue[0];
        e.onkeydown:=nil;
        e.readonly:=freadonly;
        if p^.proptype^.name='TColor' then begin
          e.text:=colortostring(strtoint(fvalue[0]));
          e.onkeydown:=ekeydown;
          e.readonly:=true;
        end;
        if p^.proptype^.name='TDate' then begin
          e.text:=datetostr(strtofloat(fvalue[0]));
        end;
        if p^.proptype^.name='TDateTime' then begin
          e.text:=datetimetostr(strtofloat(fvalue[0]));
        end;
        if p^.proptype^.name='TTime' then begin
          e.text:=timetostr(strtofloat(fvalue[0]));
        end;
        if p^.proptype^.name='TCursor' then begin
          fcontrol:=cb;
          cb.style:=csdropdownlist;
          cb.items.Clear;
          for i:=0 to cursorcount do
            cb.items.add(cursornames[i]);
          cb.itemindex:=cb.items.indexof(cursornames[abs(strtoint(fvalue[0]))]);
        end;
        if p^.proptype^.name='TFontName' then begin
          fcontrol:=cb;
          cb.style:=csdropdownlist;
          cb.items.Clear;
          cb.items.assign(screen.fonts);
          cb.itemindex:=cb.items.indexof(fvalue[0]);
        end;
        if p^.proptype^.name='TShortCut' then begin
          fcontrol:=hk;
          hk.hotkey:=strtoint(fvalue[0]);
        end;
      end;
    end;
    if assigned(fcontrol) then begin
      r:=getpos;
      fcontrol.show;
      if fcontrol.enabled then
        fcontrol.SetFocus;
      fediting:=true;
    end;
  end;
  fmodified:=false;
end;

procedure TLogicOIForm.cmInspectObject(Sender: TObject);
var
  p :ppropinfo;
  obj :tobject;
  editable :boolean;
begin
  fvalue.clear;
  frow:=sg.row;
  if sg.cells[0,sg.row]<>'<none>' then begin
    if fcollection then begin
      obj:=tcollection(fobject).items[sg.row-1] as tcollection(fobject).itemclass;
      editable:=true;
    end else begin
      p:=oi.getproperty(fpropertyname);
      if p^.proptype^.kind=tkclass then begin
        obj:=tobject(getordprop(fobject,p));
        editable:=assigned(obj) and not(obj is tstrings);
      end else
        editable:=false;
    end;
    if editable then begin
      if (obj is tgraphic) or (obj is tpicture) then begin
        if not freadonly and opd.execute then begin
          if (obj is tgraphic) then
            tgraphic(obj).loadfromfile(opd.filename);
          if (obj is tpicture) then
            tpicture(obj).loadfromfile(opd.filename);
        end;
      end else begin
        fobject:=obj;
        if obj is tcollectionitem then
          fobjname:=fobjname+'.Item['+inttostr(frow-1)+']'
        else
          fobjname:=fobjname+'.'+p^.name;
        fSubObject:=true;
        fcollection:=false;
        if (obj is tcollection) then begin
          fcolobj:=tcollection(obj);
          sb.panels[1].text:=inttostr(getitems(tcollection(obj)));
          fcollection:=true;
        end else
          sb.panels[1].text:=inttostr(getprops(fobject,tkproperties));
      end;
    end;
  end;
  setcontrols;
end;

function AddItem(list,delimiter,word :string) :string;
begin
  if length(list)=0 then
    result:=list+word
  else
    result:=list+delimiter+word;
end;

procedure TLogicOIForm.RemoveEdit;
var
  i :integer;
  s :string;
begin
  fvalue.clear;
  if fcontrol is tedit then begin
    fvalue.add(tedit(fcontrol).text);
    if sg.cells[1,frow]='TColor' then
      fvalue[0]:=inttostr(stringtocolor(tedit(fcontrol).text));
    if sg.cells[1,frow]='TDateTime' then
      fvalue[0]:=floattostr(double(strtodatetime(tedit(fcontrol).text)));
    if sg.cells[1,frow]='TDate' then
      fvalue[0]:=floattostr(double(strtodate(tedit(fcontrol).text)));
  end;
  if fcontrol is tcombobox then
    if sg.cells[1,frow]='TCursor' then begin
      for i:=0 to cursorcount do
        if cursornames[i]=cb.text then
          fvalue.add(inttostr(-i));
    end else
      fvalue.add(tcombobox(fcontrol).text);
  if fcontrol is tmemo then
    fvalue.assign(tmemo(fcontrol).lines);
  if fcontrol is thotkey then
    fvalue.add(inttostr(thotkey(fcontrol).hotkey));
  if fcontrol is tchecklistbox then begin
    for i:=0 to tchecklistbox(fcontrol).items.count-1 do
      if tchecklistbox(fcontrol).checked[i] then
        s:=additem(s,',',tchecklistbox(fcontrol).items[i]);
    s:='['+s+']';
    fvalue.add(s);
  end;
  if fmodified then
    oi.setpropertyvalue(fpropertyname,fvalue);
  fcontrol.hide;
  oi.getpropertyvalue(fpropertyname,fvalue);
  if fcontrol is tmemo then
    sg.cells[2,frow]:='(TStrings)'
  else
    sg.cells[2,frow]:=fvalue[0];
  fediting:=false;
  frow:=-1;
  sg.setfocus;
end;

procedure TLogicOIForm.SetControls;
begin
  pmtop.checked:=ftopmost;
  pmAutoRefresh.Checked:=FAutoRefresh;
  pmRefresh.Enabled := not FAutoRefresh;
  sbRefresh.Enabled := not FAutoRefresh;
  AutoRefreshTimer.Enabled := FAutoRefresh;
  pmpreview.checked:=fpreview;
  pmstretch.checked:=image.stretch;
  pmdelete.enabled:=(fcollection and (tcollection(fobject).count>0)) or
                    not(fcollection or fsubobject or (not(assigned(fobject))
                    or assigned(application.findcomponent(
                    tcomponent(fobject).name))));
  pmdelete.enabled:=pmdelete.enabled and not readonly;
  pminsert.enabled:=fcollection and not readonly;
  pmfront.enabled:=assigned(fobject) and (fobject is twincontrol);
  pmback.enabled:=pmfront.enabled;
  sbinsert.enabled:=pminsert.enabled;
  sbdelete.enabled:=pmdelete.enabled;
  sbfront.enabled:=pmfront.enabled;
  sbback.enabled:=pmfront.enabled;

  if FTopMost then
    SetWindowPos(Handle, hwnd_TopMost, 0, 0, 0, 0, swp_NoMove + swp_NoSize)
  else
    SetWindowPos(Handle, hwnd_NoTopMost, 0, 0, 0, 0, swp_NoMove + swp_NoSize);


  if fpreview then
    splitter.show
  else
    splitter.hide;
  gp.visible:=fpreview;
end;

procedure TLogicOIForm.SetOwner(value :TComponent);
begin
  fowner:=value;
  cbforms.itemindex:=cbforms.Items.indexof(fowner.name+' :'+fowner.classname);
  getobjects(fowner);
  cbobjects.onchange(self);
end;

function TLogicOIForm.GetObjects(AOwner: TComponent):integer;
var
  i :integer;
begin
  cbobjects.items.clear;
  cbobjects.items.add(aowner.name+' :'+aowner.classname);
  GetComponentChildren(aowner); //adds child components to cbobjects
  cbobjects.itemindex:=cbobjects.items.indexof(aowner.name+' :'+
    aowner.classname);
  result:=cbobjects.items.count;
  cbobjects.hint:=inttostr(result)+' available object(s)';
end;

procedure TLogicOIForm.GetComponentChildren(AOwner:TComponent);
var
  i : integer;
begin
  for i:=0 to aowner.componentcount-1 do
    if not ( (aowner.Components[i] is TPopupMenu) //Customized for BinaryLogic
          or (aowner.Components[i] is TMenuItem)
          or (aowner.Components[i] is TTimer) ) then     //v2.28
    begin
    cbobjects.items.addobject(aowner.components[i].name+' :'+
      aowner.components[i].classname, aowner.Components[i] as TObject);
    if aowner.Components[i] is TWinControl then
      GetComponentChildren(aowner.Components[i]);
    end;
end;

procedure TLogicOIForm.ObjectChange(Sender: TObject);
begin
  fsubobject:=false;
  fcollection:=false;
  if cbobjects.text=fowner.name+' :'+fowner.classname then
    fobject:=fowner
  else
    //fobject:=FOwner.findcomponent(parseobjname(cbobjects.text));
    fobject:=cbobjects.Items.Objects[cbobjects.itemindex];
  //fobjname:=parseobjname(cbobjects.items[cbobjects.itemindex]);
  fobjname:=parseobjname(cbobjects.Text);
  if assigned(fobject) then
    pcchange(sender);
  if (oi.component is tcontrol) and assigned(tcontrol(oi.component).parent) then
    sb.panels[3].text:=tcontrol(oi.component).parent.name
  else
    sb.panels[3].text:='<none>';
  sb.panels[3].width:=self.canvas.textwidth(sb.panels[3].text)+10;
  setcontrols;
end;

//function TOIForm.GetProps;
Function TLogicOIForm.GetProps(AObject :TObject; PropType :TTypeKinds) :integer;
var
  i,j :integer;
begin
  oi.filter:=proptype;
  oi.component:=aobject;
  for i:=1 to sg.rowcount-1 do
    for j:=0 to sg.colcount-1 do
      sg.cells[j,i]:='';
  if oi.properties.count=0 then
    sg.rowcount:=2
  else
    sg.rowcount:=oi.properties.count+1;
  for i:=0 to oi.properties.count-1 do
    with sg,oi do begin
      j:=i+1;
      cells[0,j]:=properties[i];
      cells[1,j]:=types[i];
      cells[2,j]:=values[i];
      if declarations.count>0 then
        cells[3,j]:=declarations[i];
    end;
  result:=oi.properties.count;
  hb.panels[1].text:=fobjname+' :'+aobject.classname;
  hb.panels[1].width:=self.canvas.textwidth(hb.panels[1].text)+10;
end;

procedure TLogicOIForm.pcChange(Sender: TObject);
var
  tk :ttypekinds;
begin
  if pc.activepage=tsproperties then
    tk:=tkproperties
  else
    tk:=tkmethods;
  if fediting then
    removeedit;
  image.picture.graphic:=nil;
  if assigned(fobject) then
    sb.panels[1].text:=inttostr(getprops(fobject,tk));
end;

procedure TLogicOIForm.cmClose(Sender: TObject);
begin
  close;
end;

procedure TLogicOIForm.FormCreate(Sender: TObject);
begin
  top:=0;
  left:=0;
  height:=screen.height;
  fvalue:=tstringlist.create;
  sg.cells[0,0]:='Name';
  sg.cells[1,0]:='Type';
  sg.cells[2,0]:='Value';
  sg.cells[3,0]:='Additional info';
  frow:=-1;
  fmodified:=false;
  //readset;  //V2.28 don't read/write registry
  GetPageControl;
end;

procedure TLogicOIForm.TopPanelResize(Sender: TObject);
begin
  cbforms.width:=tpanel(sender).width-7-buttonpanel.width;
  cbobjects.width:=tpanel(sender).width-7;
end;

procedure TLogicOIForm.pcChanging(Sender: TObject; var AllowChange: Boolean);
begin
  allowchange:=not fsubobject;
end;

procedure TLogicOIForm.eDblClick(Sender: TObject);
begin
  if oi.getpropertytype(fpropertyname)='TColor' then begin
    cd.color:=stringtocolor(e.text);
    if cd.execute then
      e.text:=colortostring(cd.color);
  end;
end;

procedure TLogicOIForm.cmRefresh(Sender: TObject);
begin
  objectchange(sender);
end;

procedure TLogicOIForm.eKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  edblclick(sender);
end;

procedure TLogicOIForm.cmAbout(Sender: TObject);
begin
  shellabout(self.Handle,'','MiTeC '+title+' '+fileversion+#10#13+'Copyright  1997,99 MichaL MutL',self.icon.handle);
end;

{
procedure TLogicOIForm.FormChange(Sender: TObject);
var
  AComp : TComponent;
  AName : string;
begin
  AName := parseobjname(cbforms.text);
  AComp := application.FindComponent(AName);
  if AComp <> nil then
    setowner(AComp)
  else
    begin
      AComp := fowner.FindComponent(AName);
      if AComp <> nil then
        setowner(AComp)
      else
        if fowner.Owner <> nil then
          setowner(fowner.Owner);
    end;
  setcontrols;
end;
}

procedure TLogicOIForm.FormChange(Sender: TObject);
var
  AComp : TComponent;
  AName : string;
begin
  if assigned(fowner) then
    setowner(fowner);
  setcontrols;
end;

procedure TLogicOIForm.FormShow(Sender: TObject);
begin
  GetPageControl; //v2.28
  formchange(sender);
end;

procedure TLogicOIForm.cmTop(Sender: TObject);
begin
  ftopmost:=not ftopmost;
  setcontrols;
end;

procedure TLogicOIForm.FormDestroy(Sender: TObject);
begin
  //writeset;  //V2.28 don't read/write registry
end;

procedure TLogicOIForm.sgKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key=vk_return) and not fediting then
    cminspectobject(sender);
end;

procedure TLogicOIForm.cmPreview(Sender: TObject);
begin
  fpreview:=not fpreview;
  pc.onchange(sender);
  setcontrols;
end;

procedure TLogicOIForm.cmStretch(Sender: TObject);
begin
  image.stretch:=not image.stretch;
  setcontrols;
end;

procedure TLogicOIForm.cmSave(Sender: TObject);
var
  f :system.text;
  i :integer;
begin
  if sd.execute then begin
    assignfile(f,sd.FileName);
    rewrite(f);
    writeln(f,title+' '+fileversion+' -  1997, MichaL MutL');
    writeln(f);
    writeln(f,tcomponent(fobject).name+' :'+fobject.classname+' owned by '+fowner.name+' :'+fowner.classname);
    writeln(f,'------------------------------------------------------------------------------------------------');
    for i:=1 to sg.RowCount-1 do begin
      write(f,sg.cells[0,i]+' :'+sg.cells[1,i]+' = '+sg.cells[2,i]);
      if sg.cells[3,i]<>'' then
        writeln(f,' ['+sg.cells[3,i]+']')
      else
        writeln(f);
    end;
    closefile(f);
    MessageDlg('Object properties saved.',mtInformation,[mbOK],0);
  end;
end;

procedure TLogicOIForm.cmDelete(Sender: TObject);
var
  i :integer;
begin
  if not freadonly then
  if fcollection then begin
    if MessageDlg('Delete Item['+inttostr(sg.row-1)+']?',mtConfirmation,[mbYes,mbNo],0)=mryes then begin
      with fcolobj do begin
        beginupdate;
        items[sg.row-1].free;
        endupdate;
      end;
      sb.panels[1].text:=inttostr(getitems(fcolobj));
    end;
  end else begin
    if MessageDlg('Delete object '+parseobjname(cbobjects.text)+'?',mtConfirmation,[mbYes,mbNo],0)=mryes then begin
      for i:=0 to application.componentcount-1 do
        application.components[i].freenotification(tcomponent(fobject));
      fobject.free;
      getobjects(fowner);
      cbobjects.onchange(self);
    end;
  end;
end;

procedure TLogicOIForm.cmInsert(Sender: TObject);
begin
  if fcollection and not freadonly then begin
    with fcolobj do begin
      beginupdate;
      add;
      endupdate;
    end;
    sb.panels[1].text:=inttostr(getitems(fcolobj));
  end;
end;

procedure TLogicOIForm.ImagePanelResize(Sender: TObject);
begin
  if fediting then
    removeedit;
end;

procedure TLogicOIForm.OIException(sender: TObject; e: Exception);
begin
  MessageDlg(e.message,mtError,[mbOK],0);
end;

procedure TLogicOIForm.Change(Sender: TObject);
begin
  if freadonly then
    abort
  else
    fmodified:=true;
end;

procedure TLogicOIForm.sgSelectCell(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
begin
  sg.hint:=sg.cells[0,row]+' :'+sg.cells[1,row]+' = '+sg.cells[2,row];
  if sg.cells[3,row]<>'' then
    sg.hint:=sg.hint+' ['+sg.cells[3,row]+']';
  if self.visible and (frow<>row) and (pc.activepage=tsproperties) then begin
    if fediting then
      removeedit;
    if {(gdselected in state) and} not fcollection and (sg.cells[0,row]<>'') then begin
      placeedit;
    end;
    if fpreview and assigned(fprop) then begin
      if not fediting and (fprop.classtype=tpicture) then
        image.picture.assign(tpicture(fprop));
      if not fediting and (fprop.classtype=tbitmap) then
        image.picture.bitmap.assign(tbitmap(fprop));
      if not fediting and (fprop.classtype=tgraphic) then
        image.picture.graphic.assign(tgraphic(fprop));
      if not fediting and (fprop.classtype=tmetafile) then
        image.picture.metafile.assign(tmetafile(fprop));
      if not fediting and (fprop.classtype=ticon) then
        image.picture.icon.assign(ticon(fprop));
    end else
      image.picture.graphic:=nil;
  end;
end;

procedure TLogicOIForm.sgDrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
begin
  if ((col=2) and (row=frow)) and assigned(fcontrol) then
    if (gdselected in state) then begin
      fcontrol.width:=rect.right-rect.left;
      fcontrol.left:=rect.Left+4;
      fcontrol.top:=rect.top+4;
    end;
  sg.hint:=sg.cells[0,row]+' :'+sg.cells[1,row]+' = '+sg.cells[2,row];  
end;

procedure TLogicOIForm.sgTopLeftChanged(Sender: TObject);
begin
  if (sg.toprow>frow) or (sg.toprow+sg.visiblerowcount<frow) then
    if fediting then
      removeedit;
end;

procedure TLogicOIForm.cmFront(Sender: TObject);
begin
  twincontrol(fobject).bringtofront;
end;

procedure TLogicOIForm.cmBack(Sender: TObject);
begin
  twincontrol(fobject).sendtoback;
end;

procedure TLogicOIForm.SetComponent(const Value: string);
var
  i :integer;
begin
  i:=cbobjects.items.indexof(value);
  if i>-1 then begin
    cbobjects.itemindex:=i;
    objectchange(nil);
  end;
end;

procedure TLogicOIForm.SetCanChange(const Value: boolean);
begin
  FCanChange:=Value;
  cbforms.enabled:=fcanchange;
  cbobjects.enabled:=fcanchange;
end;

procedure TLogicOIForm.SetReadOnly(const Value: boolean);
begin
  FReadOnly:=Value;
  m.readonly:=freadonly;
  e.readonly:=freadonly;
end;

procedure TLogicOIForm.pmAutoRefreshClick(Sender: TObject);
begin
  FAutoRefresh:=not FAutoRefresh;
  setcontrols;
end;

procedure TLogicOIForm.AutoRefreshTimerTimer(Sender: TObject);
begin
  GetProps(fobject,tkproperties);
end;

end.
