unit LogicHelpText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ComCtrls;

type
  THelpText = class(TForm)
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    btnSave: TButton;
    RichEdit1: TRichEdit;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  HelpText: THelpText;
  HelpFileDir, HelpFileName : string;

implementation

{$R *.dfm}

procedure THelpText.FormCreate(Sender: TObject);
begin
  HelpFileDir := ExtractFilePath(ParamStr(0));
  HelpFileName := HelpFileDir + '\BinaryLogicHelpFile.rtf';
  if FileExists(HelpFileName) then
    RichEdit1.Lines.LoadFromFile(HelpFileName)
  else
    RichEdit1.Lines.Add('Help file "BinaryLogicHelpFile.rtf" was not found.');
end;

procedure THelpText.btnSaveClick(Sender: TObject);
begin
  RichEdit1.Lines.SaveToFile(HelpFileName);
end;

procedure THelpText.FormResize(Sender: TObject);
begin
  Invalidate;
end;

end.
