{ :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :: QuickReport 3.0 for Delphi 3.0/4.0/5.0                  ::
  ::                                                         ::
  :: Example reports project                                 ::
  ::                                                         ::
  :: Copyright (c) 1995-1999 QuSoft AS                       ::
  :: All Rights Reserved                                     ::
  ::                                                         ::
  :: web: http://www.qusoft.com  fax: +47 22 41 74 91        ::
  ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: }
unit mdmain;

{$DEFINE DEMOVERSION}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, quickrpt, Db, DBTables, printers, qrextra, QRExport,
  qrprntr, FR_Class;

type
  TfrmQR3Demo = class(TForm)
    Label1: TLabel;
    GroupBox1: TGroupBox;
    rbCreateList: TRadioButton;
    btnPreview: TButton;
    rbMasterDetail: TRadioButton;
    Description: TMemo;
    rbExprMemo: TRadioButton;
    rbImage: TRadioButton;
    rbBasicMD: TRadioButton;
    rbFormLetter: TRadioButton;
    rbAbout: TRadioButton;
    rbGrouping: TRadioButton;
    btnPreviewFast: TButton;
    btnDesign: TButton;
    Label2: TLabel;
    Button1: TButton;
    Label3: TLabel;
    procedure CreateList(Sender: TObject);
    procedure rbCreateListClick(Sender: TObject);
    procedure rbMasterDetailClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure rbExprMemoClick(Sender: TObject);
    procedure rbImageClick(Sender: TObject);
    procedure rbBasicMDClick(Sender: TObject);
    procedure rbFormLetterClick(Sender: TObject);
    procedure rbAboutClick(Sender: TObject);
    procedure rbGroupingClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FReport : TCustomQuickRep;
    CreateListReport : TQuickRep;
    procedure SetReport(Value : TCustomQuickRep);
  public
    { Public declarations }
    property Report : TCustomQuickRep read FReport write SetReport;
  end;

var
  frmQR3Demo: TfrmQR3Demo;

implementation

uses mdrpt, exprmemo, image, basicmd, frmltr,
  history, grouping, convqrfr, f_info;

{$R *.DFM}

procedure TfrmQR3Demo.SetReport(Value : TCustomQuickRep);
begin
  FReport := Value;
end;

procedure TfrmQR3Demo.CreateList(Sender: TObject);
var
  aReport : TCustomQuickRep;
  SomeFields: TStringList;
  MyTable: TTable;
  nIdx: integer;
begin
  { Create a table on the fly, this example uses a table from the demo database }
  MyTable := TTable.Create(self);

  { create the list of fields to output from the table }
  SomeFields := TStringList.Create;
  with MyTable do
  begin
    DatabaseName := 'DBDEMOS';
    TableName := 'COUNTRY.DB';
    ReadOnly := True;
    Active := True;

    // For this example, we will pull the field names from the table
    // If you wanted to only use some of the fields, you would edit
    // this list.
    for nIdx := 0 to FieldCount - 1 do
      SomeFields.Add(Fields[nIdx].FieldName);
  end;

  // If you didn't create the report, you must set the report object to nil
  // before calling QRCreateList

  areport := nil;

  { Build the report }

  // If you change the displaywidth, it will be reflecte in the created
  // report

  with MyTable.Fields[1] do
    DisplayWidth := DisplayWidth div 2;

  // create the report
  QRCreateList(aReport, nil, MyTable, 'Country Listing', SomeFields);

  // Make the column header's font use bold attribute
  aReport.Bands.ColumnHeaderBand.Font.Style := [fsBold];

  // Now adjust the spacing of the fields.  There isn't any reason to
  // do this, this is just to show how to access the controls on the
  // report.

  for nIdx := 0 to aReport.Bands.ColumnHeaderBand.ControlCount -1 do
    if aReport.Bands.ColumnHeaderBand.Controls[nIdx] is TQRPrintable then
      with TQRPrintable(aReport.Bands.ColumnHeaderBand.Controls[nIdx]) do
        Left := Left - (5 * nIdx);

  for nIdx := 0 to aReport.Bands.DetailBand.ControlCount -1 do
    if aReport.Bands.DetailBand.Controls[nIdx] is TQRPrintable then
      with TQRPrintable(aReport.Bands.DetailBand.Controls[nIdx]) do
        Left := Left - (5 * nIdx);


  { You can change the report objects before calling the report }
//  areport.page.orientation := poLandscape;
  {preview or print the report}

      if sender = btnPreview then
      begin
         areport.preview;
      end else
      if sender = btnPreviewFast then
      begin
         ConvertReportAndPreview(TQuickRep(areport));
      end else
      if sender = btnDesign then
      begin
         {$IFNDEF DEMOVERSION}
         ConvertReportAndDesign(TQuickRep(areport));
         {$ENDIF}
      end;

  { all done, free the objects }
  aReport.Free;
  MyTable.Free;
  SomeFields.Free;
end;

procedure TfrmQR3Demo.rbCreateListClick(Sender: TObject);
begin
  Report := CreateListReport;
end;

procedure TfrmQR3Demo.rbMasterDetailClick(Sender: TObject);
begin
  Report := frmMasterDetail.QuickRep1;
end;

procedure TfrmQR3Demo.FormCreate(Sender: TObject);
var i: integer;
begin
  // Create the report object used by the QRCreateList() function
  CreateListReport := TQuickRep.Create(self);
  rbCreateListClick(Self);
  rbCreateList.Checked := True;
end;

procedure TfrmQR3Demo.btnPreviewClick(Sender: TObject);
begin
  // This code is more complicated than what you would
  // typically need to run a report.  Most of this code
  // is to handle the selection of the various types of
  // reports.

  if report <> nil then
  begin
    if report = CreateListReport then
      CreateList(Sender)
    else 
    begin
      if sender = btnPreview then
      begin
         report.preview;
      end else
      if sender = btnPreviewFast then
      begin
         ConvertReportAndPreview(TQuickRep(report));
      end else
      if sender = btnDesign then
      begin
         {$IFNDEF DEMOVERSION}
         ConvertReportAndDesign(TQuickRep(report));
         {$ENDIF}
      end;
    end;
  end;
end;

procedure TfrmQR3Demo.rbExprMemoClick(Sender: TObject);
begin
  Report := frmExprmemo.QuickRep1;
end;

procedure TfrmQR3Demo.rbImageClick(Sender: TObject);
begin
  Report := frmImageRpt.QuickRep1;
end;

procedure TfrmQR3Demo.rbBasicMDClick(Sender: TObject);
begin
  Report := frmBasicMD.QuickRep1;
end;

procedure TfrmQR3Demo.rbFormLetterClick(Sender: TObject);
begin
  Report := frmFormLetter.QuickRep1;
end;

// The following code show how to explicitly call an export
// filter without going through the preview
procedure TfrmQR3Demo.rbAboutClick(Sender: TObject);
begin
  Report := frmHistory.QuickRep1;
end;

procedure TfrmQR3Demo.rbGroupingClick(Sender: TObject);
begin
  Report := frmGrouping.QuickRep1;     
end;

procedure TfrmQR3Demo.Button1Click(Sender: TObject);
begin
   fmInfo.ShowModal;
end;

end.
