(************************************************************************
 * Copyright  1998-2000 by
 *
 * IVS GbR
 * Annaberger Str. 240
 * D-09125 Chemnitz
 *
 * Tel. +49-371-5347 380
 * Fax +49-371-5347 428
 *
 * http://www.ivs-solutions.de
 *
 * $Header: /Private/Steffen/Projects/LangControl/Source/Demo/DemoTools.pas 1     19.01.00 16:57 Sl $
 *
 * Description: Demo of the IVS Language Controller; Tool functions
 *
 * This unit illustrates the use of the IVS Language Controller in
 * ordinary units without a form; Use the new items in the "Edit"
 * menu to call the editor of the IVS Language Controller
 *
 ************************************************************************)

unit DemoTools;

interface

uses
  SysUtils,Dialogs,
  LangControl; // This unit is required for the multilingual facility

procedure ShowAboutBox;
// Shows the about box

implementation

{$R *.LNG} // Include language file for this unit

var
  GetString:TGetString;
  // This procedure reference must be used to retrieve multilingual strings

// This notification procedure is called when the language has changed;
// It is comparable with the TLangControl.OnChange event
procedure LangChange(const Language:string);
begin
  // You can define your own code here to adjust
  // anything to the new active language
end;

procedure ShowAboutBox;
const
  Homepage='http://www.ivs-solutions.de';
var
  S:string;
begin
  S:=GetString('Copyright')+#13#10#13#10;
  S:=S+Format(GetString('PleaseVisit'),[#13#10+HomePage]);
  ShowMessage(S);
end;

initialization
  // The following procedure call is used to initialize the multilingual
  // facility for this unit; The procedure reference GetString becomes valid
  InitLangControl('{7990FD64-B3CC-469B-8B78-1DE82EECCA44}',LangChange,GetString);

end.
