(************************************************************************
 * Copyright  1998-2000 by
 *
 * IVS GbR
 * Annaberger Str. 240
 * D-09125 Chemnitz
 *
 * Tel. +49-371-5347 380
 * Fax +49-371-5347 428
 *
 * http://www.ivs-solutions.de
 *
 * $Header: /Private/Steffen/Projects/LangControl/Source/Demo/DemoMain.pas 5     19.01.00 16:57 Sl $
 *
 * Description: Demo of the IVS Language Controller; Main form
 *
 * This form shows the usage of the invisible component TLangControl;
 * Not only multilingual properties are used, but also multilingual
 * character strings
 *
 ************************************************************************)

unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, ExtCtrls, Menus, StdCtrls, LangControl,
  DemoLang, DemoTools;

{ TDemoMainForm }

type
  TDemoMainForm = class(TForm)
    LangControl: TLangControl;
    MainMenu: TMainMenu;
    MenuFile: TMenuItem;
    ItemOpen: TMenuItem;
    ItemSave: TMenuItem;
    ItemSaveAs: TMenuItem;
    ItemN1: TMenuItem;
    ItemExit: TMenuItem;
    MenuEdit: TMenuItem;
    ItemCut: TMenuItem;
    ItemCopy: TMenuItem;
    ItemPaste: TMenuItem;
    MenuOptions: TMenuItem;
    ItemLang: TMenuItem;
    MenuHelp: TMenuItem;
    ItemHelp: TMenuItem;
    ItemN2: TMenuItem;
    ItemAbout: TMenuItem;
    StatusBar: TStatusBar;
    Memo: TRichEdit;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PanelToolbar: TPanel;
    SpeedBtnLang: TSpeedButton;
    LangComboBox: TLangComboBox;
    LabelFont: TLabel;
    ImageGermany: TImage;
    ImageUSA: TImage;
    PanelDummy: TPanel;

    // Form events
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    // LangControl events
    procedure LangControlChange(Sender: TObject);

    // File menu events
    procedure ItemOpenClick(Sender: TObject);
    procedure ItemSaveClick(Sender: TObject);
    procedure ItemSaveAsClick(Sender: TObject);
    procedure ItemExitClick(Sender: TObject);

    // Edit menu events
    procedure ItemPasteClick(Sender: TObject);
    procedure ItemCutClick(Sender: TObject);
    procedure ItemCopyClick(Sender: TObject);

    // Option menu events
    procedure ItemLangClick(Sender: TObject);

    // Help menu events
    procedure ItemHelpClick(Sender: TObject);
    procedure ItemAboutClick(Sender: TObject);
  private
    FFileName:string;
    procedure CheckStatus;
    procedure ApplicationHint(Sender:TObject);
  public
  end;

var
  DemoMainForm: TDemoMainForm;

implementation

{$R *.DFM}

{ TDemoMainForm }

procedure TDemoMainForm.CheckStatus;
var
  S:string;
begin
  // Check document state
  if FFileName=''then
    StatusBar.Panels[1].Text:=LangControl.GetString('NoFileName')
  else
  begin
    S:=LangControl.GetString('FileName');
    StatusBar.Panels[1].Text:=Format(S,[FFileName]);
  end;

  // Refresh font label
  LabelFont.Caption:=LangControl.GetString('CurrentFont')+Font.Name;
end;

procedure TDemoMainForm.ApplicationHint(Sender:TObject);
begin
  if Application.Hint=''
  then CheckStatus
  else StatusBar.Panels[1].Text:=Application.Hint;
end;

procedure TDemoMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if Memo.Modified then
    ItemSaveAsClick(Self);
end;

procedure TDemoMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint:=ApplicationHint;
  CheckStatus;
end;

procedure TDemoMainForm.FormDestroy(Sender: TObject);
begin
  Application.OnHint:=nil;
end;

procedure TDemoMainForm.LangControlChange(Sender: TObject);
var
  I:Integer;
  S:string;
begin
  // Adjust status messages 
  CheckStatus;

  // Use only a short version as application title
  S:=Caption;
  I:=Pos(' -',S);
  if I>0then
    SetLength(S,I-1);
  Application.Title:=S;
end;

procedure TDemoMainForm.ItemOpenClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    Memo.Lines.BeginUpdate;
    try
      Memo.Lines.Clear;
      Memo.Lines.LoadFromFile(OpenDialog.FileName);
    finally
      Memo.Lines.EndUpdate;
    end;
    FFileName:=OpenDialog.FileName;
    Memo.Modified:=False;
    CheckStatus;
  end;
end;

procedure TDemoMainForm.ItemSaveClick(Sender: TObject);
begin
  if FFileName=''then
    ItemSaveAsClick(Self)
  else
  begin
    Memo.Lines.SaveToFile(FFileName);
    Memo.Modified:=False;
  end;
end;

procedure TDemoMainForm.ItemSaveAsClick(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);
    FFileName:=SaveDialog.FileName;
    Memo.Modified:=False;
    CheckStatus;
  end;
end;

procedure TDemoMainForm.ItemExitClick(Sender: TObject);
begin
  Close;
end;

procedure TDemoMainForm.ItemPasteClick(Sender: TObject);
begin
  Memo.PasteFromClipboard;
end;

procedure TDemoMainForm.ItemCutClick(Sender: TObject);
begin
  Memo.CutToClipboard;
end;

procedure TDemoMainForm.ItemCopyClick(Sender: TObject);
begin
  Memo.CopyToClipboard;
end;

procedure TDemoMainForm.ItemLangClick(Sender: TObject);
var
  F:TLangForm;
begin
  F:=TLangForm.Create(Application);
  try
    F.ShowModal;
  finally
    F.Free;
  end;
end;

procedure TDemoMainForm.ItemHelpClick(Sender: TObject);
begin
  ShowMessage(LangControl.GetString('EHelpError'));
end;

procedure TDemoMainForm.ItemAboutClick(Sender: TObject);
begin
  ShowAboutBox;
end;

end.
