{********************************************************************
TADVSTRINGGRID main demo unit

written by TMS Software
           copyright  1996-2000
           Email : info@tmssoftware.com
           Web : http://www.tmssoftware.com

The source code is given as is. The author is not responsible
for any possible damage done due to the use of this code.
The component can be freely used in any application. The complete
source code remains property of the author and may not be distributed,
published, given or sold in any form as such. No parts of the source
code can be included in any other component or application without
written authorization of the author.
********************************************************************}

unit Asgunit;

interface

{$DEFINE SHOWHTML}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, AdvGrid, StdCtrls, Buttons, ExtCtrls,
  Menus, ClipBrd, asprev, asabout, asfind, ComCtrls
  {$IFDEF VER120} ,ImgList {$ENDIF}
  {$IFDEF VER130} ,ImgList {$ENDIF}
  ;

type
  TDemo = class(TForm)
    FontDialog1: TFontDialog;
    MainMenu1: TMainMenu;
    Loaddata1: TMenuItem;
    Loadfromfile1: TMenuItem;
    Savetofile1: TMenuItem;
    SavetoHTML1: TMenuItem;
    SavetoCSV1: TMenuItem;
    SaveasXLS1: TMenuItem;
    Clipboard1: TMenuItem;
    Print1: TMenuItem;
    Copytoclipboard2: TMenuItem;
    Pastefromclipboard2: TMenuItem;
    Copyselectiontoclipboard1: TMenuItem;
    Print2: TMenuItem;
    Printpreview1: TMenuItem;
    Setselection1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Pastefromclipboard1: TMenuItem;
    LoadfromCSV1: TMenuItem;
    LoadfromXLS1: TMenuItem;
    Hide1: TMenuItem;
    Column11: TMenuItem;
    Column21: TMenuItem;
    Column31: TMenuItem;
    Column41: TMenuItem;
    Search1: TMenuItem;
    Findfirst1: TMenuItem;
    Findnext1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    AdvStringGrid2: TAdvStringGrid;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Button8: TButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Button3: TButton;
    Button6: TButton;
    RadioGroup1: TRadioGroup;
    fixedsort: TCheckBox;
    multiline: TCheckBox;
    colro: TCheckBox;
    AdvStringGrid1: TAdvStringGrid;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SavetoASCII1: TMenuItem;
    TabSheet3: TTabSheet;
    editgrid: TAdvStringGrid;
    Label6: TLabel;
    Column51: TMenuItem;
    Column61: TMenuItem;
    Column71: TMenuItem;
    ImageList1: TImageList;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Label8: TLabel;
    PrintDialog1: TPrintDialog;
    TabSheet4: TTabSheet;
    AdvStringGrid3: TAdvStringGrid;
    SavetoDOC1: TMenuItem;
    Button1: TButton;
    Button2: TButton;
    RadioGroup2: TRadioGroup;
    Exit1: TMenuItem;
    CheckBox7: TCheckBox;
    SavetoXML1: TMenuItem;
    colfix: TCheckBox;
    Memo1: TMemo;
    Printpreviewwithgraphics1: TMenuItem;
    Printwithgraphics1: TMenuItem;
    Timer1: TTimer;
    TabSheet5: TTabSheet;
    AdvStringGrid4: TAdvStringGrid;
    Label9: TLabel;
    ComboBox1: TComboBox;
    CheckBox8: TCheckBox;
    ComboBox2: TComboBox;
    Label10: TLabel;
    TabSheet6: TTabSheet;
    AdvStringGrid5: TAdvStringGrid;
    Label11: TLabel;
    Label12: TLabel;
    CheckBox9: TCheckBox;
    procedure Button3Click(Sender: TObject);
    procedure AdvStringGrid1GetAlignment(Sender: TObject; ARow,
      ACol: Longint; var AAlignment: TAlignment);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure AdvStringGrid1GetCellColor(Sender: TObject; ARow,
      ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
    procedure FormCreate(Sender: TObject);
    procedure AdvStringGrid1GridHint(Sender: TObject; Arow, Acol: Longint;
      var hintstr: string);
    procedure Loadfromfile1Click(Sender: TObject);
    procedure Savetofile1Click(Sender: TObject);
    procedure SavetoHTML1Click(Sender: TObject);
    procedure SavetoCSV1Click(Sender: TObject);
    procedure AdvStringGrid1AutoInsertRow(Sender: TObject; ARow: Longint);
    procedure AdvStringGrid1AutoDeleteRow(Sender: TObject; aRow: Longint);
    procedure AdvStringGrid1ClickSort(Sender: TObject; aCol: Longint);
    procedure CopytoExcel1Click(Sender: TObject);
    procedure SaveasXLS1Click(Sender: TObject);
    procedure Copytoclipboard2Click(Sender: TObject);
    procedure Pastefromclipboard2Click(Sender: TObject);
    procedure Print2Click(Sender: TObject);
    procedure Printpreview1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Setselection1Click(Sender: TObject);
    procedure fixedsortClick(Sender: TObject);
    procedure Copyselectiontoclipboard1Click(Sender: TObject);
    procedure Pastefromclipboard1Click(Sender: TObject);
    procedure LoadfromCSV1Click(Sender: TObject);
    procedure LoadfromXLS1Click(Sender: TObject);
    procedure AdvStringGrid1PrintPage(Sender: TObject; Canvas: TCanvas;
      pagenr, pagexsize, pageysize: Integer);
    procedure Column11Click(Sender: TObject);
    procedure Findfirst1Click(Sender: TObject);
    procedure Findnext1Click(Sender: TObject);
    procedure multilineClick(Sender: TObject);
    procedure AdvStringGrid1CanEditCell(Sender: TObject; Arow,
      Acol: Integer; var canedit: Boolean);
    procedure AdvStringGrid1CellValidate(Sender: TObject; Col,
      Row: Integer; var Value: String; var Valid: Boolean);
    procedure AdvStringGrid2GetAlignment(Sender: TObject; ARow,
      ACol: Integer; var AAlignment: TAlignment);
    procedure AdvStringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure SavetoASCII1Click(Sender: TObject);
    procedure editgridGetEditorType(Sender: TObject; aCol, aRow: Integer;
      var aEditor: TEditorType);
    procedure editgridEllipsClick(Sender: TObject; aCol, aRow: Integer;
      var S: String);
    procedure AdvStringGrid1GetFormat(Sender: TObject; ACol: Integer;
      var AStyle: TSortStyle; var aPrefix, aPostfix: String);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure AdvStringGrid1PrintStart(Sender: TObject; NrOfPages: Integer;
      var FromPage, ToPage: Integer);
    procedure SavetoDOC1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SavetoXML1Click(Sender: TObject);
    procedure AdvStringGrid1IsFixedCell(Sender: TObject; Arow,
      Acol: Integer; var isfixed: Boolean);
    procedure colfixClick(Sender: TObject);
    procedure AdvStringGrid1CanSort(Sender: TObject; aCol: Integer;
      var dosort: Boolean);
    procedure Printpreviewwithgraphics1Click(Sender: TObject);
    procedure Printwithgraphics1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure AdvStringGrid2ButtonClick(Sender: TObject; aCol,
      aRow: Integer);
    procedure CheckBox9Click(Sender: TObject);
    procedure AdvStringGrid5GetFormat(Sender: TObject; ACol: Integer;
      var AStyle: TSortStyle; var aPrefix, aSuffix: String);
  private
     procedure InitGraphicGrid;
     procedure SetPrintOptions;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Demo: TDemo;

implementation

{$R *.DFM}
{$R iehand.res}
{$R icons.res}     

procedure TDemo.Button3Click(Sender: TObject);
begin
 advstringgrid1.autosize:=true;
end;

procedure TDemo.AdvStringGrid1GetAlignment(Sender: TObject; ARow,
  ACol: Longint; var AAlignment: TAlignment);
begin
 if acol in [3,4] then aAlignment:=taRightJustify;
end;

procedure TDemo.Button6Click(Sender: TObject);
begin
 if radiogroup1.itemindex=0 then
   advstringgrid1.sortdirection:=sdAscending
 else
   advstringgrid1.sortdirection:=sdDescending;
 advstringgrid1.sortcolumn:=1;
 advstringgrid1.QSort;
end;

procedure TDemo.Button7Click(Sender: TObject);
var
 pagepreview:tpagepreview;
begin
 advstringgrid1.printsettings.titlelines.Assign(memo1.lines);

 if checkbox2.checked then
    advstringgrid1.printsettings.time:=ppTopLeft
 else
    advstringgrid1.printsettings.time:=ppNone;

 if checkbox2.checked then
    advstringgrid1.printsettings.date:=ppTopRight
 else
    advstringgrid1.printsettings.date:=ppNone;

 if checkbox3.checked then
    advstringgrid1.printsettings.pagenr:=ppBottomCenter
 else
    advstringgrid1.printsettings.pagenr:=ppNone;

 if checkbox4.checked then
    advstringgrid1.printsettings.borders:=pbSingle
 else
    advstringgrid1.printsettings.borders:=pbNoborder;

{
 advstringgrid1.print;
}

{
 advstringgrid1.printpreview(paintbox1.canvas);
}

 pagepreview:=tpagepreview.CreatePreview(self,advstringgrid1);
 try
  pagepreview.showmodal;
 finally
  pagepreview.free;
 end;

end;

procedure TDemo.Button8Click(Sender: TObject);
begin
 fontdialog1.font:=advstringgrid1.printsettings.font;
 if fontdialog1.execute then
   advstringgrid1.printsettings.font:=fontdialog1.font;
end;

procedure TDemo.AdvStringGrid1GetCellColor(Sender: TObject; ARow,
  ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
begin
 if (acol=1) and (arow>0) and (arow<advstringgrid1.rowcount-advstringgrid1.fixedfooters) and (not(gdSelected in AState) or (gdFocused in AState)) then
   begin
    abrush.color:=clYellow;
    afont.color:=clRed;
   end;
 if (arow=0) then
    begin
     afont.style:=[fsBold];
    end;
end;

procedure TDemo.InitGraphicGrid;
begin
  with advstringgrid2 do
   begin
    with CreateIcon(1,1,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_1');
    with CreateIcon(1,2,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_2');
    with CreateIcon(1,3,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_3');
    with CreateIcon(1,4,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_4');
    with CreateIcon(1,5,haCenter,vaAboveText) do handle:=LoadIcon(hinstance,'ICON_5');

    addrotated(1,0,90,'Icons');

    cells[1,1]:='cpu';
    cells[1,2]:='trashcan';
    cells[1,3]:='icon';
    cells[1,4]:='floppy';
    cells[1,5]:='audio';

    addimageidx(2,1,0,habeforetext,vaCenter);
    addimageidx(2,2,1,haBeforeText,vaCenter);
    addimageidx(2,3,2,haBeforeText,vaCenter);
    addimageidx(2,4,3,haBeforeText,vaCenter);
    addimageidx(2,5,4,haBeforeText,vaCenter);

    addrotated(2,0,90,'Imagelist');

    cells[2,1]:='mail';
    cells[2,2]:='note';
    cells[2,3]:='cancel';
    cells[2,4]:='home';
    cells[2,5]:='web';

    with CreateBitmap(3,1,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_1');
    with CreateBitmap(3,2,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_2');
    with CreateBitmap(3,3,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_3');
    with CreateBitmap(3,4,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_4');
    with CreateBitmap(3,5,false,haright,vabottom) do LoadFromResourceName(hinstance,'BITMAP_5');

    cells[3,1]:='';
    cells[3,2]:='';
    cells[3,3]:='';
    cells[3,4]:='';
    cells[3,5]:='';

    addrotated(3,0,90,'Bitmaps');

    autonumbercol(0);

    addrotated(4,0,90,'Text');

    addrotated(4,1,45,'One');

    addrotated(4,2,135,'Two');

    addrotated(4,3,225,'Three');

    addrotated(4,4,315,'Four');

    addrotated(4,5,180,'Five');

    addrotated(5,0,90,'Multi Image');

    addrotated(6,0,90,'Rich text');

    addmultiimage(5,1,0,haBeforeText,vaCenter);

    with CellImages [5,1] do
      begin
       Add(0);
       Add(1);
      end;

    addmultiimage(5,2,0,haBeforeText,vaCenter);

    with CellImages [5,2] do
      begin
       Add(2);
       Add(3);
       Add(4);
      end;

    addmultiimage(5,3,0,haBeforeText,vaCenter);

    with CellImages [5,3] do
      begin
       Add(0);
      end;

    addmultiimage(5,4,0,haBeforeText,vaCenter);

    with CellImages [5,4] do
      begin
       Add(1);
       Add(3);
       Add(4);
       Add(2);
      end;

    addmultiimage(5,5,0,haBeforeText,vaCenter);

    with CellImages [5,5] do
      begin
       Add(4);
       Add(1);
      end;

    richedit.text:='Rich text';
    richedit.selstart:=0;
    richedit.sellength:=4;
    richedit.selattributes.color:=clRed;
    richedit.selattributes.style:=[fsBold];
    richedit.selstart:=5;
    richedit.sellength:=4;
    richedit.selattributes.color:=clBlue;
    richedit.selattributes.style:=[fsItalic];
    richtocell(6,1,richedit);


    richedit.Clear;
    richedit.selattributes.style:=[];
    richedit.selattributes.color:=clBlack;

    richedit.text:='Superscript';

    richedit.selstart:=0;
    richedit.sellength:=5;
    richedit.selsuperscript;
    richedit.selattributes.color:=clBlue;

    richtocell(6,2,richedit);

    richedit.Clear;
    richedit.selattributes.style:=[];
    richedit.selattributes.color:=clBlack;

    richedit.text:='Subscript';
    richedit.selstart:=0;
    richedit.sellength:=3;
    richedit.selsubscript;
    richedit.selattributes.color:=clBlue;

    richtocell(6,3,richedit);

    richedit.Clear;
    richedit.selattributes.style:=[];
    richedit.selattributes.color:=clBlack;
    richedit.selnormal;
    richedit.paragraph.Numbering := nsBullet;

    richedit.lines.add('One'#13'Two'#13'Three');
    richedit.paragraph.Numbering := nsNone;

    richtocell(6,4,richedit);

    addrotated(7,0,90,'HTML');

    {$IFDEF SHOWHTML}

    cells[7,1]:='Easy <B>HTML</B><BR><I>formatting</I>';
    cells[7,2]:='Including <IMG src="idx:0"><FONT color="clred">everywhere</FONT>';
    cells[7,3]:='Enjoy<HR><B>miniHTML</B>';
    cells[7,4]:='<A href="http://www.tmssoftware.com/minihtml.htm">Click here</A><BR>for more';
    cells[7,5]:='125 <SUP>9</SUP>/<SUB>16</SUB>';

    {$ENDIF}


     addrotated(8,0,90,'Various');

     ints[8,1]:=50;
     AddProgress(8,1,clRed,clSilver);

     ints[8,2]:=75;
     AddProgress(8,2,clBlue,clWhite);

     AddComment(8,3,'This is a custom'#13'comment for this cell');

     cells[8,3]:='Cell with<BR><I>comment</I>';

     cells[8,4]:='<A href="CELL://R2C1">Link to cell 1,2</A>';
     cells[8,5]:='<A href="CELL://R1C2">Link to cell 2,1</A>';

     ints[6,5]:=1;

     AddButton(6,5,45,20,'Push me',haBeforeText,vaCenter);

   end;
end;

procedure TDemo.FormCreate(Sender: TObject);
var
 i:integer;
begin
 advstringgrid1.Clear;
 advstringgrid1.loadfromfile('test.txt');
 advstringgrid3.loadfromfile('test.txt');
 advstringgrid4.loadfromfile('test.txt');
 advstringgrid5.loadfromfile('test.txt');
 advstringgrid5.AutoSizeColumns(false,15);

 advstringgrid1.SortColumn :=1;
 editgrid.Clear;
 editgrid.loadfromfile('test.txt');

 editgrid.ClearComboString;
 editgrid.AddComboString('BMW');
 editgrid.AddComboString('Mercedes Benz');
 editgrid.AddComboString('Audi');
 editgrid.AddComboString('Porsche');
 editgrid.AddComboString('Ferrari');
 editgrid.AddComboString('Opel');
 editgrid.AddComboString('Lamborghini');
 editgrid.Combobox.sorted:=true;

 initgraphicGrid;

 for i:=1 to editgrid.rowcount-1 do editgrid.addcheckbox(5,i,false,false);

 editgrid.datetimepicker.calcolors.titlebackcolor:=clRed;
 editgrid.datetimepicker.calcolors.monthbackcolor:=clYellow;

 editgrid.spinedit.minvalue:=0;
 editgrid.spinedit.maxvalue:=100;
 editgrid.spinedit.increment:=2;

 with advstringgrid3 do
   begin
    fixedcols:=0;
    fixedcolwidth:=20;
    addnode(2,4);
    addnode(7,2);
    addnode(13,4);
   end;

 combobox1.itemindex:=0;
 combobox2.itemindex:=0;
end;

procedure TDemo.AdvStringGrid1GridHint(Sender: TObject; Arow,
  Acol: Longint; var hintstr: string);
begin
 case acol of
 1:hintstr:='Name of car company';
 2:hintstr:='Car model';
 3:hintstr:='# of cylinders';
 4:hintstr:='Year of introduction';
 5:hintstr:='Engine power';
 6:hintstr:='Price';
 7:hintstr:='Website';
 end;
end;

procedure TDemo.Loadfromfile1Click(Sender: TObject);
begin
 advstringgrid1.Clear;
 advstringgrid1.loadfromfile('test.txt');
end;

procedure TDemo.Savetofile1Click(Sender: TObject);
begin
advstringgrid1.savetofile('test.txt');
end;

procedure TDemo.SavetoHTML1Click(Sender: TObject);
begin
 advstringgrid1.Savetohtml('test.htm');
end;

procedure TDemo.SavetoCSV1Click(Sender: TObject);
begin
 advstringgrid1.savefixedcells:=false;
 advstringgrid1.Savetocsv('test.csv');
end;

procedure TDemo.LoadfromCSV1Click(Sender: TObject);
begin
 advstringgrid1.savefixedcells:=false;
 advstringgrid1.loadfromcsv('test.csv');
end;

procedure TDemo.AdvStringGrid1AutoInsertRow(Sender: TObject;
  ARow: Longint);
begin
 advstringgrid1.autonumbercol(0);
end;

procedure TDemo.AdvStringGrid1AutoDeleteRow(Sender: TObject;
  aRow: Longint);
begin
 advstringgrid1.autonumbercol(0);
end;

procedure TDemo.AdvStringGrid1ClickSort(Sender: TObject; aCol: Longint);
begin
 if not advstringgrid1.sortfixedcols then
 advstringgrid1.autonumbercol(0);
end;

procedure TDemo.CopytoExcel1Click(Sender: TObject);
begin
 Advstringgrid1.savetoxls('test.xls');
end;

procedure TDemo.SaveasXLS1Click(Sender: TObject);
begin
 advstringgrid1.savetoxls('text.xls');
end;

procedure TDemo.Copytoclipboard2Click(Sender: TObject);
begin
 advstringgrid1.copytoclipboard;
end;

procedure TDemo.Copyselectiontoclipboard1Click(Sender: TObject);
begin
 advstringgrid1.copyselectiontoclipboard;
end;

procedure TDemo.Pastefromclipboard2Click(Sender: TObject);
begin
 advstringgrid1.pasteselectionfromclipboard;
end;

procedure TDemo.Pastefromclipboard1Click(Sender: TObject);
begin
 advstringgrid1.pastefromclipboard;
end;

procedure TDemo.SetPrintOptions;
begin
 advstringgrid1.printsettings.titlelines.Assign(memo1.lines);

 if checkbox2.checked then
    advstringgrid1.printsettings.time:=ppTopLeft
 else
    advstringgrid1.printsettings.time:=ppNone;

 if checkbox1.checked then
    advstringgrid1.printsettings.date:=ppTopRight
 else
    advstringgrid1.printsettings.date:=ppNone;

 if checkbox3.checked then
    advstringgrid1.printsettings.pagenr:=ppBottomCenter
 else
    advstringgrid1.printsettings.pagenr:=ppNone;

 if checkbox4.checked then
   begin
     if radiobutton1.checked then
       advstringgrid1.PrintSettings.Borders :=advgrid.pbVertical;
     if radiobutton2.checked then
       advstringgrid1.PrintSettings.Borders :=advgrid.pbHorizontal;
     if radiobutton3.checked then
       advstringgrid1.PrintSettings.Borders :=advgrid.pbSingle;
   end
 else
    advstringgrid1.printsettings.borders:=advgrid.pbNoborder;

  if checkbox5.checked then
    advstringgrid1.printsettings.FitToPage := fpAlways
  else
    advstringgrid1.printsettings.FitToPage := fpNever;

  advstringgrid1.printsettings.NoAutoSize:=not checkbox7.checked;

  advstringgrid1.printsettings.Centered :=checkbox6.checked;
end;

procedure TDemo.Print2Click(Sender: TObject);
begin
 SetPrintOptions;
 advstringgrid1.print;
end;

procedure TDemo.Printpreview1Click(Sender: TObject);
var
 pagepreview:tpagepreview;
begin
 SetPrintOptions;
 advstringgrid1.previewpage:=1;
 pagepreview:=tpagepreview.CreatePreview(self,advstringgrid1);
 try
  pagepreview.showmodal;
 finally
  pagepreview.free;
 end;
end;

procedure TDemo.About1Click(Sender: TObject);
var
 About:tAbout;
begin
 About:=tAbout.Create(self);
 try
  About.showmodal;
 finally
  about.free;
 end;
end;

procedure TDemo.Setselection1Click(Sender: TObject);
var
 gridrect:tgridrect;
begin
 gridrect.left:=1;
 gridrect.top:=5;
 gridrect.right:=advstringgrid1.colcount-1;
 gridrect.bottom:=advstringgrid1.rowcount-1;
 advstringgrid1.printrect(gridrect);
end;

procedure TDemo.fixedsortClick(Sender: TObject);
begin
 advstringgrid1.sortfixedcols:=fixedsort.checked;
end;

procedure TDemo.LoadfromXLS1Click(Sender: TObject);
begin
 advstringgrid1.loadfromxls('test.xls');
end;

procedure TDemo.AdvStringGrid1PrintPage(Sender: TObject; Canvas: TCanvas;
  pagenr, pagexsize, pageysize: Integer);
var
 savefont:tfont;
 ts,tw:integer;

const
 myowntitle:string='Your company name can go here using custom drawing';

begin
 if advstringgrid1.PrintColStart <>0 then exit;
 with canvas do
  begin

    savefont:=tfont.create;
    savefont.assign(font);

    font.name:='Arial';
    font.style:=[fsBold];
    font.height:=advstringgrid1.mapfontheight(14);
    font.color:=clRed;

    ts:=advstringgrid1.printcoloffset[0];
    tw:=advstringgrid1.printpagewidth;

    moveto(ts,-5);
    lineto(ts+tw,-5);
    lineto(ts+tw,-advstringgrid1.printsettings.headersize+5);
    lineto(ts,-advstringgrid1.printsettings.headersize+5);
    lineto(ts,-5);

    ts:=ts+ ((tw-textwidth(myowntitle)) shr 1);

    textout(ts,-10,myowntitle);

    font.assign(savefont);
    savefont.free;
  end;

end;

procedure TDemo.Column11Click(Sender: TObject);
var
 acol:longint;
begin
  acol:=(sender as tmenuitem).tag;
  with advstringgrid1 do
   begin
    if ishiddencolumn(acol) then unhidecolumn(acol)
    else hidecolumn(acol);
    (sender as tmenuitem).checked:=ishiddencolumn(acol);
   end;
end;

procedure TDemo.Findfirst1Click(Sender: TObject);
var
 res:tpoint;
 finddlg:tfinddlg;
 findparams:tfindparams;

begin
 finddlg:=tfinddlg.create(self);
 try
  if (finddlg.showmodal=mrOk) then
   begin
    findparams:=[];

    if finddlg.chkcase.checked then findparams:=findparams + [fnMatchCase];
    if finddlg.chkfull.checked then findparams:=findparams + [fnMatchFull];
    if finddlg.chkregular.checked then findparams:=findparams + [fnMatchRegular];
    if finddlg.dir.itemindex=1 then findparams:=findparams + [fnDirectionLeftRight];
    if finddlg.where.itemindex=1 then findparams:=findparams + [fnFindInCurrentCol];
    if finddlg.where.itemindex=2 then findparams:=findparams + [fnFindInCurrentRow];
    res:=advstringgrid1.findfirst(finddlg.findtext.text,findparams);
    if res.x>=0 then
     begin
      advstringgrid1.col:=res.x;
      advstringgrid1.row:=res.y;
     end
    else
      messagedlg('Text not found',mtinformation,[mbOK],0);
   end;
 finally
  finddlg.free;
 end;

end;

procedure TDemo.Findnext1Click(Sender: TObject);
var
 res:tpoint;
begin
 res:=advstringgrid1.findnext;
 if (res.x>=0) and (res.y>=0) then
   begin
    advstringgrid1.col:=res.x;
    advstringgrid1.row:=res.y;
   end
 else
  messagedlg('Text not found',mtinformation,[mbOK],0);
end;

procedure TDemo.multilineClick(Sender: TObject);
begin
 if multiline.checked then
   advstringgrid1.defaultrowheight:=28
 else
   advstringgrid1.defaultrowheight:=16;

 advstringgrid1.multilinecells:=multiline.checked;
end;

procedure TDemo.AdvStringGrid1CanEditCell(Sender: TObject; Arow,
  Acol: Integer; var canedit: Boolean);
begin
 canedit:=(acol<>3) or (colro.checked=false);
end;

procedure TDemo.AdvStringGrid1CellValidate(Sender: TObject; Col,
  Row: Integer; var Value: String; var Valid: Boolean);
{
var
 code,i:integer;
}
begin
{
 if (col>=3) then
  begin
    val(value,i,code);
    valid:=(code=0) and (i>0);
    if not valid then messagedlg('Validation example'#13#10'Input should be a number > 0',mtinformation,[mbok],0);
  end;
}
end;

procedure TDemo.AdvStringGrid2GetAlignment(Sender: TObject; ARow,
  ACol: Integer; var AAlignment: TAlignment);
begin
 if (acol<4) and (acol<>2) then Aalignment:=taCenter;
 if (arow=0) then Aalignment:=taCenter;
end;


procedure TDemo.AdvStringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
begin
{
  if col=2 then
  with advstringgrid1.canvas do
   begin
    moveto(rect.left,rect.top);
    lineto(rect.right,rect.bottom);
   end;
}
end;

procedure TDemo.SavetoASCII1Click(Sender: TObject);
begin
 advstringgrid1.savetoascii('test.asc');
end;

procedure TDemo.editgridGetEditorType(Sender: TObject; aCol, aRow: Integer;
  var aEditor: TEditorType);
begin
 case acol of
 1:aEditor:=edComboList;
 2:aEditor:=edEditBtn;
 3:aEditor:=edSpinEdit;
 4:aEditor:=edDateEdit;
 end;
end;

procedure TDemo.editgridEllipsClick(Sender: TObject; aCol, aRow: Integer;
  var S: String);
var
 tmp:string;
begin
 tmp:=s;
 if inputquery('Edit ('+inttostr(aCol)+':'+inttostr(aRow)+')','Cell value',tmp) then
  s:=tmp;

end;



procedure TDemo.AdvStringGrid1GetFormat(Sender: TObject; ACol: Integer;
  var AStyle: TSortStyle; var aPrefix, aPostfix: String);
begin
  case acol of
  3:AStyle:=ssNumeric;
  4:AStyle:=ssDate;
  5:begin
     AStyle:=ssNumeric;
     apostfix:='pk';
    end;
  6:begin
     AStyle:=ssNumeric;
     aprefix:='$ ';
    end;
  end;
end;

procedure TDemo.RadioButton1Click(Sender: TObject);
begin
 radiobutton3.checked:=false;
 radiobutton2.checked:=false;
 radiobutton1.checked:=true;
end;

procedure TDemo.RadioButton3Click(Sender: TObject);
begin
 radiobutton2.checked:=false;
 radiobutton1.checked:=false;
 radiobutton3.checked:=true;
end;

procedure TDemo.RadioButton2Click(Sender: TObject);
begin
 radiobutton1.checked:=false;
 radiobutton3.checked:=false;
 radiobutton2.checked:=true;
end;

procedure TDemo.AdvStringGrid1PrintStart(Sender: TObject;
  NrOfPages: Integer; var FromPage, ToPage: Integer);
begin
 printdialog1.FromPage :=frompage;
 printdialog1.ToPage:= toPage;
 printdialog1.Maxpage:=toPage;
 printdialog1.minpage:=1;

 if printdialog1.execute then
  begin
   frompage:=printdialog1.FromPage;
   topage:=printdialog1.ToPage;
  end
 else
  begin
   frompage:=0;
   topage:=0;
  end;


end;

procedure TDemo.SavetoDOC1Click(Sender: TObject);
begin
 advstringgrid1.SavetoDOC('test.doc');
end;

procedure TDemo.Button1Click(Sender: TObject);
begin
 advstringgrid3.expandall;
end;

procedure TDemo.Button2Click(Sender: TObject);
begin
 advstringgrid3.contractall;
end;

procedure TDemo.RadioGroup2Click(Sender: TObject);
begin
 case radiogroup2.itemindex of
 0:advstringgrid3.cellnode.nodetype:=cnFlat;
 1:advstringgrid3.cellnode.nodetype:=cn3D;
 2:advstringgrid3.cellnode.nodetype:=cnGlyph;
 end;
end;

procedure TDemo.Exit1Click(Sender: TObject);
begin
self.Close;
end;

procedure TDemo.SavetoXML1Click(Sender: TObject);
var
 sl:tstringlist;
begin
 sl:=tstringlist.Create;
 sl.add('Nr');
 sl.add('Car');
 sl.add('Type');
 sl.add('Cylinders');
 sl.add('Intro');
 sl.add('Power');
 sl.add('Price');
 sl.add('Web');

 advstringgrid1.Savetoxml('test.xml','CARLIST','CAR',sl);
 sl.free;
end;

procedure TDemo.AdvStringGrid1IsFixedCell(Sender: TObject; Arow,
  Acol: Integer; var isfixed: Boolean);
begin
 isfixed:=colfix.checked and (acol=3); 
end;

procedure TDemo.colfixClick(Sender: TObject);
begin
 colro.checked:=true;
 advstringgrid1.repaint;
end;

procedure TDemo.AdvStringGrid1CanSort(Sender: TObject; aCol: Integer;
  var dosort: Boolean);
begin
 dosort:=not ((acol=3) and colfix.checked);
end;

procedure TDemo.Printpreviewwithgraphics1Click(Sender: TObject);
begin
 advstringgrid2.previewpage:=1;

 pagepreview:=tpagepreview.CreatePreview(self,advstringgrid2);
 try
  pagepreview.showmodal;
 finally
  pagepreview.free;
 end;

end;

procedure TDemo.Printwithgraphics1Click(Sender: TObject);
begin
 SetPrintOptions;
 advstringgrid2.print;
end;

procedure TDemo.Timer1Timer(Sender: TObject);
begin
 advstringgrid2.ints[8,1]:=random(100);
 advstringgrid2.ints[8,2]:=random(100);
end;

procedure TDemo.CheckBox8Click(Sender: TObject);
begin
 advstringgrid4.Filter.Clear;
 with advstringgrid4.Filter.Add do
  begin
   condition:=combobox1.Items[combobox1.itemindex];
   column:=1;
  end;
 with advstringgrid4.Filter.Add do
  begin
   condition:=combobox2.Items[combobox2.itemindex];
   column:=3;
  end;

 advstringgrid4.FilterActive:=checkbox8.checked;
end;

procedure TDemo.AdvStringGrid2ButtonClick(Sender: TObject; aCol,
  aRow: Integer);
begin
 with advstringgrid2 do ints[6,5]:=ints[6,5]+1;
end;

procedure TDemo.CheckBox9Click(Sender: TObject);
begin
  advstringgrid1.URLFull:=checkbox9.checked;
end;

procedure TDemo.AdvStringGrid5GetFormat(Sender: TObject; ACol: Integer;
  var AStyle: TSortStyle; var aPrefix, aSuffix: String);
begin
 {make sure some model nummers with numeric only data do not confuse the
  automatic format detection} 
 if acol=2 then aStyle:=ssAlphabetic else aStyle:=ssAutomatic;
end;

end.
