unit RepFrm4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  QuickRpt, ExtCtrls, StdCtrls, Db, DBTables, PIQRAlt, AltQRCtl;

type
  TForm4 = class(TForm)
    QuickRep1: TQuickRep;
    DetailBand1: TQRBand;
    Table1: TTable;
    AltQRDBText1: TAltQRDBText;
    PageHeaderBand1: TQRBand;
    AltQRContainer1: TAltQRContainer;
    AltQRText2: TAltQRText;
    AltQRText1: TAltQRText;
    PageCountText: TAltQRText;
    PageNumberExpr: TAltQRExpr;
    Button2: TButton;
    Button1: TButton;
    Label1: TLabel;
    procedure QuickRep1EndPage(Sender: TCustomQuickRep);
    procedure Button1Click(Sender: TObject);
    procedure PageNumberTextPrint(Sender: TpiQRPrintable; var IsPrint: Boolean;
      var PrintText: String);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation

{$R *.DFM}

procedure TForm4.QuickRep1EndPage(Sender: TCustomQuickRep);
procedure DrawRuler(NLeft, NTop, NLength: extended);
var NBot: extended;
	NatStep, NatCur, RulWidth, NatFig: extended;
begin
	NBot:=NTop+NLength;
   NatStep:=100;
   RulWidth:=30;
	with QuickRep1.QRPrinter do begin
   	with Canvas do begin
      	Font:=QuickRep1.Font;
         MoveTo(XPos(NLeft), YPos(NTop));
      	LineTo(XPos(NLeft), YPos(NBot));
         NatCur:=NTop;
         NatFig:=0;
         while NatCur <= NBot do begin
            MoveTo(XPos(NLeft-RulWidth), YPos(NatCur));
            LineTo(XPos(NLeft), YPos(NatCur));
            TextOut(XPos(NLeft+10), YPos(NatCur), FormatFloat('0', NatFig / 100));
            NatCur:=NatCur+NatStep;
            NatFig:=NatFig+NatStep;
         end;
      end;
   end;
end;
begin
	DrawRuler(1900, 0, QuickRep1.Page.Length);
end;

procedure TForm4.Button1Click(Sender: TObject);
begin
	QuickRep1.Prepare;
   PageCountText.Caption:=IntToStr(QuickRep1.QRPrinter.PageCount);
	QuickRep1.Preview;
end;

procedure TForm4.PageNumberTextPrint(Sender: TpiQRPrintable;
  var IsPrint: Boolean; var PrintText: String);
begin
	PrintText:=IntToStr(QuickRep1.PageNumber);
end;

procedure TForm4.Button2Click(Sender: TObject);
begin
	QuickRep1.Prepare;
   PageCountText.Caption:=IntToStr(QuickRep1.QRPrinter.PageCount);
	QuickRep1.Print;
end;

end.
