unit MainDlg;

interface

{$INCLUDE PictureTemplate.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CamRemote, CamDefines, ExtCtrls, ComCtrls;

type
  TFormMain = class(TForm)
    CamRemote: TCamRemote;
    ButtonConnect: TButton;
    ListBox: TListBox;
    RichEdit: TRichEdit;
    ButtonDisconnect: TButton;
    EditPCDir: TEdit;
    LabelPCDir: TLabel;
    ImageThumbnail: TImage;
    ButtonTransfer: TButton;
    ButtonDelete: TButton;
    ProgressBar: TProgressBar;
    procedure ButtonConnectClick(Sender: TObject);
    procedure ButtonDisconnectClick(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure ButtonTransferClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CamRemoteGetPictureEvent(PercentageDone: Integer);
    procedure ButtonDeleteClick(Sender: TObject);
  private
    { Private declarations }
    mImageList : ImageListType;

    procedure UpdateListBox;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.dfm}

{$IFDEF DEXIF}
uses dEXIF, dIPTC;
{$ENDIF}

procedure TFormMain.ButtonConnectClick(Sender: TObject);
begin
  //Connect to the camera
  CamRemote.Connect;
  //List all pictures on the camera
  mImageList := CamRemote.OpenCameraCollection(ExtractFileDir(ParamStr(0)));
  UpdateListBox;
end;

procedure TFormMain.UpdateListBox;
var i : integer;
begin
  //Update the list of pictures on the form
  ListBox.Items.Clear;
  for i := 0 to Length(mImageList) - 1 do
  begin
    ListBox.Items.Add(mImageList[i].Name)
  end;
end;

procedure TFormMain.ButtonDisconnectClick(Sender: TObject);
begin
  //Close the picture collection and delete the objects in mImageList
  CamRemote.CloseCameraCollection(mImageList);
  CamRemote.Disconnect;
end;

procedure TFormMain.ListBoxClick(Sender: TObject);
{$IFDEF DEXIF}
var exif_item : TTagEntry;
{$ENDIF}
begin
  //Print EXIF data for RAW-pictures to a RichEdit VCL.
  RichEdit.Lines.Clear;
  if (ListBox.ItemIndex <> -1) then
  begin
    //Update thumbnail on the form
    ImageThumbnail.Picture.Assign(mImageList[ListBox.ItemIndex].Thumbnail);
{$IFDEF DEXIF}
    if (mImageList[ListBox.ItemIndex].EXIF.ExifObj <> nil) then
    begin
      RichEdit.Lines.Add(mImageList[ListBox.ItemIndex].EXIF.ExifObj.toLongString);
      RichEdit.Lines.Add('Detailed EXIF data');
      mImageList[ListBox.ItemIndex].EXIF.ExifObj.ResetIterator;
      while mImageList[ListBox.ItemIndex].EXIF.ExifObj.IterateFoundTags(GenericEXIF, exif_item) do
      begin
        RichEdit.Lines.Add(exif_item.Desc+DexifDelim + exif_item.Data);
      end;
      RichEdit.Lines.Add('Maker specific EXIF data');
      mImageList[ListBox.ItemIndex].EXIF.ExifObj.ResetIterator;
      while mImageList[ListBox.ItemIndex].EXIF.ExifObj.IterateFoundTags(CustomEXIF, exif_item) do
      begin
        RichEdit.Lines.Add(exif_item.Desc + DexifDelim + exif_item.Data);
      end;
    end;  
{$ENDIF}
  end;
end;

procedure TFormMain.ButtonTransferClick(Sender: TObject);
begin
  if (ListBox.ItemIndex <> -1) then
  begin
    CamRemote.GetPicture(ListBox.ItemIndex,
                         EditPCDir.Text + '\' + ListBox.Items[ListBox.ItemIndex]);
  end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
   EditPCDir.Text := ExtractFileDir(ParamStr(0));
end;

procedure TFormMain.CamRemoteGetPictureEvent(PercentageDone: Integer);
begin
  ProgressBar.Position := PercentageDone;
end;

procedure TFormMain.ButtonDeleteClick(Sender: TObject);
begin
  if (ListBox.ItemIndex <> -1) then
  begin
    CamRemote.DeletePicture(mImageList, ListBox.ItemIndex);
    //Update the list of pictures, since mImageList has been modified
    UpdateListBox;
  end else begin
    MessageDlg('No picture selected to delete', mtInformation, [mbOK], 0)
  end;
end;

end.
