unit CamDefines;

interface

{$INCLUDE CamRemote.inc}

uses SysUtils, Jpeg
     {$IFDEF DEXIF}, dEXIF, dIPTC {$ENDIF};

type
  ECamException = class(Exception);
  CamModType = (CamModNone,
                CamModPowerShot,
                CamModEOS);
  ConnectInfoType = record
                      CameraModel     : CamModType;
                      CameraModelName : string;
                      OwnerName       : string;
                    end;
  //Release method when taking a picture remotely
  ReleaseModeType =
    (ReleaseModeOnlyToPC,        //The picture will only be sent to the PC. No picture is stored in the camera.
     ReleaseModeBothPCAndCamera, //The picture will be stored both on PC and Camera.
     ReleaseModeOnlyToCamera     //The picture will only be stored on Camera.
                     );
  //Type of pictures taken when a photo is taken remotely
  ReleaseDataKindType = (ReleaseDataKindTakeOnlyThumbnail,    //Only a thumbnail picture will be taken
                         ReleaseDataKindTakeOnlyPicture,      //Only the full size picture will be taken
                         ReleaseDataKingTakeBothThumbAndPic); //Both the full size and thumbnail picture will ba taken.
  type RemoteViewFinderOutputType =
    (RemoteViewFinderOutputLCD,   //The viewfinder LCD is started.
     RemoteViewFinderOutputVideo, //The viewfinder is sent to the video output of the camera.
     RemoteViewFinderOutputOff);  //Turn of LCD and video viewfinder.

  //Remote Format Quality
  type RemoteFormatQualityType = (RemoteFormatQualityNotUsed,
                                  RemoteFormatQualityEconomy,
                                  RemoteFormatQualityNormal,
                                  RemoteFormatQualityFine,
                                  RemoteFormatQualitySuperfine,
                                  RemoteFormatQualityRAW);
  //Remote Format Size
  type RemoteFormatSizeType = (RemoteFormatSizeNotUsed,
                               RemoteFormatSizeLarge,
                               RemoteFormatSizeMedium,
                               RemoteFormatSizeSmall,
                               RemoteFormatSizeMedium1,
                               RemoteFormatSizeMedium2,
                               RemoteFormatSizeMedium3);

  //Remote Shooting mode
  type RemoteFormatShootingModeType = (RemoteFormatShootingModeNotUsed,
                                       RemoteFormatShootingModeAuto,
                                       RemoteFormatShootingModeManual,
                                       RemoteFormatShootingModeFarScene,
                                       RemoteFormatShootingModeFastShutter,
                                       RemoteFormatShootingModeSlowShutter,
                                       RemoteFormatShootingModeNightScene,
                                       RemoteFormatShootingModeGrayScene,
                                       RemoteFormatShootingModeSepia,
                                       RemoteFormatShootingModePortrait,
                                       RemoteFormatShootingModeSport,
                                       RemoteFormatShootingModeMacro,
                                       RemoteFormatShootingModeBW,
                                       RemoteFormatShootingModePanFocus,
                                       RemoteFormatShootingModeVivid,
                                       RemoteFormatShootingModeNeutral,
                                       RemoteFormatShootingModeProgram,
                                       RemoteFormatShootingModeTV,
                                       RemoteFormatShootingModeAV,
                                       RemoteFormatShootingModeADep,
                                       RemoteFormatShootingModeMDep,
                                       RemoteFormatShootingModeBulb,
                                       RemoteFormatShootingModeManual2,
                                       RemoteFormatShootingModeFlashOff,
                                       RemoteFormatShootingModeLongShutter,
                                       RemoteFormatShootingModeSuperMacro,
                                       RemoteFormatShootingModeFoliage,
                                       RemoteFormatShootingModeIndoor,
                                       RemoteFormatShootingModeFireworks,
                                       RemoteFormatShootingModeBeach,
                                       RemoteFormatShootingModeUnderwater,
                                       RemoteFormatShootingModeSnow,
                                       RemoteFormatShootingModeKidsAndPets,
                                       RemoteFormatShootingModeNightSnapshot,
                                       RemoteFormatShootingModeDigitalMacro,
                                       RemoteFormatShootingModeMyColors,
                                       RemoteFormatShootingModePhotoInMovie);

  //Remote Exposure Compensation
  type RemoteFormatExposureCompType = (RemoteFormatExposureCompNotUsed,
                                       RemoteFormatExposureComp200Plus,
                                       RemoteFormatExposureComp166Plus,
                                       RemoteFormatExposureComp133Plus,
                                       RemoteFormatExposureComp100Plus,
                                       RemoteFormatExposureComp066Plus,
                                       RemoteFormatExposureComp033Plus,
                                       RemoteFormatExposureComp0,
                                       RemoteFormatExposureComp033Minus,
                                       RemoteFormatExposureComp066Minus,
                                       RemoteFormatExposureComp100Minus,
                                       RemoteFormatExposureComp133Minus,
                                       RemoteFormatExposureComp166Minus,
                                       RemoteFormatExposureComp200Minus);

  //Remote White Balance
  type RemoteFormatWBType = (RemoteFormatWBNotUsed,
                             RemoteFormatWBAuto,
                             RemoteFormatWBDaylight,
                             RemoteFormatWBCloudy,
                             RemoteFormatWBTungsten,
                             RemoteFormatWBFluorscent,
                             RemoteFormatWBFlash,
                             RemoteFormatWBFluorescentLight,
                             RemoteFormatWBCustom,
                             RemoteFormatWBCustom1,
                             RemoteFormatWBCustom2,
                             RemoteFormatWBBW,
                             RemoteFormatWBShade,
                             RemoteFormatWBKelvin,
                             RemoteFormatWBPCSet1,
                             RemoteFormatWBPCSet2,
                             RemoteFormatWBPCSet3);

  //Remote Autofocus Distance
  type RemoteFormatAFDistType = (RemoteFormatAFDistNotUsed,
                                 RemoteFormatAFDistManual,
                                 RemoteFormatAFDistAuto,
                                 RemoteFormatAFDistUnknown,
                                 RemoteFormatAFDistZFCloseUp,
                                 RemoteFormatAFDistZFShortestDistance,
                                 RemoteFormatAFDistZFShortDistance,
                                 RemoteFormatAFDistZFMediumDistance,
                                 RemoteFormatAFDistZFFarDistance,
                                 RemoteFormatAFDistPanFocus,
                                 RemoteFormatAFDistSuperMacro,
                                 RemoteFormatAFDistInfinity,
                                 RemoteFormatAFDistSuperMacroOCM);

  //Remote Flash setting
  type RemoteFormatFlashType = (RemoteFormatFlashNotUsed,
                                RemoteFormatFlashOff,
                                RemoteFormatFlashAuto,
                                RemoteFormatFlashOn,
                                RemoteFormatFlashRedEye,
                                RemoteFormatFlashSlowSync,
                                RemoteFormatFlashAutoRedEye,
                                RemoteFormatFlashOnRedEye);

  //Remote Flash Compensation setting
  type RemoteFormatFlashCompType = (RemoteFormatFlashCompNotUsed,
                                    RemoteFormatFlashComp200Plus,
                                    RemoteFormatFlashComp166Plus,
                                    RemoteFormatFlashComp133Plus,
                                    RemoteFormatFlashComp100Plus,
                                    RemoteFormatFlashComp066Plus,
                                    RemoteFormatFlashComp033Plus,
                                    RemoteFormatFlashComp0,
                                    RemoteFormatFlashComp033Minus,
                                    RemoteFormatFlashComp066Minus,
                                    RemoteFormatFlashComp100Minus,
                                    RemoteFormatFlashComp133Minus,
                                    RemoteFormatFlashComp166Minus,
                                    RemoteFormatFlashComp200Minus);

  //Remote ML Weighting
  type RemoteFormatMLWeiType = (RemoteFormatMLWeiNotUsed,
                                RemoteFormatMLWeiCenterWeighted,
                                RemoteFormatMLWeiSpot,
                                RemoteFormatMLWeiAveraging,
                                RemoteFormatMLWeiEvaluative,
                                RemoteFormatMLWeiPartial,
                                RemoteFormatMLWeiCenterwWeightedAveraging);

  //Remote Contrast, Color Gain, Sharpness
  type RemoteFormatLevelType = (RemoteFormatLevelNotUsed,
                                RemoteFormatLevelLow,
                                RemoteFormatLevelDefault,
                                RemoteFormatLevelHigh);

  //Remote ISO
  type RemoteFormatISOType = (RemoteFormatISONotUsed,
                              RemoteFormatISOAuto,
                              RemoteFormatISO50,
                              RemoteFormatISO100,
                              RemoteFormatISO200,
                              RemoteFormatISO400,
                              RemoteFormatISO800,
                              RemoteFormatISO1600,
                              RemoteFormatISO3200);

  //Remote TV
  type RemoteFormatTVType = (RemoteFormatTVNotUsed,
                             RemoteFormatTV30sec,
                             RemoteFormatTV15sec,
                             RemoteFormatTV8sec,
                             RemoteFormatTV4sec,
                             RemoteFormatTV2sec,
                             RemoteFormatTV1sec,
                             RemoteFormatTV0sec5,
                             RemoteFormatTV1_4,
                             RemoteFormatTV1_8,
                             RemoteFormatTV1_15,
                             RemoteFormatTV1_30,
                             RemoteFormatTV1_60,
                             RemoteFormatTV1_125,
                             RemoteFormatTV1_250,
                             RemoteFormatTV1_500,
                             RemoteFormatTV1_1000,
                             RemoteFormatTV1_2000,
                             RemoteFormatTV1_4000,
                             RemoteFormatTV1_8000,
                             RemoteFormatTV1_16000);

  //Remote AV
  type RemoteFormatAVType = (RemoteFormatAVNotUsed,
                             RemoteFormatAV1_0,
                             RemoteFormatAV1_4,
                             RemoteFormatAV2_0,
                             RemoteFormatAV2_8,
                             RemoteFormatAV4_0,
                             RemoteFormatAV5_6,
                             RemoteFormatAV8_0,
                             RemoteFormatAV11_0,
                             RemoteFormatAV16_0,
                             RemoteFormatAV22_0,
                             RemoteFormatAV32_0,
                             RemoteFormatAV45_0,
                             RemoteFormatAV64_0,
                             RemoteFormatAV91_0);

  //Remote Photo effect
  type RemoteFormatPhotoEffectType = (RemoteFormatPhotoEffectNotUsed,
                                      RemoteFormatPhotoEffectOff,
                                      RemoteFormatPhotoEffectVivid,
                                      RemoteFormatPhotoEffectNeutral,
                                      RemoteFormatPhotoEffectLowSharpening,
                                      RemoteFormatPhotoEffectSepia,
                                      RemoteFormatPhotoEffectBW);

  //Remote Beep
  type RemoteFormatBeepType = (RemoteFormatBeepNotUsed,
                               RemoteFormatBeepOn,
                               RemoteFormatBeepOff);

  //Parameters used when taking picture remotely.
  type RemoteReleaseParametersType =
    record
      CompQuality          : RemoteFormatQualityType;
      ImageSize            : RemoteFormatSizeType;
      StrobeSetting        : RemoteFormatFlashType;
      StrobeCompSetting    : RemoteFormatFlashCompType;
      ImageMode            : RemoteFormatShootingModeType;
      MLWeiMode            : RemoteFormatMLWeiType;
      AFDistance           : RemoteFormatAFDistType;
      WhiteBalanceSetting  : RemoteFormatWBType;
      Contrast             : RemoteFormatLevelType;
      ColorGain            : RemoteFormatLevelType;
      Sharpness            : RemoteFormatLevelType;
      ISO                  : RemoteFormatISOType;
      Av                   : RemoteFormatAVType;
      Tv                   : RemoteFormatTVType;
      ExposureCompensation : RemoteFormatExposureCompType;
      PhotoEffect          : RemoteFormatPhotoEffectType;
      Beep                 : RemoteFormatBeepType;
    end;

  //Type used when probing which remote parameters a camera supports
  type RemoteReleaseAvailParametersType =
    record
      CompQuality          : array[RemoteFormatQualityType] of boolean;
      ImageSize            : array[RemoteFormatSizeType] of boolean;
      StrobeSetting        : array[RemoteFormatFlashType] of boolean;
      StrobeCompSetting    : array[RemoteFormatFlashCompType] of boolean;
      ImageMode            : array[RemoteFormatShootingModeType] of boolean;
      MLWeiMode            : array[RemoteFormatMLWeiType] of boolean;
      AFDistance           : array[RemoteFormatAFDistType] of boolean;
      WhiteBalanceSetting  : array[RemoteFormatWBType] of boolean;
      Contrast             : array[RemoteFormatLevelType] of boolean;
      ColorGain            : array[RemoteFormatLevelType] of boolean;
      Sharpness            : array[RemoteFormatLevelType] of boolean;
      ISO                  : array[RemoteFormatISOType] of boolean;
      Av                   : array[RemoteFormatAVType] of boolean;
      Tv                   : array[RemoteFormatTVType] of boolean;
      ExposureCompensation : array[RemoteFormatExposureCompType] of boolean;
      PhotoEffect          : array[RemoteFormatPhotoEffectType] of boolean;
      Beep                 : array[RemoteFormatBeepType] of boolean;
     end;

  //Remote function supported. Used when starting the remote more to get
  //information about supported remote functions
  RemoteFuncType = record
                      DoSupportZoom                : boolean;
                      DoSupportShootingPara        : boolean;
                      DoSupportViewfinder          : boolean;
                      ReqViewfinderOffWhenShooting : boolean;
                      DoSupportAfLockUnlock        : boolean;
                      RemoteParamSupported         : RemoteReleaseAvailParametersType;
                    end;

  RemoteZoomCapabilityType = record
                               CurrentZoomPos    : integer;
                               MaxOpticalZoomPos : integer;
                               MaxZoomPos        : integer;
                             end;

  EventSeverityType = (EventSeverityNotUsed,
                       EventSeverityInfo,
                       EventSeverityWarning,
                       EventSeverityClosing);
  EventEnumType     = (EventNotUsed,
                       EventBatteryLevelNormal,
                       EventBatteryLevelWeak,
                       EventBatteryLevelSafetyLow,
                       EventBatteryLevelLB,
                       EventDialChanged,
                       EventCFGateOpened,
                       EventBatteryCoverOpened,
                       EventConnectionDisappeared,
                       EventUnrecoverableError,
                       EventUnkonwnCommandReceived,
                       EventRemoteParamterChanged);
  EventCallbackType = record
                        Severity : EventSeverityType;
                        Event    : EventEnumType;
                      end;
  RemoteEventCallbackType = (RemoteEventCallbackNotUsed,
                             RemoteEventCallbackReleaseStart,
                             RemoteEventCallbackReleaseComplete,
                             RemoteEventCallbackResetHWError,
                             RemoteEventCallbackChangedByUI,
                             RemoteEventCallbackCamReleaseOn,
                             RemoteEventCallbackViewfinderOn,
                             RemoteEventCallbackViewfinderOff);
  ImageDataType = record
                    Name      : string;
                    Thumbnail : TJPEGImage;
{$IFDEF DEXIF}
                    EXIF      : TImgData;
{$ENDIF}                    
                  end;
  ImageListType = array of ImageDataType;
implementation

end.
