unit DlgViewFinder;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFormViewFinder = class(TForm)
    Image: TImage;
    ButtonSetAE: TButton;
    ComboBoxViewFinderMode: TComboBox;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonSetAEClick(Sender: TObject);
    procedure ComboBoxViewFinderModeChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormViewFinder: TFormViewFinder;

implementation

uses DlgRemote, CamDefines;

{$R *.DFM}

procedure TFormViewFinder.FormShow(Sender: TObject);
begin
  ComboBoxViewFinderMode.Enabled := true;
  FormRemote.CamRemote.RemoteStartViewfinder;
end;

procedure TFormViewFinder.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  FormRemote.CamRemote.RemoteStopViewfinder;
  FormRemote.ViewFinderEnabled := false;
end;

procedure TFormViewFinder.ButtonSetAEClick(Sender: TObject);
begin
  FormRemote.CamRemote.RemoteActivateViewfinderAuto;
end;

procedure TFormViewFinder.ComboBoxViewFinderModeChange(Sender: TObject);
begin
  case ComboBoxViewFinderMode.ItemIndex of
    0: FormRemote.CamRemote.RemoteSetViewfinderOutput(RemoteViewFinderOutputOff);
    1: FormRemote.CamRemote.RemoteSetViewfinderOutput(RemoteViewFinderOutputVideo);
    2: FormRemote.CamRemote.RemoteSetViewfinderOutput(RemoteViewFinderOutputLCD);
  end;
  ComboBoxViewFinderMode.Enabled := false;
end;

end.
