unit PLtypes;

interface

uses
  Windows, Classes, Graphics, PLStrings;

type

 TPaperType = record
   width,height : single;
   name : string;
   value : smallint;
  end;
  
const
 LEFT_A : array[0..9] of PChar = ('0001101','0011001','0010011','0111101',
              '0100011','0110001','0101111','0111011','0110111','0001011');
 LEFT_B : array[0..9] of PChar = ('0100111','0110011','0011011','0100001',
              '0011101','0111001','0000101','0010001','0001001','0010111');
 RIGHT  : array[0..9] of PChar = ('1110010','1100110','1101100','1000010',
              '1011100','1001110','1010000','1000100','1001000','1110100');
 CodLeft : array[0..9] of PChar = ('AAAAA','ABABB','ABBAB','ABBBA','BAABB',
              'BBAAB','BBBAA','BABAB','BABBA','BBABA');
 ValidEAN = ['0'..'9'];
 ValidCode39 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%';
   Code39Table: array[1..44, 1..9] of char = (
    'NNNWWNWNN',  {1 - 0}
    'WNNWNNNNW',  {2 - 1}
    'NNWWNNNNW',  {3 - 2}
    'WNWWNNNNN',  {4 - 3}
    'NNNWWNNNW',  {5 - 4}
    'WNNWWNNNN',  {6 - 5}
    'NNWWWNNNN',  {7 - 6}
    'NNNWNNWNW',  {8 - 7}
    'WNNWNNWNN',  {9 - 8}
    'NNWWNNWNN',  {10 - 9}
    'WNNNNWNNW',  {11 - A}
    'NNWNNWNNW',  {12 - B}
    'WNWNNWNNN',  {13 - C}
    'NNNNWWNNW',  {14 - D}
    'WNNNWWNNN',  {15 - E}
    'NNWNWWNNN',  {16 - F}
    'NNNNNWWNW',  {17 - G}
    'WNNNNWWNN',  {18 - H}
    'NNWNNWWNN',  {19 - I}
    'NNNNWWWNN',  {20 - J}
    'WNNNNNNWW',  {21 - K}
    'NNWNNNNWW',  {22 - L}
    'WNWNNNNWN',  {23 - M}
    'NNNNWNNWW',  {24 - N}
    'WNNNWNNWN',  {25 - O}
    'NNWNWNNWN',  {26 - P}
    'NNNNNNWWW',  {27 - Q}
    'WNNNNNWWN',  {28 - R}
    'NNWNNNWWN',  {29 - S}
    'NNNNWNWWN',  {30 - T}
    'WWNNNNNNW',  {31 - U}
    'NWWNNNNNW',  {32 - V}
    'WWWNNNNNN',  {33 - W}
    'NWNNWNNNW',  {34 - X}
    'WWNNWNNNN',  {35 - Y}
    'NWWNWNNNN',  {36 - Z}
    'NWNNNNWNW',  {37 - -}
    'WWNNNNWNN',  {38 - .}
    'NWWNNNWNN',  {39 - blank space}
    'NWNNWNWNN',  {40 - *}
    'NWNWNWNNN',  {41 - $}
    'NWNWNNNWN',  {42 - /}
    'NWNNNWNWN',  {43 - +}
    'NNNWNWNWN'); {44 - %}

  Int25Table : array['0'..'9', 1..5] of char =
	(
  ('0', '0', '1', '1', '0'),  //0
  ('1', '0', '0', '0', '1'),  //1
  ('0', '1', '0', '0', '1'),  //2
  ('1', '1', '0', '0', '0'),  //3
  ('0', '0', '1', '0', '1'),  //4
  ('1', '0', '1', '0', '0'),  //5
  ('0', '1', '1', '0', '0'),  //6
  ('0', '0', '0', '1', '1'),  //7
  ('1', '0', '0', '1', '0'),  //8
  ('0', '1', '0', '1', '0')   //9
	);

  Papers : array [0..20] of TPaperType = (
    (width: 210;height: 297;name: 'A4';value: 9),
    (width: 297;height: 420;name: 'A3';value: 8),
    (width: 148;height: 210;name: 'A5';value: 11),
    (width: 250;height: 354;name: 'B4';value: 12),
    (width: 182;height: 257;name: 'B5';value: 13),
    (width: 110;height: 220;name: PlEnDL;value: 27),
    (width: 162;height: 229;name: PlEnC5;value: 28),
    (width: 324;height: 458;name: PlEnC3;value: 29),
    (width: 229;height: 324;name: PlEnC4;value: 30),
    (width: 215;height: 275;name: 'Quarto';value: 15),
    (width: 114;height: 162;name: PlEnC6;value: 31),
    (width: 114;height: 229;name: PlEnC65;value: 32),
    (width: 250;height: 353;name: PlEnB4;value: 33),
    (width: 176;height: 250;name: PlEnB5;value: 34),
    (width: 176;height: 125;name: PlEnB6;value: 35),
    (width: 110;height: 230;name: 'Italy';value: 36),
    (width: 250;height: 353;name: 'B4 (ISO)';value: 42),
    (width: 100;height: 148;name: 'Japanese Postcard';value: 43),
    (width: 200;height: 148;name: 'Japanese Doble';value: 82),
    (width: 220;height: 220;name: PlEnInv;value: 47),
    (width: 200;height: 200;name: PlUser;value: $100)
    );//    (width: 105;height: 148;name: 'A6';value: 70),
type

 TPoint2D = record
    x,y : single;
  end;

 TRect2D = record
    X1,Y1,X2,Y2: single;
  end;

 TDragStyle = (dsMove, dsSizeTopLeft, dsSizeTopRight, dsSizeBottomLeft, dsSizeBottomRight,
                dsSizeTop, dsSizeLeft, dsSizeBottom, dsSizeRight);

 TPLZoom = (zm50,zm75,zm100,zm125,zm150,zm175,zm200);

 TPLUnits = (unMM,unINCH);

 TPLBackStyle = (biNone,biImage);

 TPLFrameStyle = (maNot,maSingle,maDoble);

 TPLDirection = (diHor,diVer);

 TPLSnap = (snPoint,snGrid,snNone);

 TPLDrawTool = (dwLine, dwRect, dwText, dwBarCode, dwSelection, dwSymbol, dwAddText, dwImage, dwParagraph);

 TTextAlign = (taLeBa, taCeBa, taRiBa, taLeBo, taCeBo, taRiBo, taLeTo, taCeTo, taRiTo);

 TPLEleAlign = (eaLeft, eaTop, eaRight, eaBottom);

 TPLEle = (dePoint, deLine, deText, deBar, deRect, deSymbol, dePoliText, deImage, deParagraph);

 TPLBar = (baEAN13,baEAN8,baCode39,baUPCA);

 function Point2D(a,b:single) : TPoint2D;
 function Rect2D (x1,y1,x2,y2:single):TRect2D;
 function Coord(e:extended): integer;
 function MinInt(a, b: integer): integer;
 function MaxInt(a, b: integer): integer;
 function Ceil(X: Extended): Integer;
 function Floor(X: Extended): Integer;
 procedure Expand(var Bar:TRect;dx:integer);
 procedure Enlarge(var Bar:TRect;dy:integer);
 procedure RotateBorder(var Border:TRect;angle,p1x,p1y,wi,he:integer);
 procedure Rotate90(var Ap: TPoint; Center: TPoint);
 procedure Rotate180(var Ap: TPoint; Center: TPoint);
 procedure Rotate270(var Ap: TPoint; Center: TPoint);
 procedure PascalStr(var s : string);
 procedure ComaStr(var s : string);

implementation

function Point2D(a,b:single) : TPoint2D;
begin
  result.x := a;
  result.y := b;
end;

function Coord(e:extended): integer;
begin
  result:= Round(e*100);
end;

function Rect2D (x1,y1,x2,y2:single):TRect2D;
begin
  Result.x1:=x1;
  Result.y1:=y1;
  Result.x2:=x2;
  Result.y2:=y2;
end;

procedure Rotate90(var Ap: TPoint; Center: TPoint);
Var
 New: TPoint;
begin
  New.X:= Center.X + Ap.Y - Center.Y;
  New.Y:= Center.Y - Ap.X + Center.X;
  Ap:= New;
end;

procedure Rotate180(var Ap: TPoint; Center: TPoint);
Var
 New: TPoint;
begin
  New.X:= Center.X - Ap.X + Center.X;
  New.Y:= Center.Y - Ap.Y + Center.Y;
  Ap:= New;
end;

procedure Rotate270(var Ap: TPoint; Center: TPoint);
Var
 New: TPoint;
begin
  New.X:= Center.X - Ap.Y + Center.Y;
  New.Y:= Center.Y + Ap.X - Center.X;
  Ap:= New;
end;

function MinInt(a, b: integer): integer;
begin
  Result:= b;
  if a < b then Result := a;
end;

function MaxInt(a, b: integer): integer;
begin
  Result:= b;
  if a > b then Result := a;
end;


function Ceil(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) > 0 then
    Inc(Result);
end;

function Floor(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) < 0 then
    Dec(Result);
end;

procedure Expand(var Bar:TRect;dx:integer);
begin
 Bar.Right:= Bar.Right+dx;
end;

procedure Enlarge(var Bar:TRect;dy:integer);
begin
 Bar.Bottom:= Bar.Bottom+dy;
end;

procedure RotateBorder(var Border:TRect;angle,p1x,p1y,wi,he:integer);
begin
 case angle of
     0 : begin
          Border.Left:= p1x;
          Border.Top := p1y;
          Border.Right:= p1x + wi;
          Border.Bottom:= p1y + he;
         end;
    90 : begin
          Border.Left:= p1x;
          Border.Top := p1y - wi;
          Border.Right:= p1x + he;
          Border.Bottom:= p1y;
         end;
  180 : begin
          Border.Left:= p1x-wi;
          Border.Top := p1y-he;
          Border.Right:= p1x;
          Border.Bottom:= p1y;
         end;
  270 : begin
          Border.Left:= p1x-he;
          Border.Top := p1y;
          Border.Right:= p1x;
          Border.Bottom:= p1y + wi;
         end;
 end;
end;

procedure PascalStr(var s : string);
Var
  i : integer;
begin
  for i:=Length(s) downto 1 do
    if s[i]='''' then Insert('''',s,i);
  s:=''''+s+'''';
end;

procedure ComaStr(var s : string);
Var
  i : integer;
begin
  for i:=Length(s) downto 1 do
    if s[i]=',' then s[i]:='.';
end;

end.




