// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ExoTrans2.pas' rev: 5.00

#ifndef ExoTrans2HPP
#define ExoTrans2HPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <IdIPWatch.hpp>	// Pascal unit
#include <IdSocketHandle.hpp>	// Pascal unit
#include <IdException.hpp>	// Pascal unit
#include <IdUDPClient.hpp>	// Pascal unit
#include <IdUDPServer.hpp>	// Pascal unit
#include <IdTCPClient.hpp>	// Pascal unit
#include <IdThreadMgrDefault.hpp>	// Pascal unit
#include <IdTCPServer.hpp>	// Pascal unit
#include <IdTCPConnection.hpp>	// Pascal unit
#include <IdComponent.hpp>	// Pascal unit
#include <IdBaseComponent.hpp>	// Pascal unit
#include <Contnrs.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Exotrans2
{
//-- type declarations -------------------------------------------------------
typedef TIdPeerThread TIdPeerThread;
;

class DELPHICLASS TExoTransThreadTimer;
class PASCALIMPLEMENTATION TExoTransThreadTimer : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	unsigned Interval;
	Classes::TThreadMethod OnTimer;
	bool FEnabled;
	void __fastcall SetEnabled(const bool Value);
	__property bool Enabled = {read=FEnabled, write=SetEnabled, nodefault};
	
protected:
	virtual void __fastcall Execute(void);
public:
	#pragma option push -w-inl
	/* TThread.Create */ inline __fastcall TExoTransThreadTimer(bool CreateSuspended) : Classes::TThread(
		CreateSuspended) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TThread.Destroy */ inline __fastcall virtual ~TExoTransThreadTimer(void) { }
	#pragma option pop
	
};


class DELPHICLASS TExoTransWaitForAnswerThread;
class DELPHICLASS TExoConnection;
class DELPHICLASS TExoClient;
typedef void __fastcall (__closure *TAnswerEvent)(TExoClient* Sender, bool &Success);

typedef void __fastcall (__closure *TClientRequestEvent)(TExoClient* Sender);

typedef void __fastcall (__closure *TTimeOutEvent)(TExoClient* Sender, bool &GiveUpFlag, bool Coming
	);

typedef void __fastcall (__closure *TTransEndEvent)(TExoClient* Sender, bool Success);

class DELPHICLASS TAnswer;
class PASCALIMPLEMENTATION TAnswer : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int LineCount;
	Classes::TStringList* Lines;
	bool Coming;
	TExoClient* Client;
	__fastcall virtual ~TAnswer(void);
	
private:
	bool __fastcall IsEOF(void);
	__fastcall TAnswer(TExoClient* OwnerClient);
	AnsiString __fastcall ReadLine();
	void __fastcall GoTopLine(void);
	AnsiString __fastcall ReadMultiLines();
	void __fastcall ReadStringList(Classes::TStringList* slList, bool bClear);
	void __fastcall CopyToList(Classes::TStringList* slList);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TAnswer(void) : System::TObject() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TExoClient : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TAnswerEvent FOnAnswer;
	TClientRequestEvent FOnRequest;
	TTimeOutEvent FOnTimeOut;
	TTransEndEvent FOnTransEnd;
	int FPriority;
	TExoConnection* FConnection;
	TAnswer* Answer;
	
public:
	__fastcall virtual TExoClient(Classes::TComponent* AOwner);
	__fastcall virtual ~TExoClient(void);
	void __fastcall Request(void);
	void __fastcall WriteLine(AnsiString sText);
	void __fastcall WriteMultiLines(AnsiString sText, int LineLen);
	void __fastcall WriteStringList(Classes::TStringList* slList);
	void __fastcall GoTopLine(void);
	AnsiString __fastcall ReadLine();
	AnsiString __fastcall ReadMultiLines();
	void __fastcall ReadStringList(Classes::TStringList* slList, bool bClear);
	void __fastcall SaveToFile(AnsiString sFileName, AnsiString sFileExt);
	void __fastcall CopyToList(Classes::TStringList* slList);
	bool __fastcall IsEOF(void);
	
__published:
	__property int Priority = {read=FPriority, write=FPriority, default=1};
	__property TAnswerEvent OnAnswer = {read=FOnAnswer, write=FOnAnswer};
	__property TClientRequestEvent OnRequest = {read=FOnRequest, write=FOnRequest};
	__property TTimeOutEvent OnTimeOut = {read=FOnTimeOut, write=FOnTimeOut};
	__property TTransEndEvent OnTransEnd = {read=FOnTransEnd, write=FOnTransEnd};
	__property TExoConnection* Connection = {read=FConnection, write=FConnection};
};


class PASCALIMPLEMENTATION TExoConnection : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Idtcpclient::TIdTCPClient* TCPClient;
	Idudpclient::TIdUDPClient* UDPClient;
	AnsiString FileName;
	TextFile FileHandler;
	bool Success;
	bool GiveUpFlag;
	bool Checking;
	TExoClient* Client;
	int CodeReceived;
	int CodeExpected;
	bool IndyCompsAssigned;
	AnsiString FSeekKey;
	int FPort;
	AnsiString FHost;
	Classes::TNotifyEvent FOnConnected;
	Classes::TNotifyEvent FOnDisconnected;
	bool FAutoConnect;
	AnsiString FServerDir;
	bool FBlocking;
	bool FUseTCP;
	TExoTransWaitForAnswerThread* WaitForAnswerThread;
	void __fastcall Request(TExoClient* ReqClient);
	void __fastcall ReadTCP(System::TObject* Sender);
	void __fastcall ReadFS(System::TObject* Sender);
	void __fastcall TCPClientOnConnected(System::TObject* Sender);
	void __fastcall TCPClientOnDisconnected(System::TObject* Sender);
	void __fastcall WriteLine(AnsiString msg);
	void __fastcall WriteControlLine(AnsiString msg);
	void __fastcall GiveUp(void);
	void __fastcall SetPort(const int Value);
	void __fastcall SetHost(const AnsiString Value);
	void __fastcall SetUseTCP(const bool Value);
	AnsiString __fastcall GetServerDir();
	
public:
	int SeekServerTimeOut;
	int TimeOut;
	bool Working;
	void __fastcall Connect(void);
	void __fastcall Disconnect(void);
	Contnrs::TObjectList* __fastcall SeekServer(void);
	void __fastcall SendNotification(AnsiString Data);
	__fastcall virtual TExoConnection(Classes::TComponent* AOwner);
	
__published:
	__property bool UseTCP = {read=FUseTCP, write=SetUseTCP, default=1};
	__property int Port = {read=FPort, write=SetPort, default=2000};
	__property AnsiString Host = {read=FHost, write=SetHost};
	__property bool AutoConnect = {read=FAutoConnect, write=FAutoConnect, default=1};
	__property Classes::TNotifyEvent OnConnected = {read=FOnConnected, write=FOnConnected};
	__property Classes::TNotifyEvent OnDisconnected = {read=FOnDisconnected, write=FOnDisconnected};
	__property AnsiString ServerDir = {read=FServerDir, write=FServerDir};
	__property bool Blocking = {read=FBlocking, write=FBlocking, default=0};
	__property AnsiString SeekKey = {read=FSeekKey, write=FSeekKey};
public:
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TExoConnection(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TExoTransWaitForAnswerThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TExoConnection* Connection;
	void __fastcall OnAnswer(void);
	void __fastcall OnTimeOut(void);
	void __fastcall OnTransEnd(void);
	
protected:
	virtual void __fastcall Execute(void);
public:
	#pragma option push -w-inl
	/* TThread.Create */ inline __fastcall TExoTransWaitForAnswerThread(bool CreateSuspended) : Classes::TThread(
		CreateSuspended) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TThread.Destroy */ inline __fastcall virtual ~TExoTransWaitForAnswerThread(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRequest;
class DELPHICLASS TExoServer;
typedef DynamicArray<Classes::TList* >  ExoTrans2__31;

typedef void __fastcall (__closure *TRequestEvent)(TExoServer* Sender, TRequest* Request);

typedef void __fastcall (__closure *TOtherServerFoundEvent)(TExoServer* Sender, Contnrs::TObjectList* 
	OtherServers, bool &GiveUpFlag);

typedef void __fastcall (__closure *TNotificationReceivedEvent)(TExoServer* Sender, AnsiString Data)
	;

class PASCALIMPLEMENTATION TExoServer : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Idtcpserver::TIdTCPServer* TCPServer;
	Idudpserver::TIdUDPServer* UDPServer;
	Idudpclient::TIdUDPClient* UDPClient;
	Idipwatch::TIdIPWatch* IPWatch;
	TExoTransThreadTimer* Timer;
	TExoTransThreadTimer* ReadFileTimer;
	Idthreadmgrdefault::TIdThreadMgrDefault* ThreadMgrDefault;
	DynamicArray<Classes::TList* >  Requests;
	Classes::TList* IncompleteRequests;
	bool Active;
	bool Deactivating;
	bool IndyCompsAssigned;
	int FPort;
	unsigned FInterval;
	Idtcpserver::TIdServerThreadEvent FOnConnect;
	Idtcpserver::TIdServerThreadEvent FOnDisconnect;
	TRequestEvent FOnRequest;
	TOtherServerFoundEvent FOnOtherServerFound;
	TNotificationReceivedEvent FOnNotificationReceived;
	AnsiString FServerDir;
	AnsiString FSeekKey;
	bool FUseTCP;
	int FMaxPriorities;
	bool __fastcall Idle(void);
	void __fastcall Clean(void);
	void __fastcall UpdateBindings(void);
	void __fastcall TCPServerExecute(Idtcpserver::TIdPeerThread* AThread);
	void __fastcall TCPServerConnect(Idtcpserver::TIdPeerThread* AThread);
	void __fastcall TCPServerDisconnect(Idtcpserver::TIdPeerThread* AThread);
	void __fastcall TimerOnTimer(void);
	void __fastcall ReadFileTimerOnTimer(void);
	void __fastcall UDPServerUDPRead(System::TObject* Sender, Classes::TStream* AData, Idsockethandle::TIdSocketHandle* 
		ABinding);
	void __fastcall DeleteRequest(TRequest* rRequest);
	bool __fastcall SeekOtherServer(void);
	void __fastcall SetInterval(const unsigned Value);
	void __fastcall SetPort(const int Value);
	void __fastcall SetUseTCP(const bool Value);
	void __fastcall SetMaxPriorities(const int Value);
	void __fastcall SetServerDir(const AnsiString Value);
	AnsiString __fastcall GetServerDir();
	
public:
	int SeekServerTimeOut;
	__fastcall virtual TExoServer(Classes::TComponent* AOwner);
	__fastcall virtual ~TExoServer(void);
	bool __fastcall Activate(void);
	void __fastcall DeActivate(void);
	__property unsigned Interval = {read=FInterval, write=SetInterval, nodefault};
	
__published:
	__property int MaxPriorities = {read=FMaxPriorities, write=SetMaxPriorities, default=3};
	__property bool UseTCP = {read=FUseTCP, write=SetUseTCP, default=1};
	__property int Port = {read=FPort, write=SetPort, default=2000};
	__property AnsiString ServerDir = {read=FServerDir, write=SetServerDir};
	__property AnsiString SeekKey = {read=FSeekKey, write=FSeekKey};
	__property TRequestEvent OnRequest = {read=FOnRequest, write=FOnRequest};
	__property TOtherServerFoundEvent OnOtherServerFound = {read=FOnOtherServerFound, write=FOnOtherServerFound
		};
	__property TNotificationReceivedEvent OnNotificationReceived = {read=FOnNotificationReceived, write=
		FOnNotificationReceived};
};


class PASCALIMPLEMENTATION TRequest : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int Priority;
	int Cod;
	Classes::TStringList* Lines;
	Idtcpserver::TIdPeerThread* Thread;
	AnsiString FileName;
	TextFile FileHandler;
	int CurrLine;
	TExoServer* ParentServer;
	__fastcall TRequest(TExoServer* Server);
	void __fastcall WriteControlLine(AnsiString Msg);
	AnsiString __fastcall ReadLine();
	void __fastcall ReadStringList(Classes::TStringList* slList, bool bClear);
	void __fastcall WriteLine(AnsiString Msg);
	void __fastcall WriteStringList(Classes::TStringList* slList);
	void __fastcall GoTopLine(void);
	bool __fastcall IsEOF(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRequest(void) { }
	#pragma option pop
	
};


class DELPHICLASS EExoWrongModeError;
class PASCALIMPLEMENTATION EExoWrongModeError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExoWrongModeError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExoWrongModeError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExoWrongModeError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExoWrongModeError(int Ident, const System::TVarRec 
		* Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExoWrongModeError(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExoWrongModeError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExoWrongModeError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExoWrongModeError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExoWrongModeError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EAlreadyWorking;
class PASCALIMPLEMENTATION EAlreadyWorking : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EAlreadyWorking(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EAlreadyWorking(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EAlreadyWorking(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EAlreadyWorking(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EAlreadyWorking(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EAlreadyWorking(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EAlreadyWorking(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EAlreadyWorking(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EAlreadyWorking(void) { }
	#pragma option pop
	
};


class DELPHICLASS ETCPError;
class PASCALIMPLEMENTATION ETCPError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ETCPError(const AnsiString Msg) : Sysutils::Exception(Msg)
		 { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ETCPError(const AnsiString Msg, const System::TVarRec * 
		Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ETCPError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ETCPError(int Ident, const System::TVarRec * Args, const 
		int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ETCPError(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(
		Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ETCPError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ETCPError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ETCPError(System::PResStringRec ResStringRec, const 
		System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ETCPError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EFileSystemError;
class PASCALIMPLEMENTATION EFileSystemError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EFileSystemError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EFileSystemError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EFileSystemError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EFileSystemError(int Ident, const System::TVarRec * 
		Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EFileSystemError(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EFileSystemError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EFileSystemError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EFileSystemError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EFileSystemError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EExoClientError;
class PASCALIMPLEMENTATION EExoClientError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExoClientError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExoClientError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExoClientError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExoClientError(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExoClientError(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExoClientError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExoClientError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExoClientError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExoClientError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EExoServerError;
class PASCALIMPLEMENTATION EExoServerError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExoServerError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExoServerError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExoServerError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExoServerError(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExoServerError(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExoServerError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExoServerError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExoServerError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExoServerError(void) { }
	#pragma option pop
	
};


class DELPHICLASS TMachine;
class PASCALIMPLEMENTATION TMachine : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString IP;
	AnsiString Name;
	AnsiString SeekKey;
	
private:
	__fastcall TMachine(AnsiString mIP, AnsiString mName);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TMachine(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TMachine(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
#define COMBOSTRINGSTAG "@cs-end"
static const Shortint MaxPrioritiesDefault = 0x3;
static const Word SeekServerTimeOutDefault = 0x3e8;
static const Word PortDefault = 0x7d0;
static const Word TimeOutDefault = 0x1f40;
static const char DirSeparator = '\x5c';
extern PACKAGE void __fastcall Register(void);

}	/* namespace Exotrans2 */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Exotrans2;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ExoTrans2
