unit FClient;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, ExoTrans2, Contnrs;

type
  TfoClient = class(TForm)
    Label1: TLabel;
    btLoad: TButton;
    cbCustomerName: TComboBox;
    btDelete: TButton;
    btClose: TButton;
    ExoConnection1: TExoConnection;
    ecLoad: TExoClient;
    ecDelete: TExoClient;
    ecList: TExoClient;
    Label2: TLabel;
    Label3: TLabel;
    edAddress: TEdit;
    edPhone: TEdit;
    procedure btCloseClick(Sender: TObject);
    procedure btDeleteClick(Sender: TObject);
    procedure btLoadClick(Sender: TObject);
    procedure ecDeleteAnswer(Sender: TExoClient; var Success: Boolean);
    procedure ecDeleteRequest(Sender: TExoClient);
    procedure ecListAnswer(Sender: TExoClient; var Success: Boolean);
    procedure ecListRequest(Sender: TExoClient);
    procedure ecLoadAnswer(Sender: TExoClient; var Success: Boolean);
    procedure ecLoadRequest(Sender: TExoClient);
    procedure ecLoadTimeOut(Sender: TExoClient; var GiveUpFlag: Boolean;
      Coming: Boolean);
    procedure ecLoadTransEnd(Sender: TExoClient; Success: Boolean);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  foClient: TfoClient;

implementation

{$R *.xfm}

procedure TfoClient.FormShow(Sender: TObject);
var
  oServers: TObjectList;
begin
{oServers := ExoConnection1.SeekServer;
if oServers.Count > 0 then
  ExoConnection1.Host := TMachine(oServers.Items[0]).IP;}
ecList.Request;
end;

procedure TfoClient.ecListRequest(Sender: TExoClient);
begin
Sender.WriteLine('List');
end;

procedure TfoClient.ecListAnswer(Sender: TExoClient; var Success: Boolean);
var
  oList: TStringList;
begin
oList := TStringList.Create;
Sender.ReadStringList(oList, true);
cbCustomerName.Items.AddStrings(oList);
cbCustomerName.ItemIndex := 0;
end;

procedure TfoClient.btLoadClick(Sender: TObject);
begin
ecLoad.Request;
end;

procedure TfoClient.ecLoadRequest(Sender: TExoClient);
begin
Sender.WriteLine('Load');
Sender.WriteLine(cbCustomerName.Text);
end;

procedure TfoClient.ecLoadAnswer(Sender: TExoClient; var Success: Boolean);
begin
if Sender.ReadLine = 'OK' then
  begin
  edAddress.Text := Sender.ReadLine;
  edPhone.Text := Sender.ReadLine;
  end;
end;

procedure TfoClient.ecLoadTimeOut(Sender: TExoClient;
  var GiveUpFlag: Boolean; Coming: Boolean);
begin
if not Coming then
  GiveUpFlag := true;
end;

procedure TfoClient.ecLoadTransEnd(Sender: TExoClient; Success: Boolean);
begin
if not Success then
  Application.MessageBox('Could not communicate to server !','Comm Error',[smbOK],
    smsCritical);
end;

procedure TfoClient.btDeleteClick(Sender: TObject);
begin
ecDelete.Request;
end;

procedure TfoClient.ecDeleteRequest(Sender: TExoClient);
begin
Sender.WriteLine('Delete');
Sender.WriteLine(cbCustomerName.Text);
end;

procedure TfoClient.ecDeleteAnswer(Sender: TExoClient;
  var Success: Boolean);
begin
if Sender.ReadLine = 'OK' then
  Application.MessageBox('Customer was deleted !','Customer Deletion');
end;

procedure TfoClient.btCloseClick(Sender: TObject);
begin
Close;
end;

end.
