unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Dialogs,
  StdCtrls, ComCtrls, ConvertEdit, NumEdit, Menus, Db,
  DBConvEdit, DBCtrls, DBTables, Mask, ExtCtrls, Controls;


type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    Changeunit1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabControl1: TTabControl;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label3: TLabel;
    Label1: TLabel;
    Label6: TLabel;
    ListBox1: TListBox;
    ListBox2: TListBox;
    ConvEdit1: TConvEdit;
    NumEdit1: TNumEdit;
    UpDown1: TUpDown;
    NumEdit2: TNumEdit;
    UpDown2: TUpDown;
    NumEdit3: TNumEdit;
    AlignEdit1: TAlignEdit;
    TabSheet2: TTabSheet;
    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    Table1Category: TStringField;
    Table1Common_Name: TStringField;
    Table1Graphic: TGraphicField;
    Label8: TLabel;
    Label9: TLabel;
    lblLength: TLabel;
    Label14: TLabel;
    DBImage1: TDBImage;
    DBMoreEdit2: TDBMoreEdit;
    DBMoreEdit3: TDBMoreEdit;
    DBMoreEdit5: TDBMoreEdit;
    Table1Lengthcm: TConvFloatfield;
    PopupMenu2: TPopupMenu;
    miLength: TMenuItem;
    Label11: TLabel;
    Label10: TLabel;
    procedure ListBox1Click(Sender: TObject);
    procedure EditConv1Convert(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure LoadUnits;
    procedure UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: Smallint; Direction: TUpDownDirection);
    procedure UpDown2ChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: Smallint; Direction: TUpDownDirection);
    procedure ConvEdit1UnitChange(Sender: TObject; UnitKind, UnitIn,
      UnitOut: String; var Allow: Boolean);
    procedure AlignEdit1Change(Sender: TObject);
    procedure Table1LengthcmConvert(Sender: TObject);
  Protected
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}



procedure TForm1.ListBox1Click(Sender: TObject);
begin
  With (Sender as TListbox) do
    Case (Sender as TListbox).Tag of
      1: ConvEdit1.Conversion.UnitIn := items[Itemindex];
      2: ConvEdit1.Conversion.UnitOut := items[Itemindex];
    end;
end;

procedure TForm1.EditConv1Convert(Sender: TObject);
begin
   with ConvEdit1.Conversion do
     NumEdit1.FloatValue := ConvEdit1.GetConverted;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

   LoadUnits;
   With TabControl1, ConvEdit1.Conversion do
   begin
      GetTypeList(Tabs);
      TabIndex := Tabs.Indexof(UnitKind);
   end;
end;

procedure TForm1.TabControl1Change(Sender: TObject);
begin
   With TabControl1, ConvEdit1.Conversion do
     UnitKind := Tabs[TabIndex];
   LoadUnits;
end;

procedure TForm1.LoadUnits;
begin
   with Listbox1, ConvEdit1.Conversion do
   begin
      GetUnitList(Items, UnitKind);
      ListBox2.Items := Items;
      If Items.Count > 0 then
      begin
        UnitIn := Items[0];
        UnitOut := UnitIn;
        ItemIndex := 0;
        Listbox2.itemindex := 0;
      end;
   end;
end;

procedure TForm1.UpDown1ChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: Smallint;
  Direction: TUpDownDirection);
begin
  NumEdit1.Digits := NewValue;
end;

procedure TForm1.UpDown2ChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: Smallint;
  Direction: TUpDownDirection);
begin
  NumEdit1.Precision := NewValue;
end;

procedure TForm1.ConvEdit1UnitChange(Sender: TObject; UnitKind, UnitIn,
  UnitOut: String; var Allow: Boolean);
begin
  With listbox1 do //This is to match menu seolection with listbox
    ItemIndex := Items.IndexOf(UnitIn);
  Label2.Caption := UnitIn;
  Label4.Caption := UnitOut;
end;

procedure TForm1.AlignEdit1Change(Sender: TObject);
begin
   NumEdit1.CustomFormat := AlignEdit1.Text;
end;

procedure TForm1.Table1LengthcmConvert(Sender: TObject);
begin
   Label10.Caption := 'Actual (rounded) database value: ' + FormatFloat('#,##0.00', Table1Lengthcm.AsFloat);
end;

end.
