{ Written 2003 by TyBreizh29 (TyBreizh29@yahoo.co.uk)

  Version 1.00 : 19. September 2003

  Licensing: Use however you want, if you don't make money with it.
  If you make money with it, its price is : 5 
  Please tell me where you use it (location and use of program).
  If you fix bugs or add nifty features, please let me know.
  Visit my homepage for the latest version: http://www.le-meur.org/liens.php

  I WILL NOT ASSUME ANY RESPONSIBILITY WHATSOEVER FOR ANY DAMAGES RESULTING
  FROM THE USE/MISUSE OF THIS UNIT. Use at your own risk.
}
unit BzhLeds;

interface

uses
  windows, messages, sysutils, classes, controls,  graphics,extctrls;

type
	TLedType = (ltRound, ltRectangle);

	TBzhLeds = class(TGraphicControl)
	private
		fLedType	    : TLedType;
		fLedStatus		: Boolean;
		fLedOnColor		: TColor;
		fLedOffColor	: TColor;
		fLedOutLineColor: TColor;

		fBevel			: TPanelBevel;

		fRect			: TRect;

		fBlinkingTimer	: TTimer;
		fBlinkingSpeed  : integer;
		fBlinking	    : Boolean;
		fVisible		: Boolean;

		procedure BlinkingProc		(Sender : TObject);
		procedure SetBlinking		(value : Boolean);
		procedure SetBevel			(value : TPanelBevel);
		procedure SetBlinkingSpeed	(value : integer);
		procedure SetLedOffColor	(value : TColor);
		procedure SetLedOnColor		(value : TColor);
		procedure SetLedOutLineColor(value : TColor);

		procedure SetRect			(value  : TRect);
	protected
		procedure Paint; override;
	public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure SetLedOn;
		procedure SetLedOff;
		procedure SetLedStatus		(value : Boolean);
		procedure StartBlink;
	published
		property OnClick;
		property OnDblClick;
		property Visible;
		property Height;
		property Width;
		property Bevel	 		: TPanelBevel 	read fBevel	 	write SetBevel;
		property LedType	 	: TLedType 	read fLedType	 	write fLedType;
		property LedOnColor 	: Tcolor 	read fLedOnColor 	write SetLedOnColor;
		property LedOffColor 	: TColor 	read fLedOffColor 	write SetLedOffColor;
		property LedOutLineColor : TColor  read fLedOutLineColor 	write SetLedOutLineColor;
		property BlinkingSpeed 	: Integer 	read fBlinkingSpeed write SetBlinkingSpeed;
		property LedStatus		: Boolean	read fLedStatus 	write SetLedStatus;
		property Blinking 		: Boolean 	read fBlinking 		write SetBlinking;
		property IsLedOn 		: Boolean 	read fLedStatus		write SetLedStatus;
	end;
	
procedure Register;

implementation

{************************************************************************
************************************************************************}
procedure Register;
begin
  RegisterComponents('Bzh', [TBzhLeds]);
end;

{************************************************************************
************************************************************************}
constructor TBzhLeds.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  height			:= 15;
  width				:= 15;

  fLedOnColor		:= clLime;
  fLedOffColor		:= clRed;
  LedOutLineColor	:= clMaroon;
  LedStatus			:= FALSE;

  fBlinking			:= FALSE;
  fBlinkingSpeed	:= 400;

  fBlinkingTimer			:= TTimer.create(Self);
  fBlinkingTimer.onTimer	:= BlinkingProc;
  fBlinkingTimer.enabled	:= fBlinking;
  fBlinkingTimer.Interval	:= fBlinkingSpeed;

end;

{************************************************************************
************************************************************************}
destructor TBzhLeds.Destroy;
begin
  fBlinkingTimer.free;
  inherited destroy;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.BlinkingProc(Sender : TObject);
begin
	LedStatus	:= not LedStatus;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedOnColor(value : TColor);
begin
	fLedOnColor:=value;
	paint;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedOffColor(value : TColor);
begin
	fLedOffColor	:= value;
	Invalidate;
end;


{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedOutLineColor(value : TColor);
begin
	fLedOutLineColor		:= value;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedStatus(value : Boolean);
begin
	fLedStatus		:= value;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetRect			(value  : TRect);
begin
	fRect := value ;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetBlinking(value : Boolean);
begin
  fBlinking					:= value;
  fBlinkingTimer.enabled	:= fBlinking;
  
  invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedOn;
begin
  fLedStatus			:= TRUE;
  fBlinkingTimer.enabled:= FALSE;
  
  Invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetLedOff;
begin
  fLedStatus			:= FALSE;
  fBlinkingTimer.enabled:= FALSE;

  invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.StartBlink;
begin
	fBlinkingTimer.enabled	:= not fBlinkingTimer.enabled;
	fLedStatus:=FALSE;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetBevel			(value : TPanelBevel);
begin
	fBevel := value;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.SetBlinkingSpeed(value : Integer);
begin
	fBlinkingTimer.Interval	:= value;
	fBlinkingSpeed			:= value;
end;

{************************************************************************
************************************************************************}
procedure TBzhLeds.Paint;
var
	tabPoints	: array [0..2] of TPoint;
begin
	with canvas do
	begin
		if fLedStatus then
			brush.color	:= fLedOnColor
		else
			brush.color	:= fLedOffColor;

		pen.width	:= 1;
		pen.color	:= LedOutLineColor;

		case (fLedType) of
		//--------------------------------------------
		ltRound:
			begin
				Ellipse(1, 1, Width-1, Height-1);

				case (fBevel) of
				bvLowered:
					begin
						pen.color	:= clBlack;
						Arc(0, 0, Width, Height, Width,  0, 0, Height);

						pen.color	:= clWhite;
						Arc(0, 0, Width, Height, 0, Height, Width,  0);
					end;
				bvRaised:
					begin
						pen.color	:= clWhite;
						Arc(0, 0, Width, Height, Width,  0, 0, Height);

						pen.color	:= clBlack;
						Arc(0, 0, Width, Height, 0, Height, Width,  0);
					end;
				end;

				pen.width	:= Height div 6;
				pen.color	:= LedOutLineColor;

				tabPoints[0].X	:= Width div 2;
				tabPoints[0].Y	:= Height - Round(Height/7);
				tabPoints[1].X	:= Width - Round(Width/9);
				tabPoints[1].Y	:= Height div 2;
				tabPoints[2].X	:= Width - Round(Width/9);
				tabPoints[2].Y	:= Height div 2;

				Polyline(tabPoints);

				Arc(1, 1, Width-Round(Width/9), Height-Round(Height/9), Width div 2 , Height-Round(Height/9), Width-Round(Width/9), Height div 2);
			end;
		//--------------------------------------------
		ltRectangle:
			begin
				Rectangle(1, 1, Width-2, Height-2);
				case (fBevel) of
				bvLowered:
					begin
						pen.width	:= 1;
						pen.color	:= clWhite;
						tabPoints[0].X	:= 0;
						tabPoints[0].Y	:= Height-1;
						tabPoints[1].X	:= 0;
						tabPoints[1].Y	:= 0;
						tabPoints[2].X	:= Width-1;
						tabPoints[2].Y	:= 0;
						Polyline(tabPoints);

						pen.color	:= clBlack;
						tabPoints[0].X	:= 0;
						tabPoints[0].Y	:= Height-1;
						tabPoints[1].X	:= Width-1;
						tabPoints[1].Y	:= Height-1;
						tabPoints[2].X	:= Width-1;
						tabPoints[2].Y	:= 0;
						Polyline(tabPoints);

					end;
				bvRaised:
					begin
						pen.width	:= 1;
						pen.color	:= clBlack;
						tabPoints[0].X	:= 0;
						tabPoints[0].Y	:= Height;
						tabPoints[1].X	:= 0;
						tabPoints[1].Y	:= 0;
						tabPoints[2].X	:= Width;
						tabPoints[2].Y	:= 0;
						Polyline(tabPoints);

						pen.color	:= clWhite;
						tabPoints[0].X	:= 0;
						tabPoints[0].Y	:= Height;
						tabPoints[1].X	:= Width;
						tabPoints[1].Y	:= Height;
						tabPoints[2].X	:= Width;
						tabPoints[2].Y	:= 0;
						Polyline(tabPoints);
					end;
				end;
			end;
		//--------------------------------------------
		end;

	end;
end;

{************************************************************************
************************************************************************}
end.
