{ Written 2003 by TyBreizh29 (TyBreizh29@yahoo.co.uk)

  Version 1.00 : 19. September 2003

  Licensing: Use however you want, if you don't make money with it.
  If you make money with it, its price is : 5 
  Please tell me where you use it (location and use of program).
  If you fix bugs or add nifty features, please let me know.
  Visit my homepage for the latest version: http://www.le-meur.org/liens.php

  I WILL NOT ASSUME ANY RESPONSIBILITY WHATSOEVER FOR ANY DAMAGES RESULTING
  FROM THE USE/MISUSE OF THIS UNIT. Use at your own risk.
}

unit BzhDigits;

interface

uses
  windows, messages, sysutils, classes, controls,  graphics,extctrls;

type

	TBzhDigits = class(TGraphicControl)
	private
		fLedStatus		: Boolean;
		fLedOnColor		: TColor;
		fLedOffColor	: TColor;
		fLedOutLineColor: TColor;
		fBackgroundColor: TColor;

		fBevel			: TPanelBevel;

		fRect			: TRect;

		fBlinkingTimer	: TTimer;
		fBlinkingSpeed  : integer;
		fBlinking	    : Boolean;
		fVisible		: Boolean;

		fDigitsNumber	: integer;
		fValue			: integer;

		procedure BlinkingProc		(Sender : TObject);
		procedure DisplayOneDigit	(nDigIndex, nDigValue : integer);
		procedure SetBackgroundColor(value : TColor);
		procedure SetBevel			(value : TPanelBevel);
		procedure SetBlinking		(value : Boolean);
		procedure SetBlinkingSpeed	(value : integer);
		procedure SetDigitsNumber	(value : integer);
		procedure SetLedOffColor	(value : TColor);
		procedure SetLedOnColor		(value : TColor);
		procedure SetLedOutLineColor(value : TColor);

		procedure SetRect			(value  : TRect);
		procedure SetValue      	(value : integer);

	protected
		procedure Paint; override;
	public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure SetLedOn;
		procedure SetLedOff;
		procedure SetLedStatus		(value : Boolean);
		procedure StartBlink;
	published
		property OnClick;
		property OnDblClick;
		property Visible;
		property Height;
		property Width;
		property Bevel	 		: TPanelBevel 	read fBevel	 			write SetBevel;
		property LedOnColor 	: Tcolor 	    read fLedOnColor 	    write SetLedOnColor;
		property LedOffColor 	: TColor 	    read fLedOffColor 	    write SetLedOffColor;
		property LedOutLineColor : TColor  	    read fLedOutLineColor 	write SetLedOutLineColor;
		property BackgroundColor : TColor  	    read fBackgroundColor 	write SetBackgroundColor;

		property BlinkingSpeed 	: Integer 	    read fBlinkingSpeed     write SetBlinkingSpeed;
		property LedStatus		: Boolean	    read fLedStatus 	    write SetLedStatus;
		property Blinking 		: Boolean 	    read fBlinking 		    write SetBlinking;
		property IsLedOn 		: Boolean 	    read fLedStatus		    write SetLedStatus;
		property DigitsNumber	: integer       read fDigitsNumber      write SetDigitsNumber;
		property Value			: integer       read fValue		        write SetValue;

	end;
	
procedure Register;

implementation

{************************************************************************
************************************************************************}
procedure Register;
begin
  RegisterComponents('Bzh', [TBzhDigits]);
end;

{************************************************************************
************************************************************************}
constructor TBzhDigits.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  height			:= 15;
  width				:= 15;

  fLedOnColor		:= clLime;
  fLedOffColor		:= clRed;
  LedOutLineColor	:= clMaroon;
  fBackgroundColor	:= clGreen;
  LedStatus			:= TRUE;

  fBlinking			:= FALSE;
  fBlinkingSpeed	:= 400;
  fDigitsNumber		:= 1;
  fValue			:= 8;

  fBlinkingTimer			:= TTimer.create(Self);
  fBlinkingTimer.onTimer	:= BlinkingProc;
  fBlinkingTimer.enabled	:= fBlinking;
  fBlinkingTimer.Interval	:= fBlinkingSpeed;

end;

{************************************************************************
************************************************************************}
destructor TBzhDigits.Destroy;
begin
  fBlinkingTimer.free;
  inherited destroy;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.BlinkingProc(Sender : TObject);
begin
	LedStatus	:= not LedStatus;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedOnColor(value : TColor);
begin
	fLedOnColor:=value;
	paint;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetBackgroundColor(value : TColor);
begin
	fBackgroundColor := value;
	Invalidate;
end;
{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedOffColor(value : TColor);
begin
	fLedOffColor	:= value;
	Invalidate;
end;


{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedOutLineColor(value : TColor);
begin
	fLedOutLineColor		:= value;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedStatus(value : Boolean);
begin
	fLedStatus		:= value;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetRect			(value  : TRect);
begin
	fRect := value ;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetBlinking(value : Boolean);
begin
  fBlinking					:= value;
  fBlinkingTimer.enabled	:= fBlinking;
  
  invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedOn;
begin
  fLedStatus			:= TRUE;
  fBlinkingTimer.enabled:= FALSE;

  Invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetLedOff;
begin
  fLedStatus			:= FALSE;
  fBlinkingTimer.enabled:= FALSE;

  invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.StartBlink;
begin
	fBlinkingTimer.enabled	:= not fBlinkingTimer.enabled;
	fLedStatus:=FALSE;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetBevel			(value : TPanelBevel);
begin
	fBevel := value;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetBlinkingSpeed(value : Integer);
begin
	fBlinkingTimer.Interval	:= value;
	fBlinkingSpeed			:= value;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetDigitsNumber	(value : integer);
begin
	fDigitsNumber := value;
	invalidate;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.SetValue      	(value : integer);
begin
	fValue := Value;
	invalidate;
end;

{************************************************************************
7 segment
   6
 5	 1
   7
 4	 2
   3
************************************************************************}
procedure TBzhDigits.DisplayOneDigit(nDigIndex, nDigValue : integer);
var
	tabPoints	: array [0..4] of TPoint;
	tabPointsM	: array [0..6] of TPoint;
	nLeft		: integer;
	nWidth		: integer;
	nRight		: integer;
	rRect		: TRect;
	nEpaisseur	: integer;
	nBorder     : integer;
	lColorFront	: TColor;
begin
	with canvas do
	begin
		pen.width	:= 1;
		pen.color	:= LedOutLineColor;
		Brush.Color := fBackgroundColor;
		nWidth		:= (Height div 2);
		nLeft		:= nWidth*(nDigIndex-1);
		nRight		:= nWidth*(nDigIndex);

		Rectangle(nLeft, 0, nRight+1, Height);

		if fLedStatus then
			lColorFront	:= fLedOnColor
		else
			lColorFront	:= fLedOffColor;

		nEpaisseur	:= 4;
		nBorder		:= 2;
		pen.color	:= lColorFront;

		// segment N1
		Brush.Color := lColorFront;
		if (nDigValue<=4) OR (nDigValue>=7) then
		begin
			tabPoints[0].X	:= nRight-nBorder;
			tabPoints[0].Y	:= nBorder;
			tabPoints[1].X	:= nRight-nBorder;
			tabPoints[1].Y	:= (Height div 2 );
			tabPoints[2].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[2].Y	:= (Height div 2 )-nEpaisseur;
			tabPoints[3].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[3].Y	:= nBorder+nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X - nEpaisseur div 2, tabPoints[0].Y+ nEpaisseur, fBackgroundColor, fsSurface);
		end;

		// segment N2
		if (nDigValue<>2) then
		begin
			tabPoints[0].X	:= nRight-nBorder;
			tabPoints[0].Y	:= (Height div 2 );
			tabPoints[1].X	:= nRight-nBorder;
			tabPoints[1].Y	:= Height-nBorder;
			tabPoints[2].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[2].Y	:= Height-nBorder-nEpaisseur;
			tabPoints[3].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[3].Y	:= (Height div 2 )+nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X - nEpaisseur div 2, tabPoints[0].Y+ nEpaisseur, fBackgroundColor, fsSurface);
		end;


		// segment N3
		if (nDigValue<>1) AND (nDigValue<>4)  AND (nDigValue<>7) then
		begin
			tabPoints[0].X	:= nRight-nBorder;
			tabPoints[0].Y	:= Height-nBorder;
			tabPoints[1].X	:= nLeft+nBorder;
			tabPoints[1].Y	:= Height-nBorder;
			tabPoints[2].X	:= nLeft+nEpaisseur;
			tabPoints[2].Y	:= Height-nBorder-nEpaisseur;
			tabPoints[3].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[3].Y	:= Height-nBorder-nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X - nEpaisseur, tabPoints[0].Y- nEpaisseur div 2, fBackgroundColor, fsSurface);
		end;


		// segment N4
		if (nDigValue=0) OR	(nDigValue=2) OR (nDigValue=6) OR (nDigValue>=8) then
		begin
			tabPoints[0].X	:= nLeft+nBorder;
			tabPoints[0].Y	:= Height-nBorder;
			tabPoints[1].X	:= nLeft+nBorder;
			tabPoints[1].Y	:= (Height div 2 );
			tabPoints[2].X	:= nLeft+nBorder+nEpaisseur;
			tabPoints[2].Y	:= (Height div 2 )+nEpaisseur;
			tabPoints[3].X	:= nLeft+nBorder+nEpaisseur;
			tabPoints[3].Y	:= Height-nBorder-nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X + nEpaisseur div 2, tabPoints[0].Y- 2*nEpaisseur, fBackgroundColor, fsSurface);
		end;

		// segment N5
		if (nDigValue<>1) AND (nDigValue<>2)  AND (nDigValue<>3) AND (nDigValue<>7) then
		begin
			tabPoints[0].X	:= nLeft+nBorder;
			tabPoints[0].Y	:= (Height div 2 );
			tabPoints[1].X	:= nLeft+nBorder;
			tabPoints[1].Y	:= nBorder;
			tabPoints[2].X	:= nLeft+nBorder+nEpaisseur;
			tabPoints[2].Y	:= nBorder+nEpaisseur;
			tabPoints[3].X	:= nLeft+nBorder+nEpaisseur;
			tabPoints[3].Y	:= (Height div 2 )-nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X + nEpaisseur div 2, tabPoints[0].Y- nEpaisseur, fBackgroundColor, fsSurface);
		end;


		// segment N6
		if (nDigValue<>1) AND (nDigValue<>4) then
		begin
			tabPoints[0].X	:= nRight-nBorder;
			tabPoints[0].Y	:= nBorder;
			tabPoints[1].X	:= nLeft+nBorder;
			tabPoints[1].Y	:= nBorder;
			tabPoints[2].X	:= nLeft+nEpaisseur;
			tabPoints[2].Y	:= nBorder+nEpaisseur;
			tabPoints[3].X	:= nRight-nBorder-nEpaisseur;
			tabPoints[3].Y	:= nBorder+nEpaisseur;
			tabPoints[4]	:= tabPoints[0];
			Polyline(tabPoints);

			FloodFill(tabPoints[0].X - nEpaisseur, tabPoints[0].Y + nEpaisseur div 2, fBackgroundColor, fsSurface);
		end;


		// segment N7 barre du milieu
		if (nDigValue<>7) AND (nDigValue<>1) AND (nDigValue<>0) then
		begin
			tabPointsM[0].X	:= nRight-nBorder;
			tabPointsM[0].Y	:= (Height div 2 );
			tabPointsM[1].X	:= nRight-nBorder-nEpaisseur;
			tabPointsM[1].Y	:= (Height div 2 )+nEpaisseur;
			tabPointsM[2].X	:= nLeft+nBorder+nEpaisseur;
			tabPointsM[2].Y	:= (Height div 2 )+nEpaisseur;
			tabPointsM[3].X	:= nLeft+nBorder;
			tabPointsM[3].Y	:= (Height div 2 );
			tabPointsM[4].X	:= nLeft+nBorder+nEpaisseur;
			tabPointsM[4].Y	:= (Height div 2 )-nEpaisseur;
			tabPointsM[5].X	:= nRight-nBorder-nEpaisseur;
			tabPointsM[5].Y	:= (Height div 2 )-nEpaisseur;
			tabPointsM[6]	:= tabPointsM[0];

			Polyline(tabPointsM);

			FloodFill(tabPointsM[0].X - nEpaisseur, tabPointsM[0].Y , fBackgroundColor, fsSurface);
		end;

		//aspect final
		pen.width	:= 3 ;
		pen.color	:= fBackgroundColor;
		Brush.Color := fBackgroundColor;

		//haut gauche puis droite
		MoveTo(nLeft+nBorder, nBorder);
		LineTo(nLeft+nBorder+2*nEpaisseur, nBorder+2*nEpaisseur);
		MoveTo(nRight-nBorder, nBorder);
		LineTo(nRight-nBorder-2*nEpaisseur, nBorder+2*nEpaisseur);

		//haut gauche puis droite
		MoveTo(nLeft+nBorder, Height-nBorder);
		LineTo(nLeft+nBorder+2*nEpaisseur, Height-nBorder-2*nEpaisseur);
		MoveTo(nRight-nBorder, Height-nBorder);
		LineTo(nRight-nBorder-2*nEpaisseur, Height-nBorder-2*nEpaisseur);

		//milieu gauche
		MoveTo(nLeft+nBorder, (Height div 2));
		LineTo(nLeft+nBorder+2*nEpaisseur, (Height div 2)+2*nEpaisseur);
		MoveTo(nLeft+nBorder, (Height div 2));
		LineTo(nLeft+nBorder+2*nEpaisseur, (Height div 2)-2*nEpaisseur);

		//milieu droite
		MoveTo(nRight-nBorder, (Height div 2));
		LineTo(nRight-nBorder-2*nEpaisseur, (Height div 2)+2*nEpaisseur);
		MoveTo(nRight-nBorder, (Height div 2));
		LineTo(nRight-nBorder-2*nEpaisseur, (Height div 2)-2*nEpaisseur);

	end;
end;

{************************************************************************
************************************************************************}
procedure TBzhDigits.Paint;
var
	tabPoints	: array [0..2] of TPoint;
	sTmp		: string;
	i			: integer;
begin
	Width := ((Height div 2)) * fDigitsNumber+1;

	with canvas do
	begin

		sTmp := IntToStr(fValue);
		for i:=length(sTmp) to fDigitsNumber-1 do
			sTmp := '0'+sTmp;

		for i:=1 to length(sTmp) do
		begin
			DisplayOneDigit(i, StrToInt(sTmp[i]));
		end;

	end;
end;

{************************************************************************
************************************************************************}
end.
