unit uJChaine;
//--------------------------------------------------------------------
//Unti utilitaire: uJChaine
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:28 Mai 2002
//--------------------------------------------------------------------

//Aide  la gestion des chaines de caracts
interface

uses sysutils, StdCtrls;

type
  StringArray = Array of String;
  CharSet = Set of char;

Function Filtrer(Const Chaine : String; Const Min, Max : Char) : String;
function RetirerDeChaine(const text : String; filtres : array of char) : String;
procedure ObligerChiffre(Sender : TEdit; var Key: Char);
function ValiderFlottant(const text : String; var OK : Boolean) : String;
procedure ChTxtVersWinFormat(var Chiffre : String);
Procedure ChTxtVersSQLFormat(var Chiffre : String);
function ChPlusGrand(const ch1, ch2 : String) : Boolean;
function lireUnEl(Const source : String; var lecture : String; var pos : longInt) : Boolean; overload;
function lireUnEl(Const source : String; var lecture : String; var pos : longInt;
                  const separateur : charSet) : Boolean; overload;
function calculerConcordance(const ch1, ch2 : String) : LongInt;
function ExtraireEls(const chaine : String) : StringArray;
function ExtensionDe(const chaine : String) : String;
function SansExtension(Const chaine : String) : String;
function ExtraireNomFichier(Const chaine : String) : String;
function DossierPrec(Const Chaine : String) : String;
function RetirerALaFin(const chaine : String; const retirer : char) : String;
function ChangerMotDeCommande(Const Commande, Mot, nmot : String) : String;
function StrAug(const el : String) : String;
procedure debug(const msg : String);

implementation

//Cette procdure retourne le dossier prcdent dans l'arborescence
function DossierPrec(Const Chaine : String) : String;
var i : LongInt;
 begin
   i := LastDelimiter('\/', Chaine);
   result := copy(Chaine, 1, i - 1);
 end;

//Cette procdure crit des informations de dbogage dans un fichier
procedure debug(const msg : String);
var Fic : textFile;
const FichierDebug = 'AutoDebug.log';
 begin
   assignFile(fic, FichierDebug);
   try
     if FileExists(FichierDebug) then
        append(fic)
     else
        rewrite(fic);
     try
       writeln(fic, msg);
     finally
       closefile(fic);
     end;  
   except
     on e : exception do
      begin
      end;//Gobe les erreurs
   end;
 end;

//Cette procdure augmente la chaine de 1
function StrAug(const el : String) : String;
var i : LongInt;
 begin
   result := el;
   i := length(result);
   while (i > 0) and (result[i] = 'Z') do
     dec(i);
   if i < 1 then
      result := result + 'A'
   else
      inc(result[i]);// := result[i]
 end;

//Cette procdure parcoure une chaine de commande en prenant en considraion
//les espace et "  la recherche du mot
function ChangerMotDeCommande(Const Commande, Mot, nmot : String) : String;
const strdeli = '"';
var i : LongInt;
    STRMODE : Boolean;
    UMOT : String;
 begin
   result := '';

   if mot = '' then
      raise exception.Create('PARAMTRE MOT EST VIDE DANS CHANGER MOT DE PASSE');

   UMot := ' ' + UpperCase(Mot) + ' ';
   STRMODE := False;
   i := 1;
   while i <= Length(Commande) - length(umot) + 1 do
    begin
      if Commande[i] = StrDeli then
         StrMode := not StrMode;
      if (not StrMode) and (UpperCase(Copy(Commande, i, Length(uMot))) = UMot) then
       begin
         result := RetirerALaFin(result, ' ');
         i := i + Length(uMot);
         while (Commande[i] = ' ') do
               inc(i);
         dec(i);

         result := result + ' ' + nmot;
         If nmot <> '' then
            result := result + ' ';
       end
      else
        result := result + Commande[i];
      inc(i);
    end;

   result := result + Copy(Commande, i, length(Commande));
 end;

//Cette procdure lit la chaine tant que les caractres sparateurs ne sont pas
//rencontrs
//Si la chaine commence par des caractres sparateurs, ces caratres sont sauts
function lireUnEl(Const source : String; var lecture : String; var pos : longInt) : Boolean;
Const Separateur = [',', ' ', ';', '(', ')'];
 Begin
   lecture := '';
   while (pos <= length(source)) and
         ((lecture = '') or not (source[pos] in Separateur)) do
    begin
      if not (source[pos] in Separateur) Then
         lecture := lecture + source[pos];
      inc(pos);
    end;
   result := lecture <> '';
 end;

//Cette procdure lit la chaine tant que les caractres sparateurs ne sont pas
//rencontrs
//Si la chaine commence par des caractres sparateur, ces caratres sont saut
function lireUnEl(Const source : String; var lecture : String; var pos : longInt;
                  const separateur : CharSet) : Boolean;
 Begin
   lecture := '';
   while (pos <= length(source)) and
         ((lecture = '') or not (source[pos] in Separateur)) do
    begin
      if not (source[pos] in Separateur) Then
         lecture := lecture + source[pos];
      inc(pos);
    end;
   result := lecture <> '';
 end;

//Cette fonction compare deux chaines de caractre de longueur identique
//retourne vrai si la premire est plus grande que la deuxime
function ChPlusGrand(const ch1, ch2 : String) : Boolean;
 begin
   if length(ch1) <> length(ch2) then
        raise exception.Create('ChPlusGrand PARAMTRES incorrects');
   if length(ch1) > 0 then
    begin
      if ch1[1] > ch2[1] then
        result := true
      else if ch1[1] < ch2[1] then
        result := false
      else
        result := ChPlusGrand(copy(ch1, 2, high(integer)),
                              copy(ch2, 2, high(integer)));
    end
   else
     result := false;
 end;

//Enlve tous les caractres qui ne sont pas entre min et max
Function Filtrer(Const Chaine : String; Const Min, Max : Char) : String;
Var I : LongInt;
 Begin
   Result := '';
   For I := 1 to Length(Chaine) Do
       If (Chaine[i] >= min) and (Chaine[i] <= Max) Then
          Result := Result + Chaine[i];
 End;

//Retire tous les caratres fesant partie des filtres
//SYNTAXE des filtres: [filtre1, filtre2, filtr3...]
//retourne la rponse
function RetirerDeChaine(const text : String; filtres : array of char) : String;
var i, j : Longint;
 begin
   result := '';
   i := 1;
   while i <= length(text) do
    begin
      j := 0;
      while (j < Length(filtres)) and (filtres[j] <> text[i]) do
         inc(j);
      if j = Length(filtres) then
         result := result + text[i];
      inc(i);
    end;
 end;

//Rend l'entre d'un chiffre  virgule obligatoire
//effectue un filtrage sur les touches
procedure ObligerChiffre(Sender : TEdit; var Key: Char);

  procedure AppuieVirgule;
   Begin
     With Sender as TEdit Do
      Begin
        If (Pos(DecimalSeparator, Text) = 0) And ((Pos('-', Text) = 0) Or (SelStart > 0)) Then
         Begin
           If (SelStart = 0) Then
            Begin
              Text := '0' + DecimalSeparator + Text;
              SelStart := 2;
              Key := #0;
            End
           Else If ((Pos('-', Text) = 1) And (SelStart = 1)) Then
            Begin
              Text := '-0' + DecimalSeparator + Copy(Text, 2, Length(Text));
              SelStart := 3;
              Key := #0;
            End;
         End
        Else
          Key := #0;
      end;
   end;

begin
  Case Key of
   '-':
    Begin
      With Sender as TEdit Do
       Begin
         If SelStart > 0 Then
            Key := #0;
       End;
    End;
   '0':
    If (Sender as TEdit).SelStart=0 {Pos(DecimalSeparator, (Sender as TEdit).Text) = 0} Then
       Key := #0;
   '1'..'9':
    Begin
    End;
   #8:
    Begin
    End
   Else
    begin
     if key = DecimalSeparator then
        AppuieVirgule
     else
        Key := #0;
    End;
  End;
end;

//Retirer tous les caractres de RETIRER  la fin de la chainge
function RetirerALaFin(const chaine : String; const retirer : char) : String;
var fin : LongInt;
 begin
   fin := length(chaine);
   while (fin > 0) and (chaine[fin] = retirer) do
        dec(fin);
   result := copy(chaine, 1, fin);
 end;

//Vrifie et apporte des corrections  un chiffre floattant
//retourne vrai si le chiffre en virgule flottance est acceptable
function ValiderFlottant(const text : String; var OK : Boolean) : String;
Var i : LongInt;
    virgule : Boolean;
 begin
   Ok := false;
   //gestion des chanes trop courte
   if (text = '') or (text = '-') then
    begin
      result := '0';
      Ok := true;
    end
   else
    begin
      virgule := false;

      //gestion des chanes contenants des caractres invalides
      for i := 1 to length(text) do
       begin
         if not (text[i] in ['0'..'9', '-', DecimalSeparator, ' ']) then
            exit;
       end;

      i := 1;
      //Sauter les espaces inutiles en dbut
      while (i < length(text)) and (text[i] = ' ') do
            Inc(i);

      if text[i] = '-' then
       begin
         inc(i);
         result := '-';
       end
      else
         result := '';

      //Sauter les zro inutiles en dbut
      while (i < length(text)) and
            ((text[i] = '0') or (text[i] = ' ')) do
                inc(i);

      //Ajouter un zro s'il en manque avant la virgule
      if (i <= length(text)) and (text[i] = DecimalSeparator) then
       begin
         result := result + '0' + DecimalSeparator;
         inc(i);
         virgule := true;
       end;

      //transfert intelligent
      while i <= length(text) do
       begin
         if text[i] <> ' ' then
          begin
             if text[i] = DecimalSeparator then
              begin
                if virgule then
                   raise exception.Create('Double virgule dans ' + text);
                virgule := true;
              end;
             result := result + text[i];
          end;
         inc(i);
       end;

      //Retirer les zros de fin inutiles
      If virgule then
         result := retirerALaFin(result, '0');

      if (result <> '') and
         (result[length(result)] = DecimalSeparator) then
         result := copy(result, 1, length(result) - 1);
      Ok := True;
    end;
 end;

//Cette procdure change le format du chiffre de '.' vers le format de windows
Procedure ChTxtVersWinFormat(var Chiffre : String);
var vPos : LongINt;
 begin
   vPos := Pos('.', Chiffre);
   if vPos > 0 then
      Chiffre[vPos] := DecimalSeparator;
 end;

//Cette procdure change le format du chiffre de '.' vers le format de windows
Procedure ChTxtVersSQLFormat(var Chiffre : String);
var vPos : LongINt;
 begin
   vPos := Pos(DecimalSeparator, Chiffre);
   if vPos > 0 then
      Chiffre[vPos] := '.';
 end;

//Cette procdure donne une note de concordance entre les deux chaines
function calculerConcordance(const ch1, ch2 : String) : LongInt;
var p1, p2 : longInt;
 begin
   result := 0;
   p1 := 1;
   p2 := 1;
   while (p1<=length(ch1)) and (p2<=length(ch2)) do
    begin
      if (ch1[p1]) = (ch2[p2]) then
         inc(result, 10)
      else if UpCase(ch1[p1]) = UpCase(ch2[p2]) then
         inc(result, 9)
      else
       begin
         inc(p1);
         if (p1<=length(ch1)) and (UpCase(ch1[p1]) = UpCase(ch2[p2])) then
            inc(result)
         else
          begin
            dec(p1);
            inc(p2);
            if (p2<length(ch2)) and (UpCase(ch1[p1]) = UpCase(ch2[p2])) then
               inc(result)
            else
               exit;
          end;
       end;
      inc(p1);
      inc(p2);
    end;
 end;

//Cette fonction extrait les lments d'une chaine spars par des caractres
//de sparation
function ExtraireEls(const chaine : String) : StringArray;
var pos, lgResult : longint;
    lecture : string;
 begin
   pos := 1;
   lgResult := 0;
   setLength(result, 0);
   while LireUnEl(chaine, lecture, pos) do
    begin
      setLength(result, lgResult + 1);
      result[lgResult] := lecture;
      inc(lgResult);
    end;
 end;

//retourne l'extension du fichier
function ExtensionDe(Const chaine : String) : String;
var ppos : longint;
 begin
   ppos := length(chaine) -1;
   while (ppos > 0) and (chaine[ppos] <> '.') do
         dec(ppos);
   result := copy(chaine, ppos, high(longInt));
 end;

//retourne le fichier sans son extension
function SansExtension(Const chaine : String) : String;
var ppos : longint;
 begin
   ppos := length(chaine) -1;
   while (ppos > 0) and (chaine[ppos] <> '.') do
         dec(ppos);
   dec(ppos);
   if ppos > 0 then
      result := copy(chaine, 1, ppos)
   else
      result := chaine;
 end;

//Cette fonction extrait le nom de fichier(enlve le dossier)
function ExtraireNomFichier(Const chaine : String) : String;
var i : LongInt;
 begin
   i := Length(chaine);
   while (i > 0) and (not (chaine[i] in ['\', '/'])) do
    begin
      dec(i);
    end;
   inc(i);
   result := copy(chaine, i, high(longInt));
 end;

end.
